import React from 'react';

export const Customizer = React.forwardRef<SVGSVGElement, any>((props, ref) => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 123 82">
			<rect width="120.5" height="81" x="1.25" y=".5" fill="#F9FAFB" rx="4.5" />
			<rect
				width="120.5"
				height="81"
				x="1.25"
				y=".5"
				stroke="#E2E8F0"
				rx="4.5"
			/>
			<path
				stroke="#849CB8"
				stroke-linecap="round"
				stroke-linejoin="round"
				stroke-width=".955"
				d="M70.133 44.5a1.925 1.925 0 0 0 .385 2.124l.07.07a2.332 2.332 0 0 1 0 3.301 2.332 2.332 0 0 1-3.301 0l-.07-.07a1.925 1.925 0 0 0-2.124-.385 1.926 1.926 0 0 0-1.166 1.762v.198a2.333 2.333 0 1 1-4.667 0v-.105A1.925 1.925 0 0 0 58 49.634a1.924 1.924 0 0 0-2.123.385l-.07.07a2.333 2.333 0 0 1-3.986-1.651 2.334 2.334 0 0 1 .684-1.651l.07-.07a1.925 1.925 0 0 0 .385-2.123 1.925 1.925 0 0 0-1.762-1.167H51a2.333 2.333 0 1 1 0-4.667h.105a1.925 1.925 0 0 0 1.762-1.26 1.925 1.925 0 0 0-.385-2.123l-.07-.07a2.334 2.334 0 1 1 3.301-3.302l.07.07a1.925 1.925 0 0 0 2.124.385H58a1.925 1.925 0 0 0 1.167-1.761V30.5a2.333 2.333 0 0 1 4.666 0v.105A1.926 1.926 0 0 0 65 32.367a1.925 1.925 0 0 0 2.123-.385l.07-.07a2.333 2.333 0 0 1 3.809.757 2.334 2.334 0 0 1-.507 2.545l-.07.07a1.924 1.924 0 0 0-.385 2.123v.093a1.925 1.925 0 0 0 1.762 1.167H72a2.333 2.333 0 1 1 0 4.667h-.105a1.925 1.925 0 0 0-1.762 1.166v0Z"
			/>
			<path
				stroke="#849CB8"
				stroke-linecap="round"
				stroke-linejoin="round"
				stroke-width=".955"
				d="M61.5 47.632a6.632 6.632 0 1 0 0-13.263 6.632 6.632 0 0 0 0 13.263ZM54.868 41h13.264"
			/>
			<path
				stroke="#849CB8"
				stroke-linecap="round"
				stroke-linejoin="round"
				stroke-width=".955"
				d="M61.5 34.37A10.147 10.147 0 0 1 64.152 41a10.146 10.146 0 0 1-2.652 6.632 10.146 10.146 0 0 1-2.653-6.631 10.147 10.147 0 0 1 2.653-6.632v0Z"
			/>
		</svg>
	);
});
export const CenteredSidebar = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
				<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
				<rect
					width="120.5"
					height="81"
					x=".5"
					y=".5"
					stroke="#E2E8F0"
					rx="4.5"
				/>
				<rect width="59.5" height="18" x="31" y="11" fill="#CED8E3" rx="2" />
				<rect width="59.5" height="2" x="31" y="34" fill="#CED8E3" rx="1" />
				<rect width="59.5" height="2" x="31" y="41" fill="#CED8E3" rx="1" />
				<rect width="59.5" height="2" x="31" y="48" fill="#CED8E3" rx="1" />
				<rect width="59.5" height="2" x="31" y="55" fill="#CED8E3" rx="1" />
				<rect width="59.5" height="2" x="31" y="62" fill="#CED8E3" rx="1" />
				<rect width="59.5" height="2" x="31" y="69" fill="#CED8E3" rx="1" />
			</svg>
		);
	},
);
export const RightSidebar = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
				<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
				<rect
					width="120.5"
					height="81"
					x=".5"
					y=".5"
					stroke="#E2E8F0"
					rx="4.5"
				/>
				<g fill="#CED8E3" opacity=".7">
					<rect width="71.5" height="13" x="9" y="9" rx="2" />
					<rect width="71.5" height="2" x="9" y="27" rx="1" />
					<rect width="71.5" height="2" x="9" y="34" rx="1" />
					<rect width="71.5" height="2" x="9" y="41" rx="1" />
					<rect width="71.5" height="2" x="9" y="48" rx="1" />
					<rect width="71.5" height="2" x="9" y="55" rx="1" />
					<rect width="71.5" height="2" x="9" y="62" rx="1" />
					<rect width="71.5" height="2" x="9" y="69" rx="1" />
				</g>
				<rect width="26" height="64" x="86.5" y="9" fill="#C5D0DD" rx="2" />
			</svg>
		);
	},
);
export const StretchedSidebar = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
				<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
				<rect
					width="120.5"
					height="81"
					x=".5"
					y=".5"
					stroke="#E2E8F0"
					rx="4.5"
				/>
				<rect width="109.5" height="18" x="6" y="11" fill="#CED8E3" rx="2" />
				<rect width="109.5" height="2" x="6" y="34" fill="#CED8E3" rx="1" />
				<rect width="109.5" height="2" x="6" y="41" fill="#CED8E3" rx="1" />
				<rect width="109.5" height="2" x="6" y="48" fill="#CED8E3" rx="1" />
				<rect width="109.5" height="2" x="6" y="55" fill="#CED8E3" rx="1" />
				<rect width="109.5" height="2" x="6" y="62" fill="#CED8E3" rx="1" />
				<rect width="109.5" height="2" x="6" y="69" fill="#CED8E3" rx="1" />
			</svg>
		);
	},
);
export const ContainedSidebar = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
				<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
				<rect
					width="120.5"
					height="81"
					x=".5"
					y=".5"
					stroke="#E2E8F0"
					rx="4.5"
				/>
				<rect width="95.5" height="18" x="13" y="11" fill="#CED8E3" rx="2" />
				<rect width="95.5" height="2" x="13" y="34" fill="#CED8E3" rx="1" />
				<rect width="95.5" height="2" x="13" y="41" fill="#CED8E3" rx="1" />
				<rect width="95.5" height="2" x="13" y="48" fill="#CED8E3" rx="1" />
				<rect width="95.5" height="2" x="13" y="55" fill="#CED8E3" rx="1" />
				<rect width="95.5" height="2" x="13" y="62" fill="#CED8E3" rx="1" />
				<rect width="95.5" height="2" x="13" y="69" fill="#CED8E3" rx="1" />
			</svg>
		);
	},
);

export const NoSidebar = React.forwardRef<SVGSVGElement, any>((props, ref) => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
			<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
			<rect width="120.5" height="81" x=".5" y=".5" stroke="#E2E8F0" rx="4.5" />
			<rect width="103.5" height="18" x="9" y="11" fill="#CED8E3" rx="2" />
			<rect width="103.5" height="2" x="9" y="34" fill="#CED8E3" rx="1" />
			<rect width="103.5" height="2" x="9" y="41" fill="#CED8E3" rx="1" />
			<rect width="103.5" height="2" x="9" y="48" fill="#CED8E3" rx="1" />
			<rect width="103.5" height="2" x="9" y="55" fill="#CED8E3" rx="1" />
			<rect width="103.5" height="2" x="9" y="62" fill="#CED8E3" rx="1" />
			<rect width="103.5" height="2" x="9" y="69" fill="#CED8E3" rx="1" />
		</svg>
	);
});
export const BothSidebar = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
				<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
				<rect
					width="120.5"
					height="81"
					x=".5"
					y=".5"
					stroke="#E2E8F0"
					rx="4.5"
				/>
				<rect width="26" height="64" x="9" y="9" fill="#C5D0DD" rx="2" />
				<g fill="#CED8E3" opacity=".7">
					<rect width="39.5" height="13" x="41" y="10" rx="2" />
					<rect width="39.5" height="2" x="41" y="28" rx="1" />
					<rect width="39.5" height="2" x="41" y="35" rx="1" />
					<rect width="39.5" height="2" x="41" y="42" rx="1" />
					<rect width="39.5" height="2" x="41" y="49" rx="1" />
					<rect width="39.5" height="2" x="41" y="56" rx="1" />
					<rect width="39.5" height="2" x="41" y="63" rx="1" />
					<rect width="39.5" height="2" x="41" y="70" rx="1" />
				</g>
				<rect width="26" height="64" x="86.5" y="9" fill="#C5D0DD" rx="2" />
			</svg>
		);
	},
);
export const LeftSidebar = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 122 82">
				<rect width="120.5" height="81" x=".5" y=".5" fill="#F9FAFB" rx="4.5" />
				<rect
					width="120.5"
					height="81"
					x=".5"
					y=".5"
					stroke="#E2E8F0"
					rx="4.5"
				/>
				<rect width="26" height="64" x="9" y="9" fill="#C5D0DD" rx="2" />
				<g fill="#CED8E3" opacity=".7">
					<rect width="71.5" height="13" x="41" y="10" rx="2" />
					<rect width="71.5" height="2" x="41" y="28" rx="1" />
					<rect width="71.5" height="2" x="41" y="35" rx="1" />
					<rect width="71.5" height="2" x="41" y="42" rx="1" />
					<rect width="71.5" height="2" x="41" y="49" rx="1" />
					<rect width="71.5" height="2" x="41" y="56" rx="1" />
					<rect width="71.5" height="2" x="41" y="63" rx="1" />
					<rect width="71.5" height="2" x="41" y="70" rx="1" />
				</g>
			</svg>
		);
	},
);
export const HeaderLeft = React.forwardRef<SVGSVGElement, any>((props, ref) => {
	return (
		<svg
			ref={ref}
			{...props}
			xmlns="http://www.w3.org/2000/svg"
			fill="none"
			viewBox="0 0 120 100"
		>
			<rect width="120" height="100" fill="#E4E4E7" rx="4" />
			<rect width="119" height="27" x=".5" y=".5" fill="#FAFAFA" rx="3.5" />
			<rect width="18" height="4" x="8" y="12" fill="#71717A" rx="1" />
			<rect width="12" height="3" x="52" y="12.5" fill="#71717A" rx="1.5" />
			<rect width="12" height="3" x="68" y="12.5" fill="#71717A" rx="1.5" />
			<rect width="12" height="3" x="84" y="12.5" fill="#71717A" rx="1.5" />
			<rect width="12" height="3" x="100" y="12.5" fill="#71717A" rx="1.5" />
			<rect width="119" height="27" x=".5" y=".5" stroke="#71717A" rx="3.5" />
		</svg>
	);
});
export const HeaderCenter = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg
				ref={ref}
				{...props}
				xmlns="http://www.w3.org/2000/svg"
				fill="none"
				viewBox="0 0 120 100"
			>
				<rect width="120" height="100" fill="#E4E4E7" rx="4" />
				<rect width="119" height="36" x=".5" y=".5" fill="#FAFAFA" rx="3.5" />
				<rect width="18" height="4" x="51" y="12" fill="#71717A" rx="1" />
				<rect width="12" height="3" x="30" y="22" fill="#71717A" rx="1.5" />
				<rect width="12" height="3" x="46" y="22" fill="#71717A" rx="1.5" />
				<rect width="12" height="3" x="62" y="22" fill="#71717A" rx="1.5" />
				<rect width="12" height="3" x="78" y="22" fill="#71717A" rx="1.5" />
				<rect width="119" height="36" x=".5" y=".5" stroke="#71717A" rx="3.5" />
			</svg>
		);
	},
);
export const HeaderRight = React.forwardRef<SVGSVGElement, any>(
	(props, ref) => {
		return (
			<svg
				ref={ref}
				{...props}
				xmlns="http://www.w3.org/2000/svg"
				fill="none"
				viewBox="0 0 120 100"
			>
				<rect width="120" height="100" fill="#E4E4E7" rx="4" />
				<rect width="119" height="27" x=".5" y=".5" fill="#FAFAFA" rx="3.5" />
				<rect width="12" height="3" x="8" y="12.5" fill="#71717A" rx="1.5" />
				<rect width="12" height="3" x="24" y="12.5" fill="#71717A" rx="1.5" />
				<rect width="12" height="3" x="40" y="12.5" fill="#71717A" rx="1.5" />
				<rect width="12" height="3" x="56" y="12.5" fill="#71717A" rx="1.5" />
				<rect width="18" height="4" x="94" y="12" fill="#71717A" rx="1" />
				<rect width="119" height="27" x=".5" y=".5" stroke="#71717A" rx="3.5" />
			</svg>
		);
	},
);
