<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version  4.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( $max_value && $min_value === $max_value ) {
	?>
    <div class="quantity hidden">
        <input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty"
               name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>"/>
    </div>
	<?php
} else {
	/* translators: %s: Quantity. */
	$labelledby = ! empty( $args['product_name'] ) ? sprintf( esc_html__( '%s quantity', 'evolve' ), wp_strip_all_tags( $args['product_name'] ) ) : esc_html__( 'Quantity', 'evolve' );

	?>
    <div class="quantity mb-4">
		<?php do_action( 'woocommerce_before_quantity_input_field' ); ?>

        <label class="screen-reader-text sr-only"
               for="<?php echo esc_attr( $input_id ); ?>"><?php esc_html_e( 'Quantity', 'evolve' ); ?></label>
        <div class="input-group">
            <div class="input-group-prepend">
                <div class="input-group-text"><?php esc_html_e( 'Quantity', 'evolve' ); ?></div>
            </div>
            <input
                    type="number"
                    id="<?php echo esc_attr( $input_id ); ?>"
                    class="input-text qty text form-control"
                    step="<?php echo esc_attr( $step ); ?>"
                    min="<?php echo esc_attr( $min_value ); ?>"
                    max="<?php echo esc_attr( 0 < $max_value ? $max_value : '' ); ?>"
                    name="<?php echo esc_attr( $input_name ); ?>"
                    value="<?php echo esc_attr( $input_value ); ?>"
                    title="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'evolve' ); ?>"
                    size="4"
                    pattern="<?php echo esc_attr( $pattern ); ?>"
                    inputmode="<?php echo esc_attr( $inputmode ); ?>"
                    aria-labelledby="<?php echo esc_attr( $labelledby ); ?>"/>
        </div>
    </div>
	<?php
}