<?php
/**
 * Functions and definitions for the Oberon theme.
 */
add_action( 'after_setup_theme', 'oberon_theme_setup' );

function oberon_theme_setup() {
    load_child_theme_textdomain( 'oberon', get_stylesheet_directory() . '/languages' );
}

add_action('wp_enqueue_scripts', 'oberon_enqueue_theme_style');

function oberon_enqueue_theme_style() {
    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
}

add_action('twentyfifteen_credits', 'oberon_credits_handler');

function oberon_credits_handler() {
    ?>
    <a href="<?php echo esc_url( __( 'https://wphowto.net/', 'oberon' ) ); ?>" title="<?php esc_attr_e( 'Twenty fifteen child theme', 'oberon' ); ?>"><?php printf( __( '%s theme', 'oberon' ), 'Oberon' ); ?></a> |
    <?php
}

