<?php
/* ------------------------------------------------------------------------- *
 *  Dynamic styles
/* ------------------------------------------------------------------------- */

/*  Convert hexadecimal to rgb
/* ------------------------------------ */
if ( ! function_exists( 'timelines_hex2rgb' ) ) {

	function timelines_hex2rgb( $hex, $array=false ) {
		$hex = str_replace("#", "", $hex);

		if ( strlen($hex) == 3 ) {
			$r = hexdec(substr($hex,0,1).substr($hex,0,1));
			$g = hexdec(substr($hex,1,1).substr($hex,1,1));
			$b = hexdec(substr($hex,2,1).substr($hex,2,1));
		} else {
			$r = hexdec(substr($hex,0,2));
			$g = hexdec(substr($hex,2,2));
			$b = hexdec(substr($hex,4,2));
		}

		$rgb = array( $r, $g, $b );
		if ( !$array ) { $rgb = implode(",", $rgb); }
		return $rgb;
	}
	
}	


/*  Google fonts
/* ------------------------------------ */
if ( ! function_exists( 'timelines_enqueue_google_fonts' ) ) {

	function timelines_enqueue_google_fonts () {
		if ( get_theme_mod('dynamic-styles', 'on') == 'on' ) {
			if ( get_theme_mod( 'font' ) == 'titillium-web-ext' ) { wp_enqueue_style( 'titillium-web-ext', '//fonts.googleapis.com/css?family=Titillium+Web:400,400italic,300italic,300,600&subset=latin,latin-ext' ); }		
			if ( get_theme_mod( 'font' ) == 'droid-serif' )	{ wp_enqueue_style( 'droid-serif', '//fonts.googleapis.com/css?family=Droid+Serif:400,400italic,700' ); }				
			if ( get_theme_mod( 'font' ) == 'source-sans-pro' )	{ wp_enqueue_style( 'source-sans-pro', '//fonts.googleapis.com/css?family=Source+Sans+Pro:400,300italic,300,400italic,600&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'lato' ) { wp_enqueue_style( 'lato', '//fonts.googleapis.com/css?family=Lato:400,300,300italic,400italic,700' ); }
			if ( get_theme_mod( 'font' ) == 'raleway' )	{ wp_enqueue_style( 'raleway', '//fonts.googleapis.com/css?family=Raleway:400,300,600' ); }
			/*default*/ if ( ( get_theme_mod( 'font' ) == '' ) || ( get_theme_mod( 'font' ) == 'inter' ) ) { wp_enqueue_style( 'inter', '//fonts.googleapis.com/css?family=Inter:400,300,600,800' ); }
			if ( get_theme_mod( 'font' ) == 'ubuntu' ) { wp_enqueue_style( 'ubuntu', '//fonts.googleapis.com/css?family=Ubuntu:400,400italic,300italic,300,700&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'ubuntu-cyr' ) { wp_enqueue_style( 'ubuntu-cyr', '//fonts.googleapis.com/css?family=Ubuntu:400,400italic,300italic,300,700&subset=latin,cyrillic-ext' ); }
			if ( get_theme_mod( 'font' ) == 'roboto' ) { wp_enqueue_style( 'roboto', '//fonts.googleapis.com/css?family=Roboto:400,300italic,300,400italic,700&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'roboto-cyr' ) { wp_enqueue_style( 'roboto-cyr', '//fonts.googleapis.com/css?family=Roboto:400,300italic,300,400italic,700&subset=latin,cyrillic-ext' ); }
			if ( get_theme_mod( 'font' ) == 'roboto-condensed' ) { wp_enqueue_style( 'roboto-condensed', '//fonts.googleapis.com/css?family=Roboto+Condensed:400,300italic,300,400italic,700&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'roboto-condensed-cyr' ) { wp_enqueue_style( 'roboto-condensed-cyr', '//fonts.googleapis.com/css?family=Roboto+Condensed:400,300italic,300,400italic,700&subset=latin,cyrillic-ext' ); }
			if ( get_theme_mod( 'font' ) == 'roboto-slab' ) { wp_enqueue_style( 'roboto-slab', '//fonts.googleapis.com/css?family=Roboto+Slab:400,300italic,300,400italic,700&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'roboto-slab-cyr' ) { wp_enqueue_style( 'roboto-slab-cyr', '//fonts.googleapis.com/css?family=Roboto+Slab:400,300italic,300,400italic,700&subset=latin,cyrillic-ext' ); }
			if ( get_theme_mod( 'font' ) == 'playfair-display' ) { wp_enqueue_style( 'playfair-display', '//fonts.googleapis.com/css?family=Playfair+Display:400,400italic,700&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'playfair-display-cyr' ) { wp_enqueue_style( 'playfair-display-cyr', '//fonts.googleapis.com/css?family=Playfair+Display:400,400italic,700&subset=latin,cyrillic' ); }
			if ( get_theme_mod( 'font' ) == 'open-sans' ) { wp_enqueue_style( 'open-sans', '//fonts.googleapis.com/css?family=Open+Sans:400,400italic,300italic,300,600&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'open-sans-cyr' ) { wp_enqueue_style( 'open-sans-cyr', '//fonts.googleapis.com/css?family=Open+Sans:400,400italic,300italic,300,600&subset=latin,cyrillic-ext' ); }
			if ( get_theme_mod( 'font' ) == 'pt-serif' ) { wp_enqueue_style( 'pt-serif', '//fonts.googleapis.com/css?family=PT+Serif:400,700,400italic&subset=latin,latin-ext' ); }
			if ( get_theme_mod( 'font' ) == 'pt-serif-cyr' ) { wp_enqueue_style( 'pt-serif-cyr', '//fonts.googleapis.com/css?family=PT+Serif:400,700,400italic&subset=latin,cyrillic-ext' ); }
		}
	}	
	
}
add_action( 'wp_enqueue_scripts', 'timelines_enqueue_google_fonts' ); 	


/*  Dynamic css output
/* ------------------------------------ */
if ( ! function_exists( 'timelines_dynamic_css' ) ) {

	function timelines_dynamic_css() {
		if ( get_theme_mod('dynamic-styles', 'on') == 'on' ) {
		
			// rgb values
			$color_1 = get_theme_mod('color-1');
			$color_1_rgb = timelines_hex2rgb($color_1);
			
			// start output
			$styles = '';		
			
			// google fonts
			if ( get_theme_mod( 'font' ) == 'titillium-web-ext' ) { $styles .= 'body { font-family: "Titillium Web", Arial, sans-serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'droid-serif' ) { $styles .= 'body { font-family: "Droid Serif", serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'source-sans-pro' ) { $styles .= 'body { font-family: "Source Sans Pro", Arial, sans-serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'lato' ) { $styles .= 'body { font-family: "Lato", Arial, sans-serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'raleway' ) { $styles .= 'body { font-family: "Raleway", Arial, sans-serif; }'."\n"; }
			/*default*/ if ( ( get_theme_mod( 'font' ) == '' ) || ( get_theme_mod( 'font' ) == 'inter' ) ) { $styles .= 'body { font-family: "Inter", Arial, sans-serif; }'."\n"; }
			if ( ( get_theme_mod( 'font' ) == 'ubuntu' ) || ( get_theme_mod( 'font' ) == 'ubuntu-cyr' ) ) { $styles .= 'body { font-family: "Ubuntu", Arial, sans-serif; }'."\n"; }	
			if ( ( get_theme_mod( 'font' ) == 'roboto' ) || ( get_theme_mod( 'font' ) == 'roboto-cyr' ) ) { $styles .= 'body { font-family: "Roboto", Arial, sans-serif; }'."\n"; }
			if ( ( get_theme_mod( 'font' ) == 'roboto-condensed' ) || ( get_theme_mod( 'font' ) == 'roboto-condensed-cyr' ) ) { $styles .= 'body { font-family: "Roboto Condensed", Arial, sans-serif; }'."\n"; }
			if ( ( get_theme_mod( 'font' ) == 'roboto-slab' ) || ( get_theme_mod( 'font' ) == 'roboto-slab-cyr' ) ) { $styles .= 'body { font-family: "Roboto Slab", Arial, sans-serif; }'."\n"; }			
			if ( ( get_theme_mod( 'font' ) == 'playfair-display' ) || ( get_theme_mod( 'font' ) == 'playfair-display-cyr' ) ) { $styles .= 'body { font-family: "Playfair Display", Arial, sans-serif; }'."\n"; }
			if ( ( get_theme_mod( 'font' ) == 'open-sans' ) || ( get_theme_mod( 'font' ) == 'open-sans-cyr' ) )	{ $styles .= 'body { font-family: "Open Sans", Arial, sans-serif; }'."\n"; }
			if ( ( get_theme_mod( 'font' ) == 'pt-serif' ) || ( get_theme_mod( 'font' ) == 'pt-serif-cyr' ) ) { $styles .= 'body { font-family: "PT Serif", serif; }'."\n"; }	
			if ( get_theme_mod( 'font' ) == 'arial' ) { $styles .= 'body { font-family: Arial, sans-serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'georgia' ) { $styles .= 'body { font-family: Georgia, serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'verdana' ) { $styles .= 'body { font-family: Verdana, sans-serif; }'."\n"; }
			if ( get_theme_mod( 'font' ) == 'tahoma' ) { $styles .= 'body { font-family: Tahoma, sans-serif; }'."\n"; }
			
			// container width
			if ( get_theme_mod('container-width','1680') != '1680' ) {			
				if ( get_theme_mod( 'boxed' ) ) { 
					$styles .= '
body.boxed #wrapper,
body.boxed #header { max-width: '.esc_attr( get_theme_mod('container-width') ).'px; }
				'."\n";
				}
				else {
					$styles .= ''."\n";
				}
			}
			// content max-width
			if ( get_theme_mod('content-width','720') != '720' ) {
				$styles .= '
.entry-header,
.entry-footer,
.entry > :not(.alignfull) { max-width: '.esc_attr( get_theme_mod('content-width') ).'px; }
				'."\n";
			}
			// rounded design
			if ( get_theme_mod('rounded-design','0') != '0' ) {
				$styles .= '
.subheader,
.left-sidebar,
.featured-card,
.featured-card:after,
.featured-card-image-wrapper,
.slick-featured .slick-posts-nav .slick-prev, 
.slick-featured .slick-posts-nav .slick-next,
.slick-featured .slick-posts-nav .slick-prev::after, 
.slick-featured .slick-posts-nav .slick-next::after,
.sticky-heading,
.list-card,
.list-card-image,
.list-card-image:after,
.main-header-single,
.main-header-single:after,
.main-header-single-meta,
.main-header-single-meta .single-meta-comments,
.main-header-single-meta .single-meta-comments:after,
.sidebar .author-bio-name,
.alx-posts > li,
.alx-posts > li .post-item-thumbnail,
.alx-posts > li:after,
.alx-tabs-nav,
.alx-tabs-nav:after,
.sharrre-footer .sharrre .box,
.themeform input[type="submit"] { border-radius: '.esc_attr( get_theme_mod('rounded-design') ).'px; }

.card-comments { bottom: '.esc_attr( get_theme_mod('rounded-design') ).'px; }
.card-comments,
.card-comments:after { border-radius: '.esc_attr( get_theme_mod('rounded-design') ).'px 0 0 '.esc_attr( get_theme_mod('rounded-design') ).'px; }

.sidebar .post-nav li.next a i { border-radius: '.esc_attr( get_theme_mod('rounded-design') ).'px 0 0 '.esc_attr( get_theme_mod('rounded-design') ).'px; }
.sidebar .post-nav li.previous a i { border-radius: 0 '.esc_attr( get_theme_mod('rounded-design') ).'px '.esc_attr( get_theme_mod('rounded-design') ).'px 0; }

.toggle-search.active { border-radius: '.esc_attr( get_theme_mod('rounded-design') ).'px 0 0 '.esc_attr( get_theme_mod('rounded-design') ).'px; }
.search-expand { border-radius: 0 '.esc_attr( get_theme_mod('rounded-design') ).'px '.esc_attr( get_theme_mod('rounded-design') ).'px 0; }

.themeform input:not([type="submit"]):not([type="checkbox"]), 
.themeform textarea,
.themeform input[type="submit"] { border-radius: '.esc_attr( get_theme_mod('rounded-design') ).'px; }

.main-content { border-radius: 0 '.esc_attr( get_theme_mod('rounded-design') ).'px '.esc_attr( get_theme_mod('rounded-design') ).'px 0; }
@media only screen and (max-width: 920px) {
	.main-content { border-radius: '.esc_attr( get_theme_mod('rounded-design') ).'px; }
}
.main-container { background: #171d25; }
.main-content { background: #2d333c; }
body:where(.light) .main-container { background: #f4f4f4; }
body:where(.light) .main-content { background: #fff; }
	
				'."\n";
			}
			// accent color
			if ( get_theme_mod('color-accent','#1a9fff') != '#1a9fff' ) {
				$styles .= '
.main-header-single-meta .single-meta-comments,
#theme-toggle-btn:before,
.slick-featured .slick-posts-nav .slick-prev,
.slick-featured .slick-posts-nav .slick-next,
.slick-featured .slick-posts-nav .slick-prev:hover,
.slick-featured .slick-posts-nav .slick-next:hover,
.slick-featured .slick-posts-nav .slick-prev:focus,
.slick-featured .slick-posts-nav .slick-next:focus,
.card-comments,
.post-tags a:hover,
.alx-tabs-nav li.active a,
.commentlist li.bypostauthor > .comment-body:after,
.commentlist li.comment-author-admin > .comment-body:after,
.wp-pagenavi a:hover,
.wp-pagenavi a:active,
.wp-pagenavi span.current { background: '.esc_attr( get_theme_mod('color-accent') ).'; }

.sticky-heading-alt,
.nav-menu:not(.mobile) li.current_page_item > span > a, 
.nav-menu:not(.mobile) li.current-menu-item > span > a, 
.nav-menu:not(.mobile) li.current-menu-ancestor > span > a, 
.nav-menu:not(.mobile) li.current-post-parent > span > a,
.sidebar .post-nav li a:hover i { color: '.esc_attr( get_theme_mod('color-accent') ).'; }

.author-bio-image svg { stroke: '.esc_attr( get_theme_mod('color-accent') ).'; }
				'."\n";
			}
			// header color
			if ( get_theme_mod('color-header','#2d333c') != '#2d333c' ) {
				$styles .= '
#header { background: '.esc_attr( get_theme_mod('color-header') ).'!important; }
.site-title a { color: #fff!important; }
.site-description { color: rgba(255,255,255,0.5)!important; }

.menu-toggle-icon span { background: #fff!important; }

.nav-menu:not(.mobile) a { color: rgba(255,255,255,0.6)!important; }
.nav-menu:not(.mobile) a:hover { color: #fff!important; }
.nav-menu:not(.mobile) button.active { background: rgba(255,255,255,0.15)!important; }
.nav-menu:not(.mobile) button .svg-icon { fill: rgba(255,255,255,0.4)!important; }
.nav-menu:not(.mobile) li.current_page_item > span > a, 
.nav-menu:not(.mobile) li.current-menu-item > span > a, 
.nav-menu:not(.mobile) li.current-menu-ancestor > span > a, 
.nav-menu:not(.mobile) li.current-post-parent > span > a { color: #fff!important; }

body:where(.dark) .nav-menu:not(.mobile) li li a { color: rgba(0,0,0,0.6)!important; }
body:where(.dark) .nav-menu:not(.mobile) li li a:hover { color: #000!important; }
body:where(.dark) .nav-menu:not(.mobile) li li button.active { background: rgba(0,0,0,0.06)!important; }
body:where(.dark) .nav-menu:not(.mobile) li li button .svg-icon { fill: rgba(0,0,0,0.3)!important; }
body:where(.dark) .nav-menu:not(.mobile) li li.current_page_item > span > a, 
body:where(.dark) .nav-menu:not(.mobile) li li.current-menu-item > span > a, 
body:where(.dark) .nav-menu:not(.mobile) li li.current-menu-ancestor > span > a, 
body:where(.dark) .nav-menu:not(.mobile) li li.current-post-parent > span > a { color: #000!important; }

.nav-menu.mobile { border-top: 1px solid rgba(255,255,255,0.1)!important; }
.nav-menu.mobile button.active .svg-icon { fill: #fff!important; }
.nav-menu.mobile ul ul { background: rgba(255,255,255,0.05)!important; }
.nav-menu.mobile ul li .menu-item-wrapper,
.nav-menu.mobile ul ul li .menu-item-wrapper { border-bottom: 1px solid rgba(255,255,255,0.1)!important; }
.nav-menu.mobile ul li a { color: #fff!important; }
.nav-menu.mobile ul button,
.nav-menu.mobile ul ul button { border-left: 1px solid rgba(255,255,255,0.1)!important; }
.nav-menu.mobile > div > ul { border-top: 1px solid rgba(255,255,255,0.1)!important; }

.nav-menu .svg-icon { fill: #fff!important; }
.nav-menu.mobile button:focus,
.menu-toggle:focus { background: rgba(255,255,255,0.06)!important; }
				'."\n";
			}
			// dark background tone
			if ( get_theme_mod('dark-background-tone','#2d333c') != '#2d333c' ) {
				$styles .= '
body:where(.dark) #wrapper,
body:where(.dark) #header,
body:where(.dark) .main-content,
body:where(.dark) .author-bio-name,
body:where(.dark) .sidebar .post-nav li a i { background: '.esc_attr( get_theme_mod('dark-background-tone') ).'; }
body:where(.dark) .sticky-heading-alt { background: '.esc_attr( get_theme_mod('dark-background-tone') ).'!important; }
body:where(.dark) .author-bio-name:after { border-bottom-color: '.esc_attr( get_theme_mod('dark-background-tone') ).'; }
body:where(.dark) .main-header,
body:where(.dark) .author-bio-image { background: linear-gradient(0deg, '.esc_attr( get_theme_mod('darker-background-tone') ).' 0%, '.esc_attr( get_theme_mod('dark-background-tone') ).' 100%); }
.sticky-heading a { color: '.esc_attr( get_theme_mod('dark-background-tone') ).'; }
				'."\n";
			}
			// darker background tone
			if ( get_theme_mod('darker-background-tone','#171d25') != '#171d25' ) {
				$styles .= '
body:where(.dark) .main-container,
body:where(.dark) .sticky-heading,
body:where(.dark) .right-sidebar,
body:where(.dark) #footer,
body:where(.dark) .wp-pagenavi a { background: '.esc_attr( get_theme_mod('darker-background-tone') ).'; }
body:where(.dark) .main-header,
body:where(.dark) .author-bio-image { background: linear-gradient(0deg, '.esc_attr( get_theme_mod('darker-background-tone') ).' 0%, '.esc_attr( get_theme_mod('dark-background-tone') ).' 100%); }
body:where(.dark) .main-header-single-meta:after { background: linear-gradient(0deg, '.esc_attr( get_theme_mod('darker-background-tone') ).' 0%, rgba(255,255,255,0) 100%); }
				'."\n";
			}
			// boxed background color
			if ( get_theme_mod('color-background','#2d333c') != '#2d333c' ) {
				$styles .= '
body { background: '.esc_attr( get_theme_mod('color-background') ).'!important; }
				'."\n";
			}
			// header logo max-height
			if ( get_theme_mod('logo-max-height','60') != '60' ) {
				$styles .= '.site-title a img { max-height: '.esc_attr( get_theme_mod('logo-max-height') ).'px; }'."\n";
			}
			// header text color
			if ( get_theme_mod( 'header_textcolor' ) != '' ) {
				$styles .= '.site-title a, .site-description { color: #'.esc_attr( get_theme_mod( 'header_textcolor' ) ).'; }'."\n";
			}
			if ( get_theme_mod('dark','off') == 'on' ) { 
				wp_add_inline_style( 'timelines-dark', $styles );
			} else {
				wp_add_inline_style( 'timelines-style', $styles );
			}
		}
	}
	
}
add_action( 'wp_enqueue_scripts', 'timelines_dynamic_css' );
