/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 7078:
/***/ (function(module) {

/**
 * Checks if the block is experimental based on the metadata loaded
 * from block.json.
 *
 * This function is in a separate file and uses the older JS syntax so
 * that it can be imported in both:
 * – block-library/src/index.js
 * – block-library/src/babel-plugin.js
 *
 * @param {Object} metadata Parsed block.json metadata.
 * @return {boolean} Is the block experimental?
 */
module.exports = function isBlockMetadataExperimental(metadata) {
  return metadata && '__experimental' in metadata && metadata.__experimental !== false;
};


/***/ }),

/***/ 5619:
/***/ (function(module) {

"use strict";


// do not edit .js files directly - edit src/index.jst


  var envHasBigInt64Array = typeof BigInt64Array !== 'undefined';


module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }


    if ((a instanceof Map) && (b instanceof Map)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      for (i of a.entries())
        if (!equal(i[1], b.get(i[0]))) return false;
      return true;
    }

    if ((a instanceof Set) && (b instanceof Set)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      return true;
    }

    if (ArrayBuffer.isView(a) && ArrayBuffer.isView(b)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (a[i] !== b[i]) return false;
      return true;
    }


    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 4793:
/***/ (function(module) {

var characterMap = {
	"À": "A",
	"Á": "A",
	"Â": "A",
	"Ã": "A",
	"Ä": "A",
	"Å": "A",
	"Ấ": "A",
	"Ắ": "A",
	"Ẳ": "A",
	"Ẵ": "A",
	"Ặ": "A",
	"Æ": "AE",
	"Ầ": "A",
	"Ằ": "A",
	"Ȃ": "A",
	"Ç": "C",
	"Ḉ": "C",
	"È": "E",
	"É": "E",
	"Ê": "E",
	"Ë": "E",
	"Ế": "E",
	"Ḗ": "E",
	"Ề": "E",
	"Ḕ": "E",
	"Ḝ": "E",
	"Ȇ": "E",
	"Ì": "I",
	"Í": "I",
	"Î": "I",
	"Ï": "I",
	"Ḯ": "I",
	"Ȋ": "I",
	"Ð": "D",
	"Ñ": "N",
	"Ò": "O",
	"Ó": "O",
	"Ô": "O",
	"Õ": "O",
	"Ö": "O",
	"Ø": "O",
	"Ố": "O",
	"Ṍ": "O",
	"Ṓ": "O",
	"Ȏ": "O",
	"Ù": "U",
	"Ú": "U",
	"Û": "U",
	"Ü": "U",
	"Ý": "Y",
	"à": "a",
	"á": "a",
	"â": "a",
	"ã": "a",
	"ä": "a",
	"å": "a",
	"ấ": "a",
	"ắ": "a",
	"ẳ": "a",
	"ẵ": "a",
	"ặ": "a",
	"æ": "ae",
	"ầ": "a",
	"ằ": "a",
	"ȃ": "a",
	"ç": "c",
	"ḉ": "c",
	"è": "e",
	"é": "e",
	"ê": "e",
	"ë": "e",
	"ế": "e",
	"ḗ": "e",
	"ề": "e",
	"ḕ": "e",
	"ḝ": "e",
	"ȇ": "e",
	"ì": "i",
	"í": "i",
	"î": "i",
	"ï": "i",
	"ḯ": "i",
	"ȋ": "i",
	"ð": "d",
	"ñ": "n",
	"ò": "o",
	"ó": "o",
	"ô": "o",
	"õ": "o",
	"ö": "o",
	"ø": "o",
	"ố": "o",
	"ṍ": "o",
	"ṓ": "o",
	"ȏ": "o",
	"ù": "u",
	"ú": "u",
	"û": "u",
	"ü": "u",
	"ý": "y",
	"ÿ": "y",
	"Ā": "A",
	"ā": "a",
	"Ă": "A",
	"ă": "a",
	"Ą": "A",
	"ą": "a",
	"Ć": "C",
	"ć": "c",
	"Ĉ": "C",
	"ĉ": "c",
	"Ċ": "C",
	"ċ": "c",
	"Č": "C",
	"č": "c",
	"C̆": "C",
	"c̆": "c",
	"Ď": "D",
	"ď": "d",
	"Đ": "D",
	"đ": "d",
	"Ē": "E",
	"ē": "e",
	"Ĕ": "E",
	"ĕ": "e",
	"Ė": "E",
	"ė": "e",
	"Ę": "E",
	"ę": "e",
	"Ě": "E",
	"ě": "e",
	"Ĝ": "G",
	"Ǵ": "G",
	"ĝ": "g",
	"ǵ": "g",
	"Ğ": "G",
	"ğ": "g",
	"Ġ": "G",
	"ġ": "g",
	"Ģ": "G",
	"ģ": "g",
	"Ĥ": "H",
	"ĥ": "h",
	"Ħ": "H",
	"ħ": "h",
	"Ḫ": "H",
	"ḫ": "h",
	"Ĩ": "I",
	"ĩ": "i",
	"Ī": "I",
	"ī": "i",
	"Ĭ": "I",
	"ĭ": "i",
	"Į": "I",
	"į": "i",
	"İ": "I",
	"ı": "i",
	"Ĳ": "IJ",
	"ĳ": "ij",
	"Ĵ": "J",
	"ĵ": "j",
	"Ķ": "K",
	"ķ": "k",
	"Ḱ": "K",
	"ḱ": "k",
	"K̆": "K",
	"k̆": "k",
	"Ĺ": "L",
	"ĺ": "l",
	"Ļ": "L",
	"ļ": "l",
	"Ľ": "L",
	"ľ": "l",
	"Ŀ": "L",
	"ŀ": "l",
	"Ł": "l",
	"ł": "l",
	"Ḿ": "M",
	"ḿ": "m",
	"M̆": "M",
	"m̆": "m",
	"Ń": "N",
	"ń": "n",
	"Ņ": "N",
	"ņ": "n",
	"Ň": "N",
	"ň": "n",
	"ŉ": "n",
	"N̆": "N",
	"n̆": "n",
	"Ō": "O",
	"ō": "o",
	"Ŏ": "O",
	"ŏ": "o",
	"Ő": "O",
	"ő": "o",
	"Œ": "OE",
	"œ": "oe",
	"P̆": "P",
	"p̆": "p",
	"Ŕ": "R",
	"ŕ": "r",
	"Ŗ": "R",
	"ŗ": "r",
	"Ř": "R",
	"ř": "r",
	"R̆": "R",
	"r̆": "r",
	"Ȓ": "R",
	"ȓ": "r",
	"Ś": "S",
	"ś": "s",
	"Ŝ": "S",
	"ŝ": "s",
	"Ş": "S",
	"Ș": "S",
	"ș": "s",
	"ş": "s",
	"Š": "S",
	"š": "s",
	"ß": "ss",
	"Ţ": "T",
	"ţ": "t",
	"ț": "t",
	"Ț": "T",
	"Ť": "T",
	"ť": "t",
	"Ŧ": "T",
	"ŧ": "t",
	"T̆": "T",
	"t̆": "t",
	"Ũ": "U",
	"ũ": "u",
	"Ū": "U",
	"ū": "u",
	"Ŭ": "U",
	"ŭ": "u",
	"Ů": "U",
	"ů": "u",
	"Ű": "U",
	"ű": "u",
	"Ų": "U",
	"ų": "u",
	"Ȗ": "U",
	"ȗ": "u",
	"V̆": "V",
	"v̆": "v",
	"Ŵ": "W",
	"ŵ": "w",
	"Ẃ": "W",
	"ẃ": "w",
	"X̆": "X",
	"x̆": "x",
	"Ŷ": "Y",
	"ŷ": "y",
	"Ÿ": "Y",
	"Y̆": "Y",
	"y̆": "y",
	"Ź": "Z",
	"ź": "z",
	"Ż": "Z",
	"ż": "z",
	"Ž": "Z",
	"ž": "z",
	"ſ": "s",
	"ƒ": "f",
	"Ơ": "O",
	"ơ": "o",
	"Ư": "U",
	"ư": "u",
	"Ǎ": "A",
	"ǎ": "a",
	"Ǐ": "I",
	"ǐ": "i",
	"Ǒ": "O",
	"ǒ": "o",
	"Ǔ": "U",
	"ǔ": "u",
	"Ǖ": "U",
	"ǖ": "u",
	"Ǘ": "U",
	"ǘ": "u",
	"Ǚ": "U",
	"ǚ": "u",
	"Ǜ": "U",
	"ǜ": "u",
	"Ứ": "U",
	"ứ": "u",
	"Ṹ": "U",
	"ṹ": "u",
	"Ǻ": "A",
	"ǻ": "a",
	"Ǽ": "AE",
	"ǽ": "ae",
	"Ǿ": "O",
	"ǿ": "o",
	"Þ": "TH",
	"þ": "th",
	"Ṕ": "P",
	"ṕ": "p",
	"Ṥ": "S",
	"ṥ": "s",
	"X́": "X",
	"x́": "x",
	"Ѓ": "Г",
	"ѓ": "г",
	"Ќ": "К",
	"ќ": "к",
	"A̋": "A",
	"a̋": "a",
	"E̋": "E",
	"e̋": "e",
	"I̋": "I",
	"i̋": "i",
	"Ǹ": "N",
	"ǹ": "n",
	"Ồ": "O",
	"ồ": "o",
	"Ṑ": "O",
	"ṑ": "o",
	"Ừ": "U",
	"ừ": "u",
	"Ẁ": "W",
	"ẁ": "w",
	"Ỳ": "Y",
	"ỳ": "y",
	"Ȁ": "A",
	"ȁ": "a",
	"Ȅ": "E",
	"ȅ": "e",
	"Ȉ": "I",
	"ȉ": "i",
	"Ȍ": "O",
	"ȍ": "o",
	"Ȑ": "R",
	"ȑ": "r",
	"Ȕ": "U",
	"ȕ": "u",
	"B̌": "B",
	"b̌": "b",
	"Č̣": "C",
	"č̣": "c",
	"Ê̌": "E",
	"ê̌": "e",
	"F̌": "F",
	"f̌": "f",
	"Ǧ": "G",
	"ǧ": "g",
	"Ȟ": "H",
	"ȟ": "h",
	"J̌": "J",
	"ǰ": "j",
	"Ǩ": "K",
	"ǩ": "k",
	"M̌": "M",
	"m̌": "m",
	"P̌": "P",
	"p̌": "p",
	"Q̌": "Q",
	"q̌": "q",
	"Ř̩": "R",
	"ř̩": "r",
	"Ṧ": "S",
	"ṧ": "s",
	"V̌": "V",
	"v̌": "v",
	"W̌": "W",
	"w̌": "w",
	"X̌": "X",
	"x̌": "x",
	"Y̌": "Y",
	"y̌": "y",
	"A̧": "A",
	"a̧": "a",
	"B̧": "B",
	"b̧": "b",
	"Ḑ": "D",
	"ḑ": "d",
	"Ȩ": "E",
	"ȩ": "e",
	"Ɛ̧": "E",
	"ɛ̧": "e",
	"Ḩ": "H",
	"ḩ": "h",
	"I̧": "I",
	"i̧": "i",
	"Ɨ̧": "I",
	"ɨ̧": "i",
	"M̧": "M",
	"m̧": "m",
	"O̧": "O",
	"o̧": "o",
	"Q̧": "Q",
	"q̧": "q",
	"U̧": "U",
	"u̧": "u",
	"X̧": "X",
	"x̧": "x",
	"Z̧": "Z",
	"z̧": "z",
	"й":"и",
	"Й":"И",
	"ё":"е",
	"Ё":"Е",
};

var chars = Object.keys(characterMap).join('|');
var allAccents = new RegExp(chars, 'g');
var firstAccent = new RegExp(chars, '');

function matcher(match) {
	return characterMap[match];
}

var removeAccents = function(string) {	
	return string.replace(allAccents, matcher);
};

var hasAccents = function(string) {
	return !!string.match(firstAccent);
};

module.exports = removeAccents;
module.exports.has = hasAccents;
module.exports.remove = removeAccents;


/***/ }),

/***/ 4526:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var classNames = (function () {
		// don't inherit from Object so we can skip hasOwnProperty check later
		// http://stackoverflow.com/questions/15518328/creating-js-object-with-object-createnull#answer-21079232
		function StorageObject() {}
		StorageObject.prototype = Object.create(null);

		function _parseArray (resultSet, array) {
			var length = array.length;

			for (var i = 0; i < length; ++i) {
				_parse(resultSet, array[i]);
			}
		}

		var hasOwn = {}.hasOwnProperty;

		function _parseNumber (resultSet, num) {
			resultSet[num] = true;
		}

		function _parseObject (resultSet, object) {
			if (object.toString !== Object.prototype.toString && !object.toString.toString().includes('[native code]')) {
				resultSet[object.toString()] = true;
				return;
			}

			for (var k in object) {
				if (hasOwn.call(object, k)) {
					// set value to false instead of deleting it to avoid changing object structure
					// https://www.smashingmagazine.com/2012/11/writing-fast-memory-efficient-javascript/#de-referencing-misconceptions
					resultSet[k] = !!object[k];
				}
			}
		}

		var SPACE = /\s+/;
		function _parseString (resultSet, str) {
			var array = str.split(SPACE);
			var length = array.length;

			for (var i = 0; i < length; ++i) {
				resultSet[array[i]] = true;
			}
		}

		function _parse (resultSet, arg) {
			if (!arg) return;
			var argType = typeof arg;

			// 'foo bar'
			if (argType === 'string') {
				_parseString(resultSet, arg);

			// ['foo', 'bar', ...]
			} else if (Array.isArray(arg)) {
				_parseArray(resultSet, arg);

			// { 'foo': true, ... }
			} else if (argType === 'object') {
				_parseObject(resultSet, arg);

			// '130'
			} else if (argType === 'number') {
				_parseNumber(resultSet, arg);
			}
		}

		function _classNames () {
			// don't leak arguments
			// https://github.com/petkaantonov/bluebird/wiki/Optimization-killers#32-leaking-arguments
			var len = arguments.length;
			var args = Array(len);
			for (var i = 0; i < len; i++) {
				args[i] = arguments[i];
			}

			var classSet = new StorageObject();
			_parseArray(classSet, args);

			var list = [];

			for (var k in classSet) {
				if (classSet[k]) {
					list.push(k)
				}
			}

			return list.join(' ');
		}

		return _classNames;
	})();

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ 7153:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames () {
		var classes = '';

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (arg) {
				classes = appendClass(classes, parseValue(arg));
			}
		}

		return classes;
	}

	function parseValue (arg) {
		if (typeof arg === 'string' || typeof arg === 'number') {
			return arg;
		}

		if (typeof arg !== 'object') {
			return '';
		}

		if (Array.isArray(arg)) {
			return classNames.apply(null, arg);
		}

		if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
			return arg.toString();
		}

		var classes = '';

		for (var key in arg) {
			if (hasOwn.call(arg, key) && arg[key]) {
				classes = appendClass(classes, key);
			}
		}

		return classes;
	}

	function appendClass (value, newClass) {
		if (!newClass) {
			return value;
		}
	
		if (value) {
			return value + ' ' + newClass;
		}
	
		return value + newClass;
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "__experimentalGetCoreBlocks": function() { return /* binding */ __experimentalGetCoreBlocks; },
  "__experimentalRegisterExperimentalCoreBlocks": function() { return /* binding */ __experimentalRegisterExperimentalCoreBlocks; },
  "registerCoreBlocks": function() { return /* binding */ registerCoreBlocks; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/archives/index.js
var archives_namespaceObject = {};
__webpack_require__.r(archives_namespaceObject);
__webpack_require__.d(archives_namespaceObject, {
  "init": function() { return init; },
  "metadata": function() { return metadata; },
  "name": function() { return archives_name; },
  "settings": function() { return settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/avatar/index.js
var avatar_namespaceObject = {};
__webpack_require__.r(avatar_namespaceObject);
__webpack_require__.d(avatar_namespaceObject, {
  "init": function() { return avatar_init; },
  "metadata": function() { return avatar_metadata; },
  "name": function() { return avatar_name; },
  "settings": function() { return avatar_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/audio/index.js
var build_module_audio_namespaceObject = {};
__webpack_require__.r(build_module_audio_namespaceObject);
__webpack_require__.d(build_module_audio_namespaceObject, {
  "init": function() { return audio_init; },
  "metadata": function() { return audio_metadata; },
  "name": function() { return audio_name; },
  "settings": function() { return audio_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/button/index.js
var build_module_button_namespaceObject = {};
__webpack_require__.r(build_module_button_namespaceObject);
__webpack_require__.d(build_module_button_namespaceObject, {
  "init": function() { return button_init; },
  "metadata": function() { return button_metadata; },
  "name": function() { return button_name; },
  "settings": function() { return button_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/buttons/index.js
var build_module_buttons_namespaceObject = {};
__webpack_require__.r(build_module_buttons_namespaceObject);
__webpack_require__.d(build_module_buttons_namespaceObject, {
  "init": function() { return buttons_init; },
  "metadata": function() { return buttons_metadata; },
  "name": function() { return buttons_name; },
  "settings": function() { return buttons_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/calendar/index.js
var build_module_calendar_namespaceObject = {};
__webpack_require__.r(build_module_calendar_namespaceObject);
__webpack_require__.d(build_module_calendar_namespaceObject, {
  "init": function() { return calendar_init; },
  "metadata": function() { return calendar_metadata; },
  "name": function() { return calendar_name; },
  "settings": function() { return calendar_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/categories/index.js
var categories_namespaceObject = {};
__webpack_require__.r(categories_namespaceObject);
__webpack_require__.d(categories_namespaceObject, {
  "init": function() { return categories_init; },
  "metadata": function() { return categories_metadata; },
  "name": function() { return categories_name; },
  "settings": function() { return categories_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/freeform/index.js
var freeform_namespaceObject = {};
__webpack_require__.r(freeform_namespaceObject);
__webpack_require__.d(freeform_namespaceObject, {
  "init": function() { return freeform_init; },
  "metadata": function() { return freeform_metadata; },
  "name": function() { return freeform_name; },
  "settings": function() { return freeform_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/code/index.js
var build_module_code_namespaceObject = {};
__webpack_require__.r(build_module_code_namespaceObject);
__webpack_require__.d(build_module_code_namespaceObject, {
  "init": function() { return code_init; },
  "metadata": function() { return code_metadata; },
  "name": function() { return code_name; },
  "settings": function() { return code_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/column/index.js
var build_module_column_namespaceObject = {};
__webpack_require__.r(build_module_column_namespaceObject);
__webpack_require__.d(build_module_column_namespaceObject, {
  "init": function() { return column_init; },
  "metadata": function() { return column_metadata; },
  "name": function() { return column_name; },
  "settings": function() { return column_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/columns/index.js
var build_module_columns_namespaceObject = {};
__webpack_require__.r(build_module_columns_namespaceObject);
__webpack_require__.d(build_module_columns_namespaceObject, {
  "init": function() { return columns_init; },
  "metadata": function() { return columns_metadata; },
  "name": function() { return columns_name; },
  "settings": function() { return columns_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comments/index.js
var comments_namespaceObject = {};
__webpack_require__.r(comments_namespaceObject);
__webpack_require__.d(comments_namespaceObject, {
  "init": function() { return comments_init; },
  "metadata": function() { return comments_metadata; },
  "name": function() { return comments_name; },
  "settings": function() { return comments_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-author-avatar/index.js
var build_module_comment_author_avatar_namespaceObject = {};
__webpack_require__.r(build_module_comment_author_avatar_namespaceObject);
__webpack_require__.d(build_module_comment_author_avatar_namespaceObject, {
  "init": function() { return comment_author_avatar_init; },
  "metadata": function() { return comment_author_avatar_metadata; },
  "name": function() { return comment_author_avatar_name; },
  "settings": function() { return comment_author_avatar_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-author-name/index.js
var build_module_comment_author_name_namespaceObject = {};
__webpack_require__.r(build_module_comment_author_name_namespaceObject);
__webpack_require__.d(build_module_comment_author_name_namespaceObject, {
  "init": function() { return comment_author_name_init; },
  "metadata": function() { return comment_author_name_metadata; },
  "name": function() { return comment_author_name_name; },
  "settings": function() { return comment_author_name_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-content/index.js
var build_module_comment_content_namespaceObject = {};
__webpack_require__.r(build_module_comment_content_namespaceObject);
__webpack_require__.d(build_module_comment_content_namespaceObject, {
  "init": function() { return comment_content_init; },
  "metadata": function() { return comment_content_metadata; },
  "name": function() { return comment_content_name; },
  "settings": function() { return comment_content_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-date/index.js
var comment_date_namespaceObject = {};
__webpack_require__.r(comment_date_namespaceObject);
__webpack_require__.d(comment_date_namespaceObject, {
  "init": function() { return comment_date_init; },
  "metadata": function() { return comment_date_metadata; },
  "name": function() { return comment_date_name; },
  "settings": function() { return comment_date_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-edit-link/index.js
var build_module_comment_edit_link_namespaceObject = {};
__webpack_require__.r(build_module_comment_edit_link_namespaceObject);
__webpack_require__.d(build_module_comment_edit_link_namespaceObject, {
  "init": function() { return comment_edit_link_init; },
  "metadata": function() { return comment_edit_link_metadata; },
  "name": function() { return comment_edit_link_name; },
  "settings": function() { return comment_edit_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-reply-link/index.js
var build_module_comment_reply_link_namespaceObject = {};
__webpack_require__.r(build_module_comment_reply_link_namespaceObject);
__webpack_require__.d(build_module_comment_reply_link_namespaceObject, {
  "init": function() { return comment_reply_link_init; },
  "metadata": function() { return comment_reply_link_metadata; },
  "name": function() { return comment_reply_link_name; },
  "settings": function() { return comment_reply_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comment-template/index.js
var comment_template_namespaceObject = {};
__webpack_require__.r(comment_template_namespaceObject);
__webpack_require__.d(comment_template_namespaceObject, {
  "init": function() { return comment_template_init; },
  "metadata": function() { return comment_template_metadata; },
  "name": function() { return comment_template_name; },
  "settings": function() { return comment_template_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comments-pagination-previous/index.js
var comments_pagination_previous_namespaceObject = {};
__webpack_require__.r(comments_pagination_previous_namespaceObject);
__webpack_require__.d(comments_pagination_previous_namespaceObject, {
  "init": function() { return comments_pagination_previous_init; },
  "metadata": function() { return comments_pagination_previous_metadata; },
  "name": function() { return comments_pagination_previous_name; },
  "settings": function() { return comments_pagination_previous_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comments-pagination/index.js
var comments_pagination_namespaceObject = {};
__webpack_require__.r(comments_pagination_namespaceObject);
__webpack_require__.d(comments_pagination_namespaceObject, {
  "init": function() { return comments_pagination_init; },
  "metadata": function() { return comments_pagination_metadata; },
  "name": function() { return comments_pagination_name; },
  "settings": function() { return comments_pagination_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comments-pagination-next/index.js
var comments_pagination_next_namespaceObject = {};
__webpack_require__.r(comments_pagination_next_namespaceObject);
__webpack_require__.d(comments_pagination_next_namespaceObject, {
  "init": function() { return comments_pagination_next_init; },
  "metadata": function() { return comments_pagination_next_metadata; },
  "name": function() { return comments_pagination_next_name; },
  "settings": function() { return comments_pagination_next_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comments-pagination-numbers/index.js
var comments_pagination_numbers_namespaceObject = {};
__webpack_require__.r(comments_pagination_numbers_namespaceObject);
__webpack_require__.d(comments_pagination_numbers_namespaceObject, {
  "init": function() { return comments_pagination_numbers_init; },
  "metadata": function() { return comments_pagination_numbers_metadata; },
  "name": function() { return comments_pagination_numbers_name; },
  "settings": function() { return comments_pagination_numbers_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/comments-title/index.js
var comments_title_namespaceObject = {};
__webpack_require__.r(comments_title_namespaceObject);
__webpack_require__.d(comments_title_namespaceObject, {
  "init": function() { return comments_title_init; },
  "metadata": function() { return comments_title_metadata; },
  "name": function() { return comments_title_name; },
  "settings": function() { return comments_title_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/cover/index.js
var build_module_cover_namespaceObject = {};
__webpack_require__.r(build_module_cover_namespaceObject);
__webpack_require__.d(build_module_cover_namespaceObject, {
  "init": function() { return cover_init; },
  "metadata": function() { return cover_metadata; },
  "name": function() { return cover_name; },
  "settings": function() { return cover_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/details/index.js
var build_module_details_namespaceObject = {};
__webpack_require__.r(build_module_details_namespaceObject);
__webpack_require__.d(build_module_details_namespaceObject, {
  "init": function() { return details_init; },
  "metadata": function() { return details_metadata; },
  "name": function() { return details_name; },
  "settings": function() { return details_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/embed/index.js
var embed_namespaceObject = {};
__webpack_require__.r(embed_namespaceObject);
__webpack_require__.d(embed_namespaceObject, {
  "init": function() { return embed_init; },
  "metadata": function() { return embed_metadata; },
  "name": function() { return embed_name; },
  "settings": function() { return embed_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/file/index.js
var build_module_file_namespaceObject = {};
__webpack_require__.r(build_module_file_namespaceObject);
__webpack_require__.d(build_module_file_namespaceObject, {
  "init": function() { return file_init; },
  "metadata": function() { return file_metadata; },
  "name": function() { return file_name; },
  "settings": function() { return file_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/gallery/index.js
var build_module_gallery_namespaceObject = {};
__webpack_require__.r(build_module_gallery_namespaceObject);
__webpack_require__.d(build_module_gallery_namespaceObject, {
  "init": function() { return gallery_init; },
  "metadata": function() { return gallery_metadata; },
  "name": function() { return gallery_name; },
  "settings": function() { return gallery_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/group/index.js
var build_module_group_namespaceObject = {};
__webpack_require__.r(build_module_group_namespaceObject);
__webpack_require__.d(build_module_group_namespaceObject, {
  "init": function() { return group_init; },
  "metadata": function() { return group_metadata; },
  "name": function() { return group_name; },
  "settings": function() { return group_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/heading/index.js
var build_module_heading_namespaceObject = {};
__webpack_require__.r(build_module_heading_namespaceObject);
__webpack_require__.d(build_module_heading_namespaceObject, {
  "init": function() { return heading_init; },
  "metadata": function() { return heading_metadata; },
  "name": function() { return heading_name; },
  "settings": function() { return heading_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/home-link/index.js
var home_link_namespaceObject = {};
__webpack_require__.r(home_link_namespaceObject);
__webpack_require__.d(home_link_namespaceObject, {
  "init": function() { return home_link_init; },
  "metadata": function() { return home_link_metadata; },
  "name": function() { return home_link_name; },
  "settings": function() { return home_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/html/index.js
var build_module_html_namespaceObject = {};
__webpack_require__.r(build_module_html_namespaceObject);
__webpack_require__.d(build_module_html_namespaceObject, {
  "init": function() { return html_init; },
  "metadata": function() { return html_metadata; },
  "name": function() { return html_name; },
  "settings": function() { return html_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/image/index.js
var build_module_image_namespaceObject = {};
__webpack_require__.r(build_module_image_namespaceObject);
__webpack_require__.d(build_module_image_namespaceObject, {
  "init": function() { return image_init; },
  "metadata": function() { return image_metadata; },
  "name": function() { return image_name; },
  "settings": function() { return image_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/latest-comments/index.js
var latest_comments_namespaceObject = {};
__webpack_require__.r(latest_comments_namespaceObject);
__webpack_require__.d(latest_comments_namespaceObject, {
  "init": function() { return latest_comments_init; },
  "metadata": function() { return latest_comments_metadata; },
  "name": function() { return latest_comments_name; },
  "settings": function() { return latest_comments_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/latest-posts/index.js
var latest_posts_namespaceObject = {};
__webpack_require__.r(latest_posts_namespaceObject);
__webpack_require__.d(latest_posts_namespaceObject, {
  "init": function() { return latest_posts_init; },
  "metadata": function() { return latest_posts_metadata; },
  "name": function() { return latest_posts_name; },
  "settings": function() { return latest_posts_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/list/index.js
var build_module_list_namespaceObject = {};
__webpack_require__.r(build_module_list_namespaceObject);
__webpack_require__.d(build_module_list_namespaceObject, {
  "init": function() { return list_init; },
  "metadata": function() { return list_metadata; },
  "name": function() { return list_name; },
  "settings": function() { return list_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/list-item/index.js
var build_module_list_item_namespaceObject = {};
__webpack_require__.r(build_module_list_item_namespaceObject);
__webpack_require__.d(build_module_list_item_namespaceObject, {
  "init": function() { return list_item_init; },
  "metadata": function() { return list_item_metadata; },
  "name": function() { return list_item_name; },
  "settings": function() { return list_item_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/loginout/index.js
var loginout_namespaceObject = {};
__webpack_require__.r(loginout_namespaceObject);
__webpack_require__.d(loginout_namespaceObject, {
  "init": function() { return loginout_init; },
  "metadata": function() { return loginout_metadata; },
  "name": function() { return loginout_name; },
  "settings": function() { return loginout_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/media-text/index.js
var media_text_namespaceObject = {};
__webpack_require__.r(media_text_namespaceObject);
__webpack_require__.d(media_text_namespaceObject, {
  "init": function() { return media_text_init; },
  "metadata": function() { return media_text_metadata; },
  "name": function() { return media_text_name; },
  "settings": function() { return media_text_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/missing/index.js
var missing_namespaceObject = {};
__webpack_require__.r(missing_namespaceObject);
__webpack_require__.d(missing_namespaceObject, {
  "init": function() { return missing_init; },
  "metadata": function() { return missing_metadata; },
  "name": function() { return missing_name; },
  "settings": function() { return missing_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/more/index.js
var build_module_more_namespaceObject = {};
__webpack_require__.r(build_module_more_namespaceObject);
__webpack_require__.d(build_module_more_namespaceObject, {
  "init": function() { return more_init; },
  "metadata": function() { return more_metadata; },
  "name": function() { return more_name; },
  "settings": function() { return more_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/navigation/index.js
var build_module_navigation_namespaceObject = {};
__webpack_require__.r(build_module_navigation_namespaceObject);
__webpack_require__.d(build_module_navigation_namespaceObject, {
  "init": function() { return navigation_init; },
  "metadata": function() { return navigation_metadata; },
  "name": function() { return navigation_name; },
  "settings": function() { return navigation_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/navigation-link/index.js
var navigation_link_namespaceObject = {};
__webpack_require__.r(navigation_link_namespaceObject);
__webpack_require__.d(navigation_link_namespaceObject, {
  "init": function() { return navigation_link_init; },
  "metadata": function() { return navigation_link_metadata; },
  "name": function() { return navigation_link_name; },
  "settings": function() { return navigation_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/navigation-submenu/index.js
var navigation_submenu_namespaceObject = {};
__webpack_require__.r(navigation_submenu_namespaceObject);
__webpack_require__.d(navigation_submenu_namespaceObject, {
  "init": function() { return navigation_submenu_init; },
  "metadata": function() { return navigation_submenu_metadata; },
  "name": function() { return navigation_submenu_name; },
  "settings": function() { return navigation_submenu_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/nextpage/index.js
var nextpage_namespaceObject = {};
__webpack_require__.r(nextpage_namespaceObject);
__webpack_require__.d(nextpage_namespaceObject, {
  "init": function() { return nextpage_init; },
  "metadata": function() { return nextpage_metadata; },
  "name": function() { return nextpage_name; },
  "settings": function() { return nextpage_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/pattern/index.js
var pattern_namespaceObject = {};
__webpack_require__.r(pattern_namespaceObject);
__webpack_require__.d(pattern_namespaceObject, {
  "init": function() { return pattern_init; },
  "metadata": function() { return pattern_metadata; },
  "name": function() { return pattern_name; },
  "settings": function() { return pattern_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/page-list/index.js
var page_list_namespaceObject = {};
__webpack_require__.r(page_list_namespaceObject);
__webpack_require__.d(page_list_namespaceObject, {
  "init": function() { return page_list_init; },
  "metadata": function() { return page_list_metadata; },
  "name": function() { return page_list_name; },
  "settings": function() { return page_list_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/page-list-item/index.js
var page_list_item_namespaceObject = {};
__webpack_require__.r(page_list_item_namespaceObject);
__webpack_require__.d(page_list_item_namespaceObject, {
  "init": function() { return page_list_item_init; },
  "metadata": function() { return page_list_item_metadata; },
  "name": function() { return page_list_item_name; },
  "settings": function() { return page_list_item_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/paragraph/index.js
var build_module_paragraph_namespaceObject = {};
__webpack_require__.r(build_module_paragraph_namespaceObject);
__webpack_require__.d(build_module_paragraph_namespaceObject, {
  "init": function() { return paragraph_init; },
  "metadata": function() { return paragraph_metadata; },
  "name": function() { return paragraph_name; },
  "settings": function() { return paragraph_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-author/index.js
var build_module_post_author_namespaceObject = {};
__webpack_require__.r(build_module_post_author_namespaceObject);
__webpack_require__.d(build_module_post_author_namespaceObject, {
  "init": function() { return post_author_init; },
  "metadata": function() { return post_author_metadata; },
  "name": function() { return post_author_name; },
  "settings": function() { return post_author_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-author-name/index.js
var post_author_name_namespaceObject = {};
__webpack_require__.r(post_author_name_namespaceObject);
__webpack_require__.d(post_author_name_namespaceObject, {
  "init": function() { return post_author_name_init; },
  "metadata": function() { return post_author_name_metadata; },
  "name": function() { return post_author_name_name; },
  "settings": function() { return post_author_name_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-author-biography/index.js
var post_author_biography_namespaceObject = {};
__webpack_require__.r(post_author_biography_namespaceObject);
__webpack_require__.d(post_author_biography_namespaceObject, {
  "init": function() { return post_author_biography_init; },
  "metadata": function() { return post_author_biography_metadata; },
  "name": function() { return post_author_biography_name; },
  "settings": function() { return post_author_biography_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-comment/index.js
var post_comment_namespaceObject = {};
__webpack_require__.r(post_comment_namespaceObject);
__webpack_require__.d(post_comment_namespaceObject, {
  "init": function() { return post_comment_init; },
  "metadata": function() { return post_comment_metadata; },
  "name": function() { return post_comment_name; },
  "settings": function() { return post_comment_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-comments-count/index.js
var build_module_post_comments_count_namespaceObject = {};
__webpack_require__.r(build_module_post_comments_count_namespaceObject);
__webpack_require__.d(build_module_post_comments_count_namespaceObject, {
  "init": function() { return post_comments_count_init; },
  "metadata": function() { return post_comments_count_metadata; },
  "name": function() { return post_comments_count_name; },
  "settings": function() { return post_comments_count_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-comments-form/index.js
var build_module_post_comments_form_namespaceObject = {};
__webpack_require__.r(build_module_post_comments_form_namespaceObject);
__webpack_require__.d(build_module_post_comments_form_namespaceObject, {
  "init": function() { return post_comments_form_init; },
  "metadata": function() { return post_comments_form_metadata; },
  "name": function() { return post_comments_form_name; },
  "settings": function() { return post_comments_form_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-comments-link/index.js
var post_comments_link_namespaceObject = {};
__webpack_require__.r(post_comments_link_namespaceObject);
__webpack_require__.d(post_comments_link_namespaceObject, {
  "init": function() { return post_comments_link_init; },
  "metadata": function() { return post_comments_link_metadata; },
  "name": function() { return post_comments_link_name; },
  "settings": function() { return post_comments_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-content/index.js
var build_module_post_content_namespaceObject = {};
__webpack_require__.r(build_module_post_content_namespaceObject);
__webpack_require__.d(build_module_post_content_namespaceObject, {
  "init": function() { return post_content_init; },
  "metadata": function() { return post_content_metadata; },
  "name": function() { return post_content_name; },
  "settings": function() { return post_content_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-date/index.js
var build_module_post_date_namespaceObject = {};
__webpack_require__.r(build_module_post_date_namespaceObject);
__webpack_require__.d(build_module_post_date_namespaceObject, {
  "init": function() { return post_date_init; },
  "metadata": function() { return post_date_metadata; },
  "name": function() { return post_date_name; },
  "settings": function() { return post_date_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-excerpt/index.js
var build_module_post_excerpt_namespaceObject = {};
__webpack_require__.r(build_module_post_excerpt_namespaceObject);
__webpack_require__.d(build_module_post_excerpt_namespaceObject, {
  "init": function() { return post_excerpt_init; },
  "metadata": function() { return post_excerpt_metadata; },
  "name": function() { return post_excerpt_name; },
  "settings": function() { return post_excerpt_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-featured-image/index.js
var build_module_post_featured_image_namespaceObject = {};
__webpack_require__.r(build_module_post_featured_image_namespaceObject);
__webpack_require__.d(build_module_post_featured_image_namespaceObject, {
  "init": function() { return post_featured_image_init; },
  "metadata": function() { return post_featured_image_metadata; },
  "name": function() { return post_featured_image_name; },
  "settings": function() { return post_featured_image_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-navigation-link/index.js
var post_navigation_link_namespaceObject = {};
__webpack_require__.r(post_navigation_link_namespaceObject);
__webpack_require__.d(post_navigation_link_namespaceObject, {
  "init": function() { return post_navigation_link_init; },
  "metadata": function() { return post_navigation_link_metadata; },
  "name": function() { return post_navigation_link_name; },
  "settings": function() { return post_navigation_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-template/index.js
var post_template_namespaceObject = {};
__webpack_require__.r(post_template_namespaceObject);
__webpack_require__.d(post_template_namespaceObject, {
  "init": function() { return post_template_init; },
  "metadata": function() { return post_template_metadata; },
  "name": function() { return post_template_name; },
  "settings": function() { return post_template_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-terms/index.js
var build_module_post_terms_namespaceObject = {};
__webpack_require__.r(build_module_post_terms_namespaceObject);
__webpack_require__.d(build_module_post_terms_namespaceObject, {
  "init": function() { return post_terms_init; },
  "metadata": function() { return post_terms_metadata; },
  "name": function() { return post_terms_name; },
  "settings": function() { return post_terms_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-time-to-read/index.js
var post_time_to_read_namespaceObject = {};
__webpack_require__.r(post_time_to_read_namespaceObject);
__webpack_require__.d(post_time_to_read_namespaceObject, {
  "init": function() { return post_time_to_read_init; },
  "metadata": function() { return post_time_to_read_metadata; },
  "name": function() { return post_time_to_read_name; },
  "settings": function() { return post_time_to_read_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/post-title/index.js
var post_title_namespaceObject = {};
__webpack_require__.r(post_title_namespaceObject);
__webpack_require__.d(post_title_namespaceObject, {
  "init": function() { return post_title_init; },
  "metadata": function() { return post_title_metadata; },
  "name": function() { return post_title_name; },
  "settings": function() { return post_title_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/preformatted/index.js
var build_module_preformatted_namespaceObject = {};
__webpack_require__.r(build_module_preformatted_namespaceObject);
__webpack_require__.d(build_module_preformatted_namespaceObject, {
  "init": function() { return preformatted_init; },
  "metadata": function() { return preformatted_metadata; },
  "name": function() { return preformatted_name; },
  "settings": function() { return preformatted_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/pullquote/index.js
var build_module_pullquote_namespaceObject = {};
__webpack_require__.r(build_module_pullquote_namespaceObject);
__webpack_require__.d(build_module_pullquote_namespaceObject, {
  "init": function() { return pullquote_init; },
  "metadata": function() { return pullquote_metadata; },
  "name": function() { return pullquote_name; },
  "settings": function() { return pullquote_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query/index.js
var query_namespaceObject = {};
__webpack_require__.r(query_namespaceObject);
__webpack_require__.d(query_namespaceObject, {
  "init": function() { return query_init; },
  "metadata": function() { return query_metadata; },
  "name": function() { return query_name; },
  "settings": function() { return query_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query-no-results/index.js
var query_no_results_namespaceObject = {};
__webpack_require__.r(query_no_results_namespaceObject);
__webpack_require__.d(query_no_results_namespaceObject, {
  "init": function() { return query_no_results_init; },
  "metadata": function() { return query_no_results_metadata; },
  "name": function() { return query_no_results_name; },
  "settings": function() { return query_no_results_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query-pagination/index.js
var build_module_query_pagination_namespaceObject = {};
__webpack_require__.r(build_module_query_pagination_namespaceObject);
__webpack_require__.d(build_module_query_pagination_namespaceObject, {
  "init": function() { return query_pagination_init; },
  "metadata": function() { return query_pagination_metadata; },
  "name": function() { return query_pagination_name; },
  "settings": function() { return query_pagination_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query-pagination-next/index.js
var build_module_query_pagination_next_namespaceObject = {};
__webpack_require__.r(build_module_query_pagination_next_namespaceObject);
__webpack_require__.d(build_module_query_pagination_next_namespaceObject, {
  "init": function() { return query_pagination_next_init; },
  "metadata": function() { return query_pagination_next_metadata; },
  "name": function() { return query_pagination_next_name; },
  "settings": function() { return query_pagination_next_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query-pagination-numbers/index.js
var build_module_query_pagination_numbers_namespaceObject = {};
__webpack_require__.r(build_module_query_pagination_numbers_namespaceObject);
__webpack_require__.d(build_module_query_pagination_numbers_namespaceObject, {
  "init": function() { return query_pagination_numbers_init; },
  "metadata": function() { return query_pagination_numbers_metadata; },
  "name": function() { return query_pagination_numbers_name; },
  "settings": function() { return query_pagination_numbers_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query-pagination-previous/index.js
var build_module_query_pagination_previous_namespaceObject = {};
__webpack_require__.r(build_module_query_pagination_previous_namespaceObject);
__webpack_require__.d(build_module_query_pagination_previous_namespaceObject, {
  "init": function() { return query_pagination_previous_init; },
  "metadata": function() { return query_pagination_previous_metadata; },
  "name": function() { return query_pagination_previous_name; },
  "settings": function() { return query_pagination_previous_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/query-title/index.js
var query_title_namespaceObject = {};
__webpack_require__.r(query_title_namespaceObject);
__webpack_require__.d(query_title_namespaceObject, {
  "init": function() { return query_title_init; },
  "metadata": function() { return query_title_metadata; },
  "name": function() { return query_title_name; },
  "settings": function() { return query_title_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/quote/index.js
var build_module_quote_namespaceObject = {};
__webpack_require__.r(build_module_quote_namespaceObject);
__webpack_require__.d(build_module_quote_namespaceObject, {
  "init": function() { return quote_init; },
  "metadata": function() { return quote_metadata; },
  "name": function() { return quote_name; },
  "settings": function() { return quote_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/block/index.js
var block_namespaceObject = {};
__webpack_require__.r(block_namespaceObject);
__webpack_require__.d(block_namespaceObject, {
  "init": function() { return block_init; },
  "metadata": function() { return block_metadata; },
  "name": function() { return block_name; },
  "settings": function() { return block_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/read-more/index.js
var read_more_namespaceObject = {};
__webpack_require__.r(read_more_namespaceObject);
__webpack_require__.d(read_more_namespaceObject, {
  "init": function() { return read_more_init; },
  "metadata": function() { return read_more_metadata; },
  "name": function() { return read_more_name; },
  "settings": function() { return read_more_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/rss/index.js
var build_module_rss_namespaceObject = {};
__webpack_require__.r(build_module_rss_namespaceObject);
__webpack_require__.d(build_module_rss_namespaceObject, {
  "init": function() { return rss_init; },
  "metadata": function() { return rss_metadata; },
  "name": function() { return rss_name; },
  "settings": function() { return rss_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/search/index.js
var build_module_search_namespaceObject = {};
__webpack_require__.r(build_module_search_namespaceObject);
__webpack_require__.d(build_module_search_namespaceObject, {
  "init": function() { return search_init; },
  "metadata": function() { return search_metadata; },
  "name": function() { return search_name; },
  "settings": function() { return search_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/separator/index.js
var build_module_separator_namespaceObject = {};
__webpack_require__.r(build_module_separator_namespaceObject);
__webpack_require__.d(build_module_separator_namespaceObject, {
  "init": function() { return separator_init; },
  "metadata": function() { return separator_metadata; },
  "name": function() { return separator_name; },
  "settings": function() { return separator_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/shortcode/index.js
var build_module_shortcode_namespaceObject = {};
__webpack_require__.r(build_module_shortcode_namespaceObject);
__webpack_require__.d(build_module_shortcode_namespaceObject, {
  "init": function() { return shortcode_init; },
  "metadata": function() { return shortcode_metadata; },
  "name": function() { return shortcode_name; },
  "settings": function() { return shortcode_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/site-logo/index.js
var build_module_site_logo_namespaceObject = {};
__webpack_require__.r(build_module_site_logo_namespaceObject);
__webpack_require__.d(build_module_site_logo_namespaceObject, {
  "init": function() { return site_logo_init; },
  "metadata": function() { return site_logo_metadata; },
  "name": function() { return site_logo_name; },
  "settings": function() { return site_logo_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/site-tagline/index.js
var site_tagline_namespaceObject = {};
__webpack_require__.r(site_tagline_namespaceObject);
__webpack_require__.d(site_tagline_namespaceObject, {
  "init": function() { return site_tagline_init; },
  "metadata": function() { return site_tagline_metadata; },
  "name": function() { return site_tagline_name; },
  "settings": function() { return site_tagline_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/site-title/index.js
var site_title_namespaceObject = {};
__webpack_require__.r(site_title_namespaceObject);
__webpack_require__.d(site_title_namespaceObject, {
  "init": function() { return site_title_init; },
  "metadata": function() { return site_title_metadata; },
  "name": function() { return site_title_name; },
  "settings": function() { return site_title_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/social-link/index.js
var social_link_namespaceObject = {};
__webpack_require__.r(social_link_namespaceObject);
__webpack_require__.d(social_link_namespaceObject, {
  "init": function() { return social_link_init; },
  "metadata": function() { return social_link_metadata; },
  "name": function() { return social_link_name; },
  "settings": function() { return social_link_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/social-links/index.js
var social_links_namespaceObject = {};
__webpack_require__.r(social_links_namespaceObject);
__webpack_require__.d(social_links_namespaceObject, {
  "init": function() { return social_links_init; },
  "metadata": function() { return social_links_metadata; },
  "name": function() { return social_links_name; },
  "settings": function() { return social_links_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/spacer/index.js
var spacer_namespaceObject = {};
__webpack_require__.r(spacer_namespaceObject);
__webpack_require__.d(spacer_namespaceObject, {
  "init": function() { return spacer_init; },
  "metadata": function() { return spacer_metadata; },
  "name": function() { return spacer_name; },
  "settings": function() { return spacer_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/table/index.js
var build_module_table_namespaceObject = {};
__webpack_require__.r(build_module_table_namespaceObject);
__webpack_require__.d(build_module_table_namespaceObject, {
  "init": function() { return table_init; },
  "metadata": function() { return table_metadata; },
  "name": function() { return table_name; },
  "settings": function() { return table_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/table-of-contents/index.js
var table_of_contents_namespaceObject = {};
__webpack_require__.r(table_of_contents_namespaceObject);
__webpack_require__.d(table_of_contents_namespaceObject, {
  "init": function() { return table_of_contents_init; },
  "metadata": function() { return table_of_contents_metadata; },
  "name": function() { return table_of_contents_name; },
  "settings": function() { return table_of_contents_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/tag-cloud/index.js
var tag_cloud_namespaceObject = {};
__webpack_require__.r(tag_cloud_namespaceObject);
__webpack_require__.d(tag_cloud_namespaceObject, {
  "init": function() { return tag_cloud_init; },
  "metadata": function() { return tag_cloud_metadata; },
  "name": function() { return tag_cloud_name; },
  "settings": function() { return tag_cloud_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/template-part/index.js
var template_part_namespaceObject = {};
__webpack_require__.r(template_part_namespaceObject);
__webpack_require__.d(template_part_namespaceObject, {
  "init": function() { return template_part_init; },
  "metadata": function() { return template_part_metadata; },
  "name": function() { return template_part_name; },
  "settings": function() { return template_part_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/term-description/index.js
var build_module_term_description_namespaceObject = {};
__webpack_require__.r(build_module_term_description_namespaceObject);
__webpack_require__.d(build_module_term_description_namespaceObject, {
  "init": function() { return term_description_init; },
  "metadata": function() { return term_description_metadata; },
  "name": function() { return term_description_name; },
  "settings": function() { return term_description_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/text-columns/index.js
var text_columns_namespaceObject = {};
__webpack_require__.r(text_columns_namespaceObject);
__webpack_require__.d(text_columns_namespaceObject, {
  "init": function() { return text_columns_init; },
  "metadata": function() { return text_columns_metadata; },
  "name": function() { return text_columns_name; },
  "settings": function() { return text_columns_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/verse/index.js
var build_module_verse_namespaceObject = {};
__webpack_require__.r(build_module_verse_namespaceObject);
__webpack_require__.d(build_module_verse_namespaceObject, {
  "init": function() { return verse_init; },
  "metadata": function() { return verse_metadata; },
  "name": function() { return verse_name; },
  "settings": function() { return verse_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/video/index.js
var build_module_video_namespaceObject = {};
__webpack_require__.r(build_module_video_namespaceObject);
__webpack_require__.d(build_module_video_namespaceObject, {
  "init": function() { return video_init; },
  "metadata": function() { return video_metadata; },
  "name": function() { return video_name; },
  "settings": function() { return video_settings; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-library/build-module/footnotes/index.js
var footnotes_namespaceObject = {};
__webpack_require__.r(footnotes_namespaceObject);
__webpack_require__.d(footnotes_namespaceObject, {
  "init": function() { return footnotes_init; },
  "metadata": function() { return footnotes_metadata; },
  "name": function() { return footnotes_name; },
  "settings": function() { return footnotes_settings; }
});

;// CONCATENATED MODULE: external ["wp","blocks"]
var external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// CONCATENATED MODULE: external ["wp","element"]
var external_wp_element_namespaceObject = window["wp"]["element"];
;// CONCATENATED MODULE: external ["wp","primitives"]
var external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/archive.js


/**
 * WordPress dependencies
 */

const archive = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 6.2h-5.9l-.6-1.1c-.3-.7-1-1.1-1.8-1.1H5c-1.1 0-2 .9-2 2v11.8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V8.2c0-1.1-.9-2-2-2zm.5 11.6c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h5.8c.2 0 .4.1.4.3l1 2H19c.3 0 .5.2.5.5v9.5zM8 12.8h8v-1.5H8v1.5zm0 3h8v-1.5H8v1.5z"
}));
/* harmony default export */ var library_archive = (archive);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/utils/init-block.js
/**
 * WordPress dependencies
 */

/**
 * Function to register an individual block.
 *
 * @param {Object} block The block to be registered.
 *
 * @return {WPBlockType | undefined} The block, if it has been successfully registered;
 *                        otherwise `undefined`.
 */

function initBlock(block) {
  if (!block) {
    return;
  }

  const {
    metadata,
    settings,
    name
  } = block;
  return (0,external_wp_blocks_namespaceObject.registerBlockType)({
    name,
    ...metadata
  }, settings);
}

;// CONCATENATED MODULE: external ["wp","components"]
var external_wp_components_namespaceObject = window["wp"]["components"];
;// CONCATENATED MODULE: external ["wp","i18n"]
var external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// CONCATENATED MODULE: external ["wp","blockEditor"]
var external_wp_blockEditor_namespaceObject = window["wp"]["blockEditor"];
;// CONCATENATED MODULE: external ["wp","serverSideRender"]
var external_wp_serverSideRender_namespaceObject = window["wp"]["serverSideRender"];
var external_wp_serverSideRender_default = /*#__PURE__*/__webpack_require__.n(external_wp_serverSideRender_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/archives/edit.js


/**
 * WordPress dependencies
 */




function ArchivesEdit({
  attributes,
  setAttributes
}) {
  const {
    showLabel,
    showPostCounts,
    displayAsDropdown,
    type
  } = attributes;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display as dropdown'),
    checked: displayAsDropdown,
    onChange: () => setAttributes({
      displayAsDropdown: !displayAsDropdown
    })
  }), displayAsDropdown && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show label'),
    checked: showLabel,
    onChange: () => setAttributes({
      showLabel: !showLabel
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show post counts'),
    checked: showPostCounts,
    onChange: () => setAttributes({
      showPostCounts: !showPostCounts
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Group by:'),
    options: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Year'),
      value: 'yearly'
    }, {
      label: (0,external_wp_i18n_namespaceObject.__)('Month'),
      value: 'monthly'
    }, {
      label: (0,external_wp_i18n_namespaceObject.__)('Week'),
      value: 'weekly'
    }, {
      label: (0,external_wp_i18n_namespaceObject.__)('Day'),
      value: 'daily'
    }],
    value: type,
    onChange: value => setAttributes({
      type: value
    })
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)()
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, null, (0,external_wp_element_namespaceObject.createElement)((external_wp_serverSideRender_default()), {
    block: "core/archives",
    skipBlockSupportAttributes: true,
    attributes: attributes
  }))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/archives/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/archives",
  title: "Archives",
  category: "widgets",
  description: "Display a date archive of your posts.",
  textdomain: "default",
  attributes: {
    displayAsDropdown: {
      type: "boolean",
      "default": false
    },
    showLabel: {
      type: "boolean",
      "default": true
    },
    showPostCounts: {
      type: "boolean",
      "default": false
    },
    type: {
      type: "string",
      "default": "monthly"
    }
  },
  supports: {
    align: true,
    html: false,
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-archives-editor"
};

const {
  name: archives_name
} = metadata;

const settings = {
  icon: library_archive,
  example: {},
  edit: ArchivesEdit
};
const init = () => initBlock({
  name: archives_name,
  metadata,
  settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/comment-author-avatar.js


/**
 * WordPress dependencies
 */

const commentAuthorAvatar = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  fillRule: "evenodd",
  d: "M7.25 16.437a6.5 6.5 0 1 1 9.5 0V16A2.75 2.75 0 0 0 14 13.25h-4A2.75 2.75 0 0 0 7.25 16v.437Zm1.5 1.193a6.47 6.47 0 0 0 3.25.87 6.47 6.47 0 0 0 3.25-.87V16c0-.69-.56-1.25-1.25-1.25h-4c-.69 0-1.25.56-1.25 1.25v1.63ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm10-2a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z",
  clipRule: "evenodd"
}));
/* harmony default export */ var comment_author_avatar = (commentAuthorAvatar);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(7153);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
;// CONCATENATED MODULE: external ["wp","url"]
var external_wp_url_namespaceObject = window["wp"]["url"];
;// CONCATENATED MODULE: external ["wp","coreData"]
var external_wp_coreData_namespaceObject = window["wp"]["coreData"];
;// CONCATENATED MODULE: external ["wp","data"]
var external_wp_data_namespaceObject = window["wp"]["data"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/avatar/hooks.js
/**
 * WordPress dependencies
 */





function getAvatarSizes(sizes) {
  const minSize = sizes ? sizes[0] : 24;
  const maxSize = sizes ? sizes[sizes.length - 1] : 96;
  const maxSizeBuffer = Math.floor(maxSize * 2.5);
  return {
    minSize,
    maxSize: maxSizeBuffer
  };
}

function useDefaultAvatar() {
  const {
    avatarURL: defaultAvatarUrl
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      __experimentalDiscussionSettings
    } = getSettings();
    return __experimentalDiscussionSettings;
  });
  return defaultAvatarUrl;
}

function useCommentAvatar({
  commentId
}) {
  const [avatars] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'comment', 'author_avatar_urls', commentId);
  const [authorName] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'comment', 'author_name', commentId);
  const avatarUrls = avatars ? Object.values(avatars) : null;
  const sizes = avatars ? Object.keys(avatars) : null;
  const {
    minSize,
    maxSize
  } = getAvatarSizes(sizes);
  const defaultAvatar = useDefaultAvatar();
  return {
    src: avatarUrls ? avatarUrls[avatarUrls.length - 1] : defaultAvatar,
    minSize,
    maxSize,
    // translators: %s is the Author name.
    alt: authorName ? // translators: %s is the Author name.
    (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('%s Avatar'), authorName) : (0,external_wp_i18n_namespaceObject.__)('Default Avatar')
  };
}
function useUserAvatar({
  userId,
  postId,
  postType
}) {
  const {
    authorDetails
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedEntityRecord,
      getUser
    } = select(external_wp_coreData_namespaceObject.store);

    if (userId) {
      return {
        authorDetails: getUser(userId)
      };
    }

    const _authorId = getEditedEntityRecord('postType', postType, postId)?.author;

    return {
      authorDetails: _authorId ? getUser(_authorId) : null
    };
  }, [postType, postId, userId]);
  const avatarUrls = authorDetails?.avatar_urls ? Object.values(authorDetails.avatar_urls) : null;
  const sizes = authorDetails?.avatar_urls ? Object.keys(authorDetails.avatar_urls) : null;
  const {
    minSize,
    maxSize
  } = getAvatarSizes(sizes);
  const defaultAvatar = useDefaultAvatar();
  return {
    src: avatarUrls ? avatarUrls[avatarUrls.length - 1] : defaultAvatar,
    minSize,
    maxSize,
    alt: authorDetails ? // translators: %s is the Author name.
    (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('%s Avatar'), authorDetails?.name) : (0,external_wp_i18n_namespaceObject.__)('Default Avatar')
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/avatar/user-control.js


/**
 * WordPress dependencies
 */





const AUTHORS_QUERY = {
  who: 'authors',
  per_page: -1,
  _fields: 'id,name',
  context: 'view'
};

function UserControl({
  value,
  onChange
}) {
  const [filteredAuthorsList, setFilteredAuthorsList] = (0,external_wp_element_namespaceObject.useState)();
  const authorsList = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getUsers
    } = select(external_wp_coreData_namespaceObject.store);
    return getUsers(AUTHORS_QUERY);
  }, []);

  if (!authorsList) {
    return null;
  }

  const options = authorsList.map(author => {
    return {
      label: author.name,
      value: author.id
    };
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ComboboxControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('User'),
    help: (0,external_wp_i18n_namespaceObject.__)('Select the avatar user to display, if it is blank it will use the post/page author.'),
    value: value,
    onChange: onChange,
    options: filteredAuthorsList || options,
    onFilterValueChange: inputValue => setFilteredAuthorsList(options.filter(option => option.label.toLowerCase().startsWith(inputValue.toLowerCase())))
  });
}

/* harmony default export */ var user_control = (UserControl);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/avatar/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




const AvatarInspectorControls = ({
  setAttributes,
  avatar,
  attributes,
  selectUser
}) => (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
  title: (0,external_wp_i18n_namespaceObject.__)('Settings')
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
  __nextHasNoMarginBottom: true,
  label: (0,external_wp_i18n_namespaceObject.__)('Image size'),
  onChange: newSize => setAttributes({
    size: newSize
  }),
  min: avatar.minSize,
  max: avatar.maxSize,
  initialPosition: attributes?.size,
  value: attributes?.size
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
  __nextHasNoMarginBottom: true,
  label: (0,external_wp_i18n_namespaceObject.__)('Link to user profile'),
  onChange: () => setAttributes({
    isLink: !attributes.isLink
  }),
  checked: attributes.isLink
}), attributes.isLink && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
  label: (0,external_wp_i18n_namespaceObject.__)('Open in new tab'),
  onChange: value => setAttributes({
    linkTarget: value ? '_blank' : '_self'
  }),
  checked: attributes.linkTarget === '_blank'
}), selectUser && (0,external_wp_element_namespaceObject.createElement)(user_control, {
  value: attributes?.userId,
  onChange: value => {
    setAttributes({
      userId: value
    });
  }
})));

const ResizableAvatar = ({
  setAttributes,
  attributes,
  avatar,
  blockProps,
  isSelected
}) => {
  const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalUseBorderProps)(attributes);
  const doubledSizedSrc = (0,external_wp_url_namespaceObject.addQueryArgs)((0,external_wp_url_namespaceObject.removeQueryArgs)(avatar?.src, ['s']), {
    s: attributes?.size * 2
  });
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ResizableBox, {
    size: {
      width: attributes.size,
      height: attributes.size
    },
    showHandle: isSelected,
    onResizeStop: (event, direction, elt, delta) => {
      setAttributes({
        size: parseInt(attributes.size + (delta.height || delta.width), 10)
      });
    },
    lockAspectRatio: true,
    enable: {
      top: false,
      right: !(0,external_wp_i18n_namespaceObject.isRTL)(),
      bottom: true,
      left: (0,external_wp_i18n_namespaceObject.isRTL)()
    },
    minWidth: avatar.minSize,
    maxWidth: avatar.maxSize
  }, (0,external_wp_element_namespaceObject.createElement)("img", {
    src: doubledSizedSrc,
    alt: avatar.alt,
    className: classnames_default()('avatar', 'avatar-' + attributes.size, 'photo', 'wp-block-avatar__image', borderProps.className),
    style: borderProps.style
  })));
};

const CommentEdit = ({
  attributes,
  context,
  setAttributes,
  isSelected
}) => {
  const {
    commentId
  } = context;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const avatar = useCommentAvatar({
    commentId
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(AvatarInspectorControls, {
    avatar: avatar,
    setAttributes: setAttributes,
    attributes: attributes,
    selectUser: false
  }), attributes.isLink ? (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#avatar-pseudo-link",
    className: "wp-block-avatar__link",
    onClick: event => event.preventDefault()
  }, (0,external_wp_element_namespaceObject.createElement)(ResizableAvatar, {
    attributes: attributes,
    avatar: avatar,
    blockProps: blockProps,
    isSelected: isSelected,
    setAttributes: setAttributes
  })) : (0,external_wp_element_namespaceObject.createElement)(ResizableAvatar, {
    attributes: attributes,
    avatar: avatar,
    blockProps: blockProps,
    isSelected: isSelected,
    setAttributes: setAttributes
  }));
};

const UserEdit = ({
  attributes,
  context,
  setAttributes,
  isSelected
}) => {
  const {
    postId,
    postType
  } = context;
  const avatar = useUserAvatar({
    userId: attributes?.userId,
    postId,
    postType
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(AvatarInspectorControls, {
    selectUser: true,
    attributes: attributes,
    avatar: avatar,
    setAttributes: setAttributes
  }), (0,external_wp_element_namespaceObject.createElement)("div", null, attributes.isLink ? (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#avatar-pseudo-link",
    className: "wp-block-avatar__link",
    onClick: event => event.preventDefault()
  }, (0,external_wp_element_namespaceObject.createElement)(ResizableAvatar, {
    attributes: attributes,
    avatar: avatar,
    blockProps: blockProps,
    isSelected: isSelected,
    setAttributes: setAttributes
  })) : (0,external_wp_element_namespaceObject.createElement)(ResizableAvatar, {
    attributes: attributes,
    avatar: avatar,
    blockProps: blockProps,
    isSelected: isSelected,
    setAttributes: setAttributes
  })));
};

function Edit(props) {
  // Don't show the Comment Edit controls if we have a comment ID set, or if we're in the Site Editor (where it is `null`).
  if (props?.context?.commentId || props?.context?.commentId === null) {
    return (0,external_wp_element_namespaceObject.createElement)(CommentEdit, { ...props
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)(UserEdit, { ...props
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/avatar/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const avatar_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/avatar",
  title: "Avatar",
  category: "theme",
  description: "Add a user\u2019s avatar.",
  textdomain: "default",
  attributes: {
    userId: {
      type: "number"
    },
    size: {
      type: "number",
      "default": 96
    },
    isLink: {
      type: "boolean",
      "default": false
    },
    linkTarget: {
      type: "string",
      "default": "_self"
    }
  },
  usesContext: ["postType", "postId", "commentId"],
  supports: {
    html: false,
    align: true,
    alignWide: false,
    spacing: {
      margin: true,
      padding: true
    },
    __experimentalBorder: {
      __experimentalSkipSerialization: true,
      radius: true,
      width: true,
      color: true,
      style: true,
      __experimentalDefaultControls: {
        radius: true
      }
    },
    color: {
      text: false,
      background: false,
      __experimentalDuotone: "img"
    }
  },
  editorStyle: "wp-block-avatar-editor",
  style: "wp-block-avatar"
};

const {
  name: avatar_name
} = avatar_metadata;

const avatar_settings = {
  icon: comment_author_avatar,
  edit: Edit
};
const avatar_init = () => initBlock({
  name: avatar_name,
  metadata: avatar_metadata,
  settings: avatar_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/audio.js


/**
 * WordPress dependencies
 */

const audio = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M17.7 4.3c-1.2 0-2.8 0-3.8 1-.6.6-.9 1.5-.9 2.6V14c-.6-.6-1.5-1-2.5-1C8.6 13 7 14.6 7 16.5S8.6 20 10.5 20c1.5 0 2.8-1 3.3-2.3.5-.8.7-1.8.7-2.5V7.9c0-.7.2-1.2.5-1.6.6-.6 1.8-.6 2.8-.6h.3V4.3h-.4z"
}));
/* harmony default export */ var library_audio = (audio);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/audio/deprecated.js


/**
 * WordPress dependencies
 */

/* harmony default export */ var deprecated = ([{
  attributes: {
    src: {
      type: 'string',
      source: 'attribute',
      selector: 'audio',
      attribute: 'src'
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: 'figcaption'
    },
    id: {
      type: 'number'
    },
    autoplay: {
      type: 'boolean',
      source: 'attribute',
      selector: 'audio',
      attribute: 'autoplay'
    },
    loop: {
      type: 'boolean',
      source: 'attribute',
      selector: 'audio',
      attribute: 'loop'
    },
    preload: {
      type: 'string',
      source: 'attribute',
      selector: 'audio',
      attribute: 'preload'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      autoplay,
      caption,
      loop,
      preload,
      src
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("figure", null, (0,external_wp_element_namespaceObject.createElement)("audio", {
      controls: "controls",
      src: src,
      autoPlay: autoplay,
      loop: loop,
      preload: preload
    }), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
  }

}]);

;// CONCATENATED MODULE: external ["wp","blob"]
var external_wp_blob_namespaceObject = window["wp"]["blob"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/caption.js


/**
 * WordPress dependencies
 */

const caption = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M6 5.5h12a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H6a.5.5 0 0 1-.5-.5V6a.5.5 0 0 1 .5-.5ZM4 6a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Zm4 10h2v-1.5H8V16Zm5 0h-2v-1.5h2V16Zm1 0h2v-1.5h-2V16Z"
}));
/* harmony default export */ var library_caption = (caption);

;// CONCATENATED MODULE: external ["wp","notices"]
var external_wp_notices_namespaceObject = window["wp"]["notices"];
;// CONCATENATED MODULE: external ["wp","compose"]
var external_wp_compose_namespaceObject = window["wp"]["compose"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/constants.js
const ASPECT_RATIOS = [// Common video resolutions.
{
  ratio: '2.33',
  className: 'wp-embed-aspect-21-9'
}, {
  ratio: '2.00',
  className: 'wp-embed-aspect-18-9'
}, {
  ratio: '1.78',
  className: 'wp-embed-aspect-16-9'
}, {
  ratio: '1.33',
  className: 'wp-embed-aspect-4-3'
}, // Vertical video and instagram square video support.
{
  ratio: '1.00',
  className: 'wp-embed-aspect-1-1'
}, {
  ratio: '0.56',
  className: 'wp-embed-aspect-9-16'
}, {
  ratio: '0.50',
  className: 'wp-embed-aspect-1-2'
}];
const WP_EMBED_TYPE = 'wp-embed';

;// CONCATENATED MODULE: external "lodash"
var external_lodash_namespaceObject = window["lodash"];
// EXTERNAL MODULE: ./node_modules/classnames/dedupe.js
var dedupe = __webpack_require__(4526);
var dedupe_default = /*#__PURE__*/__webpack_require__.n(dedupe);
;// CONCATENATED MODULE: ./node_modules/memize/dist/index.js
/**
 * Memize options object.
 *
 * @typedef MemizeOptions
 *
 * @property {number} [maxSize] Maximum size of the cache.
 */

/**
 * Internal cache entry.
 *
 * @typedef MemizeCacheNode
 *
 * @property {?MemizeCacheNode|undefined} [prev] Previous node.
 * @property {?MemizeCacheNode|undefined} [next] Next node.
 * @property {Array<*>}                   args   Function arguments for cache
 *                                               entry.
 * @property {*}                          val    Function result.
 */

/**
 * Properties of the enhanced function for controlling cache.
 *
 * @typedef MemizeMemoizedFunction
 *
 * @property {()=>void} clear Clear the cache.
 */

/**
 * Accepts a function to be memoized, and returns a new memoized function, with
 * optional options.
 *
 * @template {(...args: any[]) => any} F
 *
 * @param {F}             fn        Function to memoize.
 * @param {MemizeOptions} [options] Options object.
 *
 * @return {((...args: Parameters<F>) => ReturnType<F>) & MemizeMemoizedFunction} Memoized function.
 */
function memize(fn, options) {
	var size = 0;

	/** @type {?MemizeCacheNode|undefined} */
	var head;

	/** @type {?MemizeCacheNode|undefined} */
	var tail;

	options = options || {};

	function memoized(/* ...args */) {
		var node = head,
			len = arguments.length,
			args,
			i;

		searchCache: while (node) {
			// Perform a shallow equality test to confirm that whether the node
			// under test is a candidate for the arguments passed. Two arrays
			// are shallowly equal if their length matches and each entry is
			// strictly equal between the two sets. Avoid abstracting to a
			// function which could incur an arguments leaking deoptimization.

			// Check whether node arguments match arguments length
			if (node.args.length !== arguments.length) {
				node = node.next;
				continue;
			}

			// Check whether node arguments match arguments values
			for (i = 0; i < len; i++) {
				if (node.args[i] !== arguments[i]) {
					node = node.next;
					continue searchCache;
				}
			}

			// At this point we can assume we've found a match

			// Surface matched node to head if not already
			if (node !== head) {
				// As tail, shift to previous. Must only shift if not also
				// head, since if both head and tail, there is no previous.
				if (node === tail) {
					tail = node.prev;
				}

				// Adjust siblings to point to each other. If node was tail,
				// this also handles new tail's empty `next` assignment.
				/** @type {MemizeCacheNode} */ (node.prev).next = node.next;
				if (node.next) {
					node.next.prev = node.prev;
				}

				node.next = head;
				node.prev = null;
				/** @type {MemizeCacheNode} */ (head).prev = node;
				head = node;
			}

			// Return immediately
			return node.val;
		}

		// No cached value found. Continue to insertion phase:

		// Create a copy of arguments (avoid leaking deoptimization)
		args = new Array(len);
		for (i = 0; i < len; i++) {
			args[i] = arguments[i];
		}

		node = {
			args: args,

			// Generate the result from original function
			val: fn.apply(null, args),
		};

		// Don't need to check whether node is already head, since it would
		// have been returned above already if it was

		// Shift existing head down list
		if (head) {
			head.prev = node;
			node.next = head;
		} else {
			// If no head, follows that there's no tail (at initial or reset)
			tail = node;
		}

		// Trim tail if we're reached max size and are pending cache insertion
		if (size === /** @type {MemizeOptions} */ (options).maxSize) {
			tail = /** @type {MemizeCacheNode} */ (tail).prev;
			/** @type {MemizeCacheNode} */ (tail).next = null;
		} else {
			size++;
		}

		head = node;

		return node.val;
	}

	memoized.clear = function () {
		head = null;
		tail = null;
		size = 0;
	};

	// Ignore reason: There's not a clear solution to create an intersection of
	// the function with additional properties, where the goal is to retain the
	// function signature of the incoming argument and add control properties
	// on the return value.

	// @ts-ignore
	return memoized;
}



;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/util.js


/**
 * Internal dependencies
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const util_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/embed",
  title: "Embed",
  category: "embed",
  description: "Add a block that displays content pulled from other sites, like Twitter or YouTube.",
  textdomain: "default",
  attributes: {
    url: {
      type: "string",
      __experimentalRole: "content"
    },
    caption: {
      type: "string",
      source: "html",
      selector: "figcaption",
      __experimentalRole: "content"
    },
    type: {
      type: "string",
      __experimentalRole: "content"
    },
    providerNameSlug: {
      type: "string",
      __experimentalRole: "content"
    },
    allowResponsive: {
      type: "boolean",
      "default": true
    },
    responsive: {
      type: "boolean",
      "default": false,
      __experimentalRole: "content"
    },
    previewable: {
      type: "boolean",
      "default": true,
      __experimentalRole: "content"
    }
  },
  supports: {
    align: true,
    spacing: {
      margin: true
    }
  },
  editorStyle: "wp-block-embed-editor",
  style: "wp-block-embed"
};
const {
  name: DEFAULT_EMBED_BLOCK
} = util_metadata;
/** @typedef {import('@wordpress/blocks').WPBlockVariation} WPBlockVariation */

/**
 * Returns the embed block's information by matching the provided service provider
 *
 * @param {string} provider The embed block's provider
 * @return {WPBlockVariation} The embed block's information
 */

const getEmbedInfoByProvider = provider => (0,external_wp_blocks_namespaceObject.getBlockVariations)(DEFAULT_EMBED_BLOCK)?.find(({
  name
}) => name === provider);
/**
 * Returns true if any of the regular expressions match the URL.
 *
 * @param {string} url      The URL to test.
 * @param {Array}  patterns The list of regular expressions to test agains.
 * @return {boolean} True if any of the regular expressions match the URL.
 */

const matchesPatterns = (url, patterns = []) => patterns.some(pattern => url.match(pattern));
/**
 * Finds the block variation that should be used for the URL,
 * based on the provided URL and the variation's patterns.
 *
 * @param {string} url The URL to test.
 * @return {WPBlockVariation} The block variation that should be used for this URL
 */

const findMoreSuitableBlock = url => (0,external_wp_blocks_namespaceObject.getBlockVariations)(DEFAULT_EMBED_BLOCK)?.find(({
  patterns
}) => matchesPatterns(url, patterns));
const isFromWordPress = html => html && html.includes('class="wp-embedded-content"');
const getPhotoHtml = photo => {
  // If full image url not found use thumbnail.
  const imageUrl = photo.url || photo.thumbnail_url; // 100% width for the preview so it fits nicely into the document, some "thumbnails" are
  // actually the full size photo.

  const photoPreview = (0,external_wp_element_namespaceObject.createElement)("p", null, (0,external_wp_element_namespaceObject.createElement)("img", {
    src: imageUrl,
    alt: photo.title,
    width: "100%"
  }));
  return (0,external_wp_element_namespaceObject.renderToString)(photoPreview);
};
/**
 * Creates a more suitable embed block based on the passed in props
 * and attributes generated from an embed block's preview.
 *
 * We require `attributesFromPreview` to be generated from the latest attributes
 * and preview, and because of the way the react lifecycle operates, we can't
 * guarantee that the attributes contained in the block's props are the latest
 * versions, so we require that these are generated separately.
 * See `getAttributesFromPreview` in the generated embed edit component.
 *
 * @param {Object} props                   The block's props.
 * @param {Object} [attributesFromPreview] Attributes generated from the block's most up to date preview.
 * @return {Object|undefined} A more suitable embed block if one exists.
 */

const createUpgradedEmbedBlock = (props, attributesFromPreview = {}) => {
  const {
    preview,
    attributes = {}
  } = props;
  const {
    url,
    providerNameSlug,
    type,
    ...restAttributes
  } = attributes;
  if (!url || !(0,external_wp_blocks_namespaceObject.getBlockType)(DEFAULT_EMBED_BLOCK)) return;
  const matchedBlock = findMoreSuitableBlock(url); // WordPress blocks can work on multiple sites, and so don't have patterns,
  // so if we're in a WordPress block, assume the user has chosen it for a WordPress URL.

  const isCurrentBlockWP = providerNameSlug === 'wordpress' || type === WP_EMBED_TYPE; // If current block is not WordPress and a more suitable block found
  // that is different from the current one, create the new matched block.

  const shouldCreateNewBlock = !isCurrentBlockWP && matchedBlock && (matchedBlock.attributes.providerNameSlug !== providerNameSlug || !providerNameSlug);

  if (shouldCreateNewBlock) {
    return (0,external_wp_blocks_namespaceObject.createBlock)(DEFAULT_EMBED_BLOCK, {
      url,
      ...restAttributes,
      ...matchedBlock.attributes
    });
  }

  const wpVariation = (0,external_wp_blocks_namespaceObject.getBlockVariations)(DEFAULT_EMBED_BLOCK)?.find(({
    name
  }) => name === 'wordpress'); // We can't match the URL for WordPress embeds, we have to check the HTML instead.

  if (!wpVariation || !preview || !isFromWordPress(preview.html) || isCurrentBlockWP) {
    return;
  } // This is not the WordPress embed block so transform it into one.


  return (0,external_wp_blocks_namespaceObject.createBlock)(DEFAULT_EMBED_BLOCK, {
    url,
    ...wpVariation.attributes,
    // By now we have the preview, but when the new block first renders, it
    // won't have had all the attributes set, and so won't get the correct
    // type and it won't render correctly. So, we pass through the current attributes
    // here so that the initial render works when we switch to the WordPress
    // block. This only affects the WordPress block because it can't be
    // rendered in the usual Sandbox (it has a sandbox of its own) and it
    // relies on the preview to set the correct render type.
    ...attributesFromPreview
  });
};
/**
 * Determine if the block already has an aspect ratio class applied.
 *
 * @param {string} existingClassNames Existing block classes.
 * @return {boolean} True or false if the classnames contain an aspect ratio class.
 */

const hasAspectRatioClass = existingClassNames => {
  if (!existingClassNames) {
    return false;
  }

  return ASPECT_RATIOS.some(({
    className
  }) => existingClassNames.includes(className));
};
/**
 * Removes all previously set aspect ratio related classes and return the rest
 * existing class names.
 *
 * @param {string} existingClassNames Any existing class names.
 * @return {string} The class names without any aspect ratio related class.
 */

const removeAspectRatioClasses = existingClassNames => {
  if (!existingClassNames) {
    // Avoids extraneous work and also, by returning the same value as
    // received, ensures the post is not dirtied by a change of the block
    // attribute from `undefined` to an emtpy string.
    return existingClassNames;
  }

  const aspectRatioClassNames = ASPECT_RATIOS.reduce((accumulator, {
    className
  }) => {
    accumulator[className] = false;
    return accumulator;
  }, {
    'wp-has-aspect-ratio': false
  });
  return dedupe_default()(existingClassNames, aspectRatioClassNames);
};
/**
 * Returns class names with any relevant responsive aspect ratio names.
 *
 * @param {string}  html               The preview HTML that possibly contains an iframe with width and height set.
 * @param {string}  existingClassNames Any existing class names.
 * @param {boolean} allowResponsive    If the responsive class names should be added, or removed.
 * @return {string} Deduped class names.
 */

function getClassNames(html, existingClassNames, allowResponsive = true) {
  if (!allowResponsive) {
    return removeAspectRatioClasses(existingClassNames);
  }

  const previewDocument = document.implementation.createHTMLDocument('');
  previewDocument.body.innerHTML = html;
  const iframe = previewDocument.body.querySelector('iframe'); // If we have a fixed aspect iframe, and it's a responsive embed block.

  if (iframe && iframe.height && iframe.width) {
    const aspectRatio = (iframe.width / iframe.height).toFixed(2); // Given the actual aspect ratio, find the widest ratio to support it.

    for (let ratioIndex = 0; ratioIndex < ASPECT_RATIOS.length; ratioIndex++) {
      const potentialRatio = ASPECT_RATIOS[ratioIndex];

      if (aspectRatio >= potentialRatio.ratio) {
        // Evaluate the difference between actual aspect ratio and closest match.
        // If the difference is too big, do not scale the embed according to aspect ratio.
        const ratioDiff = aspectRatio - potentialRatio.ratio;

        if (ratioDiff > 0.1) {
          // No close aspect ratio match found.
          return removeAspectRatioClasses(existingClassNames);
        } // Close aspect ratio match found.


        return dedupe_default()(removeAspectRatioClasses(existingClassNames), potentialRatio.className, 'wp-has-aspect-ratio');
      }
    }
  }

  return existingClassNames;
}
/**
 * Fallback behaviour for unembeddable URLs.
 * Creates a paragraph block containing a link to the URL, and calls `onReplace`.
 *
 * @param {string}   url       The URL that could not be embedded.
 * @param {Function} onReplace Function to call with the created fallback block.
 */

function fallback(url, onReplace) {
  const link = (0,external_wp_element_namespaceObject.createElement)("a", {
    href: url
  }, url);
  onReplace((0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
    content: (0,external_wp_element_namespaceObject.renderToString)(link)
  }));
}
/***
 * Gets block attributes based on the preview and responsive state.
 *
 * @param {Object} preview The preview data.
 * @param {string} title The block's title, e.g. Twitter.
 * @param {Object} currentClassNames The block's current class names.
 * @param {boolean} isResponsive Boolean indicating if the block supports responsive content.
 * @param {boolean} allowResponsive Apply responsive classes to fixed size content.
 * @return {Object} Attributes and values.
 */

const getAttributesFromPreview = memize((preview, title, currentClassNames, isResponsive, allowResponsive = true) => {
  if (!preview) {
    return {};
  }

  const attributes = {}; // Some plugins only return HTML with no type info, so default this to 'rich'.

  let {
    type = 'rich'
  } = preview; // If we got a provider name from the API, use it for the slug, otherwise we use the title,
  // because not all embed code gives us a provider name.

  const {
    html,
    provider_name: providerName
  } = preview;
  const providerNameSlug = (0,external_lodash_namespaceObject.kebabCase)((providerName || title).toLowerCase());

  if (isFromWordPress(html)) {
    type = WP_EMBED_TYPE;
  }

  if (html || 'photo' === type) {
    attributes.type = type;
    attributes.providerNameSlug = providerNameSlug;
  } // Aspect ratio classes are removed when the embed URL is updated.
  // If the embed already has an aspect ratio class, that means the URL has not changed.
  // Which also means no need to regenerate it with getClassNames.


  if (hasAspectRatioClass(currentClassNames)) {
    return attributes;
  }

  attributes.className = getClassNames(html, currentClassNames, isResponsive && allowResponsive);
  return attributes;
});
/**
 * Returns the attributes derived from the preview, merged with the current attributes.
 *
 * @param {Object}  currentAttributes The current attributes of the block.
 * @param {Object}  preview           The preview data.
 * @param {string}  title             The block's title, e.g. Twitter.
 * @param {boolean} isResponsive      Boolean indicating if the block supports responsive content.
 * @return {Object} Merged attributes.
 */

const getMergedAttributesWithPreview = (currentAttributes, preview, title, isResponsive) => {
  const {
    allowResponsive,
    className
  } = currentAttributes;
  return { ...currentAttributes,
    ...getAttributesFromPreview(preview, title, className, isResponsive, allowResponsive)
  };
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/audio/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */


const ALLOWED_MEDIA_TYPES = ['audio'];

function AudioEdit({
  attributes,
  className,
  setAttributes,
  onReplace,
  isSelected,
  insertBlocksAfter
}) {
  const {
    id,
    autoplay,
    caption,
    loop,
    preload,
    src
  } = attributes;
  const prevCaption = (0,external_wp_compose_namespaceObject.usePrevious)(caption);
  const [showCaption, setShowCaption] = (0,external_wp_element_namespaceObject.useState)(!!caption);
  const isTemporaryAudio = !id && (0,external_wp_blob_namespaceObject.isBlobURL)(src);
  const mediaUpload = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    return getSettings().mediaUpload;
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!id && (0,external_wp_blob_namespaceObject.isBlobURL)(src)) {
      const file = (0,external_wp_blob_namespaceObject.getBlobByURL)(src);

      if (file) {
        mediaUpload({
          filesList: [file],
          onFileChange: ([media]) => onSelectAudio(media),
          onError: e => onUploadError(e),
          allowedTypes: ALLOWED_MEDIA_TYPES
        });
      }
    }
  }, []); // We need to show the caption when changes come from
  // history navigation(undo/redo).

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (caption && !prevCaption) {
      setShowCaption(true);
    }
  }, [caption, prevCaption]); // Focus the caption when we click to add one.

  const captionRef = (0,external_wp_element_namespaceObject.useCallback)(node => {
    if (node && !caption) {
      node.focus();
    }
  }, [caption]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isSelected && !caption) {
      setShowCaption(false);
    }
  }, [isSelected, caption]);

  function toggleAttribute(attribute) {
    return newValue => {
      setAttributes({
        [attribute]: newValue
      });
    };
  }

  function onSelectURL(newSrc) {
    // Set the block's src from the edit component's state, and switch off
    // the editing UI.
    if (newSrc !== src) {
      // Check if there's an embed block that handles this URL.
      const embedBlock = createUpgradedEmbedBlock({
        attributes: {
          url: newSrc
        }
      });

      if (undefined !== embedBlock && onReplace) {
        onReplace(embedBlock);
        return;
      }

      setAttributes({
        src: newSrc,
        id: undefined
      });
    }
  }

  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);

  function onUploadError(message) {
    createErrorNotice(message, {
      type: 'snackbar'
    });
  }

  function getAutoplayHelp(checked) {
    return checked ? (0,external_wp_i18n_namespaceObject.__)('Autoplay may cause usability issues for some users.') : null;
  }

  function onSelectAudio(media) {
    if (!media || !media.url) {
      // In this case there was an error and we should continue in the editing state
      // previous attributes should be removed because they may be temporary blob urls.
      setAttributes({
        src: undefined,
        id: undefined,
        caption: undefined
      });
      return;
    } // Sets the block's attribute and updates the edit component from the
    // selected media, then switches off the editing UI.


    setAttributes({
      src: media.url,
      id: media.id,
      caption: media.caption
    });
  }

  const classes = classnames_default()(className, {
    'is-transient': isTemporaryAudio
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classes
  });

  if (!src) {
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
      icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
        icon: library_audio
      }),
      onSelect: onSelectAudio,
      onSelectURL: onSelectURL,
      accept: "audio/*",
      allowedTypes: ALLOWED_MEDIA_TYPES,
      value: attributes,
      onError: onUploadError
    }));
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: () => {
      setShowCaption(!showCaption);

      if (showCaption && caption) {
        setAttributes({
          caption: undefined
        });
      }
    },
    icon: library_caption,
    isPressed: showCaption,
    label: showCaption ? (0,external_wp_i18n_namespaceObject.__)('Remove caption') : (0,external_wp_i18n_namespaceObject.__)('Add caption')
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "other"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaReplaceFlow, {
    mediaId: id,
    mediaURL: src,
    allowedTypes: ALLOWED_MEDIA_TYPES,
    accept: "audio/*",
    onSelect: onSelectAudio,
    onSelectURL: onSelectURL,
    onError: onUploadError
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Autoplay'),
    onChange: toggleAttribute('autoplay'),
    checked: autoplay,
    help: getAutoplayHelp
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Loop'),
    onChange: toggleAttribute('loop'),
    checked: loop
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject._x)('Preload', 'noun; Audio block parameter'),
    value: preload || '' // `undefined` is required for the preload attribute to be unset.
    ,
    onChange: value => setAttributes({
      preload: value || undefined
    }),
    options: [{
      value: '',
      label: (0,external_wp_i18n_namespaceObject.__)('Browser default')
    }, {
      value: 'auto',
      label: (0,external_wp_i18n_namespaceObject.__)('Auto')
    }, {
      value: 'metadata',
      label: (0,external_wp_i18n_namespaceObject.__)('Metadata')
    }, {
      value: 'none',
      label: (0,external_wp_i18n_namespaceObject._x)('None', 'Preload value')
    }]
  }))), (0,external_wp_element_namespaceObject.createElement)("figure", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, {
    isDisabled: !isSelected
  }, (0,external_wp_element_namespaceObject.createElement)("audio", {
    controls: "controls",
    src: src
  })), isTemporaryAudio && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null), showCaption && (!external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) || isSelected) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    identifier: "caption",
    tagName: "figcaption",
    className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
    ref: captionRef,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Audio caption text'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Add caption'),
    value: caption,
    onChange: value => setAttributes({
      caption: value
    }),
    inlineToolbar: true,
    __unstableOnSplitAtEnd: () => insertBlocksAfter((0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()))
  })));
}

/* harmony default export */ var edit = (AudioEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/audio/save.js


/**
 * WordPress dependencies
 */

function save({
  attributes
}) {
  const {
    autoplay,
    caption,
    loop,
    preload,
    src
  } = attributes;
  return src && (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
  }, (0,external_wp_element_namespaceObject.createElement)("audio", {
    controls: "controls",
    src: src,
    autoPlay: autoplay,
    loop: loop,
    preload: preload
  }), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    tagName: "figcaption",
    value: caption,
    className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption')
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/audio/transforms.js
/**
 * WordPress dependencies
 */


const transforms = {
  from: [{
    type: 'files',

    isMatch(files) {
      return files.length === 1 && files[0].type.indexOf('audio/') === 0;
    },

    transform(files) {
      const file = files[0]; // We don't need to upload the media directly here
      // It's already done as part of the `componentDidMount`
      // in the audio block.

      const block = (0,external_wp_blocks_namespaceObject.createBlock)('core/audio', {
        src: (0,external_wp_blob_namespaceObject.createBlobURL)(file)
      });
      return block;
    }

  }, {
    type: 'shortcode',
    tag: 'audio',
    attributes: {
      src: {
        type: 'string',
        shortcode: ({
          named: {
            src,
            mp3,
            m4a,
            ogg,
            wav,
            wma
          }
        }) => {
          return src || mp3 || m4a || ogg || wav || wma;
        }
      },
      loop: {
        type: 'string',
        shortcode: ({
          named: {
            loop
          }
        }) => {
          return loop;
        }
      },
      autoplay: {
        type: 'string',
        shortcode: ({
          named: {
            autoplay
          }
        }) => {
          return autoplay;
        }
      },
      preload: {
        type: 'string',
        shortcode: ({
          named: {
            preload
          }
        }) => {
          return preload;
        }
      }
    }
  }]
};
/* harmony default export */ var audio_transforms = (transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/audio/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const audio_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/audio",
  title: "Audio",
  category: "media",
  description: "Embed a simple audio player.",
  keywords: ["music", "sound", "podcast", "recording"],
  textdomain: "default",
  attributes: {
    src: {
      type: "string",
      source: "attribute",
      selector: "audio",
      attribute: "src",
      __experimentalRole: "content"
    },
    caption: {
      type: "string",
      source: "html",
      selector: "figcaption",
      __experimentalRole: "content"
    },
    id: {
      type: "number",
      __experimentalRole: "content"
    },
    autoplay: {
      type: "boolean",
      source: "attribute",
      selector: "audio",
      attribute: "autoplay"
    },
    loop: {
      type: "boolean",
      source: "attribute",
      selector: "audio",
      attribute: "loop"
    },
    preload: {
      type: "string",
      source: "attribute",
      selector: "audio",
      attribute: "preload"
    }
  },
  supports: {
    anchor: true,
    align: true,
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    }
  },
  editorStyle: "wp-block-audio-editor",
  style: "wp-block-audio"
};


const {
  name: audio_name
} = audio_metadata;

const audio_settings = {
  icon: library_audio,
  example: {
    attributes: {
      src: 'https://upload.wikimedia.org/wikipedia/commons/d/dd/Armstrong_Small_Step.ogg'
    },
    viewportWidth: 350
  },
  transforms: audio_transforms,
  deprecated: deprecated,
  edit: edit,
  save: save
};
const audio_init = () => initBlock({
  name: audio_name,
  metadata: audio_metadata,
  settings: audio_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/button.js


/**
 * WordPress dependencies
 */

const button_button = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M8 12.5h8V11H8v1.5Z M19 6.5H5a2 2 0 0 0-2 2V15a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V8.5a2 2 0 0 0-2-2ZM5 8h14a.5.5 0 0 1 .5.5V15a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V8.5A.5.5 0 0 1 5 8Z"
}));
/* harmony default export */ var library_button = (button_button);

;// CONCATENATED MODULE: external ["wp","privateApis"]
var external_wp_privateApis_namespaceObject = window["wp"]["privateApis"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/lock-unlock.js
/**
 * WordPress dependencies
 */

const {
  lock,
  unlock
} = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)('I know using unstable features means my plugin or theme will inevitably break on the next WordPress release.', '@wordpress/block-library');

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/utils/migrate-font-family.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const {
  cleanEmptyObject
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
/**
 * Migrates the current style.typography.fontFamily attribute,
 * whose value was "var:preset|font-family|helvetica-arial",
 * to the style.fontFamily attribute, whose value will be "helvetica-arial".
 *
 * @param {Object} attributes The current attributes
 * @return {Object} The updated attributes.
 */

/* harmony default export */ function migrate_font_family(attributes) {
  if (!attributes?.style?.typography?.fontFamily) {
    return attributes;
  }

  const {
    fontFamily,
    ...typography
  } = attributes.style.typography;
  return { ...attributes,
    style: cleanEmptyObject({ ...attributes.style,
      typography
    }),
    fontFamily: fontFamily.split('|').pop()
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/button/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const migrateBorderRadius = attributes => {
  const {
    borderRadius,
    ...newAttributes
  } = attributes; // We have to check old property `borderRadius` and if
  // `styles.border.radius` is a `number`

  const oldBorderRadius = [borderRadius, newAttributes.style?.border?.radius].find(possibleBorderRadius => {
    return typeof possibleBorderRadius === 'number' && possibleBorderRadius !== 0;
  });

  if (!oldBorderRadius) {
    return newAttributes;
  }

  return { ...newAttributes,
    style: { ...newAttributes.style,
      border: { ...newAttributes.style?.border,
        radius: `${oldBorderRadius}px`
      }
    }
  };
};

function migrateAlign(attributes) {
  if (!attributes.align) {
    return attributes;
  }

  const {
    align,
    ...otherAttributes
  } = attributes;
  return { ...otherAttributes,
    className: classnames_default()(otherAttributes.className, `align${attributes.align}`)
  };
}

const migrateCustomColorsAndGradients = attributes => {
  if (!attributes.customTextColor && !attributes.customBackgroundColor && !attributes.customGradient) {
    return attributes;
  }

  const style = {
    color: {}
  };

  if (attributes.customTextColor) {
    style.color.text = attributes.customTextColor;
  }

  if (attributes.customBackgroundColor) {
    style.color.background = attributes.customBackgroundColor;
  }

  if (attributes.customGradient) {
    style.color.gradient = attributes.customGradient;
  }

  const {
    customTextColor,
    customBackgroundColor,
    customGradient,
    ...restAttributes
  } = attributes;
  return { ...restAttributes,
    style
  };
};

const oldColorsMigration = attributes => {
  const {
    color,
    textColor,
    ...restAttributes
  } = { ...attributes,
    customTextColor: attributes.textColor && '#' === attributes.textColor[0] ? attributes.textColor : undefined,
    customBackgroundColor: attributes.color && '#' === attributes.color[0] ? attributes.color : undefined
  };
  return migrateCustomColorsAndGradients(restAttributes);
};

const blockAttributes = {
  url: {
    type: 'string',
    source: 'attribute',
    selector: 'a',
    attribute: 'href'
  },
  title: {
    type: 'string',
    source: 'attribute',
    selector: 'a',
    attribute: 'title'
  },
  text: {
    type: 'string',
    source: 'html',
    selector: 'a'
  }
};
const v11 = {
  attributes: {
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'href'
    },
    title: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'title'
    },
    text: {
      type: 'string',
      source: 'html',
      selector: 'a'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    width: {
      type: 'number'
    }
  },
  supports: {
    anchor: true,
    align: true,
    alignWide: false,
    color: {
      __experimentalSkipSerialization: true,
      gradients: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    typography: {
      fontSize: true,
      __experimentalFontFamily: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    reusable: false,
    spacing: {
      __experimentalSkipSerialization: true,
      padding: ['horizontal', 'vertical'],
      __experimentalDefaultControls: {
        padding: true
      }
    },
    __experimentalBorder: {
      radius: true,
      __experimentalSkipSerialization: true,
      __experimentalDefaultControls: {
        radius: true
      }
    },
    __experimentalSelector: '.wp-block-button__link'
  },

  save({
    attributes,
    className
  }) {
    const {
      fontSize,
      linkTarget,
      rel,
      style,
      text,
      title,
      url,
      width
    } = attributes;

    if (!text) {
      return null;
    }

    const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetBorderClassesAndStyles)(attributes);
    const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetColorClassesAndStyles)(attributes);
    const spacingProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetSpacingClassesAndStyles)(attributes);
    const buttonClasses = classnames_default()('wp-block-button__link', colorProps.className, borderProps.className, {
      // For backwards compatibility add style that isn't provided via
      // block support.
      'no-border-radius': style?.border?.radius === 0
    });
    const buttonStyle = { ...borderProps.style,
      ...colorProps.style,
      ...spacingProps.style
    }; // The use of a `title` attribute here is soft-deprecated, but still applied
    // if it had already been assigned, for the sake of backward-compatibility.
    // A title will no longer be assigned for new or updated button block links.

    const wrapperClasses = classnames_default()(className, {
      [`has-custom-width wp-block-button__width-${width}`]: width,
      [`has-custom-font-size`]: fontSize || style?.typography?.fontSize
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: wrapperClasses
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  }

};
const v10 = {
  attributes: {
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'href'
    },
    title: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'title'
    },
    text: {
      type: 'string',
      source: 'html',
      selector: 'a'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    width: {
      type: 'number'
    }
  },
  supports: {
    anchor: true,
    align: true,
    alignWide: false,
    color: {
      __experimentalSkipSerialization: true,
      gradients: true
    },
    typography: {
      fontSize: true,
      __experimentalFontFamily: true
    },
    reusable: false,
    spacing: {
      __experimentalSkipSerialization: true,
      padding: ['horizontal', 'vertical'],
      __experimentalDefaultControls: {
        padding: true
      }
    },
    __experimentalBorder: {
      radius: true,
      __experimentalSkipSerialization: true
    },
    __experimentalSelector: '.wp-block-button__link'
  },

  save({
    attributes,
    className
  }) {
    const {
      fontSize,
      linkTarget,
      rel,
      style,
      text,
      title,
      url,
      width
    } = attributes;

    if (!text) {
      return null;
    }

    const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetBorderClassesAndStyles)(attributes);
    const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetColorClassesAndStyles)(attributes);
    const spacingProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetSpacingClassesAndStyles)(attributes);
    const buttonClasses = classnames_default()('wp-block-button__link', colorProps.className, borderProps.className, {
      // For backwards compatibility add style that isn't provided via
      // block support.
      'no-border-radius': style?.border?.radius === 0
    });
    const buttonStyle = { ...borderProps.style,
      ...colorProps.style,
      ...spacingProps.style
    }; // The use of a `title` attribute here is soft-deprecated, but still applied
    // if it had already been assigned, for the sake of backward-compatibility.
    // A title will no longer be assigned for new or updated button block links.

    const wrapperClasses = classnames_default()(className, {
      [`has-custom-width wp-block-button__width-${width}`]: width,
      [`has-custom-font-size`]: fontSize || style?.typography?.fontSize
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: wrapperClasses
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  },

  migrate: migrate_font_family,

  isEligible({
    style
  }) {
    return style?.typography?.fontFamily;
  }

};
const deprecated_deprecated = [v11, v10, {
  supports: {
    anchor: true,
    align: true,
    alignWide: false,
    color: {
      __experimentalSkipSerialization: true,
      gradients: true
    },
    typography: {
      fontSize: true,
      __experimentalFontFamily: true
    },
    reusable: false,
    __experimentalSelector: '.wp-block-button__link'
  },
  attributes: { ...blockAttributes,
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    width: {
      type: 'number'
    }
  },

  isEligible({
    style
  }) {
    return typeof style?.border?.radius === 'number';
  },

  save({
    attributes,
    className
  }) {
    const {
      fontSize,
      linkTarget,
      rel,
      style,
      text,
      title,
      url,
      width
    } = attributes;

    if (!text) {
      return null;
    }

    const borderRadius = style?.border?.radius;
    const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetColorClassesAndStyles)(attributes);
    const buttonClasses = classnames_default()('wp-block-button__link', colorProps.className, {
      'no-border-radius': style?.border?.radius === 0
    });
    const buttonStyle = {
      borderRadius: borderRadius ? borderRadius : undefined,
      ...colorProps.style
    }; // The use of a `title` attribute here is soft-deprecated, but still applied
    // if it had already been assigned, for the sake of backward-compatibility.
    // A title will no longer be assigned for new or updated button block links.

    const wrapperClasses = classnames_default()(className, {
      [`has-custom-width wp-block-button__width-${width}`]: width,
      [`has-custom-font-size`]: fontSize || style?.typography?.fontSize
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: wrapperClasses
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrate_font_family, migrateBorderRadius)
}, {
  supports: {
    anchor: true,
    align: true,
    alignWide: false,
    color: {
      __experimentalSkipSerialization: true
    },
    reusable: false,
    __experimentalSelector: '.wp-block-button__link'
  },
  attributes: { ...blockAttributes,
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    borderRadius: {
      type: 'number'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    style: {
      type: 'object'
    },
    width: {
      type: 'number'
    }
  },

  save({
    attributes,
    className
  }) {
    const {
      borderRadius,
      linkTarget,
      rel,
      text,
      title,
      url,
      width
    } = attributes;
    const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetColorClassesAndStyles)(attributes);
    const buttonClasses = classnames_default()('wp-block-button__link', colorProps.className, {
      'no-border-radius': borderRadius === 0
    });
    const buttonStyle = {
      borderRadius: borderRadius ? borderRadius + 'px' : undefined,
      ...colorProps.style
    }; // The use of a `title` attribute here is soft-deprecated, but still applied
    // if it had already been assigned, for the sake of backward-compatibility.
    // A title will no longer be assigned for new or updated button block links.

    const wrapperClasses = classnames_default()(className, {
      [`has-custom-width wp-block-button__width-${width}`]: width
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: wrapperClasses
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrate_font_family, migrateBorderRadius)
}, {
  supports: {
    anchor: true,
    align: true,
    alignWide: false,
    color: {
      __experimentalSkipSerialization: true
    },
    reusable: false,
    __experimentalSelector: '.wp-block-button__link'
  },
  attributes: { ...blockAttributes,
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    borderRadius: {
      type: 'number'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    style: {
      type: 'object'
    },
    width: {
      type: 'number'
    }
  },

  save({
    attributes,
    className
  }) {
    const {
      borderRadius,
      linkTarget,
      rel,
      text,
      title,
      url,
      width
    } = attributes;
    const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetColorClassesAndStyles)(attributes);
    const buttonClasses = classnames_default()('wp-block-button__link', colorProps.className, {
      'no-border-radius': borderRadius === 0
    });
    const buttonStyle = {
      borderRadius: borderRadius ? borderRadius + 'px' : undefined,
      ...colorProps.style
    }; // The use of a `title` attribute here is soft-deprecated, but still applied
    // if it had already been assigned, for the sake of backward-compatibility.
    // A title will no longer be assigned for new or updated button block links.

    const wrapperClasses = classnames_default()(className, {
      [`has-custom-width wp-block-button__width-${width}`]: width
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: wrapperClasses
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrate_font_family, migrateBorderRadius)
}, {
  supports: {
    align: true,
    alignWide: false,
    color: {
      gradients: true
    }
  },
  attributes: { ...blockAttributes,
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    borderRadius: {
      type: 'number'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    style: {
      type: 'object'
    }
  },

  save({
    attributes
  }) {
    const {
      borderRadius,
      linkTarget,
      rel,
      text,
      title,
      url
    } = attributes;
    const buttonClasses = classnames_default()('wp-block-button__link', {
      'no-border-radius': borderRadius === 0
    });
    const buttonStyle = {
      borderRadius: borderRadius ? borderRadius + 'px' : undefined
    };
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    });
  },

  migrate: migrateBorderRadius
}, {
  supports: {
    align: true,
    alignWide: false
  },
  attributes: { ...blockAttributes,
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    },
    borderRadius: {
      type: 'number'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    customTextColor: {
      type: 'string'
    },
    customGradient: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    }
  },
  isEligible: attributes => !!attributes.customTextColor || !!attributes.customBackgroundColor || !!attributes.customGradient || !!attributes.align,
  migrate: (0,external_wp_compose_namespaceObject.compose)(migrateBorderRadius, migrateCustomColorsAndGradients, migrateAlign),

  save({
    attributes
  }) {
    const {
      backgroundColor,
      borderRadius,
      customBackgroundColor,
      customTextColor,
      customGradient,
      linkTarget,
      gradient,
      rel,
      text,
      textColor,
      title,
      url
    } = attributes;
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const backgroundClass = !customGradient && (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const buttonClasses = classnames_default()('wp-block-button__link', {
      'has-text-color': textColor || customTextColor,
      [textClass]: textClass,
      'has-background': backgroundColor || customBackgroundColor || customGradient || gradient,
      [backgroundClass]: backgroundClass,
      'no-border-radius': borderRadius === 0,
      [gradientClass]: gradientClass
    });
    const buttonStyle = {
      background: customGradient ? customGradient : undefined,
      backgroundColor: backgroundClass || customGradient || gradient ? undefined : customBackgroundColor,
      color: textClass ? undefined : customTextColor,
      borderRadius: borderRadius ? borderRadius + 'px' : undefined
    }; // The use of a `title` attribute here is soft-deprecated, but still applied
    // if it had already been assigned, for the sake of backward-compatibility.
    // A title will no longer be assigned for new or updated button block links.

    return (0,external_wp_element_namespaceObject.createElement)("div", null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  }

}, {
  attributes: { ...blockAttributes,
    align: {
      type: 'string',
      default: 'none'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    customTextColor: {
      type: 'string'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'target'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'rel'
    },
    placeholder: {
      type: 'string'
    }
  },

  isEligible(attribute) {
    return attribute.className && attribute.className.includes('is-style-squared');
  },

  migrate(attributes) {
    let newClassName = attributes.className;

    if (newClassName) {
      newClassName = newClassName.replace(/is-style-squared[\s]?/, '').trim();
    }

    return migrateBorderRadius(migrateCustomColorsAndGradients({ ...attributes,
      className: newClassName ? newClassName : undefined,
      borderRadius: 0
    }));
  },

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor,
      customTextColor,
      linkTarget,
      rel,
      text,
      textColor,
      title,
      url
    } = attributes;
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const buttonClasses = classnames_default()('wp-block-button__link', {
      'has-text-color': textColor || customTextColor,
      [textClass]: textClass,
      'has-background': backgroundColor || customBackgroundColor,
      [backgroundClass]: backgroundClass
    });
    const buttonStyle = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      color: textClass ? undefined : customTextColor
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text,
      target: linkTarget,
      rel: rel
    }));
  }

}, {
  attributes: { ...blockAttributes,
    align: {
      type: 'string',
      default: 'none'
    },
    backgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    customTextColor: {
      type: 'string'
    }
  },
  migrate: oldColorsMigration,

  save({
    attributes
  }) {
    const {
      url,
      text,
      title,
      backgroundColor,
      textColor,
      customBackgroundColor,
      customTextColor
    } = attributes;
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const buttonClasses = classnames_default()('wp-block-button__link', {
      'has-text-color': textColor || customTextColor,
      [textClass]: textClass,
      'has-background': backgroundColor || customBackgroundColor,
      [backgroundClass]: backgroundClass
    });
    const buttonStyle = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      color: textClass ? undefined : customTextColor
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: buttonClasses,
      href: url,
      title: title,
      style: buttonStyle,
      value: text
    }));
  }

}, {
  attributes: { ...blockAttributes,
    color: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    align: {
      type: 'string',
      default: 'none'
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      text,
      title,
      align,
      color,
      textColor
    } = attributes;
    const buttonStyle = {
      backgroundColor: color,
      color: textColor
    };
    const linkClass = 'wp-block-button__link';
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: `align${align}`
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      className: linkClass,
      href: url,
      title: title,
      style: buttonStyle,
      value: text
    }));
  },

  migrate: oldColorsMigration
}, {
  attributes: { ...blockAttributes,
    color: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    align: {
      type: 'string',
      default: 'none'
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      text,
      title,
      align,
      color,
      textColor
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: `align${align}`,
      style: {
        backgroundColor: color
      }
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "a",
      href: url,
      title: title,
      style: {
        color: textColor
      },
      value: text
    }));
  },

  migrate: oldColorsMigration
}];
/* harmony default export */ var button_deprecated = (deprecated_deprecated);

;// CONCATENATED MODULE: external ["wp","keycodes"]
var external_wp_keycodes_namespaceObject = window["wp"]["keycodes"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/link.js


/**
 * WordPress dependencies
 */

const link_link = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M10 17.389H8.444A5.194 5.194 0 1 1 8.444 7H10v1.5H8.444a3.694 3.694 0 0 0 0 7.389H10v1.5ZM14 7h1.556a5.194 5.194 0 0 1 0 10.39H14v-1.5h1.556a3.694 3.694 0 0 0 0-7.39H14V7Zm-4.5 6h5v-1.5h-5V13Z"
}));
/* harmony default export */ var library_link = (link_link);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/link-off.js


/**
 * WordPress dependencies
 */

const linkOff = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M17.031 4.703 15.576 4l-1.56 3H14v.03l-2.324 4.47H9.5V13h1.396l-1.502 2.889h-.95a3.694 3.694 0 0 1 0-7.389H10V7H8.444a5.194 5.194 0 1 0 0 10.389h.17L7.5 19.53l1.416.719L15.049 8.5h.507a3.694 3.694 0 0 1 0 7.39H14v1.5h1.556a5.194 5.194 0 0 0 .273-10.383l1.202-2.304Z"
}));
/* harmony default export */ var link_off = (linkOff);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/button/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */










const NEW_TAB_REL = 'noreferrer noopener';

function WidthPanel({
  selectedWidth,
  setAttributes
}) {
  function handleChange(newWidth) {
    // Check if we are toggling the width off
    const width = selectedWidth === newWidth ? undefined : newWidth; // Update attributes.

    setAttributes({
      width
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Width settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ButtonGroup, {
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Button width')
  }, [25, 50, 75, 100].map(widthValue => {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: widthValue,
      isSmall: true,
      variant: widthValue === selectedWidth ? 'primary' : undefined,
      onClick: () => handleChange(widthValue)
    }, widthValue, "%");
  })));
}

function ButtonEdit(props) {
  const {
    attributes,
    setAttributes,
    className,
    isSelected,
    onReplace,
    mergeBlocks
  } = props;
  const {
    textAlign,
    linkTarget,
    placeholder,
    rel,
    style,
    text,
    url,
    width
  } = attributes;

  function onToggleOpenInNewTab(value) {
    const newLinkTarget = value ? '_blank' : undefined;
    let updatedRel = rel;

    if (newLinkTarget && !rel) {
      updatedRel = NEW_TAB_REL;
    } else if (!newLinkTarget && rel === NEW_TAB_REL) {
      updatedRel = undefined;
    }

    setAttributes({
      linkTarget: newLinkTarget,
      rel: updatedRel
    });
  }

  function setButtonText(newText) {
    // Remove anchor tags from button text content.
    setAttributes({
      text: newText.replace(/<\/?a[^>]*>/g, '')
    });
  }

  function onKeyDown(event) {
    if (external_wp_keycodes_namespaceObject.isKeyboardEvent.primary(event, 'k')) {
      startEditing(event);
    } else if (external_wp_keycodes_namespaceObject.isKeyboardEvent.primaryShift(event, 'k')) {
      unlink();
      richTextRef.current?.focus();
    }
  } // Use internal state instead of a ref to make sure that the component
  // re-renders when the popover's anchor updates.


  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalUseBorderProps)(attributes);
  const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalUseColorProps)(attributes);
  const spacingProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetSpacingClassesAndStyles)(attributes);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const richTextRef = (0,external_wp_element_namespaceObject.useRef)();
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    ref: (0,external_wp_compose_namespaceObject.useMergeRefs)([setPopoverAnchor, ref]),
    onKeyDown
  });
  const [isEditingURL, setIsEditingURL] = (0,external_wp_element_namespaceObject.useState)(false);
  const isURLSet = !!url;
  const opensInNewTab = linkTarget === '_blank';

  function startEditing(event) {
    event.preventDefault();
    setIsEditingURL(true);
  }

  function unlink() {
    setAttributes({
      url: undefined,
      linkTarget: undefined,
      rel: undefined
    });
    setIsEditingURL(false);
  }

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isSelected) {
      setIsEditingURL(false);
    }
  }, [isSelected]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps,
    className: classnames_default()(blockProps.className, {
      [`has-custom-width wp-block-button__width-${width}`]: width,
      [`has-custom-font-size`]: blockProps.style.fontSize
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    ref: richTextRef,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Button text'),
    placeholder: placeholder || (0,external_wp_i18n_namespaceObject.__)('Add text…'),
    value: text,
    onChange: value => setButtonText(value),
    withoutInteractiveFormatting: true,
    className: classnames_default()(className, 'wp-block-button__link', colorProps.className, borderProps.className, {
      [`has-text-align-${textAlign}`]: textAlign,
      // For backwards compatibility add style that isn't
      // provided via block support.
      'no-border-radius': style?.border?.radius === 0
    }, (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('button')),
    style: { ...borderProps.style,
      ...colorProps.style,
      ...spacingProps.style
    },
    onSplit: value => (0,external_wp_blocks_namespaceObject.createBlock)('core/button', { ...attributes,
      text: value
    }),
    onReplace: onReplace,
    onMerge: mergeBlocks,
    identifier: "text"
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: nextAlign => {
      setAttributes({
        textAlign: nextAlign
      });
    }
  }), !isURLSet && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    name: "link",
    icon: library_link,
    title: (0,external_wp_i18n_namespaceObject.__)('Link'),
    shortcut: external_wp_keycodes_namespaceObject.displayShortcut.primary('k'),
    onClick: startEditing
  }), isURLSet && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    name: "link",
    icon: link_off,
    title: (0,external_wp_i18n_namespaceObject.__)('Unlink'),
    shortcut: external_wp_keycodes_namespaceObject.displayShortcut.primaryShift('k'),
    onClick: unlink,
    isActive: true
  })), isSelected && (isEditingURL || isURLSet) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Popover, {
    placement: "bottom",
    onClose: () => {
      setIsEditingURL(false);
      richTextRef.current?.focus();
    },
    anchor: popoverAnchor,
    focusOnMount: isEditingURL ? 'firstElement' : false,
    __unstableSlotName: '__unstable-block-tools-after',
    shift: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalLinkControl, {
    className: "wp-block-navigation-link__inline-link-input",
    value: {
      url,
      opensInNewTab
    },
    onChange: ({
      url: newURL = '',
      opensInNewTab: newOpensInNewTab
    }) => {
      setAttributes({
        url: (0,external_wp_url_namespaceObject.prependHTTP)(newURL)
      });

      if (opensInNewTab !== newOpensInNewTab) {
        onToggleOpenInNewTab(newOpensInNewTab);
      }
    },
    onRemove: () => {
      unlink();
      richTextRef.current?.focus();
    },
    forceIsEditingLink: isEditingURL
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(WidthPanel, {
    selectedWidth: width,
    setAttributes: setAttributes
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "advanced"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Link rel'),
    value: rel || '',
    onChange: newRel => setAttributes({
      rel: newRel
    })
  })));
}

/* harmony default export */ var button_edit = (ButtonEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/button/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function save_save({
  attributes,
  className
}) {
  const {
    textAlign,
    fontSize,
    linkTarget,
    rel,
    style,
    text,
    title,
    url,
    width
  } = attributes;

  if (!text) {
    return null;
  }

  const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetBorderClassesAndStyles)(attributes);
  const colorProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetColorClassesAndStyles)(attributes);
  const spacingProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetSpacingClassesAndStyles)(attributes);
  const buttonClasses = classnames_default()('wp-block-button__link', colorProps.className, borderProps.className, {
    [`has-text-align-${textAlign}`]: textAlign,
    // For backwards compatibility add style that isn't provided via
    // block support.
    'no-border-radius': style?.border?.radius === 0
  }, (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('button'));
  const buttonStyle = { ...borderProps.style,
    ...colorProps.style,
    ...spacingProps.style
  }; // The use of a `title` attribute here is soft-deprecated, but still applied
  // if it had already been assigned, for the sake of backward-compatibility.
  // A title will no longer be assigned for new or updated button block links.

  const wrapperClasses = classnames_default()(className, {
    [`has-custom-width wp-block-button__width-${width}`]: width,
    [`has-custom-font-size`]: fontSize || style?.typography?.fontSize
  });
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className: wrapperClasses
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    tagName: "a",
    className: buttonClasses,
    href: url,
    title: title,
    style: buttonStyle,
    value: text,
    target: linkTarget,
    rel: rel
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/button/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const button_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/button",
  title: "Button",
  category: "design",
  parent: ["core/buttons"],
  description: "Prompt visitors to take action with a button-style link.",
  keywords: ["link"],
  textdomain: "default",
  attributes: {
    textAlign: {
      type: "string"
    },
    url: {
      type: "string",
      source: "attribute",
      selector: "a",
      attribute: "href",
      __experimentalRole: "content"
    },
    title: {
      type: "string",
      source: "attribute",
      selector: "a",
      attribute: "title",
      __experimentalRole: "content"
    },
    text: {
      type: "string",
      source: "html",
      selector: "a",
      __experimentalRole: "content"
    },
    linkTarget: {
      type: "string",
      source: "attribute",
      selector: "a",
      attribute: "target",
      __experimentalRole: "content"
    },
    rel: {
      type: "string",
      source: "attribute",
      selector: "a",
      attribute: "rel",
      __experimentalRole: "content"
    },
    placeholder: {
      type: "string"
    },
    backgroundColor: {
      type: "string"
    },
    textColor: {
      type: "string"
    },
    gradient: {
      type: "string"
    },
    width: {
      type: "number"
    }
  },
  supports: {
    anchor: true,
    align: false,
    alignWide: false,
    color: {
      __experimentalSkipSerialization: true,
      gradients: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    reusable: false,
    shadow: true,
    spacing: {
      __experimentalSkipSerialization: true,
      padding: ["horizontal", "vertical"],
      __experimentalDefaultControls: {
        padding: true
      }
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      style: true,
      width: true,
      __experimentalSkipSerialization: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        style: true,
        width: true
      }
    },
    __experimentalSelector: ".wp-block-button .wp-block-button__link"
  },
  styles: [{
    name: "fill",
    label: "Fill",
    isDefault: true
  }, {
    name: "outline",
    label: "Outline"
  }],
  editorStyle: "wp-block-button-editor",
  style: "wp-block-button"
};

const {
  name: button_name
} = button_metadata;

const button_settings = {
  icon: library_button,
  example: {
    attributes: {
      className: 'is-style-fill',
      text: (0,external_wp_i18n_namespaceObject.__)('Call to Action')
    }
  },
  edit: button_edit,
  save: save_save,
  deprecated: button_deprecated,
  merge: (a, {
    text = ''
  }) => ({ ...a,
    text: (a.text || '') + text
  })
};
const button_init = () => initBlock({
  name: button_name,
  metadata: button_metadata,
  settings: button_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/buttons.js


/**
 * WordPress dependencies
 */

const buttons = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14.5 17.5H9.5V16H14.5V17.5Z M14.5 8H9.5V6.5H14.5V8Z M7 3.5H17C18.1046 3.5 19 4.39543 19 5.5V9C19 10.1046 18.1046 11 17 11H7C5.89543 11 5 10.1046 5 9V5.5C5 4.39543 5.89543 3.5 7 3.5ZM17 5H7C6.72386 5 6.5 5.22386 6.5 5.5V9C6.5 9.27614 6.72386 9.5 7 9.5H17C17.2761 9.5 17.5 9.27614 17.5 9V5.5C17.5 5.22386 17.2761 5 17 5Z M7 13H17C18.1046 13 19 13.8954 19 15V18.5C19 19.6046 18.1046 20.5 17 20.5H7C5.89543 20.5 5 19.6046 5 18.5V15C5 13.8954 5.89543 13 7 13ZM17 14.5H7C6.72386 14.5 6.5 14.7239 6.5 15V18.5C6.5 18.7761 6.72386 19 7 19H17C17.2761 19 17.5 18.7761 17.5 18.5V15C17.5 14.7239 17.2761 14.5 17 14.5Z"
}));
/* harmony default export */ var library_buttons = (buttons);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/buttons/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * @param {Object} attributes Block's attributes.
 */

const migrateWithLayout = attributes => {
  if (!!attributes.layout) {
    return attributes;
  }

  const {
    contentJustification,
    orientation,
    ...updatedAttributes
  } = attributes;

  if (contentJustification || orientation) {
    Object.assign(updatedAttributes, {
      layout: {
        type: 'flex',
        ...(contentJustification && {
          justifyContent: contentJustification
        }),
        ...(orientation && {
          orientation
        })
      }
    });
  }

  return updatedAttributes;
};

const buttons_deprecated_deprecated = [{
  attributes: {
    contentJustification: {
      type: 'string'
    },
    orientation: {
      type: 'string',
      default: 'horizontal'
    }
  },
  supports: {
    anchor: true,
    align: ['wide', 'full'],
    __experimentalExposeControlsToChildren: true,
    spacing: {
      blockGap: true,
      margin: ['top', 'bottom'],
      __experimentalDefaultControls: {
        blockGap: true
      }
    }
  },
  isEligible: ({
    contentJustification,
    orientation
  }) => !!contentJustification || !!orientation,
  migrate: migrateWithLayout,

  save({
    attributes: {
      contentJustification,
      orientation
    }
  }) {
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classnames_default()({
          [`is-content-justification-${contentJustification}`]: contentJustification,
          'is-vertical': orientation === 'vertical'
        })
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

}, {
  supports: {
    align: ['center', 'left', 'right'],
    anchor: true
  },

  save() {
    return (0,external_wp_element_namespaceObject.createElement)("div", null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  },

  isEligible({
    align
  }) {
    return align && ['center', 'left', 'right'].includes(align);
  },

  migrate(attributes) {
    return migrateWithLayout({ ...attributes,
      align: undefined,
      // Floating Buttons blocks shouldn't have been supported in the
      // first place. Most users using them probably expected them to
      // act like content justification controls, so these blocks are
      // migrated to use content justification.
      // As for center-aligned Buttons blocks, the content justification
      // equivalent will create an identical end result in most cases.
      contentJustification: attributes.align
    });
  }

}];
/* harmony default export */ var buttons_deprecated = (buttons_deprecated_deprecated);

;// CONCATENATED MODULE: external ["wp","richText"]
var external_wp_richText_namespaceObject = window["wp"]["richText"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/buttons/transforms.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const {
  name: transforms_name
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/buttons",
  title: "Buttons",
  category: "design",
  description: "Prompt visitors to take action with a group of button-style links.",
  keywords: ["link"],
  textdomain: "default",
  supports: {
    anchor: true,
    align: ["wide", "full"],
    html: false,
    __experimentalExposeControlsToChildren: true,
    spacing: {
      blockGap: true,
      margin: ["top", "bottom"],
      __experimentalDefaultControls: {
        blockGap: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    layout: {
      allowSwitching: false,
      allowInheriting: false,
      "default": {
        type: "flex"
      }
    }
  },
  editorStyle: "wp-block-buttons-editor",
  style: "wp-block-buttons"
};
const transforms_transforms = {
  from: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['core/button'],
    transform: buttons => // Creates the buttons block.
    (0,external_wp_blocks_namespaceObject.createBlock)(transforms_name, {}, // Loop the selected buttons.
    buttons.map(attributes => // Create singular button in the buttons block.
    (0,external_wp_blocks_namespaceObject.createBlock)('core/button', attributes)))
  }, {
    type: 'block',
    isMultiBlock: true,
    blocks: ['core/paragraph'],
    transform: buttons => // Creates the buttons block.
    (0,external_wp_blocks_namespaceObject.createBlock)(transforms_name, {}, // Loop the selected buttons.
    buttons.map(attributes => {
      const element = (0,external_wp_richText_namespaceObject.__unstableCreateElement)(document, attributes.content); // Remove any HTML tags.

      const text = element.innerText || ''; // Get first url.

      const link = element.querySelector('a');
      const url = link?.getAttribute('href'); // Create singular button in the buttons block.

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/button', {
        text,
        url
      });
    })),
    isMatch: paragraphs => {
      return paragraphs.every(attributes => {
        const element = (0,external_wp_richText_namespaceObject.__unstableCreateElement)(document, attributes.content);
        const text = element.innerText || '';
        const links = element.querySelectorAll('a');
        return text.length <= 30 && links.length <= 1;
      });
    }
  }]
};
/* harmony default export */ var buttons_transforms = (transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/buttons/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const ALLOWED_BLOCKS = [button_name];
const DEFAULT_BLOCK = {
  name: button_name,
  attributesToCopy: ['backgroundColor', 'border', 'className', 'fontFamily', 'fontSize', 'gradient', 'style', 'textColor', 'width']
};

function ButtonsEdit({
  attributes,
  className
}) {
  var _layout$orientation;

  const {
    fontSize,
    layout,
    style
  } = attributes;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()(className, {
      'has-custom-font-size': fontSize || style?.typography?.fontSize
    })
  });
  const preferredStyle = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const preferredStyleVariations = select(external_wp_blockEditor_namespaceObject.store).getSettings().__experimentalPreferredStyleVariations;

    return preferredStyleVariations?.value?.[button_name];
  }, []);
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    allowedBlocks: ALLOWED_BLOCKS,
    __experimentalDefaultBlock: DEFAULT_BLOCK,
    __experimentalDirectInsert: true,
    template: [[button_name, {
      className: preferredStyle && `is-style-${preferredStyle}`
    }]],
    templateInsertUpdatesSelection: true,
    orientation: (_layout$orientation = layout?.orientation) !== null && _layout$orientation !== void 0 ? _layout$orientation : 'horizontal'
  });
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  });
}

/* harmony default export */ var buttons_edit = (ButtonsEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/buttons/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function buttons_save_save({
  attributes,
  className
}) {
  const {
    fontSize,
    style
  } = attributes;
  const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save({
    className: classnames_default()(className, {
      'has-custom-font-size': fontSize || style?.typography?.fontSize
    })
  });
  const innerBlocksProps = external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(blockProps);
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/buttons/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





const buttons_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/buttons",
  title: "Buttons",
  category: "design",
  description: "Prompt visitors to take action with a group of button-style links.",
  keywords: ["link"],
  textdomain: "default",
  supports: {
    anchor: true,
    align: ["wide", "full"],
    html: false,
    __experimentalExposeControlsToChildren: true,
    spacing: {
      blockGap: true,
      margin: ["top", "bottom"],
      __experimentalDefaultControls: {
        blockGap: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    layout: {
      allowSwitching: false,
      allowInheriting: false,
      "default": {
        type: "flex"
      }
    }
  },
  editorStyle: "wp-block-buttons-editor",
  style: "wp-block-buttons"
};

const {
  name: buttons_name
} = buttons_metadata;

const buttons_settings = {
  icon: library_buttons,
  example: {
    innerBlocks: [{
      name: 'core/button',
      attributes: {
        text: (0,external_wp_i18n_namespaceObject.__)('Find out more')
      }
    }, {
      name: 'core/button',
      attributes: {
        text: (0,external_wp_i18n_namespaceObject.__)('Contact us')
      }
    }]
  },
  deprecated: buttons_deprecated,
  transforms: buttons_transforms,
  edit: buttons_edit,
  save: buttons_save_save
};
const buttons_init = () => initBlock({
  name: buttons_name,
  metadata: buttons_metadata,
  settings: buttons_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/calendar.js


/**
 * WordPress dependencies
 */

const calendar = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm.5 16c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V7h15v12zM9 10H7v2h2v-2zm0 4H7v2h2v-2zm4-4h-2v2h2v-2zm4 0h-2v2h2v-2zm-4 4h-2v2h2v-2zm4 0h-2v2h2v-2z"
}));
/* harmony default export */ var library_calendar = (calendar);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/calendar/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */








/**
 * Returns the year and month of a specified date.
 *
 * @see `WP_REST_Posts_Controller::prepare_date_response()`.
 *
 * @param {string} date Date in `ISO8601/RFC3339` format.
 * @return {Object} Year and date of the specified date.
 */

const getYearMonth = memize(date => {
  if (!date) {
    return {};
  }

  const dateObj = new Date(date);
  return {
    year: dateObj.getFullYear(),
    month: dateObj.getMonth() + 1
  };
});
function CalendarEdit({
  attributes
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const {
    date,
    hasPosts,
    hasPostsResolved
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecords,
      hasFinishedResolution
    } = select(external_wp_coreData_namespaceObject.store);
    const singlePublishedPostQuery = {
      status: 'publish',
      per_page: 1
    };
    const posts = getEntityRecords('postType', 'post', singlePublishedPostQuery);
    const postsResolved = hasFinishedResolution('getEntityRecords', ['postType', 'post', singlePublishedPostQuery]);

    let _date; // FIXME: @wordpress/block-library should not depend on @wordpress/editor.
    // Blocks can be loaded into a *non-post* block editor.
    // eslint-disable-next-line @wordpress/data-no-store-string-literals


    const editorSelectors = select('core/editor');

    if (editorSelectors) {
      const postType = editorSelectors.getEditedPostAttribute('type'); // Dates are used to overwrite year and month used on the calendar.
      // This overwrite should only happen for 'post' post types.
      // For other post types the calendar always displays the current month.

      if (postType === 'post') {
        _date = editorSelectors.getEditedPostAttribute('date');
      }
    }

    return {
      date: _date,
      hasPostsResolved: postsResolved,
      hasPosts: postsResolved && posts?.length === 1
    };
  }, []);

  if (!hasPosts) {
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
      icon: library_calendar,
      label: (0,external_wp_i18n_namespaceObject.__)('Calendar')
    }, !hasPostsResolved ? (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null) : (0,external_wp_i18n_namespaceObject.__)('No published posts found.')));
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, null, (0,external_wp_element_namespaceObject.createElement)((external_wp_serverSideRender_default()), {
    block: "core/calendar",
    attributes: { ...attributes,
      ...getYearMonth(date)
    }
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/calendar/transforms.js
/**
 * WordPress dependencies
 */

const calendar_transforms_transforms = {
  from: [{
    type: 'block',
    blocks: ['core/archives'],
    transform: () => (0,external_wp_blocks_namespaceObject.createBlock)('core/calendar')
  }],
  to: [{
    type: 'block',
    blocks: ['core/archives'],
    transform: () => (0,external_wp_blocks_namespaceObject.createBlock)('core/archives')
  }]
};
/* harmony default export */ var calendar_transforms = (calendar_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/calendar/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const calendar_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/calendar",
  title: "Calendar",
  category: "widgets",
  description: "A calendar of your site\u2019s posts.",
  keywords: ["posts", "archive"],
  textdomain: "default",
  attributes: {
    month: {
      type: "integer"
    },
    year: {
      type: "integer"
    }
  },
  supports: {
    align: true,
    color: {
      link: true,
      __experimentalSkipSerialization: ["text", "background"],
      __experimentalDefaultControls: {
        background: true,
        text: true
      },
      __experimentalSelector: "table, th"
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  style: "wp-block-calendar"
};


const {
  name: calendar_name
} = calendar_metadata;

const calendar_settings = {
  icon: library_calendar,
  example: {},
  edit: CalendarEdit,
  transforms: calendar_transforms
};
const calendar_init = () => initBlock({
  name: calendar_name,
  metadata: calendar_metadata,
  settings: calendar_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/category.js


/**
 * WordPress dependencies
 */

const category = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M6 5.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM4 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2V6zm11-.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5h-3a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM13 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2h-3a2 2 0 01-2-2V6zm5 8.5h-3a.5.5 0 00-.5.5v3a.5.5 0 00.5.5h3a.5.5 0 00.5-.5v-3a.5.5 0 00-.5-.5zM15 13a2 2 0 00-2 2v3a2 2 0 002 2h3a2 2 0 002-2v-3a2 2 0 00-2-2h-3zm-9 1.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5v-3a.5.5 0 01.5-.5zM4 15a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2v-3z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ var library_category = (category);

;// CONCATENATED MODULE: external ["wp","htmlEntities"]
var external_wp_htmlEntities_namespaceObject = window["wp"]["htmlEntities"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/pin.js


/**
 * WordPress dependencies
 */

const pin = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m21.5 9.1-6.6-6.6-4.2 5.6c-1.2-.1-2.4.1-3.6.7-.1 0-.1.1-.2.1-.5.3-.9.6-1.2.9l3.7 3.7-5.7 5.7v1.1h1.1l5.7-5.7 3.7 3.7c.4-.4.7-.8.9-1.2.1-.1.1-.2.2-.3.6-1.1.8-2.4.6-3.6l5.6-4.1zm-7.3 3.5.1.9c.1.9 0 1.8-.4 2.6l-6-6c.8-.4 1.7-.5 2.6-.4l.9.1L15 4.9 19.1 9l-4.9 3.6z"
}));
/* harmony default export */ var library_pin = (pin);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/categories/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */








function CategoriesEdit({
  attributes: {
    displayAsDropdown,
    showHierarchy,
    showPostCounts,
    showOnlyTopLevel,
    showEmpty
  },
  setAttributes,
  className
}) {
  const selectId = (0,external_wp_compose_namespaceObject.useInstanceId)(CategoriesEdit, 'blocks-category-select');
  const query = {
    per_page: -1,
    hide_empty: !showEmpty,
    context: 'view'
  };

  if (showOnlyTopLevel) {
    query.parent = 0;
  }

  const {
    records: categories,
    isResolving
  } = (0,external_wp_coreData_namespaceObject.useEntityRecords)('taxonomy', 'category', query);

  const getCategoriesList = parentId => {
    if (!categories?.length) {
      return [];
    }

    if (parentId === null) {
      return categories;
    }

    return categories.filter(({
      parent
    }) => parent === parentId);
  };

  const toggleAttribute = attributeName => newValue => setAttributes({
    [attributeName]: newValue
  });

  const renderCategoryName = name => !name ? (0,external_wp_i18n_namespaceObject.__)('(Untitled)') : (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(name).trim();

  const renderCategoryList = () => {
    const parentId = showHierarchy ? 0 : null;
    const categoriesList = getCategoriesList(parentId);
    return categoriesList.map(category => renderCategoryListItem(category));
  };

  const renderCategoryListItem = category => {
    const childCategories = getCategoriesList(category.id);
    const {
      id,
      link,
      count,
      name
    } = category;
    return (0,external_wp_element_namespaceObject.createElement)("li", {
      key: id,
      className: `cat-item cat-item-${id}`
    }, (0,external_wp_element_namespaceObject.createElement)("a", {
      href: link,
      target: "_blank",
      rel: "noreferrer noopener"
    }, renderCategoryName(name)), showPostCounts && ` (${count})`, showHierarchy && !!childCategories.length && (0,external_wp_element_namespaceObject.createElement)("ul", {
      className: "children"
    }, childCategories.map(childCategory => renderCategoryListItem(childCategory))));
  };

  const renderCategoryDropdown = () => {
    const parentId = showHierarchy ? 0 : null;
    const categoriesList = getCategoriesList(parentId);
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, {
      as: "label",
      htmlFor: selectId
    }, (0,external_wp_i18n_namespaceObject.__)('Categories')), (0,external_wp_element_namespaceObject.createElement)("select", {
      id: selectId
    }, (0,external_wp_element_namespaceObject.createElement)("option", null, (0,external_wp_i18n_namespaceObject.__)('Select Category')), categoriesList.map(category => renderCategoryDropdownItem(category, 0))));
  };

  const renderCategoryDropdownItem = (category, level) => {
    const {
      id,
      count,
      name
    } = category;
    const childCategories = getCategoriesList(id);
    return [(0,external_wp_element_namespaceObject.createElement)("option", {
      key: id,
      className: `level-${level}`
    }, Array.from({
      length: level * 3
    }).map(() => '\xa0'), renderCategoryName(name), showPostCounts && ` (${count})`), showHierarchy && !!childCategories.length && childCategories.map(childCategory => renderCategoryDropdownItem(childCategory, level + 1))];
  };

  const TagName = !!categories?.length && !displayAsDropdown && !isResolving ? 'ul' : 'div';
  const classes = classnames_default()(className, {
    'wp-block-categories-list': !!categories?.length && !displayAsDropdown && !isResolving,
    'wp-block-categories-dropdown': !!categories?.length && displayAsDropdown && !isResolving
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classes
  });
  return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display as dropdown'),
    checked: displayAsDropdown,
    onChange: toggleAttribute('displayAsDropdown')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show post counts'),
    checked: showPostCounts,
    onChange: toggleAttribute('showPostCounts')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show only top level categories'),
    checked: showOnlyTopLevel,
    onChange: toggleAttribute('showOnlyTopLevel')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show empty categories'),
    checked: showEmpty,
    onChange: toggleAttribute('showEmpty')
  }), !showOnlyTopLevel && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show hierarchy'),
    checked: showHierarchy,
    onChange: toggleAttribute('showHierarchy')
  }))), isResolving && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
    icon: library_pin,
    label: (0,external_wp_i18n_namespaceObject.__)('Categories')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null)), !isResolving && categories?.length === 0 && (0,external_wp_element_namespaceObject.createElement)("p", null, (0,external_wp_i18n_namespaceObject.__)('Your site does not have any posts, so there is nothing to display here at the moment.')), !isResolving && categories?.length > 0 && (displayAsDropdown ? renderCategoryDropdown() : renderCategoryList()));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/categories/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const categories_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/categories",
  title: "Categories List",
  category: "widgets",
  description: "Display a list of all categories.",
  textdomain: "default",
  attributes: {
    displayAsDropdown: {
      type: "boolean",
      "default": false
    },
    showHierarchy: {
      type: "boolean",
      "default": false
    },
    showPostCounts: {
      type: "boolean",
      "default": false
    },
    showOnlyTopLevel: {
      type: "boolean",
      "default": false
    },
    showEmpty: {
      type: "boolean",
      "default": false
    }
  },
  supports: {
    align: true,
    html: false,
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-categories-editor",
  style: "wp-block-categories"
};

const {
  name: categories_name
} = categories_metadata;

const categories_settings = {
  icon: library_category,
  example: {},
  edit: CategoriesEdit
};
const categories_init = () => initBlock({
  name: categories_name,
  metadata: categories_metadata,
  settings: categories_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/classic.js


/**
 * WordPress dependencies
 */

const classic = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20 6H4c-1.1 0-2 .9-2 2v9c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm.5 11c0 .3-.2.5-.5.5H4c-.3 0-.5-.2-.5-.5V8c0-.3.2-.5.5-.5h16c.3 0 .5.2.5.5v9zM10 10H8v2h2v-2zm-5 2h2v-2H5v2zm8-2h-2v2h2v-2zm-5 6h8v-2H8v2zm6-4h2v-2h-2v2zm3 0h2v-2h-2v2zm0 4h2v-2h-2v2zM5 16h2v-2H5v2z"
}));
/* harmony default export */ var library_classic = (classic);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/freeform/convert-to-blocks-button.js


/**
 * WordPress dependencies
 */






const ConvertToBlocksButton = ({
  clientId
}) => {
  const {
    replaceBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const block = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(external_wp_blockEditor_namespaceObject.store).getBlock(clientId);
  }, [clientId]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: () => replaceBlocks(block.clientId, (0,external_wp_blocks_namespaceObject.rawHandler)({
      HTML: (0,external_wp_blocks_namespaceObject.serialize)(block)
    }))
  }, (0,external_wp_i18n_namespaceObject.__)('Convert to blocks'));
};

/* harmony default export */ var convert_to_blocks_button = (ConvertToBlocksButton);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/freeform/modal.js


/**
 * WordPress dependencies
 */






function ClassicEdit(props) {
  const styles = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getSettings().styles);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      baseURL,
      suffix,
      settings
    } = window.wpEditorL10n.tinymce;
    window.tinymce.EditorManager.overrideDefaults({
      base_url: baseURL,
      suffix
    });
    window.wp.oldEditor.initialize(props.id, {
      tinymce: { ...settings,

        setup(editor) {
          editor.on('init', () => {
            const doc = editor.getDoc();
            styles.forEach(({
              css
            }) => {
              const styleEl = doc.createElement('style');
              styleEl.innerHTML = css;
              doc.head.appendChild(styleEl);
            });
          });
        }

      }
    });
    return () => {
      window.wp.oldEditor.remove(props.id);
    };
  }, []);
  return (0,external_wp_element_namespaceObject.createElement)("textarea", { ...props
  });
}

function ModalEdit(props) {
  const {
    clientId,
    attributes: {
      content
    },
    setAttributes,
    onReplace
  } = props;
  const [isOpen, setOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const id = `editor-${clientId}`;

  const onClose = () => content ? setOpen(false) : onReplace([]);

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: () => setOpen(true)
  }, (0,external_wp_i18n_namespaceObject.__)('Edit')))), content && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, content), (isOpen || !content) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Modal, {
    title: (0,external_wp_i18n_namespaceObject.__)('Classic Editor'),
    onRequestClose: onClose,
    shouldCloseOnClickOutside: false,
    overlayClassName: "block-editor-freeform-modal"
  }, (0,external_wp_element_namespaceObject.createElement)(ClassicEdit, {
    id: id,
    defaultValue: content
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, {
    className: "block-editor-freeform-modal__actions",
    justify: "flex-end",
    expanded: false
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "tertiary",
    onClick: onClose
  }, (0,external_wp_i18n_namespaceObject.__)('Cancel'))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "primary",
    onClick: () => {
      setAttributes({
        content: window.wp.oldEditor.getContent(id)
      });
      setOpen(false);
    }
  }, (0,external_wp_i18n_namespaceObject.__)('Save'))))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/freeform/edit.js


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



const {
  wp
} = window;

function isTmceEmpty(editor) {
  // When tinyMce is empty the content seems to be:
  // <p><br data-mce-bogus="1"></p>
  // avoid expensive checks for large documents
  const body = editor.getBody();

  if (body.childNodes.length > 1) {
    return false;
  } else if (body.childNodes.length === 0) {
    return true;
  }

  if (body.childNodes[0].childNodes.length > 1) {
    return false;
  }

  return /^\n?$/.test(body.innerText || body.textContent);
}

function FreeformEdit(props) {
  const {
    clientId
  } = props;
  const canRemove = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).canRemoveBlock(clientId), [clientId]);
  const [isIframed, setIsIframed] = (0,external_wp_element_namespaceObject.useState)(false);
  const ref = (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    setIsIframed(element.ownerDocument !== document);
  }, []);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, canRemove && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(convert_to_blocks_button, {
    clientId: clientId
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)({
      ref
    })
  }, isIframed ? (0,external_wp_element_namespaceObject.createElement)(ModalEdit, { ...props
  }) : (0,external_wp_element_namespaceObject.createElement)(edit_ClassicEdit, { ...props
  })));
}

function edit_ClassicEdit({
  clientId,
  attributes: {
    content
  },
  setAttributes,
  onReplace
}) {
  const {
    getMultiSelectedBlockClientIds
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const didMount = (0,external_wp_element_namespaceObject.useRef)(false);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!didMount.current) {
      return;
    }

    const editor = window.tinymce.get(`editor-${clientId}`);
    const currentContent = editor?.getContent();

    if (currentContent !== content) {
      editor.setContent(content || '');
    }
  }, [content]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      baseURL,
      suffix
    } = window.wpEditorL10n.tinymce;
    didMount.current = true;
    window.tinymce.EditorManager.overrideDefaults({
      base_url: baseURL,
      suffix
    });

    function onSetup(editor) {
      let bookmark;

      if (content) {
        editor.on('loadContent', () => editor.setContent(content));
      }

      editor.on('blur', () => {
        bookmark = editor.selection.getBookmark(2, true); // There is an issue with Chrome and the editor.focus call in core at https://core.trac.wordpress.org/browser/trunk/src/js/_enqueues/lib/link.js#L451.
        // This causes a scroll to the top of editor content on return from some content updating dialogs so tracking
        // scroll position until this is fixed in core.

        const scrollContainer = document.querySelector('.interface-interface-skeleton__content');
        const scrollPosition = scrollContainer.scrollTop; // Only update attributes if we aren't multi-selecting blocks.
        // Updating during multi-selection can overwrite attributes of other blocks.

        if (!getMultiSelectedBlockClientIds()?.length) {
          setAttributes({
            content: editor.getContent()
          });
        }

        editor.once('focus', () => {
          if (bookmark) {
            editor.selection.moveToBookmark(bookmark);

            if (scrollContainer.scrollTop !== scrollPosition) {
              scrollContainer.scrollTop = scrollPosition;
            }
          }
        });
        return false;
      });
      editor.on('mousedown touchstart', () => {
        bookmark = null;
      });
      const debouncedOnChange = (0,external_wp_compose_namespaceObject.debounce)(() => {
        const value = editor.getContent();

        if (value !== editor._lastChange) {
          editor._lastChange = value;
          setAttributes({
            content: value
          });
        }
      }, 250);
      editor.on('Paste Change input Undo Redo', debouncedOnChange); // We need to cancel the debounce call because when we remove
      // the editor (onUnmount) this callback is executed in
      // another tick. This results in setting the content to empty.

      editor.on('remove', debouncedOnChange.cancel);
      editor.on('keydown', event => {
        if (external_wp_keycodes_namespaceObject.isKeyboardEvent.primary(event, 'z')) {
          // Prevent the gutenberg undo kicking in so TinyMCE undo stack works as expected.
          event.stopPropagation();
        }

        if ((event.keyCode === external_wp_keycodes_namespaceObject.BACKSPACE || event.keyCode === external_wp_keycodes_namespaceObject.DELETE) && isTmceEmpty(editor)) {
          // Delete the block.
          onReplace([]);
          event.preventDefault();
          event.stopImmediatePropagation();
        }

        const {
          altKey
        } = event;
        /*
         * Prevent Mousetrap from kicking in: TinyMCE already uses its own
         * `alt+f10` shortcut to focus its toolbar.
         */

        if (altKey && event.keyCode === external_wp_keycodes_namespaceObject.F10) {
          event.stopPropagation();
        }
      });
      editor.on('init', () => {
        const rootNode = editor.getBody(); // Create the toolbar by refocussing the editor.

        if (rootNode.ownerDocument.activeElement === rootNode) {
          rootNode.blur();
          editor.focus();
        }
      });
    }

    function initialize() {
      const {
        settings
      } = window.wpEditorL10n.tinymce;
      wp.oldEditor.initialize(`editor-${clientId}`, {
        tinymce: { ...settings,
          inline: true,
          content_css: false,
          fixed_toolbar_container: `#toolbar-${clientId}`,
          setup: onSetup
        }
      });
    }

    function onReadyStateChange() {
      if (document.readyState === 'complete') {
        initialize();
      }
    }

    if (document.readyState === 'complete') {
      initialize();
    } else {
      document.addEventListener('readystatechange', onReadyStateChange);
    }

    return () => {
      document.removeEventListener('readystatechange', onReadyStateChange);
      wp.oldEditor.remove(`editor-${clientId}`);
    };
  }, []);

  function focus() {
    const editor = window.tinymce.get(`editor-${clientId}`);

    if (editor) {
      editor.focus();
    }
  }

  function onToolbarKeyDown(event) {
    // Prevent WritingFlow from kicking in and allow arrows navigation on the toolbar.
    event.stopPropagation(); // Prevent Mousetrap from moving focus to the top toolbar when pressing `alt+f10` on this block toolbar.

    event.nativeEvent.stopImmediatePropagation();
  } // Disable reasons:
  //
  // jsx-a11y/no-static-element-interactions
  //  - the toolbar itself is non-interactive, but must capture events
  //    from the KeyboardShortcuts component to stop their propagation.

  /* eslint-disable jsx-a11y/no-static-element-interactions */


  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", {
    key: "toolbar",
    id: `toolbar-${clientId}`,
    className: "block-library-classic__toolbar",
    onClick: focus,
    "data-placeholder": (0,external_wp_i18n_namespaceObject.__)('Classic'),
    onKeyDown: onToolbarKeyDown
  }), (0,external_wp_element_namespaceObject.createElement)("div", {
    key: "editor",
    id: `editor-${clientId}`,
    className: "wp-block-freeform block-library-rich-text__tinymce"
  }));
  /* eslint-enable jsx-a11y/no-static-element-interactions */
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/freeform/save.js


/**
 * WordPress dependencies
 */

function freeform_save_save({
  attributes
}) {
  const {
    content
  } = attributes;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, content);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/freeform/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const freeform_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/freeform",
  title: "Classic",
  category: "text",
  description: "Use the classic WordPress editor.",
  textdomain: "default",
  attributes: {
    content: {
      type: "string",
      source: "raw"
    }
  },
  supports: {
    className: false,
    customClassName: false,
    reusable: false
  },
  editorStyle: "wp-block-freeform-editor"
};

const {
  name: freeform_name
} = freeform_metadata;

const freeform_settings = {
  icon: library_classic,
  edit: FreeformEdit,
  save: freeform_save_save
};
const freeform_init = () => initBlock({
  name: freeform_name,
  metadata: freeform_metadata,
  settings: freeform_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/code.js


/**
 * WordPress dependencies
 */

const code = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20.8 10.7l-4.3-4.3-1.1 1.1 4.3 4.3c.1.1.1.3 0 .4l-4.3 4.3 1.1 1.1 4.3-4.3c.7-.8.7-1.9 0-2.6zM4.2 11.8l4.3-4.3-1-1-4.3 4.3c-.7.7-.7 1.8 0 2.5l4.3 4.3 1.1-1.1-4.3-4.3c-.2-.1-.2-.3-.1-.4z"
}));
/* harmony default export */ var library_code = (code);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/code/edit.js


/**
 * WordPress dependencies
 */


function CodeEdit({
  attributes,
  setAttributes,
  onRemove
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  return (0,external_wp_element_namespaceObject.createElement)("pre", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    tagName: "code",
    value: attributes.content,
    onChange: content => setAttributes({
      content
    }),
    onRemove: onRemove,
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write code…'),
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Code'),
    preserveWhiteSpace: true,
    __unstablePastePlainText: true
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/code/utils.js
/**
 * WordPress dependencies
 */

/**
 * Escapes ampersands, shortcodes, and links.
 *
 * @param {string} content The content of a code block.
 * @return {string} The given content with some characters escaped.
 */

function utils_escape(content) {
  return (0,external_wp_compose_namespaceObject.pipe)(escapeOpeningSquareBrackets, escapeProtocolInIsolatedUrls)(content || '');
}
/**
 * Returns the given content with all opening shortcode characters converted
 * into their HTML entity counterpart (i.e. [ => &#91;). For instance, a
 * shortcode like [embed] becomes &#91;embed]
 *
 * This function replicates the escaping of HTML tags, where a tag like
 * <strong> becomes &lt;strong>.
 *
 * @param {string} content The content of a code block.
 * @return {string} The given content with its opening shortcode characters
 *                  converted into their HTML entity counterpart
 *                  (i.e. [ => &#91;)
 */

function escapeOpeningSquareBrackets(content) {
  return content.replace(/\[/g, '&#91;');
}
/**
 * Converts the first two forward slashes of any isolated URL into their HTML
 * counterparts (i.e. // => &#47;&#47;). For instance, https://youtube.com/watch?x
 * becomes https:&#47;&#47;youtube.com/watch?x.
 *
 * An isolated URL is a URL that sits in its own line, surrounded only by spacing
 * characters.
 *
 * See https://github.com/WordPress/wordpress-develop/blob/5.1.1/src/wp-includes/class-wp-embed.php#L403
 *
 * @param {string} content The content of a code block.
 * @return {string} The given content with its ampersands converted into
 *                  their HTML entity counterpart (i.e. & => &amp;)
 */


function escapeProtocolInIsolatedUrls(content) {
  return content.replace(/^(\s*https?:)\/\/([^\s<>"]+\s*)$/m, '$1&#47;&#47;$2');
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/code/save.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function code_save_save({
  attributes
}) {
  return (0,external_wp_element_namespaceObject.createElement)("pre", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    tagName: "code",
    value: utils_escape(attributes.content)
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/code/transforms.js
/**
 * WordPress dependencies
 */

const code_transforms_transforms = {
  from: [{
    type: 'enter',
    regExp: /^```$/,
    transform: () => (0,external_wp_blocks_namespaceObject.createBlock)('core/code')
  }, {
    type: 'block',
    blocks: ['core/html', 'core/paragraph'],
    transform: ({
      content
    }) => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/code', {
        content
      });
    }
  }, {
    type: 'raw',
    isMatch: node => node.nodeName === 'PRE' && node.children.length === 1 && node.firstChild.nodeName === 'CODE',
    schema: {
      pre: {
        children: {
          code: {
            children: {
              '#text': {}
            }
          }
        }
      }
    }
  }],
  to: [{
    type: 'block',
    blocks: ['core/paragraph'],
    transform: ({
      content
    }) => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
        content: content.replace(/\n/g, '<br>')
      });
    }
  }]
};
/* harmony default export */ var code_transforms = (code_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/code/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const code_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/code",
  title: "Code",
  category: "text",
  description: "Display code snippets that respect your spacing and tabs.",
  textdomain: "default",
  attributes: {
    content: {
      type: "string",
      source: "html",
      selector: "code"
    }
  },
  supports: {
    align: ["wide"],
    anchor: true,
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    spacing: {
      margin: ["top", "bottom"],
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    __experimentalBorder: {
      radius: true,
      color: true,
      width: true,
      style: true,
      __experimentalDefaultControls: {
        width: true,
        color: true
      }
    },
    color: {
      text: true,
      background: true,
      gradients: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    }
  },
  style: "wp-block-code"
};


const {
  name: code_name
} = code_metadata;

const code_settings = {
  icon: library_code,
  example: {
    attributes: {
      /* eslint-disable @wordpress/i18n-no-collapsible-whitespace */
      // translators: Preserve \n markers for line breaks
      content: (0,external_wp_i18n_namespaceObject.__)('// A “block” is the abstract term used\n// to describe units of markup that\n// when composed together, form the\n// content or layout of a page.\nregisterBlockType( name, settings );')
      /* eslint-enable @wordpress/i18n-no-collapsible-whitespace */

    }
  },
  transforms: code_transforms,
  edit: CodeEdit,
  save: code_save_save
};
const code_init = () => initBlock({
  name: code_name,
  metadata: code_metadata,
  settings: code_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/column.js


/**
 * WordPress dependencies
 */

const column = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 6H6c-1.1 0-2 .9-2 2v9c0 1.1.9 2 2 2h13c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zM6 17.5c-.3 0-.5-.2-.5-.5V8c0-.3.2-.5.5-.5h3v10H6zm13.5-.5c0 .3-.2.5-.5.5h-3v-10h3c.3 0 .5.2.5.5v9z"
}));
/* harmony default export */ var library_column = (column);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/column/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


const column_deprecated_deprecated = [{
  attributes: {
    verticalAlignment: {
      type: 'string'
    },
    width: {
      type: 'number',
      min: 0,
      max: 100
    }
  },

  isEligible({
    width
  }) {
    return isFinite(width);
  },

  migrate(attributes) {
    return { ...attributes,
      width: `${attributes.width}%`
    };
  },

  save({
    attributes
  }) {
    const {
      verticalAlignment,
      width
    } = attributes;
    const wrapperClasses = classnames_default()({
      [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment
    });
    const style = {
      flexBasis: width + '%'
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: wrapperClasses,
      style: style
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

}];
/* harmony default export */ var column_deprecated = (column_deprecated_deprecated);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/column/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






function ColumnEdit({
  attributes: {
    verticalAlignment,
    width,
    templateLock,
    allowedBlocks
  },
  setAttributes,
  clientId
}) {
  const classes = classnames_default()('block-core-columns', {
    [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment
  });
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: (0,external_wp_blockEditor_namespaceObject.useSetting)('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
  });
  const {
    columnsIds,
    hasChildBlocks,
    rootClientId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockOrder,
      getBlockRootClientId
    } = select(external_wp_blockEditor_namespaceObject.store);
    const rootId = getBlockRootClientId(clientId);
    return {
      hasChildBlocks: getBlockOrder(clientId).length > 0,
      rootClientId: rootId,
      columnsIds: getBlockOrder(rootId)
    };
  }, [clientId]);
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);

  const updateAlignment = value => {
    // Update own alignment.
    setAttributes({
      verticalAlignment: value
    }); // Reset parent Columns block.

    updateBlockAttributes(rootClientId, {
      verticalAlignment: null
    });
  };

  const widthWithUnit = Number.isFinite(width) ? width + '%' : width;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classes,
    style: widthWithUnit ? {
      flexBasis: widthWithUnit
    } : undefined
  });
  const columnsCount = columnsIds.length;
  const currentColumnPosition = columnsIds.indexOf(clientId) + 1;
  const label = (0,external_wp_i18n_namespaceObject.sprintf)(
  /* translators: 1: Block label (i.e. "Block: Column"), 2: Position of the selected block, 3: Total number of sibling blocks of the same type */
  (0,external_wp_i18n_namespaceObject.__)('%1$s (%2$d of %3$d)'), blockProps['aria-label'], currentColumnPosition, columnsCount);
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)({ ...blockProps,
    'aria-label': label
  }, {
    templateLock,
    allowedBlocks,
    renderAppender: hasChildBlocks ? undefined : external_wp_blockEditor_namespaceObject.InnerBlocks.ButtonBlockAppender
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockVerticalAlignmentToolbar, {
    onChange: updateAlignment,
    value: verticalAlignment
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Column settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Width'),
    labelPosition: "edge",
    __unstableInputWidth: "80px",
    value: width || '',
    onChange: nextWidth => {
      nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
      setAttributes({
        width: nextWidth
      });
    },
    units: units
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  }));
}

/* harmony default export */ var column_edit = (ColumnEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/column/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function column_save_save({
  attributes
}) {
  const {
    verticalAlignment,
    width
  } = attributes;
  const wrapperClasses = classnames_default()({
    [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment
  });
  let style;

  if (width && /\d/.test(width)) {
    // Numbers are handled for backward compatibility as they can be still provided with templates.
    let flexBasis = Number.isFinite(width) ? width + '%' : width; // In some cases we need to round the width to a shorter float.

    if (!Number.isFinite(width) && width?.endsWith('%')) {
      const multiplier = 1000000000000; // Shrink the number back to a reasonable float.

      flexBasis = Math.round(Number.parseFloat(width) * multiplier) / multiplier + '%';
    }

    style = {
      flexBasis
    };
  }

  const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save({
    className: wrapperClasses,
    style
  });
  const innerBlocksProps = external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(blockProps);
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/column/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const column_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/column",
  title: "Column",
  category: "design",
  parent: ["core/columns"],
  description: "A single column within a columns block.",
  textdomain: "default",
  attributes: {
    verticalAlignment: {
      type: "string"
    },
    width: {
      type: "string"
    },
    allowedBlocks: {
      type: "array"
    },
    templateLock: {
      type: ["string", "boolean"],
      "enum": ["all", "insert", "contentOnly", false]
    }
  },
  supports: {
    anchor: true,
    reusable: false,
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      blockGap: true,
      padding: true,
      __experimentalDefaultControls: {
        padding: true,
        blockGap: true
      }
    },
    __experimentalBorder: {
      color: true,
      style: true,
      width: true,
      __experimentalDefaultControls: {
        color: true,
        style: true,
        width: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    layout: true
  }
};

const {
  name: column_name
} = column_metadata;

const column_settings = {
  icon: library_column,
  edit: column_edit,
  save: column_save_save,
  deprecated: column_deprecated
};
const column_init = () => initBlock({
  name: column_name,
  metadata: column_metadata,
  settings: column_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/columns.js


/**
 * WordPress dependencies
 */

const columns = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 6H6c-1.1 0-2 .9-2 2v9c0 1.1.9 2 2 2h13c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-4.1 1.5v10H10v-10h4.9zM5.5 17V8c0-.3.2-.5.5-.5h2.5v10H6c-.3 0-.5-.2-.5-.5zm14 0c0 .3-.2.5-.5.5h-2.6v-10H19c.3 0 .5.2.5.5v9z"
}));
/* harmony default export */ var library_columns = (columns);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Given an HTML string for a deprecated columns inner block, returns the
 * column index to which the migrated inner block should be assigned. Returns
 * undefined if the inner block was not assigned to a column.
 *
 * @param {string} originalContent Deprecated Columns inner block HTML.
 *
 * @return {number | undefined} Column to which inner block is to be assigned.
 */

function getDeprecatedLayoutColumn(originalContent) {
  let {
    doc
  } = getDeprecatedLayoutColumn;

  if (!doc) {
    doc = document.implementation.createHTMLDocument('');
    getDeprecatedLayoutColumn.doc = doc;
  }

  let columnMatch;
  doc.body.innerHTML = originalContent;

  for (const classListItem of doc.body.firstChild.classList) {
    if (columnMatch = classListItem.match(/^layout-column-(\d+)$/)) {
      return Number(columnMatch[1]) - 1;
    }
  }
}

const migrateCustomColors = attributes => {
  if (!attributes.customTextColor && !attributes.customBackgroundColor) {
    return attributes;
  }

  const style = {
    color: {}
  };

  if (attributes.customTextColor) {
    style.color.text = attributes.customTextColor;
  }

  if (attributes.customBackgroundColor) {
    style.color.background = attributes.customBackgroundColor;
  }

  const {
    customTextColor,
    customBackgroundColor,
    ...restAttributes
  } = attributes;
  return { ...restAttributes,
    style,
    isStackedOnMobile: true
  };
};

/* harmony default export */ var columns_deprecated = ([{
  attributes: {
    verticalAlignment: {
      type: 'string'
    },
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    customTextColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    }
  },
  migrate: migrateCustomColors,

  save({
    attributes
  }) {
    const {
      verticalAlignment,
      backgroundColor,
      customBackgroundColor,
      textColor,
      customTextColor
    } = attributes;
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const className = classnames_default()({
      'has-background': backgroundColor || customBackgroundColor,
      'has-text-color': textColor || customTextColor,
      [backgroundClass]: backgroundClass,
      [textClass]: textClass,
      [`are-vertically-aligned-${verticalAlignment}`]: verticalAlignment
    });
    const style = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      color: textClass ? undefined : customTextColor
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className ? className : undefined,
      style: style
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

}, {
  attributes: {
    columns: {
      type: 'number',
      default: 2
    }
  },

  isEligible(attributes, innerBlocks) {
    // Since isEligible is called on every valid instance of the
    // Columns block and a deprecation is the unlikely case due to
    // its subsequent migration, optimize for the `false` condition
    // by performing a naive, inaccurate pass at inner blocks.
    const isFastPassEligible = innerBlocks.some(innerBlock => /layout-column-\d+/.test(innerBlock.originalContent));

    if (!isFastPassEligible) {
      return false;
    } // Only if the fast pass is considered eligible is the more
    // accurate, durable, slower condition performed.


    return innerBlocks.some(innerBlock => getDeprecatedLayoutColumn(innerBlock.originalContent) !== undefined);
  },

  migrate(attributes, innerBlocks) {
    const columns = innerBlocks.reduce((accumulator, innerBlock) => {
      const {
        originalContent
      } = innerBlock;
      let columnIndex = getDeprecatedLayoutColumn(originalContent);

      if (columnIndex === undefined) {
        columnIndex = 0;
      }

      if (!accumulator[columnIndex]) {
        accumulator[columnIndex] = [];
      }

      accumulator[columnIndex].push(innerBlock);
      return accumulator;
    }, []);
    const migratedInnerBlocks = columns.map(columnBlocks => (0,external_wp_blocks_namespaceObject.createBlock)('core/column', {}, columnBlocks));
    const {
      columns: ignoredColumns,
      ...restAttributes
    } = attributes;
    return [{ ...restAttributes,
      isStackedOnMobile: true
    }, migratedInnerBlocks];
  },

  save({
    attributes
  }) {
    const {
      columns
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: `has-${columns}-columns`
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

}, {
  attributes: {
    columns: {
      type: 'number',
      default: 2
    }
  },

  migrate(attributes, innerBlocks) {
    const {
      columns,
      ...restAttributes
    } = attributes;
    attributes = { ...restAttributes,
      isStackedOnMobile: true
    };
    return [attributes, innerBlocks];
  },

  save({
    attributes
  }) {
    const {
      verticalAlignment,
      columns
    } = attributes;
    const wrapperClasses = classnames_default()(`has-${columns}-columns`, {
      [`are-vertically-aligned-${verticalAlignment}`]: verticalAlignment
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: wrapperClasses
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

}]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/utils.js
/**
 * Returns a column width attribute value rounded to standard precision.
 * Returns `undefined` if the value is not a valid finite number.
 *
 * @param {?number} value Raw value.
 *
 * @return {number} Value rounded to standard precision.
 */
const toWidthPrecision = value => {
  const unitlessValue = parseFloat(value);
  return Number.isFinite(unitlessValue) ? parseFloat(unitlessValue.toFixed(2)) : undefined;
};
/**
 * Returns an effective width for a given block. An effective width is equal to
 * its attribute value if set, or a computed value assuming equal distribution.
 *
 * @param {WPBlock} block           Block object.
 * @param {number}  totalBlockCount Total number of blocks in Columns.
 *
 * @return {number} Effective column width.
 */

function getEffectiveColumnWidth(block, totalBlockCount) {
  const {
    width = 100 / totalBlockCount
  } = block.attributes;
  return toWidthPrecision(width);
}
/**
 * Returns the total width occupied by the given set of column blocks.
 *
 * @param {WPBlock[]} blocks          Block objects.
 * @param {?number}   totalBlockCount Total number of blocks in Columns.
 *                                    Defaults to number of blocks passed.
 *
 * @return {number} Total width occupied by blocks.
 */

function getTotalColumnsWidth(blocks, totalBlockCount = blocks.length) {
  return blocks.reduce((sum, block) => sum + getEffectiveColumnWidth(block, totalBlockCount), 0);
}
/**
 * Returns an object of `clientId` → `width` of effective column widths.
 *
 * @param {WPBlock[]} blocks          Block objects.
 * @param {?number}   totalBlockCount Total number of blocks in Columns.
 *                                    Defaults to number of blocks passed.
 *
 * @return {Object<string,number>} Column widths.
 */

function getColumnWidths(blocks, totalBlockCount = blocks.length) {
  return blocks.reduce((accumulator, block) => {
    const width = getEffectiveColumnWidth(block, totalBlockCount);
    return Object.assign(accumulator, {
      [block.clientId]: width
    });
  }, {});
}
/**
 * Returns an object of `clientId` → `width` of column widths as redistributed
 * proportional to their current widths, constrained or expanded to fit within
 * the given available width.
 *
 * @param {WPBlock[]} blocks          Block objects.
 * @param {number}    availableWidth  Maximum width to fit within.
 * @param {?number}   totalBlockCount Total number of blocks in Columns.
 *                                    Defaults to number of blocks passed.
 *
 * @return {Object<string,number>} Redistributed column widths.
 */

function getRedistributedColumnWidths(blocks, availableWidth, totalBlockCount = blocks.length) {
  const totalWidth = getTotalColumnsWidth(blocks, totalBlockCount);
  return Object.fromEntries(Object.entries(getColumnWidths(blocks, totalBlockCount)).map(([clientId, width]) => {
    const newWidth = availableWidth * width / totalWidth;
    return [clientId, toWidthPrecision(newWidth)];
  }));
}
/**
 * Returns true if column blocks within the provided set are assigned with
 * explicit widths, or false otherwise.
 *
 * @param {WPBlock[]} blocks Block objects.
 *
 * @return {boolean} Whether columns have explicit widths.
 */

function hasExplicitPercentColumnWidths(blocks) {
  return blocks.every(block => {
    const blockWidth = block.attributes.width;
    return Number.isFinite(blockWidth?.endsWith?.('%') ? parseFloat(blockWidth) : blockWidth);
  });
}
/**
 * Returns a copy of the given set of blocks with new widths assigned from the
 * provided object of redistributed column widths.
 *
 * @param {WPBlock[]}             blocks Block objects.
 * @param {Object<string,number>} widths Redistributed column widths.
 *
 * @return {WPBlock[]} blocks Mapped block objects.
 */

function getMappedColumnWidths(blocks, widths) {
  return blocks.map(block => ({ ...block,
    attributes: { ...block.attributes,
      width: `${widths[block.clientId]}%`
    }
  }));
}
/**
 * Returns an array with columns widths values, parsed or no depends on `withParsing` flag.
 *
 * @param {WPBlock[]} blocks      Block objects.
 * @param {?boolean}  withParsing Whether value has to be parsed.
 *
 * @return {Array<number,string>} Column widths.
 */

function getWidths(blocks, withParsing = true) {
  return blocks.map(innerColumn => {
    const innerColumnWidth = innerColumn.attributes.width || 100 / blocks.length;
    return withParsing ? parseFloat(innerColumnWidth) : innerColumnWidth;
  });
}
/**
 * Returns a column width with unit.
 *
 * @param {string} width Column width.
 * @param {string} unit  Column width unit.
 *
 * @return {string} Column width with unit.
 */

function getWidthWithUnit(width, unit) {
  width = 0 > parseFloat(width) ? '0' : width;

  if (isPercentageUnit(unit)) {
    width = Math.min(width, 100);
  }

  return `${width}${unit}`;
}
/**
 * Returns a boolean whether passed unit is percentage
 *
 * @param {string} unit Column width unit.
 *
 * @return {boolean} 	Whether unit is '%'.
 */

function isPercentageUnit(unit) {
  return unit === '%';
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * Allowed blocks constant is passed to InnerBlocks precisely as specified here.
 * The contents of the array should never change.
 * The array should contain the name of each block that is allowed.
 * In columns block, the only block we allow is 'core/column'.
 *
 * @constant
 * @type {string[]}
 */

const edit_ALLOWED_BLOCKS = ['core/column'];

function ColumnsEditContainer({
  attributes,
  setAttributes,
  updateAlignment,
  updateColumns,
  clientId
}) {
  const {
    isStackedOnMobile,
    verticalAlignment,
    templateLock
  } = attributes;
  const {
    count,
    canInsertColumnBlock,
    minCount
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canInsertBlockType,
      canRemoveBlock,
      getBlocks,
      getBlockCount
    } = select(external_wp_blockEditor_namespaceObject.store);
    const innerBlocks = getBlocks(clientId); // Get the indexes of columns for which removal is prevented.
    // The highest index will be used to determine the minimum column count.

    const preventRemovalBlockIndexes = innerBlocks.reduce((acc, block, index) => {
      if (!canRemoveBlock(block.clientId)) {
        acc.push(index);
      }

      return acc;
    }, []);
    return {
      count: getBlockCount(clientId),
      canInsertColumnBlock: canInsertBlockType('core/column', clientId),
      minCount: Math.max(...preventRemovalBlockIndexes) + 1
    };
  }, [clientId]);
  const classes = classnames_default()({
    [`are-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
    [`is-not-stacked-on-mobile`]: !isStackedOnMobile
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classes
  });
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    allowedBlocks: edit_ALLOWED_BLOCKS,
    orientation: 'horizontal',
    renderAppender: false,
    templateLock
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockVerticalAlignmentToolbar, {
    onChange: updateAlignment,
    value: verticalAlignment
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, null, canInsertColumnBlock && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
    value: count,
    onChange: value => updateColumns(count, Math.max(minCount, value)),
    min: Math.max(1, minCount),
    max: Math.max(6, count)
  }), count > 6 && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Notice, {
    status: "warning",
    isDismissible: false
  }, (0,external_wp_i18n_namespaceObject.__)('This column count exceeds the recommended amount and may cause visual breakage.'))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Stack on mobile'),
    checked: isStackedOnMobile,
    onChange: () => setAttributes({
      isStackedOnMobile: !isStackedOnMobile
    })
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  }));
}

const ColumnsEditContainerWrapper = (0,external_wp_data_namespaceObject.withDispatch)((dispatch, ownProps, registry) => ({
  /**
   * Update all child Column blocks with a new vertical alignment setting
   * based on whatever alignment is passed in. This allows change to parent
   * to overide anything set on a individual column basis.
   *
   * @param {string} verticalAlignment the vertical alignment setting
   */
  updateAlignment(verticalAlignment) {
    const {
      clientId,
      setAttributes
    } = ownProps;
    const {
      updateBlockAttributes
    } = dispatch(external_wp_blockEditor_namespaceObject.store);
    const {
      getBlockOrder
    } = registry.select(external_wp_blockEditor_namespaceObject.store); // Update own alignment.

    setAttributes({
      verticalAlignment
    }); // Update all child Column Blocks to match.

    const innerBlockClientIds = getBlockOrder(clientId);
    innerBlockClientIds.forEach(innerBlockClientId => {
      updateBlockAttributes(innerBlockClientId, {
        verticalAlignment
      });
    });
  },

  /**
   * Updates the column count, including necessary revisions to child Column
   * blocks to grant required or redistribute available space.
   *
   * @param {number} previousColumns Previous column count.
   * @param {number} newColumns      New column count.
   */
  updateColumns(previousColumns, newColumns) {
    const {
      clientId
    } = ownProps;
    const {
      replaceInnerBlocks
    } = dispatch(external_wp_blockEditor_namespaceObject.store);
    const {
      getBlocks
    } = registry.select(external_wp_blockEditor_namespaceObject.store);
    let innerBlocks = getBlocks(clientId);
    const hasExplicitWidths = hasExplicitPercentColumnWidths(innerBlocks); // Redistribute available width for existing inner blocks.

    const isAddingColumn = newColumns > previousColumns;

    if (isAddingColumn && hasExplicitWidths) {
      // If adding a new column, assign width to the new column equal to
      // as if it were `1 / columns` of the total available space.
      const newColumnWidth = toWidthPrecision(100 / newColumns); // Redistribute in consideration of pending block insertion as
      // constraining the available working width.

      const widths = getRedistributedColumnWidths(innerBlocks, 100 - newColumnWidth);
      innerBlocks = [...getMappedColumnWidths(innerBlocks, widths), ...Array.from({
        length: newColumns - previousColumns
      }).map(() => {
        return (0,external_wp_blocks_namespaceObject.createBlock)('core/column', {
          width: `${newColumnWidth}%`
        });
      })];
    } else if (isAddingColumn) {
      innerBlocks = [...innerBlocks, ...Array.from({
        length: newColumns - previousColumns
      }).map(() => {
        return (0,external_wp_blocks_namespaceObject.createBlock)('core/column');
      })];
    } else if (newColumns < previousColumns) {
      // The removed column will be the last of the inner blocks.
      innerBlocks = innerBlocks.slice(0, -(previousColumns - newColumns));

      if (hasExplicitWidths) {
        // Redistribute as if block is already removed.
        const widths = getRedistributedColumnWidths(innerBlocks, 100);
        innerBlocks = getMappedColumnWidths(innerBlocks, widths);
      }
    }

    replaceInnerBlocks(clientId, innerBlocks);
  }

}))(ColumnsEditContainer);

function Placeholder({
  clientId,
  name,
  setAttributes
}) {
  const {
    blockType,
    defaultVariation,
    variations
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockVariations,
      getBlockType,
      getDefaultBlockVariation
    } = select(external_wp_blocks_namespaceObject.store);
    return {
      blockType: getBlockType(name),
      defaultVariation: getDefaultBlockVariation(name, 'block'),
      variations: getBlockVariations(name, 'block')
    };
  }, [name]);
  const {
    replaceInnerBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalBlockVariationPicker, {
    icon: blockType?.icon?.src,
    label: blockType?.title,
    variations: variations,
    onSelect: (nextVariation = defaultVariation) => {
      if (nextVariation.attributes) {
        setAttributes(nextVariation.attributes);
      }

      if (nextVariation.innerBlocks) {
        replaceInnerBlocks(clientId, (0,external_wp_blocks_namespaceObject.createBlocksFromInnerBlocksTemplate)(nextVariation.innerBlocks), true);
      }
    },
    allowSkip: true
  }));
}

const ColumnsEdit = props => {
  const {
    clientId
  } = props;
  const hasInnerBlocks = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getBlocks(clientId).length > 0, [clientId]);
  const Component = hasInnerBlocks ? ColumnsEditContainerWrapper : Placeholder;
  return (0,external_wp_element_namespaceObject.createElement)(Component, { ...props
  });
};

/* harmony default export */ var columns_edit = (ColumnsEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function columns_save_save({
  attributes
}) {
  const {
    isStackedOnMobile,
    verticalAlignment
  } = attributes;
  const className = classnames_default()({
    [`are-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
    [`is-not-stacked-on-mobile`]: !isStackedOnMobile
  });
  const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save({
    className
  });
  const innerBlocksProps = external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(blockProps);
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/variations.js


/**
 * WordPress dependencies
 */


/** @typedef {import('@wordpress/blocks').WPBlockVariation} WPBlockVariation */

/**
 * Template option choices for predefined columns layouts.
 *
 * @type {WPBlockVariation[]}
 */

const variations = [{
  name: 'one-column-full',
  title: (0,external_wp_i18n_namespaceObject.__)('100'),
  description: (0,external_wp_i18n_namespaceObject.__)('One column'),
  icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "m39.0625 14h-30.0625v20.0938h30.0625zm-30.0625-2c-1.10457 0-2 .8954-2 2v20.0938c0 1.1045.89543 2 2 2h30.0625c1.1046 0 2-.8955 2-2v-20.0938c0-1.1046-.8954-2-2-2z"
  })),
  innerBlocks: [['core/column']],
  scope: ['block']
}, {
  name: 'two-columns-equal',
  title: (0,external_wp_i18n_namespaceObject.__)('50 / 50'),
  description: (0,external_wp_i18n_namespaceObject.__)('Two columns; equal split'),
  icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M39 12C40.1046 12 41 12.8954 41 14V34C41 35.1046 40.1046 36 39 36H9C7.89543 36 7 35.1046 7 34V14C7 12.8954 7.89543 12 9 12H39ZM39 34V14H25V34H39ZM23 34H9V14H23V34Z"
  })),
  isDefault: true,
  innerBlocks: [['core/column'], ['core/column']],
  scope: ['block']
}, {
  name: 'two-columns-one-third-two-thirds',
  title: (0,external_wp_i18n_namespaceObject.__)('33 / 66'),
  description: (0,external_wp_i18n_namespaceObject.__)('Two columns; one-third, two-thirds split'),
  icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M39 12C40.1046 12 41 12.8954 41 14V34C41 35.1046 40.1046 36 39 36H9C7.89543 36 7 35.1046 7 34V14C7 12.8954 7.89543 12 9 12H39ZM39 34V14H20V34H39ZM18 34H9V14H18V34Z"
  })),
  innerBlocks: [['core/column', {
    width: '33.33%'
  }], ['core/column', {
    width: '66.66%'
  }]],
  scope: ['block']
}, {
  name: 'two-columns-two-thirds-one-third',
  title: (0,external_wp_i18n_namespaceObject.__)('66 / 33'),
  description: (0,external_wp_i18n_namespaceObject.__)('Two columns; two-thirds, one-third split'),
  icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M39 12C40.1046 12 41 12.8954 41 14V34C41 35.1046 40.1046 36 39 36H9C7.89543 36 7 35.1046 7 34V14C7 12.8954 7.89543 12 9 12H39ZM39 34V14H30V34H39ZM28 34H9V14H28V34Z"
  })),
  innerBlocks: [['core/column', {
    width: '66.66%'
  }], ['core/column', {
    width: '33.33%'
  }]],
  scope: ['block']
}, {
  name: 'three-columns-equal',
  title: (0,external_wp_i18n_namespaceObject.__)('33 / 33 / 33'),
  description: (0,external_wp_i18n_namespaceObject.__)('Three columns; equal split'),
  icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    d: "M41 14a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h30a2 2 0 0 0 2-2V14zM28.5 34h-9V14h9v20zm2 0V14H39v20h-8.5zm-13 0H9V14h8.5v20z"
  })),
  innerBlocks: [['core/column'], ['core/column'], ['core/column']],
  scope: ['block']
}, {
  name: 'three-columns-wider-center',
  title: (0,external_wp_i18n_namespaceObject.__)('25 / 50 / 25'),
  description: (0,external_wp_i18n_namespaceObject.__)('Three columns; wide center column'),
  icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    d: "M41 14a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h30a2 2 0 0 0 2-2V14zM31 34H17V14h14v20zm2 0V14h6v20h-6zm-18 0H9V14h6v20z"
  })),
  innerBlocks: [['core/column', {
    width: '25%'
  }], ['core/column', {
    width: '50%'
  }], ['core/column', {
    width: '25%'
  }]],
  scope: ['block']
}];
/* harmony default export */ var columns_variations = (variations);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/transforms.js
/**
 * WordPress dependencies
 */

const MAXIMUM_SELECTED_BLOCKS = 6;
const columns_transforms_transforms = {
  from: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['*'],
    __experimentalConvert: blocks => {
      const columnWidth = +(100 / blocks.length).toFixed(2);
      const innerBlocksTemplate = blocks.map(({
        name,
        attributes,
        innerBlocks
      }) => ['core/column', {
        width: `${columnWidth}%`
      }, [[name, { ...attributes
      }, innerBlocks]]]);
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/columns', {}, (0,external_wp_blocks_namespaceObject.createBlocksFromInnerBlocksTemplate)(innerBlocksTemplate));
    },
    isMatch: ({
      length: selectedBlocksLength
    }, blocks) => {
      // If a user is trying to transform a single Columns block, skip
      // the transformation. Enabling this functiontionality creates
      // nested Columns blocks resulting in an unintuitive user experience.
      // Multiple Columns blocks can still be transformed.
      if (blocks.length === 1 && blocks[0].name === 'core/columns') {
        return false;
      }

      return selectedBlocksLength && selectedBlocksLength <= MAXIMUM_SELECTED_BLOCKS;
    }
  }, {
    type: 'block',
    blocks: ['core/media-text'],
    priority: 1,
    transform: (attributes, innerBlocks) => {
      const {
        align,
        backgroundColor,
        textColor,
        style,
        mediaAlt: alt,
        mediaId: id,
        mediaPosition,
        mediaSizeSlug: sizeSlug,
        mediaType,
        mediaUrl: url,
        mediaWidth,
        verticalAlignment
      } = attributes;
      let media;

      if (mediaType === 'image' || !mediaType) {
        const imageAttrs = {
          id,
          alt,
          url,
          sizeSlug
        };
        const linkAttrs = {
          href: attributes.href,
          linkClass: attributes.linkClass,
          linkDestination: attributes.linkDestination,
          linkTarget: attributes.linkTarget,
          rel: attributes.rel
        };
        media = ['core/image', { ...imageAttrs,
          ...linkAttrs
        }];
      } else {
        media = ['core/video', {
          id,
          src: url
        }];
      }

      const innerBlocksTemplate = [['core/column', {
        width: `${mediaWidth}%`
      }, [media]], ['core/column', {
        width: `${100 - mediaWidth}%`
      }, innerBlocks]];

      if (mediaPosition === 'right') {
        innerBlocksTemplate.reverse();
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/columns', {
        align,
        backgroundColor,
        textColor,
        style,
        verticalAlignment
      }, (0,external_wp_blocks_namespaceObject.createBlocksFromInnerBlocksTemplate)(innerBlocksTemplate));
    }
  }],
  ungroup: (attributes, innerBlocks) => innerBlocks.flatMap(innerBlock => innerBlock.innerBlocks)
};
/* harmony default export */ var columns_transforms = (columns_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/columns/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const columns_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/columns",
  title: "Columns",
  category: "design",
  description: "Display content in multiple columns, with blocks added to each column.",
  textdomain: "default",
  attributes: {
    verticalAlignment: {
      type: "string"
    },
    isStackedOnMobile: {
      type: "boolean",
      "default": true
    },
    templateLock: {
      type: ["string", "boolean"],
      "enum": ["all", "insert", "contentOnly", false]
    }
  },
  supports: {
    anchor: true,
    align: ["wide", "full"],
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      blockGap: {
        __experimentalDefault: "2em",
        sides: ["horizontal", "vertical"]
      },
      margin: ["top", "bottom"],
      padding: true,
      __experimentalDefaultControls: {
        padding: true,
        blockGap: true
      }
    },
    layout: {
      allowSwitching: false,
      allowInheriting: false,
      allowEditing: false,
      "default": {
        type: "flex",
        flexWrap: "nowrap"
      }
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      style: true,
      width: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        style: true,
        width: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-columns-editor",
  style: "wp-block-columns"
};



const {
  name: columns_name
} = columns_metadata;

const columns_settings = {
  icon: library_columns,
  variations: columns_variations,
  example: {
    viewportWidth: 600,
    // Columns collapse "@media (max-width: 599px)".
    innerBlocks: [{
      name: 'core/column',
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          /* translators: example text. */
          content: (0,external_wp_i18n_namespaceObject.__)('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent et eros eu felis.')
        }
      }, {
        name: 'core/image',
        attributes: {
          url: 'https://s.w.org/images/core/5.3/Windbuchencom.jpg'
        }
      }, {
        name: 'core/paragraph',
        attributes: {
          /* translators: example text. */
          content: (0,external_wp_i18n_namespaceObject.__)('Suspendisse commodo neque lacus, a dictum orci interdum et.')
        }
      }]
    }, {
      name: 'core/column',
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          /* translators: example text. */
          content: (0,external_wp_i18n_namespaceObject.__)('Etiam et egestas lorem. Vivamus sagittis sit amet dolor quis lobortis. Integer sed fermentum arcu, id vulputate lacus. Etiam fermentum sem eu quam hendrerit.')
        }
      }, {
        name: 'core/paragraph',
        attributes: {
          /* translators: example text. */
          content: (0,external_wp_i18n_namespaceObject.__)('Nam risus massa, ullamcorper consectetur eros fermentum, porta aliquet ligula. Sed vel mauris nec enim.')
        }
      }]
    }]
  },
  deprecated: columns_deprecated,
  edit: columns_edit,
  save: columns_save_save,
  transforms: columns_transforms
};
const columns_init = () => initBlock({
  name: columns_name,
  metadata: columns_metadata,
  settings: columns_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/post-comments.js


/**
 * WordPress dependencies
 */

const postComments = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14 10.1V4c0-.6-.4-1-1-1H5c-.6 0-1 .4-1 1v8.3c0 .3.2.7.6.8.1.1.2.1.3.1.2 0 .5-.1.6-.3l1.8-1.8H13c.6 0 1-.4 1-1zm-1.5-.5H6.7l-1.2 1.2V4.5h7v5.1zM19 12h-8c-.6 0-1 .4-1 1v6.1c0 .6.4 1 1 1h5.7l1.8 1.8c.1.2.4.3.6.3.1 0 .2 0 .3-.1.4-.1.6-.5.6-.8V13c0-.6-.4-1-1-1zm-.5 7.8l-1.2-1.2h-5.8v-5.1h7v6.3z"
}));
/* harmony default export */ var post_comments = (postComments);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/deprecated.js


/**
 * WordPress dependencies
 */
 // v1: Deprecate the initial version of the block which was called "Comments
// Query Loop" instead of "Comments".

const v1 = {
  attributes: {
    tagName: {
      type: 'string',
      default: 'div'
    }
  },
  apiVersion: 3,
  supports: {
    align: ['wide', 'full'],
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    }
  },

  save({
    attributes: {
      tagName: Tag
    }
  }) {
    const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save();
    const {
      className
    } = blockProps;
    const classes = className?.split(' ') || []; // The ID of the previous version of the block
    // didn't have the `wp-block-comments` class,
    // so we need to remove it here in order to mimic it.

    const newClasses = classes?.filter(cls => cls !== 'wp-block-comments');
    const newBlockProps = { ...blockProps,
      className: newClasses.join(' ')
    };
    return (0,external_wp_element_namespaceObject.createElement)(Tag, { ...newBlockProps
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

};
/* harmony default export */ var comments_deprecated = ([v1]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/edit/comments-inspector-controls.js


/**
 * WordPress dependencies
 */



function CommentsInspectorControls({
  attributes: {
    tagName
  },
  setAttributes
}) {
  const htmlElementMessages = {
    section: (0,external_wp_i18n_namespaceObject.__)("The <section> element should represent a standalone portion of the document that can't be better represented by another element."),
    aside: (0,external_wp_i18n_namespaceObject.__)("The <aside> element should represent a portion of a document whose content is only indirectly related to the document's main content.")
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "advanced"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('HTML element'),
    options: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Default (<div>)'),
      value: 'div'
    }, {
      label: '<section>',
      value: 'section'
    }, {
      label: '<aside>',
      value: 'aside'
    }],
    value: tagName,
    onChange: value => setAttributes({
      tagName: value
    }),
    help: htmlElementMessages[tagName]
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/post-comments-form/form.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */








const CommentsFormPlaceholder = () => {
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(CommentsFormPlaceholder);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "comment-respond"
  }, (0,external_wp_element_namespaceObject.createElement)("h3", {
    className: "comment-reply-title"
  }, (0,external_wp_i18n_namespaceObject.__)('Leave a Reply')), (0,external_wp_element_namespaceObject.createElement)("form", {
    noValidate: true,
    className: "comment-form",
    inert: "true"
  }, (0,external_wp_element_namespaceObject.createElement)("p", null, (0,external_wp_element_namespaceObject.createElement)("label", {
    htmlFor: `comment-${instanceId}`
  }, (0,external_wp_i18n_namespaceObject.__)('Comment')), (0,external_wp_element_namespaceObject.createElement)("textarea", {
    id: `comment-${instanceId}`,
    name: "comment",
    cols: "45",
    rows: "8"
  })), (0,external_wp_element_namespaceObject.createElement)("p", {
    className: "form-submit wp-block-button"
  }, (0,external_wp_element_namespaceObject.createElement)("input", {
    name: "submit",
    type: "submit",
    className: classnames_default()('wp-block-button__link', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('button')),
    label: (0,external_wp_i18n_namespaceObject.__)('Post Comment'),
    value: (0,external_wp_i18n_namespaceObject.__)('Post Comment')
  }))));
};

const CommentsForm = ({
  postId,
  postType
}) => {
  const [commentStatus, setCommentStatus] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', postType, 'comment_status', postId);
  const isSiteEditor = postType === undefined || postId === undefined;
  const {
    defaultCommentStatus
  } = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getSettings().__experimentalDiscussionSettings);
  const postTypeSupportsComments = (0,external_wp_data_namespaceObject.useSelect)(select => postType ? !!select(external_wp_coreData_namespaceObject.store).getPostType(postType)?.supports.comments : false);

  if (!isSiteEditor && 'open' !== commentStatus) {
    if ('closed' === commentStatus) {
      const actions = [(0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        key: "enableComments",
        onClick: () => setCommentStatus('open'),
        variant: "primary"
      }, (0,external_wp_i18n_namespaceObject._x)('Enable comments', 'action that affects the current post'))];
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.Warning, {
        actions: actions
      }, (0,external_wp_i18n_namespaceObject.__)('Post Comments Form block: Comments are not enabled for this item.'));
    } else if (!postTypeSupportsComments) {
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.Warning, null, (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: 1: Post type (i.e. "post", "page") */
      (0,external_wp_i18n_namespaceObject.__)('Post Comments Form block: Comments are not enabled for this post type (%s).'), postType));
    } else if ('open' !== defaultCommentStatus) {
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.Warning, null, (0,external_wp_i18n_namespaceObject.__)('Post Comments Form block: Comments are not enabled.'));
    }
  }

  return (0,external_wp_element_namespaceObject.createElement)(CommentsFormPlaceholder, null);
};

/* harmony default export */ var post_comments_form_form = (CommentsForm);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/edit/placeholder.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function PostCommentsPlaceholder({
  postType,
  postId
}) {
  let [postTitle] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', postType, 'title', postId);
  postTitle = postTitle || (0,external_wp_i18n_namespaceObject.__)('Post Title');
  const {
    avatarURL
  } = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getSettings().__experimentalDiscussionSettings);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-comments__legacy-placeholder",
    inert: "true"
  }, (0,external_wp_element_namespaceObject.createElement)("h3", null,
  /* translators: %s: Post title. */
  (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('One response to %s'), postTitle)), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "navigation"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "alignleft"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#top"
  }, "\xAB ", (0,external_wp_i18n_namespaceObject.__)('Older Comments'))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "alignright"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#top"
  }, (0,external_wp_i18n_namespaceObject.__)('Newer Comments'), " \xBB"))), (0,external_wp_element_namespaceObject.createElement)("ol", {
    className: "commentlist"
  }, (0,external_wp_element_namespaceObject.createElement)("li", {
    className: "comment even thread-even depth-1"
  }, (0,external_wp_element_namespaceObject.createElement)("article", {
    className: "comment-body"
  }, (0,external_wp_element_namespaceObject.createElement)("footer", {
    className: "comment-meta"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "comment-author vcard"
  }, (0,external_wp_element_namespaceObject.createElement)("img", {
    alt: (0,external_wp_i18n_namespaceObject.__)('Commenter Avatar'),
    src: avatarURL,
    className: "avatar avatar-32 photo",
    height: "32",
    width: "32",
    loading: "lazy"
  }), (0,external_wp_element_namespaceObject.createElement)("b", {
    className: "fn"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#top",
    className: "url"
  }, (0,external_wp_i18n_namespaceObject.__)('A WordPress Commenter'))), ' ', (0,external_wp_element_namespaceObject.createElement)("span", {
    className: "says"
  }, (0,external_wp_i18n_namespaceObject.__)('says'), ":")), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "comment-metadata"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#top"
  }, (0,external_wp_element_namespaceObject.createElement)("time", {
    dateTime: "2000-01-01T00:00:00+00:00"
  }, (0,external_wp_i18n_namespaceObject.__)('January 1, 2000 at 00:00 am'))), ' ', (0,external_wp_element_namespaceObject.createElement)("span", {
    className: "edit-link"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    className: "comment-edit-link",
    href: "#top"
  }, (0,external_wp_i18n_namespaceObject.__)('Edit'))))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "comment-content"
  }, (0,external_wp_element_namespaceObject.createElement)("p", null, (0,external_wp_i18n_namespaceObject.__)('Hi, this is a comment.'), (0,external_wp_element_namespaceObject.createElement)("br", null), (0,external_wp_i18n_namespaceObject.__)('To get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.'), (0,external_wp_element_namespaceObject.createElement)("br", null), (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.__)('Commenter avatars come from <a>Gravatar</a>.'), {
    a: // eslint-disable-next-line jsx-a11y/anchor-has-content
    (0,external_wp_element_namespaceObject.createElement)("a", {
      href: "https://gravatar.com/"
    })
  }))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "reply"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    className: "comment-reply-link",
    href: "#top",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Reply to A WordPress Commenter')
  }, (0,external_wp_i18n_namespaceObject.__)('Reply')))))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "navigation"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "alignleft"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#top"
  }, "\xAB ", (0,external_wp_i18n_namespaceObject.__)('Older Comments'))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "alignright"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#top"
  }, (0,external_wp_i18n_namespaceObject.__)('Newer Comments'), " \xBB"))), (0,external_wp_element_namespaceObject.createElement)(post_comments_form_form, {
    postId: postId,
    postType: postType
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/edit/comments-legacy.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function CommentsLegacy({
  attributes,
  setAttributes,
  context: {
    postType,
    postId
  }
}) {
  const {
    textAlign
  } = attributes;
  const actions = [(0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    key: "convert",
    onClick: () => void setAttributes({
      legacy: false
    }),
    variant: "primary"
  }, (0,external_wp_i18n_namespaceObject.__)('Switch to editable mode'))];
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    })
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: nextAlign => {
      setAttributes({
        textAlign: nextAlign
      });
    }
  })), (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.Warning, {
    actions: actions
  }, (0,external_wp_i18n_namespaceObject.__)('Comments block: You’re currently using the legacy version of the block. ' + 'The following is just a placeholder - the final styling will likely look different. ' + 'For a better representation and more customization options, ' + 'switch the block to its editable mode.')), (0,external_wp_element_namespaceObject.createElement)(PostCommentsPlaceholder, {
    postId: postId,
    postType: postType
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/edit/template.js
const TEMPLATE = [['core/comments-title'], ['core/comment-template', {}, [['core/columns', {}, [['core/column', {
  width: '40px'
}, [['core/avatar', {
  size: 40,
  style: {
    border: {
      radius: '20px'
    }
  }
}]]], ['core/column', {}, [['core/comment-author-name', {
  fontSize: 'small'
}], ['core/group', {
  layout: {
    type: 'flex'
  },
  style: {
    spacing: {
      margin: {
        top: '0px',
        bottom: '0px'
      }
    }
  }
}, [['core/comment-date', {
  fontSize: 'small'
}], ['core/comment-edit-link', {
  fontSize: 'small'
}]]], ['core/comment-content'], ['core/comment-reply-link', {
  fontSize: 'small'
}]]]]]]], ['core/comments-pagination'], ['core/post-comments-form']];
/* harmony default export */ var template = (TEMPLATE);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/edit/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




function CommentsEdit(props) {
  const {
    attributes,
    setAttributes
  } = props;
  const {
    tagName: TagName,
    legacy
  } = attributes;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    template: template
  });

  if (legacy) {
    return (0,external_wp_element_namespaceObject.createElement)(CommentsLegacy, { ...props
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(CommentsInspectorControls, {
    attributes: attributes,
    setAttributes: setAttributes
  }), (0,external_wp_element_namespaceObject.createElement)(TagName, { ...innerBlocksProps
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/save.js


/**
 * WordPress dependencies
 */

function comments_save_save({
  attributes: {
    tagName: Tag,
    legacy
  }
}) {
  const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save();
  const innerBlocksProps = external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(blockProps); // The legacy version is dynamic (i.e. PHP rendered) and doesn't allow inner
  // blocks, so nothing is saved in that case.

  return legacy ? null : (0,external_wp_element_namespaceObject.createElement)(Tag, { ...innerBlocksProps
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comments_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments",
  title: "Comments",
  category: "theme",
  description: "An advanced block that allows displaying post comments using different visual configurations.",
  textdomain: "default",
  attributes: {
    tagName: {
      type: "string",
      "default": "div"
    },
    legacy: {
      type: "boolean",
      "default": false
    }
  },
  supports: {
    align: ["wide", "full"],
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-comments-editor",
  usesContext: ["postId", "postType"]
};



const {
  name: comments_name
} = comments_metadata;

const comments_settings = {
  icon: post_comments,
  edit: CommentsEdit,
  save: comments_save_save,
  deprecated: comments_deprecated
};
const comments_init = () => initBlock({
  name: comments_name,
  metadata: comments_metadata,
  settings: comments_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-author-avatar/edit.js


/**
 * WordPress dependencies
 */





function edit_Edit({
  attributes,
  context: {
    commentId
  },
  setAttributes,
  isSelected
}) {
  const {
    height,
    width
  } = attributes;
  const [avatars] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'comment', 'author_avatar_urls', commentId);
  const [authorName] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'comment', 'author_name', commentId);
  const avatarUrls = avatars ? Object.values(avatars) : null;
  const sizes = avatars ? Object.keys(avatars) : null;
  const minSize = sizes ? sizes[0] : 24;
  const maxSize = sizes ? sizes[sizes.length - 1] : 96;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const spacingProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetSpacingClassesAndStyles)(attributes);
  const maxSizeBuffer = Math.floor(maxSize * 2.5);
  const {
    avatarURL
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      __experimentalDiscussionSettings
    } = getSettings();
    return __experimentalDiscussionSettings;
  });
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Avatar Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Image size'),
    onChange: newWidth => setAttributes({
      width: newWidth,
      height: newWidth
    }),
    min: minSize,
    max: maxSizeBuffer,
    initialPosition: width,
    value: width
  })));
  const resizableAvatar = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ResizableBox, {
    size: {
      width,
      height
    },
    showHandle: isSelected,
    onResizeStop: (event, direction, elt, delta) => {
      setAttributes({
        height: parseInt(height + delta.height, 10),
        width: parseInt(width + delta.width, 10)
      });
    },
    lockAspectRatio: true,
    enable: {
      top: false,
      right: !(0,external_wp_i18n_namespaceObject.isRTL)(),
      bottom: true,
      left: (0,external_wp_i18n_namespaceObject.isRTL)()
    },
    minWidth: minSize,
    maxWidth: maxSizeBuffer
  }, (0,external_wp_element_namespaceObject.createElement)("img", {
    src: avatarUrls ? avatarUrls[avatarUrls.length - 1] : avatarURL,
    alt: `${authorName} ${(0,external_wp_i18n_namespaceObject.__)('Avatar')}`,
    ...blockProps
  }));
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, inspectorControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...spacingProps
  }, resizableAvatar));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-author-avatar/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_author_avatar_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  __experimental: "fse",
  name: "core/comment-author-avatar",
  title: "Comment Author Avatar (deprecated)",
  category: "theme",
  ancestor: ["core/comment-template"],
  description: "This block is deprecated. Please use the Avatar block instead.",
  textdomain: "default",
  attributes: {
    width: {
      type: "number",
      "default": 96
    },
    height: {
      type: "number",
      "default": 96
    }
  },
  usesContext: ["commentId"],
  supports: {
    html: false,
    inserter: false,
    __experimentalBorder: {
      radius: true,
      width: true,
      color: true,
      style: true
    },
    color: {
      background: true,
      text: false,
      __experimentalDefaultControls: {
        background: true
      }
    },
    spacing: {
      __experimentalSkipSerialization: true,
      margin: true,
      padding: true
    }
  }
};

const {
  name: comment_author_avatar_name
} = comment_author_avatar_metadata;

const comment_author_avatar_settings = {
  icon: comment_author_avatar,
  edit: edit_Edit
};
const comment_author_avatar_init = () => initBlock({
  name: comment_author_avatar_name,
  metadata: comment_author_avatar_metadata,
  settings: comment_author_avatar_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/comment-author-name.js


/**
 * WordPress dependencies
 */

const commentAuthorName = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 4H6c-1.1 0-2 .9-2 2v12.9c0 .6.5 1.1 1.1 1.1.3 0 .5-.1.8-.3L8.5 17H18c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm.5 11c0 .3-.2.5-.5.5H7.9l-2.4 2.4V6c0-.3.2-.5.5-.5h12c.3 0 .5.2.5.5v9z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M15 15V15C15 13.8954 14.1046 13 13 13L11 13C9.89543 13 9 13.8954 9 15V15",
  fillRule: "evenodd",
  clipRule: "evenodd"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Circle, {
  cx: "12",
  cy: "9",
  r: "2",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ var comment_author_name = (commentAuthorName);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-author-name/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Renders the `core/comment-author-name` block on the editor.
 *
 * @param {Object} props                       React props.
 * @param {Object} props.setAttributes         Callback for updating block attributes.
 * @param {Object} props.attributes            Block attributes.
 * @param {string} props.attributes.isLink     Whether the author name should be linked.
 * @param {string} props.attributes.linkTarget Target of the link.
 * @param {string} props.attributes.textAlign  Text alignment.
 * @param {Object} props.context               Inherited context.
 * @param {string} props.context.commentId     The comment ID.
 *
 * @return {JSX.Element} React element.
 */

function comment_author_name_edit_Edit({
  attributes: {
    isLink,
    linkTarget,
    textAlign
  },
  context: {
    commentId
  },
  setAttributes
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    })
  });
  let displayName = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const comment = getEntityRecord('root', 'comment', commentId);
    const authorName = comment?.author_name; // eslint-disable-line camelcase

    if (comment && !authorName) {
      var _user$name;

      const user = getEntityRecord('root', 'user', comment.author);
      return (_user$name = user?.name) !== null && _user$name !== void 0 ? _user$name : (0,external_wp_i18n_namespaceObject.__)('Anonymous');
    }

    return authorName !== null && authorName !== void 0 ? authorName : '';
  }, [commentId]);
  const blockControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: newAlign => setAttributes({
      textAlign: newAlign
    })
  }));
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Link to authors URL'),
    onChange: () => setAttributes({
      isLink: !isLink
    }),
    checked: isLink
  }), isLink && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Open in new tab'),
    onChange: value => setAttributes({
      linkTarget: value ? '_blank' : '_self'
    }),
    checked: linkTarget === '_blank'
  })));

  if (!commentId || !displayName) {
    displayName = (0,external_wp_i18n_namespaceObject._x)('Comment Author', 'block title');
  }

  const displayAuthor = isLink ? (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#comment-author-pseudo-link",
    onClick: event => event.preventDefault()
  }, displayName) : displayName;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, inspectorControls, blockControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, displayAuthor));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-author-name/deprecated.js
/**
 * Internal dependencies
 */

const deprecated_v1 = {
  attributes: {
    isLink: {
      type: 'boolean',
      default: false
    },
    linkTarget: {
      type: 'string',
      default: '_self'
    }
  },
  supports: {
    html: false,
    color: {
      gradients: true,
      link: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalLetterSpacing: true
    }
  },

  save() {
    return null;
  },

  migrate: migrate_font_family,

  isEligible({
    style
  }) {
    return style?.typography?.fontFamily;
  }

};
/**
 * New deprecations need to be placed first
 * for them to have higher priority.
 *
 * Old deprecations may need to be updated as well.
 *
 * See block-deprecation.md
 */

/* harmony default export */ var comment_author_name_deprecated = ([deprecated_v1]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-author-name/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_author_name_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comment-author-name",
  title: "Comment Author Name",
  category: "theme",
  ancestor: ["core/comment-template"],
  description: "Displays the name of the author of the comment.",
  textdomain: "default",
  attributes: {
    isLink: {
      type: "boolean",
      "default": true
    },
    linkTarget: {
      type: "string",
      "default": "_self"
    },
    textAlign: {
      type: "string"
    }
  },
  usesContext: ["commentId"],
  supports: {
    html: false,
    spacing: {
      margin: true,
      padding: true
    },
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};


const {
  name: comment_author_name_name
} = comment_author_name_metadata;

const comment_author_name_settings = {
  icon: comment_author_name,
  edit: comment_author_name_edit_Edit,
  deprecated: comment_author_name_deprecated
};
const comment_author_name_init = () => initBlock({
  name: comment_author_name_name,
  metadata: comment_author_name_metadata,
  settings: comment_author_name_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/comment-content.js


/**
 * WordPress dependencies
 */

const commentContent = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M6.68822 16.625L5.5 17.8145L5.5 5.5L18.5 5.5L18.5 16.625L6.68822 16.625ZM7.31 18.125L19 18.125C19.5523 18.125 20 17.6773 20 17.125L20 5C20 4.44772 19.5523 4 19 4H5C4.44772 4 4 4.44772 4 5V19.5247C4 19.8173 4.16123 20.086 4.41935 20.2237C4.72711 20.3878 5.10601 20.3313 5.35252 20.0845L7.31 18.125ZM16 9.99997H8V8.49997H16V9.99997ZM8 14H13V12.5H8V14Z"
}));
/* harmony default export */ var comment_content = (commentContent);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-content/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Renders the `core/comment-content` block on the editor.
 *
 * @param {Object} props                      React props.
 * @param {Object} props.setAttributes        Callback for updating block attributes.
 * @param {Object} props.attributes           Block attributes.
 * @param {string} props.attributes.textAlign The `textAlign` attribute.
 * @param {Object} props.context              Inherited context.
 * @param {string} props.context.commentId    The comment ID.
 *
 * @return {JSX.Element} React element.
 */

function comment_content_edit_Edit({
  setAttributes,
  attributes: {
    textAlign
  },
  context: {
    commentId
  }
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    })
  });
  const [content] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'comment', 'content', commentId);
  const blockControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: newAlign => setAttributes({
      textAlign: newAlign
    })
  }));

  if (!commentId || !content) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)("p", null, (0,external_wp_i18n_namespaceObject._x)('Comment Content', 'block title'))));
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, {
    key: "html"
  }, content.rendered))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-content/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_content_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comment-content",
  title: "Comment Content",
  category: "theme",
  ancestor: ["core/comment-template"],
  description: "Displays the contents of a comment.",
  textdomain: "default",
  usesContext: ["commentId"],
  attributes: {
    textAlign: {
      type: "string"
    }
  },
  supports: {
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    spacing: {
      padding: ["horizontal", "vertical"],
      __experimentalDefaultControls: {
        padding: true
      }
    },
    html: false
  }
};

const {
  name: comment_content_name
} = comment_content_metadata;

const comment_content_settings = {
  icon: comment_content,
  edit: comment_content_edit_Edit
};
const comment_content_init = () => initBlock({
  name: comment_content_name,
  metadata: comment_content_metadata,
  settings: comment_content_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/post-date.js


/**
 * WordPress dependencies
 */

const postDate = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M11.696 13.972c.356-.546.599-.958.728-1.235a1.79 1.79 0 00.203-.783c0-.264-.077-.47-.23-.618-.148-.153-.354-.23-.618-.23-.295 0-.569.07-.82.212a3.413 3.413 0 00-.738.571l-.147-1.188c.289-.234.59-.41.903-.526.313-.117.66-.175 1.041-.175.375 0 .695.08.959.24.264.153.46.362.59.626.135.265.203.556.203.876 0 .362-.08.734-.24 1.115-.154.381-.427.87-.82 1.466l-.756 1.152H14v1.106h-4l1.696-2.609z"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19.5 7h-15v12a.5.5 0 00.5.5h14a.5.5 0 00.5-.5V7zM3 7V5a2 2 0 012-2h14a2 2 0 012 2v14a2 2 0 01-2 2H5a2 2 0 01-2-2V7z"
}));
/* harmony default export */ var post_date = (postDate);

;// CONCATENATED MODULE: external ["wp","date"]
var external_wp_date_namespaceObject = window["wp"]["date"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-date/edit.js


/**
 * WordPress dependencies
 */





/**
 * Renders the `core/comment-date` block on the editor.
 *
 * @param {Object} props                   React props.
 * @param {Object} props.setAttributes     Callback for updating block attributes.
 * @param {Object} props.attributes        Block attributes.
 * @param {string} props.attributes.format Format of the date.
 * @param {string} props.attributes.isLink Whether the author name should be linked.
 * @param {Object} props.context           Inherited context.
 * @param {string} props.context.commentId The comment ID.
 *
 * @return {JSX.Element} React element.
 */

function comment_date_edit_Edit({
  attributes: {
    format,
    isLink
  },
  context: {
    commentId
  },
  setAttributes
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  let [date] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'comment', 'date', commentId);
  const [siteFormat = (0,external_wp_date_namespaceObject.getSettings)().formats.date] = (0,external_wp_coreData_namespaceObject.useEntityProp)('root', 'site', 'date_format');
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalDateFormatPicker, {
    format: format,
    defaultFormat: siteFormat,
    onChange: nextFormat => setAttributes({
      format: nextFormat
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Link to comment'),
    onChange: () => setAttributes({
      isLink: !isLink
    }),
    checked: isLink
  })));

  if (!commentId || !date) {
    date = (0,external_wp_i18n_namespaceObject._x)('Comment Date', 'block title');
  }

  let commentDate = date instanceof Date ? (0,external_wp_element_namespaceObject.createElement)("time", {
    dateTime: (0,external_wp_date_namespaceObject.dateI18n)('c', date)
  }, (0,external_wp_date_namespaceObject.dateI18n)(format || siteFormat, date)) : (0,external_wp_element_namespaceObject.createElement)("time", null, date);

  if (isLink) {
    commentDate = (0,external_wp_element_namespaceObject.createElement)("a", {
      href: "#comment-date-pseudo-link",
      onClick: event => event.preventDefault()
    }, commentDate);
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, inspectorControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, commentDate));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-date/deprecated.js
/**
 * Internal dependencies
 */

const comment_date_deprecated_v1 = {
  attributes: {
    format: {
      type: 'string'
    },
    isLink: {
      type: 'boolean',
      default: false
    }
  },
  supports: {
    html: false,
    color: {
      gradients: true,
      link: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalLetterSpacing: true
    }
  },

  save() {
    return null;
  },

  migrate: migrate_font_family,

  isEligible({
    style
  }) {
    return style?.typography?.fontFamily;
  }

};
/**
 * New deprecations need to be placed first
 * for them to have higher priority.
 *
 * Old deprecations may need to be updated as well.
 *
 * See block-deprecation.md
 */

/* harmony default export */ var comment_date_deprecated = ([comment_date_deprecated_v1]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-date/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_date_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comment-date",
  title: "Comment Date",
  category: "theme",
  ancestor: ["core/comment-template"],
  description: "Displays the date on which the comment was posted.",
  textdomain: "default",
  attributes: {
    format: {
      type: "string"
    },
    isLink: {
      type: "boolean",
      "default": true
    }
  },
  usesContext: ["commentId"],
  supports: {
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};


const {
  name: comment_date_name
} = comment_date_metadata;

const comment_date_settings = {
  icon: post_date,
  edit: comment_date_edit_Edit,
  deprecated: comment_date_deprecated
};
const comment_date_init = () => initBlock({
  name: comment_date_name,
  metadata: comment_date_metadata,
  settings: comment_date_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/comment-edit-link.js


/**
 * WordPress dependencies
 */

const commentEditLink = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m6.249 11.065.44-.44h3.186l-1.5 1.5H7.31l-1.957 1.96A.792.792 0 0 1 4 13.524V5a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v1.5L12.5 8V5.5h-7v6.315l.749-.75ZM20 19.75H7v-1.5h13v1.5Zm0-12.653-8.967 9.064L8 17l.867-2.935L17.833 5 20 7.097Z"
}));
/* harmony default export */ var comment_edit_link = (commentEditLink);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-edit-link/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




function comment_edit_link_edit_Edit({
  attributes: {
    linkTarget,
    textAlign
  },
  setAttributes
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    })
  });
  const blockControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: newAlign => setAttributes({
      textAlign: newAlign
    })
  }));
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Open in new tab'),
    onChange: value => setAttributes({
      linkTarget: value ? '_blank' : '_self'
    }),
    checked: linkTarget === '_blank'
  })));
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, inspectorControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#edit-comment-pseudo-link",
    onClick: event => event.preventDefault()
  }, (0,external_wp_i18n_namespaceObject.__)('Edit'))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-edit-link/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_edit_link_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comment-edit-link",
  title: "Comment Edit Link",
  category: "theme",
  ancestor: ["core/comment-template"],
  description: "Displays a link to edit the comment in the WordPress Dashboard. This link is only visible to users with the edit comment capability.",
  textdomain: "default",
  usesContext: ["commentId"],
  attributes: {
    linkTarget: {
      type: "string",
      "default": "_self"
    },
    textAlign: {
      type: "string"
    }
  },
  supports: {
    html: false,
    color: {
      link: true,
      gradients: true,
      text: false,
      __experimentalDefaultControls: {
        background: true,
        link: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};

const {
  name: comment_edit_link_name
} = comment_edit_link_metadata;

const comment_edit_link_settings = {
  icon: comment_edit_link,
  edit: comment_edit_link_edit_Edit
};
const comment_edit_link_init = () => initBlock({
  name: comment_edit_link_name,
  metadata: comment_edit_link_metadata,
  settings: comment_edit_link_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/comment-reply-link.js


/**
 * WordPress dependencies
 */

const commentReplyLink = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M6.68822 10.625L6.24878 11.0649L5.5 11.8145L5.5 5.5L12.5 5.5V8L14 6.5V5C14 4.44772 13.5523 4 13 4H5C4.44772 4 4 4.44771 4 5V13.5247C4 13.8173 4.16123 14.086 4.41935 14.2237C4.72711 14.3878 5.10601 14.3313 5.35252 14.0845L7.31 12.125H8.375L9.875 10.625H7.31H6.68822ZM14.5605 10.4983L11.6701 13.75H16.9975C17.9963 13.75 18.7796 14.1104 19.3553 14.7048C19.9095 15.2771 20.2299 16.0224 20.4224 16.7443C20.7645 18.0276 20.7543 19.4618 20.7487 20.2544C20.7481 20.345 20.7475 20.4272 20.7475 20.4999L19.2475 20.5001C19.2475 20.4191 19.248 20.3319 19.2484 20.2394V20.2394C19.2526 19.4274 19.259 18.2035 18.973 17.1307C18.8156 16.5401 18.586 16.0666 18.2778 15.7483C17.9909 15.4521 17.5991 15.25 16.9975 15.25H11.8106L14.5303 17.9697L13.4696 19.0303L8.96956 14.5303L13.4394 9.50171L14.5605 10.4983Z"
}));
/* harmony default export */ var comment_reply_link = (commentReplyLink);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-reply-link/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Renders the `core/comment-reply-link` block on the editor.
 *
 * @param {Object} props                      React props.
 * @param {Object} props.setAttributes        Callback for updating block attributes.
 * @param {Object} props.attributes           Block attributes.
 * @param {string} props.attributes.textAlign The `textAlign` attribute.
 *
 * @return {JSX.Element} React element.
 */

function comment_reply_link_edit_Edit({
  setAttributes,
  attributes: {
    textAlign
  }
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    })
  });
  const blockControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: newAlign => setAttributes({
      textAlign: newAlign
    })
  }));
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#comment-reply-pseudo-link",
    onClick: event => event.preventDefault()
  }, (0,external_wp_i18n_namespaceObject.__)('Reply'))));
}

/* harmony default export */ var comment_reply_link_edit = (comment_reply_link_edit_Edit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-reply-link/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_reply_link_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comment-reply-link",
  title: "Comment Reply Link",
  category: "theme",
  ancestor: ["core/comment-template"],
  description: "Displays a link to reply to a comment.",
  textdomain: "default",
  usesContext: ["commentId"],
  attributes: {
    textAlign: {
      type: "string"
    }
  },
  supports: {
    color: {
      gradients: true,
      link: true,
      text: false,
      __experimentalDefaultControls: {
        background: true,
        link: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    html: false
  }
};

const {
  name: comment_reply_link_name
} = comment_reply_link_metadata;

const comment_reply_link_settings = {
  edit: comment_reply_link_edit,
  icon: comment_reply_link
};
const comment_reply_link_init = () => initBlock({
  name: comment_reply_link_name,
  metadata: comment_reply_link_metadata,
  settings: comment_reply_link_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/layout.js


/**
 * WordPress dependencies
 */

const layout = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 5.5H6a.5.5 0 00-.5.5v3h13V6a.5.5 0 00-.5-.5zm.5 5H10v8h8a.5.5 0 00.5-.5v-7.5zm-10 0h-3V18a.5.5 0 00.5.5h2.5v-8zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"
}));
/* harmony default export */ var library_layout = (layout);

;// CONCATENATED MODULE: external ["wp","apiFetch"]
var external_wp_apiFetch_namespaceObject = window["wp"]["apiFetch"];
var external_wp_apiFetch_default = /*#__PURE__*/__webpack_require__.n(external_wp_apiFetch_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-template/hooks.js
/**
 * WordPress dependencies
 */




 // This is limited by WP REST API

const MAX_COMMENTS_PER_PAGE = 100;
/**
 * Return an object with the query args needed to fetch the default page of
 * comments.
 *
 * @param {Object} props        Hook props.
 * @param {number} props.postId ID of the post that contains the comments.
 *                              discussion settings.
 *
 * @return {Object} Query args to retrieve the comments.
 */

const useCommentQueryArgs = ({
  postId
}) => {
  // Initialize the query args that are not going to change.
  const queryArgs = {
    status: 'approve',
    order: 'asc',
    context: 'embed',
    parent: 0,
    _embed: 'children'
  }; // Get the Discussion settings that may be needed to query the comments.

  const {
    pageComments,
    commentsPerPage,
    defaultCommentsPage: defaultPage
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      __experimentalDiscussionSettings
    } = getSettings();
    return __experimentalDiscussionSettings;
  }); // WP REST API doesn't allow fetching more than max items limit set per single page of data.
  // As for the editor performance is more important than completeness of data and fetching only the
  // max allowed for single page should be enough for the purpose of design and laying out the page.
  // Fetching over the limit would return an error here but would work with backend query.

  const perPage = pageComments ? Math.min(commentsPerPage, MAX_COMMENTS_PER_PAGE) : MAX_COMMENTS_PER_PAGE; // Get the number of the default page.

  const page = useDefaultPageIndex({
    defaultPage,
    postId,
    perPage,
    queryArgs
  }); // Merge, memoize and return all query arguments, unless the default page's
  // number is not known yet.

  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    return page ? { ...queryArgs,
      post: postId,
      per_page: perPage,
      page
    } : null;
  }, [postId, perPage, page]);
};
/**
 * Return the index of the default page, depending on whether `defaultPage` is
 * `newest` or `oldest`. In the first case, the only way to know the page's
 * index is by using the `X-WP-TotalPages` header, which forces to make an
 * additional request.
 *
 * @param {Object} props             Hook props.
 * @param {string} props.defaultPage Page shown by default (newest/oldest).
 * @param {number} props.postId      ID of the post that contains the comments.
 * @param {number} props.perPage     The number of comments included per page.
 * @param {Object} props.queryArgs   Other query args.
 *
 * @return {number} Index of the default comments page.
 */

const useDefaultPageIndex = ({
  defaultPage,
  postId,
  perPage,
  queryArgs
}) => {
  // Store the default page indices.
  const [defaultPages, setDefaultPages] = (0,external_wp_element_namespaceObject.useState)({});
  const key = `${postId}_${perPage}`;
  const page = defaultPages[key] || 0;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Do nothing if the page is already known or not the newest page.
    if (page || defaultPage !== 'newest') {
      return;
    } // We need to fetch comments to know the index. Use HEAD and limit
    // fields just to ID, to make this call as light as possible.


    external_wp_apiFetch_default()({
      path: (0,external_wp_url_namespaceObject.addQueryArgs)('/wp/v2/comments', { ...queryArgs,
        post: postId,
        per_page: perPage,
        _fields: 'id'
      }),
      method: 'HEAD',
      parse: false
    }).then(res => {
      const pages = parseInt(res.headers.get('X-WP-TotalPages'));
      setDefaultPages({ ...defaultPages,
        [key]: pages <= 1 ? 1 : pages // If there are 0 pages, it means that there are no comments, but there is no 0th page.

      });
    });
  }, [defaultPage, postId, perPage, setDefaultPages]); // The oldest one is always the first one.

  return defaultPage === 'newest' ? page : 1;
};
/**
 * Generate a tree structure of comment IDs from a list of comment entities. The
 * children of each comment are obtained from `_embedded`.
 *
 * @typedef {{ commentId: number, children: CommentNode }} CommentNode
 *
 * @param {Object[]} topLevelComments List of comment entities.
 * @return {{ commentTree: CommentNode[]}} Tree of comment IDs.
 */


const useCommentTree = topLevelComments => {
  const commentTree = (0,external_wp_element_namespaceObject.useMemo)(() => topLevelComments?.map(({
    id,
    _embedded
  }) => {
    const [children] = _embedded?.children || [[]];
    return {
      commentId: id,
      children: children.map(child => ({
        commentId: child.id
      }))
    };
  }), [topLevelComments]);
  return commentTree;
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-template/edit.js


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


const edit_TEMPLATE = [['core/avatar'], ['core/comment-author-name'], ['core/comment-date'], ['core/comment-content'], ['core/comment-reply-link'], ['core/comment-edit-link']];
/**
 * Function that returns a comment structure that will be rendered with default placehoders.
 *
 * Each comment has a `commentId` property that is always a negative number in
 * case of the placeholders. This is to ensure that the comment does not
 * conflict with the actual (real) comments.
 *
 * @param {Object}  settings                       Discussion Settings.
 * @param {number}  [settings.perPage]             - Comments per page setting or block attribute.
 * @param {boolean} [settings.pageComments]        - Enable break comments into pages setting.
 * @param {boolean} [settings.threadComments]      - Enable threaded (nested) comments setting.
 * @param {number}  [settings.threadCommentsDepth] - Level deep of threaded comments.
 *
 * @typedef {{id: null, children: EmptyComment[]}} EmptyComment
 * @return {EmptyComment[]}                 		Inner blocks of the Comment Template
 */

const getCommentsPlaceholder = ({
  perPage,
  pageComments,
  threadComments,
  threadCommentsDepth
}) => {
  // Limit commentsDepth to 3
  const commentsDepth = !threadComments ? 1 : Math.min(threadCommentsDepth, 3);

  const buildChildrenComment = commentsLevel => {
    // Render children comments until commentsDepth is reached
    if (commentsLevel < commentsDepth) {
      const nextLevel = commentsLevel + 1;
      return [{
        commentId: -(commentsLevel + 3),
        children: buildChildrenComment(nextLevel)
      }];
    }

    return [];
  }; // Add the first comment and its children


  const placeholderComments = [{
    commentId: -1,
    children: buildChildrenComment(1)
  }]; // Add a second comment unless the break comments setting is active and set to less than 2, and there is one nested comment max

  if ((!pageComments || perPage >= 2) && commentsDepth < 3) {
    placeholderComments.push({
      commentId: -2,
      children: []
    });
  } // Add a third comment unless the break comments setting is active and set to less than 3, and there aren't nested comments


  if ((!pageComments || perPage >= 3) && commentsDepth < 2) {
    placeholderComments.push({
      commentId: -3,
      children: []
    });
  } // In case that the value is set but larger than 3 we truncate it to 3.


  return placeholderComments;
};
/**
 * Component which renders the inner blocks of the Comment Template.
 *
 * @param {Object} props                      Component props.
 * @param {Array}  [props.comment]            - A comment object.
 * @param {Array}  [props.activeCommentId]    - The ID of the comment that is currently active.
 * @param {Array}  [props.setActiveCommentId] - The setter for activeCommentId.
 * @param {Array}  [props.firstCommentId]     - ID of the first comment in the array.
 * @param {Array}  [props.blocks]             - Array of blocks returned from
 *                                            getBlocks() in parent .
 * @return {WPElement}                 		Inner blocks of the Comment Template
 */


function CommentTemplateInnerBlocks({
  comment,
  activeCommentId,
  setActiveCommentId,
  firstCommentId,
  blocks
}) {
  const {
    children,
    ...innerBlocksProps
  } = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)({}, {
    template: edit_TEMPLATE
  });
  return (0,external_wp_element_namespaceObject.createElement)("li", { ...innerBlocksProps
  }, comment.commentId === (activeCommentId || firstCommentId) ? children : null, (0,external_wp_element_namespaceObject.createElement)(MemoizedCommentTemplatePreview, {
    blocks: blocks,
    commentId: comment.commentId,
    setActiveCommentId: setActiveCommentId,
    isHidden: comment.commentId === (activeCommentId || firstCommentId)
  }), comment?.children?.length > 0 ? (0,external_wp_element_namespaceObject.createElement)(CommentsList, {
    comments: comment.children,
    activeCommentId: activeCommentId,
    setActiveCommentId: setActiveCommentId,
    blocks: blocks,
    firstCommentId: firstCommentId
  }) : null);
}

const CommentTemplatePreview = ({
  blocks,
  commentId,
  setActiveCommentId,
  isHidden
}) => {
  const blockPreviewProps = (0,external_wp_blockEditor_namespaceObject.__experimentalUseBlockPreview)({
    blocks
  });

  const handleOnClick = () => {
    setActiveCommentId(commentId);
  }; // We have to hide the preview block if the `comment` props points to
  // the curently active block!
  // Or, to put it differently, every preview block is visible unless it is the
  // currently active block - in this case we render its inner blocks.


  const style = {
    display: isHidden ? 'none' : undefined
  };
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockPreviewProps,
    tabIndex: 0,
    role: "button",
    style: style // eslint-disable-next-line jsx-a11y/no-noninteractive-element-to-interactive-role
    ,
    onClick: handleOnClick,
    onKeyPress: handleOnClick
  });
};

const MemoizedCommentTemplatePreview = (0,external_wp_element_namespaceObject.memo)(CommentTemplatePreview);
/**
 * Component that renders a list of (nested) comments. It is called recursively.
 *
 * @param {Object} props                      Component props.
 * @param {Array}  [props.comments]           - Array of comment objects.
 * @param {Array}  [props.blockProps]         - Props from parent's `useBlockProps()`.
 * @param {Array}  [props.activeCommentId]    - The ID of the comment that is currently active.
 * @param {Array}  [props.setActiveCommentId] - The setter for activeCommentId.
 * @param {Array}  [props.blocks]             - Array of blocks returned from getBlocks() in parent.
 * @param {Object} [props.firstCommentId]     - The ID of the first comment in the array of
 *                                            comment objects.
 * @return {WPElement}                 		List of comments.
 */

const CommentsList = ({
  comments,
  blockProps,
  activeCommentId,
  setActiveCommentId,
  blocks,
  firstCommentId
}) => (0,external_wp_element_namespaceObject.createElement)("ol", { ...blockProps
}, comments && comments.map(({
  commentId,
  ...comment
}, index) => (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockContextProvider, {
  key: comment.commentId || index,
  value: {
    // If the commentId is negative it means that this comment is a
    // "placeholder" and that the block is most likely being used in the
    // site editor. In this case, we have to set the commentId to `null`
    // because otherwise the (non-existent) comment with a negative ID
    // would be reqested from the REST API.
    commentId: commentId < 0 ? null : commentId
  }
}, (0,external_wp_element_namespaceObject.createElement)(CommentTemplateInnerBlocks, {
  comment: {
    commentId,
    ...comment
  },
  activeCommentId: activeCommentId,
  setActiveCommentId: setActiveCommentId,
  blocks: blocks,
  firstCommentId: firstCommentId
}))));

function CommentTemplateEdit({
  clientId,
  context: {
    postId
  }
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const [activeCommentId, setActiveCommentId] = (0,external_wp_element_namespaceObject.useState)();
  const {
    commentOrder,
    threadCommentsDepth,
    threadComments,
    commentsPerPage,
    pageComments
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    return getSettings().__experimentalDiscussionSettings;
  });
  const commentQuery = useCommentQueryArgs({
    postId
  });
  const {
    topLevelComments,
    blocks
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecords
    } = select(external_wp_coreData_namespaceObject.store);
    const {
      getBlocks
    } = select(external_wp_blockEditor_namespaceObject.store);
    return {
      // Request only top-level comments. Replies are embedded.
      topLevelComments: commentQuery ? getEntityRecords('root', 'comment', commentQuery) : null,
      blocks: getBlocks(clientId)
    };
  }, [clientId, commentQuery]); // Generate a tree structure of comment IDs.

  let commentTree = useCommentTree( // Reverse the order of top comments if needed.
  commentOrder === 'desc' && topLevelComments ? [...topLevelComments].reverse() : topLevelComments);

  if (!topLevelComments) {
    return (0,external_wp_element_namespaceObject.createElement)("p", { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null));
  }

  if (!postId) {
    commentTree = getCommentsPlaceholder({
      perPage: commentsPerPage,
      pageComments,
      threadComments,
      threadCommentsDepth
    });
  }

  if (!commentTree.length) {
    return (0,external_wp_element_namespaceObject.createElement)("p", { ...blockProps
    }, (0,external_wp_i18n_namespaceObject.__)('No results found.'));
  }

  return (0,external_wp_element_namespaceObject.createElement)(CommentsList, {
    comments: commentTree,
    blockProps: blockProps,
    blocks: blocks,
    activeCommentId: activeCommentId,
    setActiveCommentId: setActiveCommentId,
    firstCommentId: commentTree[0]?.commentId
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-template/save.js


/**
 * WordPress dependencies
 */

function CommentTemplateSave() {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comment-template/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comment_template_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comment-template",
  title: "Comment Template",
  category: "design",
  parent: ["core/comments"],
  description: "Contains the block elements used to display a comment, like the title, date, author, avatar and more.",
  textdomain: "default",
  usesContext: ["postId"],
  supports: {
    align: true,
    html: false,
    reusable: false,
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  style: "wp-block-comment-template"
};


const {
  name: comment_template_name
} = comment_template_metadata;

const comment_template_settings = {
  icon: library_layout,
  edit: CommentTemplateEdit,
  save: CommentTemplateSave
};
const comment_template_init = () => initBlock({
  name: comment_template_name,
  metadata: comment_template_metadata,
  settings: comment_template_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/query-pagination-previous.js


/**
 * WordPress dependencies
 */

const queryPaginationPrevious = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M16 10.5v3h3v-3h-3zm-5 3h3v-3h-3v3zM7 9l-3 3 3 3 1-1-2-2 2-2-1-1z"
}));
/* harmony default export */ var query_pagination_previous = (queryPaginationPrevious);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination-previous/edit.js


/**
 * WordPress dependencies
 */


const arrowMap = {
  none: '',
  arrow: '←',
  chevron: '«'
};
function CommentsPaginationPreviousEdit({
  attributes: {
    label
  },
  setAttributes,
  context: {
    'comments/paginationArrow': paginationArrow
  }
}) {
  const displayArrow = arrowMap[paginationArrow];
  return (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#comments-pagination-previous-pseudo-link",
    onClick: event => event.preventDefault(),
    ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)()
  }, displayArrow && (0,external_wp_element_namespaceObject.createElement)("span", {
    className: `wp-block-comments-pagination-previous-arrow is-arrow-${paginationArrow}`
  }, displayArrow), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.PlainText, {
    __experimentalVersion: 2,
    tagName: "span",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Older comments page link'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Older Comments'),
    value: label,
    onChange: newLabel => setAttributes({
      label: newLabel
    })
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination-previous/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comments_pagination_previous_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments-pagination-previous",
  title: "Comments Previous Page",
  category: "theme",
  parent: ["core/comments-pagination"],
  description: "Displays the previous comment's page link.",
  textdomain: "default",
  attributes: {
    label: {
      type: "string"
    }
  },
  usesContext: ["postId", "comments/paginationArrow"],
  supports: {
    reusable: false,
    html: false,
    color: {
      gradients: true,
      text: false,
      __experimentalDefaultControls: {
        background: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};

const {
  name: comments_pagination_previous_name
} = comments_pagination_previous_metadata;

const comments_pagination_previous_settings = {
  icon: query_pagination_previous,
  edit: CommentsPaginationPreviousEdit
};
const comments_pagination_previous_init = () => initBlock({
  name: comments_pagination_previous_name,
  metadata: comments_pagination_previous_metadata,
  settings: comments_pagination_previous_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/query-pagination.js


/**
 * WordPress dependencies
 */

const queryPagination = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 13.5h6v-3H4v3zm8 0h3v-3h-3v3zm5-3v3h3v-3h-3z"
}));
/* harmony default export */ var query_pagination = (queryPagination);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination/comments-pagination-arrow-controls.js


/**
 * WordPress dependencies
 */


function CommentsPaginationArrowControls({
  value,
  onChange
}) {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Arrow'),
    value: value,
    onChange: onChange,
    help: (0,external_wp_i18n_namespaceObject.__)('A decorative arrow appended to the next and previous comments link.'),
    isBlock: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    value: "none",
    label: (0,external_wp_i18n_namespaceObject._x)('None', 'Arrow option for Comments Pagination Next/Previous blocks')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    value: "arrow",
    label: (0,external_wp_i18n_namespaceObject._x)('Arrow', 'Arrow option for Comments Pagination Next/Previous blocks')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    value: "chevron",
    label: (0,external_wp_i18n_namespaceObject._x)('Chevron', 'Arrow option for Comments Pagination Next/Previous blocks')
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination/edit.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const comments_pagination_edit_TEMPLATE = [['core/comments-pagination-previous'], ['core/comments-pagination-numbers'], ['core/comments-pagination-next']];
const comments_pagination_edit_ALLOWED_BLOCKS = ['core/comments-pagination-previous', 'core/comments-pagination-numbers', 'core/comments-pagination-next'];
function QueryPaginationEdit({
  attributes: {
    paginationArrow
  },
  setAttributes,
  clientId
}) {
  const hasNextPreviousBlocks = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlocks
    } = select(external_wp_blockEditor_namespaceObject.store);
    const innerBlocks = getBlocks(clientId);
    /**
     * Show the `paginationArrow` control only if a
     * Comments Pagination Next or Comments Pagination Previous
     * block exists.
     */

    return innerBlocks?.find(innerBlock => {
      return ['core/comments-pagination-previous', 'core/comments-pagination-next'].includes(innerBlock.name);
    });
  }, []);
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    template: comments_pagination_edit_TEMPLATE,
    allowedBlocks: comments_pagination_edit_ALLOWED_BLOCKS
  }); // Get the Discussion settings

  const pageComments = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      __experimentalDiscussionSettings
    } = getSettings();
    return __experimentalDiscussionSettings?.pageComments;
  }, []); // If paging comments is not enabled in the Discussion Settings then hide the pagination
  // controls. We don't want to remove them from the template so that when the user enables
  // paging comments, the controls will be visible.

  if (!pageComments) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.Warning, null, (0,external_wp_i18n_namespaceObject.__)('Comments Pagination block: paging comments is disabled in the Discussion Settings'));
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, hasNextPreviousBlocks && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(CommentsPaginationArrowControls, {
    value: paginationArrow,
    onChange: value => {
      setAttributes({
        paginationArrow: value
      });
    }
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination/save.js


/**
 * WordPress dependencies
 */

function comments_pagination_save_save() {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comments_pagination_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments-pagination",
  title: "Comments Pagination",
  category: "theme",
  parent: ["core/comments"],
  description: "Displays a paginated navigation to next/previous set of comments, when applicable.",
  textdomain: "default",
  attributes: {
    paginationArrow: {
      type: "string",
      "default": "none"
    }
  },
  providesContext: {
    "comments/paginationArrow": "paginationArrow"
  },
  supports: {
    align: true,
    reusable: false,
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    },
    layout: {
      allowSwitching: false,
      allowInheriting: false,
      "default": {
        type: "flex"
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-comments-pagination-editor",
  style: "wp-block-comments-pagination"
};


const {
  name: comments_pagination_name
} = comments_pagination_metadata;

const comments_pagination_settings = {
  icon: query_pagination,
  edit: QueryPaginationEdit,
  save: comments_pagination_save_save
};
const comments_pagination_init = () => initBlock({
  name: comments_pagination_name,
  metadata: comments_pagination_metadata,
  settings: comments_pagination_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/query-pagination-next.js


/**
 * WordPress dependencies
 */

const queryPaginationNext = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 13.5h3v-3H5v3zm5 0h3v-3h-3v3zM17 9l-1 1 2 2-2 2 1 1 3-3-3-3z"
}));
/* harmony default export */ var query_pagination_next = (queryPaginationNext);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination-next/edit.js


/**
 * WordPress dependencies
 */


const edit_arrowMap = {
  none: '',
  arrow: '→',
  chevron: '»'
};
function CommentsPaginationNextEdit({
  attributes: {
    label
  },
  setAttributes,
  context: {
    'comments/paginationArrow': paginationArrow
  }
}) {
  const displayArrow = edit_arrowMap[paginationArrow];
  return (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#comments-pagination-next-pseudo-link",
    onClick: event => event.preventDefault(),
    ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)()
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.PlainText, {
    __experimentalVersion: 2,
    tagName: "span",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Newer comments page link'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Newer Comments'),
    value: label,
    onChange: newLabel => setAttributes({
      label: newLabel
    })
  }), displayArrow && (0,external_wp_element_namespaceObject.createElement)("span", {
    className: `wp-block-comments-pagination-next-arrow is-arrow-${paginationArrow}`
  }, displayArrow));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination-next/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comments_pagination_next_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments-pagination-next",
  title: "Comments Next Page",
  category: "theme",
  parent: ["core/comments-pagination"],
  description: "Displays the next comment's page link.",
  textdomain: "default",
  attributes: {
    label: {
      type: "string"
    }
  },
  usesContext: ["postId", "comments/paginationArrow"],
  supports: {
    reusable: false,
    html: false,
    color: {
      gradients: true,
      text: false,
      __experimentalDefaultControls: {
        background: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};

const {
  name: comments_pagination_next_name
} = comments_pagination_next_metadata;

const comments_pagination_next_settings = {
  icon: query_pagination_next,
  edit: CommentsPaginationNextEdit
};
const comments_pagination_next_init = () => initBlock({
  name: comments_pagination_next_name,
  metadata: comments_pagination_next_metadata,
  settings: comments_pagination_next_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/query-pagination-numbers.js


/**
 * WordPress dependencies
 */

const queryPaginationNumbers = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 13.5h6v-3H4v3zm8.2-2.5.8-.3V14h1V9.3l-2.2.7.4 1zm7.1-1.2c-.5-.6-1.2-.5-1.7-.4-.3.1-.5.2-.7.3l.1 1.1c.2-.2.5-.4.8-.5.3-.1.6 0 .7.1.2.3 0 .8-.2 1.1-.5.8-.9 1.6-1.4 2.5h2.7v-1h-.9c.3-.6.8-1.4.9-2.1 0-.3-.1-.8-.3-1.1z"
}));
/* harmony default export */ var query_pagination_numbers = (queryPaginationNumbers);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination-numbers/edit.js


/**
 * WordPress dependencies
 */


const PaginationItem = ({
  content,
  tag: Tag = 'a',
  extraClass = ''
}) => Tag === 'a' ? (0,external_wp_element_namespaceObject.createElement)(Tag, {
  className: `page-numbers ${extraClass}`,
  href: "#comments-pagination-numbers-pseudo-link",
  onClick: event => event.preventDefault()
}, content) : (0,external_wp_element_namespaceObject.createElement)(Tag, {
  className: `page-numbers ${extraClass}`
}, content);

function CommentsPaginationNumbersEdit() {
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)()
  }, (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "1"
  }), (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "2"
  }), (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "3",
    tag: "span",
    extraClass: "current"
  }), (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "4"
  }), (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "5"
  }), (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "...",
    tag: "span",
    extraClass: "dots"
  }), (0,external_wp_element_namespaceObject.createElement)(PaginationItem, {
    content: "8"
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-pagination-numbers/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comments_pagination_numbers_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments-pagination-numbers",
  title: "Comments Page Numbers",
  category: "theme",
  parent: ["core/comments-pagination"],
  description: "Displays a list of page numbers for comments pagination.",
  textdomain: "default",
  usesContext: ["postId"],
  supports: {
    reusable: false,
    html: false,
    color: {
      gradients: true,
      text: false,
      __experimentalDefaultControls: {
        background: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};

const {
  name: comments_pagination_numbers_name
} = comments_pagination_numbers_metadata;

const comments_pagination_numbers_settings = {
  icon: query_pagination_numbers,
  edit: CommentsPaginationNumbersEdit
};
const comments_pagination_numbers_init = () => initBlock({
  name: comments_pagination_numbers_name,
  metadata: comments_pagination_numbers_metadata,
  settings: comments_pagination_numbers_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/title.js


/**
 * WordPress dependencies
 */

const title = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "https://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m4 5.5h2v6.5h1.5v-6.5h2v-1.5h-5.5zm16 10.5h-16v-1.5h16zm-7 4h-9v-1.5h9z"
}));
/* harmony default export */ var library_title = (title);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-title/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */









function comments_title_edit_Edit({
  attributes: {
    textAlign,
    showPostTitle,
    showCommentsCount,
    level
  },
  setAttributes,
  context: {
    postType,
    postId
  }
}) {
  const TagName = 'h' + level;
  const [commentsCount, setCommentsCount] = (0,external_wp_element_namespaceObject.useState)();
  const [rawTitle] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', postType, 'title', postId);
  const isSiteEditor = typeof postId === 'undefined';
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    })
  });
  const {
    threadCommentsDepth,
    threadComments,
    commentsPerPage,
    pageComments
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    return getSettings().__experimentalDiscussionSettings;
  });
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (isSiteEditor) {
      // Match the number of comments that will be shown in the comment-template/edit.js placeholder
      const nestedCommentsNumber = threadComments ? Math.min(threadCommentsDepth, 3) - 1 : 0;
      const topLevelCommentsNumber = pageComments ? commentsPerPage : 3;
      const commentsNumber = parseInt(nestedCommentsNumber) + parseInt(topLevelCommentsNumber);
      setCommentsCount(Math.min(commentsNumber, 3));
      return;
    }

    const currentPostId = postId;
    external_wp_apiFetch_default()({
      path: (0,external_wp_url_namespaceObject.addQueryArgs)('/wp/v2/comments', {
        post: postId,
        _fields: 'id'
      }),
      method: 'HEAD',
      parse: false
    }).then(res => {
      // Stale requests will have the `currentPostId` of an older closure.
      if (currentPostId === postId) {
        setCommentsCount(parseInt(res.headers.get('X-WP-Total')));
      }
    }).catch(() => {
      setCommentsCount(0);
    });
  }, [postId]);
  const blockControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: newAlign => setAttributes({
      textAlign: newAlign
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.HeadingLevelDropdown, {
    value: level,
    onChange: newLevel => setAttributes({
      level: newLevel
    })
  }));
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show post title'),
    checked: showPostTitle,
    onChange: value => setAttributes({
      showPostTitle: value
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show comments count'),
    checked: showCommentsCount,
    onChange: value => setAttributes({
      showCommentsCount: value
    })
  })));
  const postTitle = isSiteEditor ? (0,external_wp_i18n_namespaceObject.__)('“Post Title”') : `"${rawTitle}"`;
  let placeholder;

  if (showCommentsCount && commentsCount !== undefined) {
    if (showPostTitle) {
      if (commentsCount === 1) {
        /* translators: %s: Post title. */
        placeholder = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('One response to %s'), postTitle);
      } else {
        placeholder = (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: 1: Number of comments, 2: Post title. */
        (0,external_wp_i18n_namespaceObject._n)('%1$s response to %2$s', '%1$s responses to %2$s', commentsCount), commentsCount, postTitle);
      }
    } else if (commentsCount === 1) {
      placeholder = (0,external_wp_i18n_namespaceObject.__)('One response');
    } else {
      placeholder = (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: %s: Number of comments. */
      (0,external_wp_i18n_namespaceObject._n)('%s response', '%s responses', commentsCount), commentsCount);
    }
  } else if (showPostTitle) {
    if (commentsCount === 1) {
      /* translators: %s: Post title. */
      placeholder = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Response to %s'), postTitle);
    } else {
      /* translators: %s: Post title. */
      placeholder = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Responses to %s'), postTitle);
    }
  } else if (commentsCount === 1) {
    placeholder = (0,external_wp_i18n_namespaceObject.__)('Response');
  } else {
    placeholder = (0,external_wp_i18n_namespaceObject.__)('Responses');
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, inspectorControls, (0,external_wp_element_namespaceObject.createElement)(TagName, { ...blockProps
  }, placeholder));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-title/deprecated.js
/**
 * Internal dependencies
 */
const deprecated_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments-title",
  title: "Comments Title",
  category: "theme",
  ancestor: ["core/comments"],
  description: "Displays a title with the number of comments",
  textdomain: "default",
  usesContext: ["postId", "postType"],
  attributes: {
    textAlign: {
      type: "string"
    },
    showPostTitle: {
      type: "boolean",
      "default": true
    },
    showCommentsCount: {
      type: "boolean",
      "default": true
    },
    level: {
      type: "number",
      "default": 2
    }
  },
  supports: {
    anchor: false,
    align: true,
    html: false,
    __experimentalBorder: {
      radius: true,
      color: true,
      width: true,
      style: true
    },
    color: {
      gradients: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true,
        __experimentalFontFamily: true,
        __experimentalFontStyle: true,
        __experimentalFontWeight: true
      }
    }
  }
};
const {
  attributes,
  supports
} = deprecated_metadata;
/* harmony default export */ var comments_title_deprecated = ([{
  attributes: { ...attributes,
    singleCommentLabel: {
      type: 'string'
    },
    multipleCommentsLabel: {
      type: 'string'
    }
  },
  supports,
  migrate: oldAttributes => {
    const {
      singleCommentLabel,
      multipleCommentsLabel,
      ...newAttributes
    } = oldAttributes;
    return newAttributes;
  },
  isEligible: ({
    multipleCommentsLabel,
    singleCommentLabel
  }) => multipleCommentsLabel || singleCommentLabel,
  save: () => null
}]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/comments-title/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const comments_title_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/comments-title",
  title: "Comments Title",
  category: "theme",
  ancestor: ["core/comments"],
  description: "Displays a title with the number of comments",
  textdomain: "default",
  usesContext: ["postId", "postType"],
  attributes: {
    textAlign: {
      type: "string"
    },
    showPostTitle: {
      type: "boolean",
      "default": true
    },
    showCommentsCount: {
      type: "boolean",
      "default": true
    },
    level: {
      type: "number",
      "default": 2
    }
  },
  supports: {
    anchor: false,
    align: true,
    html: false,
    __experimentalBorder: {
      radius: true,
      color: true,
      width: true,
      style: true
    },
    color: {
      gradients: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true,
        __experimentalFontFamily: true,
        __experimentalFontStyle: true,
        __experimentalFontWeight: true
      }
    }
  }
};


const {
  name: comments_title_name
} = comments_title_metadata;

const comments_title_settings = {
  icon: library_title,
  edit: comments_title_edit_Edit,
  deprecated: comments_title_deprecated
};
const comments_title_init = () => initBlock({
  name: comments_title_name,
  metadata: comments_title_metadata,
  settings: comments_title_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/cover.js


/**
 * WordPress dependencies
 */

const cover = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18.7 3H5.3C4 3 3 4 3 5.3v13.4C3 20 4 21 5.3 21h13.4c1.3 0 2.3-1 2.3-2.3V5.3C21 4 20 3 18.7 3zm.8 15.7c0 .4-.4.8-.8.8H5.3c-.4 0-.8-.4-.8-.8V5.3c0-.4.4-.8.8-.8h6.2v8.9l2.5-3.1 2.5 3.1V4.5h2.2c.4 0 .8.4.8.8v13.4z"
}));
/* harmony default export */ var library_cover = (cover);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/shared.js
/**
 * WordPress dependencies
 */

const POSITION_CLASSNAMES = {
  'top left': 'is-position-top-left',
  'top center': 'is-position-top-center',
  'top right': 'is-position-top-right',
  'center left': 'is-position-center-left',
  'center center': 'is-position-center-center',
  center: 'is-position-center-center',
  'center right': 'is-position-center-right',
  'bottom left': 'is-position-bottom-left',
  'bottom center': 'is-position-bottom-center',
  'bottom right': 'is-position-bottom-right'
};
const IMAGE_BACKGROUND_TYPE = 'image';
const VIDEO_BACKGROUND_TYPE = 'video';
const COVER_MIN_HEIGHT = 50;
const COVER_MAX_HEIGHT = 1000;
const COVER_DEFAULT_HEIGHT = 300;
const DEFAULT_FOCAL_POINT = {
  x: 0.5,
  y: 0.5
};
const shared_ALLOWED_MEDIA_TYPES = ['image', 'video'];
function mediaPosition({
  x,
  y
} = DEFAULT_FOCAL_POINT) {
  return `${Math.round(x * 100)}% ${Math.round(y * 100)}%`;
}
function dimRatioToClass(ratio) {
  return ratio === 50 || !ratio === undefined ? null : 'has-background-dim-' + 10 * Math.round(ratio / 10);
}
function attributesFromMedia(setAttributes, dimRatio) {
  return media => {
    if (!media || !media.url) {
      setAttributes({
        url: undefined,
        id: undefined
      });
      return;
    }

    if ((0,external_wp_blob_namespaceObject.isBlobURL)(media.url)) {
      media.type = (0,external_wp_blob_namespaceObject.getBlobTypeByURL)(media.url);
    }

    let mediaType; // For media selections originated from a file upload.

    if (media.media_type) {
      if (media.media_type === IMAGE_BACKGROUND_TYPE) {
        mediaType = IMAGE_BACKGROUND_TYPE;
      } else {
        // only images and videos are accepted so if the media_type is not an image we can assume it is a video.
        // Videos contain the media type of 'file' in the object returned from the rest api.
        mediaType = VIDEO_BACKGROUND_TYPE;
      }
    } else {
      // For media selections originated from existing files in the media library.
      if (media.type !== IMAGE_BACKGROUND_TYPE && media.type !== VIDEO_BACKGROUND_TYPE) {
        return;
      }

      mediaType = media.type;
    }

    setAttributes({
      dimRatio: dimRatio === 100 ? 50 : dimRatio,
      url: media.url,
      id: media.id,
      alt: media?.alt,
      backgroundType: mediaType,
      focalPoint: undefined,
      ...(mediaType === VIDEO_BACKGROUND_TYPE ? {
        hasParallax: undefined
      } : {})
    });
  };
}
/**
 * Checks of the contentPosition is the center (default) position.
 *
 * @param {string} contentPosition The current content position.
 * @return {boolean} Whether the contentPosition is center.
 */

function isContentPositionCenter(contentPosition) {
  return !contentPosition || contentPosition === 'center center' || contentPosition === 'center';
}
/**
 * Retrieves the className for the current contentPosition.
 * The default position (center) will not have a className.
 *
 * @param {string} contentPosition The current content position.
 * @return {string} The className assigned to the contentPosition.
 */

function getPositionClassName(contentPosition) {
  /*
   * Only render a className if the contentPosition is not center (the default).
   */
  if (isContentPositionCenter(contentPosition)) return '';
  return POSITION_CLASSNAMES[contentPosition];
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function backgroundImageStyles(url) {
  return url ? {
    backgroundImage: `url(${url})`
  } : {};
}
/**
 * Original function to determine the background opacity classname
 *
 * Used in deprecations: v1-7.
 *
 * @param {number} ratio ratio to use for opacity.
 * @return {string}       background opacity class   .
 */


function dimRatioToClassV1(ratio) {
  return ratio === 0 || ratio === 50 || !ratio ? null : 'has-background-dim-' + 10 * Math.round(ratio / 10);
}

function migrateDimRatio(attributes) {
  return { ...attributes,
    dimRatio: !attributes.url ? 100 : attributes.dimRatio
  };
}

function migrateTag(attributes) {
  if (!attributes.tagName) {
    attributes = { ...attributes,
      tagName: 'div'
    };
  }

  return { ...attributes
  };
}

const deprecated_blockAttributes = {
  url: {
    type: 'string'
  },
  id: {
    type: 'number'
  },
  hasParallax: {
    type: 'boolean',
    default: false
  },
  dimRatio: {
    type: 'number',
    default: 50
  },
  overlayColor: {
    type: 'string'
  },
  customOverlayColor: {
    type: 'string'
  },
  backgroundType: {
    type: 'string',
    default: 'image'
  },
  focalPoint: {
    type: 'object'
  }
};
const v8ToV10BlockAttributes = {
  url: {
    type: 'string'
  },
  id: {
    type: 'number'
  },
  alt: {
    type: 'string',
    source: 'attribute',
    selector: 'img',
    attribute: 'alt',
    default: ''
  },
  hasParallax: {
    type: 'boolean',
    default: false
  },
  isRepeated: {
    type: 'boolean',
    default: false
  },
  dimRatio: {
    type: 'number',
    default: 100
  },
  overlayColor: {
    type: 'string'
  },
  customOverlayColor: {
    type: 'string'
  },
  backgroundType: {
    type: 'string',
    default: 'image'
  },
  focalPoint: {
    type: 'object'
  },
  minHeight: {
    type: 'number'
  },
  minHeightUnit: {
    type: 'string'
  },
  gradient: {
    type: 'string'
  },
  customGradient: {
    type: 'string'
  },
  contentPosition: {
    type: 'string'
  },
  isDark: {
    type: 'boolean',
    default: true
  },
  allowedBlocks: {
    type: 'array'
  },
  templateLock: {
    type: ['string', 'boolean'],
    enum: ['all', 'insert', false]
  }
};
const v7toV10BlockSupports = {
  anchor: true,
  align: true,
  html: false,
  spacing: {
    padding: true,
    __experimentalDefaultControls: {
      padding: true
    }
  },
  color: {
    __experimentalDuotone: '> .wp-block-cover__image-background, > .wp-block-cover__video-background',
    text: false,
    background: false
  }
}; // Deprecation for blocks that does not have a HTML tag option.

const deprecated_v11 = {
  attributes: v8ToV10BlockAttributes,
  supports: v7toV10BlockSupports,

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      contentPosition,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      useFeaturedImage,
      hasParallax,
      isDark,
      isRepeated,
      overlayColor,
      url,
      alt,
      id,
      minHeight: minHeightProp,
      minHeightUnit
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const minHeight = minHeightProp && minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
    const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
    const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
    const isImgElement = !(hasParallax || isRepeated);
    const style = {
      minHeight: minHeight || undefined
    };
    const bgStyle = {
      backgroundColor: !overlayColorClass ? customOverlayColor : undefined,
      background: customGradient ? customGradient : undefined
    };
    const objectPosition = // prettier-ignore
    focalPoint && isImgElement ? mediaPosition(focalPoint) : undefined;
    const backgroundImage = url ? `url(${url})` : undefined;
    const backgroundPosition = mediaPosition(focalPoint);
    const classes = classnames_default()({
      'is-light': !isDark,
      'has-parallax': hasParallax,
      'is-repeated': isRepeated,
      'has-custom-content-position': !isContentPositionCenter(contentPosition)
    }, getPositionClassName(contentPosition));
    const imgClasses = classnames_default()('wp-block-cover__image-background', id ? `wp-image-${id}` : null, {
      'has-parallax': hasParallax,
      'is-repeated': isRepeated
    });
    const gradientValue = gradient || customGradient;
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__background', overlayColorClass, dimRatioToClass(dimRatio), {
        'has-background-dim': dimRatio !== undefined,
        // For backwards compatibility. Former versions of the Cover Block applied
        // `.wp-block-cover__gradient-background` in the presence of
        // media, a gradient and a dim.
        'wp-block-cover__gradient-background': url && gradientValue && dimRatio !== 0,
        'has-background-gradient': gradientValue,
        [gradientClass]: gradientClass
      }),
      style: bgStyle
    }), !useFeaturedImage && isImageBackground && url && (isImgElement ? (0,external_wp_element_namespaceObject.createElement)("img", {
      className: imgClasses,
      alt: alt,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }) : (0,external_wp_element_namespaceObject.createElement)("div", {
      role: "img",
      className: imgClasses,
      style: {
        backgroundPosition,
        backgroundImage
      }
    })), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: classnames_default()('wp-block-cover__video-background', 'intrinsic-ignore'),
      autoPlay: true,
      muted: true,
      loop: true,
      playsInline: true,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-cover__inner-container'
      })
    }));
  },

  migrate: migrateTag
}; // Deprecation for blocks that renders fixed background as backgroud from the main block container.

const deprecated_v10 = {
  attributes: v8ToV10BlockAttributes,
  supports: v7toV10BlockSupports,

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      contentPosition,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      useFeaturedImage,
      hasParallax,
      isDark,
      isRepeated,
      overlayColor,
      url,
      alt,
      id,
      minHeight: minHeightProp,
      minHeightUnit
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const minHeight = minHeightProp && minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
    const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
    const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
    const isImgElement = !(hasParallax || isRepeated);
    const style = { ...(isImageBackground && !isImgElement && !useFeaturedImage ? backgroundImageStyles(url) : {}),
      minHeight: minHeight || undefined
    };
    const bgStyle = {
      backgroundColor: !overlayColorClass ? customOverlayColor : undefined,
      background: customGradient ? customGradient : undefined
    };
    const objectPosition = // prettier-ignore
    focalPoint && isImgElement ? `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%` : undefined;
    const classes = classnames_default()({
      'is-light': !isDark,
      'has-parallax': hasParallax,
      'is-repeated': isRepeated,
      'has-custom-content-position': !isContentPositionCenter(contentPosition)
    }, getPositionClassName(contentPosition));
    const gradientValue = gradient || customGradient;
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__background', overlayColorClass, dimRatioToClass(dimRatio), {
        'has-background-dim': dimRatio !== undefined,
        // For backwards compatibility. Former versions of the Cover Block applied
        // `.wp-block-cover__gradient-background` in the presence of
        // media, a gradient and a dim.
        'wp-block-cover__gradient-background': url && gradientValue && dimRatio !== 0,
        'has-background-gradient': gradientValue,
        [gradientClass]: gradientClass
      }),
      style: bgStyle
    }), !useFeaturedImage && isImageBackground && isImgElement && url && (0,external_wp_element_namespaceObject.createElement)("img", {
      className: classnames_default()('wp-block-cover__image-background', id ? `wp-image-${id}` : null),
      alt: alt,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: classnames_default()('wp-block-cover__video-background', 'intrinsic-ignore'),
      autoPlay: true,
      muted: true,
      loop: true,
      playsInline: true,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-cover__inner-container'
      })
    }));
  },

  migrate: migrateTag
}; // Deprecation for blocks with `minHeightUnit` set but no `minHeight`.

const v9 = {
  attributes: v8ToV10BlockAttributes,
  supports: v7toV10BlockSupports,

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      contentPosition,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      isDark,
      isRepeated,
      overlayColor,
      url,
      alt,
      id,
      minHeight: minHeightProp,
      minHeightUnit
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const minHeight = minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
    const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
    const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
    const isImgElement = !(hasParallax || isRepeated);
    const style = { ...(isImageBackground && !isImgElement ? backgroundImageStyles(url) : {}),
      minHeight: minHeight || undefined
    };
    const bgStyle = {
      backgroundColor: !overlayColorClass ? customOverlayColor : undefined,
      background: customGradient ? customGradient : undefined
    };
    const objectPosition = // prettier-ignore
    focalPoint && isImgElement ? `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%` : undefined;
    const classes = classnames_default()({
      'is-light': !isDark,
      'has-parallax': hasParallax,
      'is-repeated': isRepeated,
      'has-custom-content-position': !isContentPositionCenter(contentPosition)
    }, getPositionClassName(contentPosition));
    const gradientValue = gradient || customGradient;
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__background', overlayColorClass, dimRatioToClass(dimRatio), {
        'has-background-dim': dimRatio !== undefined,
        // For backwards compatibility. Former versions of the Cover Block applied
        // `.wp-block-cover__gradient-background` in the presence of
        // media, a gradient and a dim.
        'wp-block-cover__gradient-background': url && gradientValue && dimRatio !== 0,
        'has-background-gradient': gradientValue,
        [gradientClass]: gradientClass
      }),
      style: bgStyle
    }), isImageBackground && isImgElement && url && (0,external_wp_element_namespaceObject.createElement)("img", {
      className: classnames_default()('wp-block-cover__image-background', id ? `wp-image-${id}` : null),
      alt: alt,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: classnames_default()('wp-block-cover__video-background', 'intrinsic-ignore'),
      autoPlay: true,
      muted: true,
      loop: true,
      playsInline: true,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-cover__inner-container'
      })
    }));
  },

  migrate: migrateTag
}; // v8: deprecated to remove duplicated gradient classes and swap `wp-block-cover__gradient-background` for `wp-block-cover__background`.

const v8 = {
  attributes: v8ToV10BlockAttributes,
  supports: v7toV10BlockSupports,

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      contentPosition,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      isDark,
      isRepeated,
      overlayColor,
      url,
      alt,
      id,
      minHeight: minHeightProp,
      minHeightUnit
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const minHeight = minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
    const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
    const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
    const isImgElement = !(hasParallax || isRepeated);
    const style = { ...(isImageBackground && !isImgElement ? backgroundImageStyles(url) : {}),
      minHeight: minHeight || undefined
    };
    const bgStyle = {
      backgroundColor: !overlayColorClass ? customOverlayColor : undefined,
      background: customGradient ? customGradient : undefined
    };
    const objectPosition = // prettier-ignore
    focalPoint && isImgElement ? `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%` : undefined;
    const classes = classnames_default()({
      'is-light': !isDark,
      'has-parallax': hasParallax,
      'is-repeated': isRepeated,
      'has-custom-content-position': !isContentPositionCenter(contentPosition)
    }, getPositionClassName(contentPosition));
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()(overlayColorClass, dimRatioToClass(dimRatio), 'wp-block-cover__gradient-background', gradientClass, {
        'has-background-dim': dimRatio !== undefined,
        'has-background-gradient': gradient || customGradient,
        [gradientClass]: !url && gradientClass
      }),
      style: bgStyle
    }), isImageBackground && isImgElement && url && (0,external_wp_element_namespaceObject.createElement)("img", {
      className: classnames_default()('wp-block-cover__image-background', id ? `wp-image-${id}` : null),
      alt: alt,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: classnames_default()('wp-block-cover__video-background', 'intrinsic-ignore'),
      autoPlay: true,
      muted: true,
      loop: true,
      playsInline: true,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-cover__inner-container'
      })
    }));
  },

  migrate: migrateTag
};
const v7 = {
  attributes: { ...deprecated_blockAttributes,
    isRepeated: {
      type: 'boolean',
      default: false
    },
    minHeight: {
      type: 'number'
    },
    minHeightUnit: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    customGradient: {
      type: 'string'
    },
    contentPosition: {
      type: 'string'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: ''
    }
  },
  supports: v7toV10BlockSupports,

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      contentPosition,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      isRepeated,
      overlayColor,
      url,
      alt,
      id,
      minHeight: minHeightProp,
      minHeightUnit
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const minHeight = minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
    const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
    const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
    const isImgElement = !(hasParallax || isRepeated);
    const style = { ...(isImageBackground && !isImgElement ? backgroundImageStyles(url) : {}),
      backgroundColor: !overlayColorClass ? customOverlayColor : undefined,
      background: customGradient && !url ? customGradient : undefined,
      minHeight: minHeight || undefined
    };
    const objectPosition = // prettier-ignore
    focalPoint && isImgElement ? `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%` : undefined;
    const classes = classnames_default()(dimRatioToClassV1(dimRatio), overlayColorClass, {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax,
      'is-repeated': isRepeated,
      'has-background-gradient': gradient || customGradient,
      [gradientClass]: !url && gradientClass,
      'has-custom-content-position': !isContentPositionCenter(contentPosition)
    }, getPositionClassName(contentPosition));
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes,
        style
      })
    }, url && (gradient || customGradient) && dimRatio !== 0 && (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__gradient-background', gradientClass),
      style: customGradient ? {
        background: customGradient
      } : undefined
    }), isImageBackground && isImgElement && url && (0,external_wp_element_namespaceObject.createElement)("img", {
      className: classnames_default()('wp-block-cover__image-background', id ? `wp-image-${id}` : null),
      alt: alt,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: classnames_default()('wp-block-cover__video-background', 'intrinsic-ignore'),
      autoPlay: true,
      muted: true,
      loop: true,
      playsInline: true,
      src: url,
      style: {
        objectPosition
      },
      "data-object-fit": "cover",
      "data-object-position": objectPosition
    }), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-cover__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrateDimRatio, migrateTag)
};
const v6 = {
  attributes: { ...deprecated_blockAttributes,
    isRepeated: {
      type: 'boolean',
      default: false
    },
    minHeight: {
      type: 'number'
    },
    minHeightUnit: {
      type: 'string'
    },
    gradient: {
      type: 'string'
    },
    customGradient: {
      type: 'string'
    },
    contentPosition: {
      type: 'string'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      contentPosition,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      isRepeated,
      overlayColor,
      url,
      minHeight: minHeightProp,
      minHeightUnit
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const minHeight = minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
    const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
    const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
    const style = isImageBackground ? backgroundImageStyles(url) : {};
    const videoStyle = {};

    if (!overlayColorClass) {
      style.backgroundColor = customOverlayColor;
    }

    if (customGradient && !url) {
      style.background = customGradient;
    }

    style.minHeight = minHeight || undefined;
    let positionValue;

    if (focalPoint) {
      positionValue = `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%`;

      if (isImageBackground && !hasParallax) {
        style.backgroundPosition = positionValue;
      }

      if (isVideoBackground) {
        videoStyle.objectPosition = positionValue;
      }
    }

    const classes = classnames_default()(dimRatioToClassV1(dimRatio), overlayColorClass, {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax,
      'is-repeated': isRepeated,
      'has-background-gradient': gradient || customGradient,
      [gradientClass]: !url && gradientClass,
      'has-custom-content-position': !isContentPositionCenter(contentPosition)
    }, getPositionClassName(contentPosition));
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes,
        style
      })
    }, url && (gradient || customGradient) && dimRatio !== 0 && (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__gradient-background', gradientClass),
      style: customGradient ? {
        background: customGradient
      } : undefined
    }), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: "wp-block-cover__video-background",
      autoPlay: true,
      muted: true,
      loop: true,
      playsInline: true,
      src: url,
      style: videoStyle
    }), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-cover__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrateDimRatio, migrateTag)
};
const v5 = {
  attributes: { ...deprecated_blockAttributes,
    minHeight: {
      type: 'number'
    },
    gradient: {
      type: 'string'
    },
    customGradient: {
      type: 'string'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      overlayColor,
      url,
      minHeight
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const style = backgroundType === IMAGE_BACKGROUND_TYPE ? backgroundImageStyles(url) : {};

    if (!overlayColorClass) {
      style.backgroundColor = customOverlayColor;
    }

    if (focalPoint && !hasParallax) {
      style.backgroundPosition = `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%`;
    }

    if (customGradient && !url) {
      style.background = customGradient;
    }

    style.minHeight = minHeight || undefined;
    const classes = classnames_default()(dimRatioToClassV1(dimRatio), overlayColorClass, {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax,
      'has-background-gradient': customGradient,
      [gradientClass]: !url && gradientClass
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: classes,
      style: style
    }, url && (gradient || customGradient) && dimRatio !== 0 && (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__gradient-background', gradientClass),
      style: customGradient ? {
        background: customGradient
      } : undefined
    }), VIDEO_BACKGROUND_TYPE === backgroundType && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: "wp-block-cover__video-background",
      autoPlay: true,
      muted: true,
      loop: true,
      src: url
    }), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-cover__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrateDimRatio, migrateTag)
};
const v4 = {
  attributes: { ...deprecated_blockAttributes,
    minHeight: {
      type: 'number'
    },
    gradient: {
      type: 'string'
    },
    customGradient: {
      type: 'string'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      backgroundType,
      gradient,
      customGradient,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      overlayColor,
      url,
      minHeight
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

    const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

    const style = backgroundType === IMAGE_BACKGROUND_TYPE ? backgroundImageStyles(url) : {};

    if (!overlayColorClass) {
      style.backgroundColor = customOverlayColor;
    }

    if (focalPoint && !hasParallax) {
      style.backgroundPosition = `${focalPoint.x * 100}% ${focalPoint.y * 100}%`;
    }

    if (customGradient && !url) {
      style.background = customGradient;
    }

    style.minHeight = minHeight || undefined;
    const classes = classnames_default()(dimRatioToClassV1(dimRatio), overlayColorClass, {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax,
      'has-background-gradient': customGradient,
      [gradientClass]: !url && gradientClass
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: classes,
      style: style
    }, url && (gradient || customGradient) && dimRatio !== 0 && (0,external_wp_element_namespaceObject.createElement)("span", {
      "aria-hidden": "true",
      className: classnames_default()('wp-block-cover__gradient-background', gradientClass),
      style: customGradient ? {
        background: customGradient
      } : undefined
    }), VIDEO_BACKGROUND_TYPE === backgroundType && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: "wp-block-cover__video-background",
      autoPlay: true,
      muted: true,
      loop: true,
      src: url
    }), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-cover__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  },

  migrate: (0,external_wp_compose_namespaceObject.compose)(migrateDimRatio, migrateTag)
};
const v3 = {
  attributes: { ...deprecated_blockAttributes,
    title: {
      type: 'string',
      source: 'html',
      selector: 'p'
    },
    contentAlign: {
      type: 'string',
      default: 'center'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      backgroundType,
      contentAlign,
      customOverlayColor,
      dimRatio,
      focalPoint,
      hasParallax,
      overlayColor,
      title,
      url
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);
    const style = backgroundType === IMAGE_BACKGROUND_TYPE ? backgroundImageStyles(url) : {};

    if (!overlayColorClass) {
      style.backgroundColor = customOverlayColor;
    }

    if (focalPoint && !hasParallax) {
      style.backgroundPosition = `${focalPoint.x * 100}% ${focalPoint.y * 100}%`;
    }

    const classes = classnames_default()(dimRatioToClassV1(dimRatio), overlayColorClass, {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax,
      [`has-${contentAlign}-content`]: contentAlign !== 'center'
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: classes,
      style: style
    }, VIDEO_BACKGROUND_TYPE === backgroundType && url && (0,external_wp_element_namespaceObject.createElement)("video", {
      className: "wp-block-cover__video-background",
      autoPlay: true,
      muted: true,
      loop: true,
      src: url
    }), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(title) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "p",
      className: "wp-block-cover-text",
      value: title
    }));
  },

  migrate(attributes) {
    const newAttribs = { ...attributes,
      dimRatio: !attributes.url ? 100 : attributes.dimRatio,
      tagName: !attributes.tagName ? 'div' : attributes.tagName
    };
    const {
      title,
      contentAlign,
      ...restAttributes
    } = newAttribs;
    return [restAttributes, [(0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
      content: attributes.title,
      align: attributes.contentAlign,
      fontSize: 'large',
      placeholder: (0,external_wp_i18n_namespaceObject.__)('Write title…')
    })]];
  }

};
const v2 = {
  attributes: { ...deprecated_blockAttributes,
    title: {
      type: 'string',
      source: 'html',
      selector: 'p'
    },
    contentAlign: {
      type: 'string',
      default: 'center'
    },
    align: {
      type: 'string'
    }
  },
  supports: {
    className: false
  },

  save({
    attributes
  }) {
    const {
      url,
      title,
      hasParallax,
      dimRatio,
      align,
      contentAlign,
      overlayColor,
      customOverlayColor
    } = attributes;
    const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);
    const style = backgroundImageStyles(url);

    if (!overlayColorClass) {
      style.backgroundColor = customOverlayColor;
    }

    const classes = classnames_default()('wp-block-cover-image', dimRatioToClassV1(dimRatio), overlayColorClass, {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax,
      [`has-${contentAlign}-content`]: contentAlign !== 'center'
    }, align ? `align${align}` : null);
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: classes,
      style: style
    }, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(title) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "p",
      className: "wp-block-cover-image-text",
      value: title
    }));
  },

  migrate(attributes) {
    const newAttribs = { ...attributes,
      dimRatio: !attributes.url ? 100 : attributes.dimRatio,
      tagName: !attributes.tagName ? 'div' : attributes.tagName
    };
    const {
      title,
      contentAlign,
      align,
      ...restAttributes
    } = newAttribs;
    return [restAttributes, [(0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
      content: attributes.title,
      align: attributes.contentAlign,
      fontSize: 'large',
      placeholder: (0,external_wp_i18n_namespaceObject.__)('Write title…')
    })]];
  }

};
const cover_deprecated_v1 = {
  attributes: { ...deprecated_blockAttributes,
    title: {
      type: 'string',
      source: 'html',
      selector: 'h2'
    },
    align: {
      type: 'string'
    },
    contentAlign: {
      type: 'string',
      default: 'center'
    }
  },
  supports: {
    className: false
  },

  save({
    attributes
  }) {
    const {
      url,
      title,
      hasParallax,
      dimRatio,
      align
    } = attributes;
    const style = backgroundImageStyles(url);
    const classes = classnames_default()('wp-block-cover-image', dimRatioToClassV1(dimRatio), {
      'has-background-dim': dimRatio !== 0,
      'has-parallax': hasParallax
    }, align ? `align${align}` : null);
    return (0,external_wp_element_namespaceObject.createElement)("section", {
      className: classes,
      style: style
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "h2",
      value: title
    }));
  },

  migrate(attributes) {
    const newAttribs = { ...attributes,
      dimRatio: !attributes.url ? 100 : attributes.dimRatio,
      tagName: !attributes.tagName ? 'div' : attributes.tagName
    };
    const {
      title,
      contentAlign,
      align,
      ...restAttributes
    } = newAttribs;
    return [restAttributes, [(0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
      content: attributes.title,
      align: attributes.contentAlign,
      fontSize: 'large',
      placeholder: (0,external_wp_i18n_namespaceObject.__)('Write title…')
    })]];
  }

};
/* harmony default export */ var cover_deprecated = ([deprecated_v11, deprecated_v10, v9, v8, v7, v6, v5, v4, v3, v2, cover_deprecated_v1]);

;// CONCATENATED MODULE: ./node_modules/colord/index.mjs
var r={grad:.9,turn:360,rad:360/(2*Math.PI)},t=function(r){return"string"==typeof r?r.length>0:"number"==typeof r},n=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=Math.pow(10,t)),Math.round(n*r)/n+0},e=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=1),r>n?n:r>t?r:t},u=function(r){return(r=isFinite(r)?r%360:0)>0?r:r+360},a=function(r){return{r:e(r.r,0,255),g:e(r.g,0,255),b:e(r.b,0,255),a:e(r.a)}},o=function(r){return{r:n(r.r),g:n(r.g),b:n(r.b),a:n(r.a,3)}},i=/^#([0-9a-f]{3,8})$/i,s=function(r){var t=r.toString(16);return t.length<2?"0"+t:t},h=function(r){var t=r.r,n=r.g,e=r.b,u=r.a,a=Math.max(t,n,e),o=a-Math.min(t,n,e),i=o?a===t?(n-e)/o:a===n?2+(e-t)/o:4+(t-n)/o:0;return{h:60*(i<0?i+6:i),s:a?o/a*100:0,v:a/255*100,a:u}},b=function(r){var t=r.h,n=r.s,e=r.v,u=r.a;t=t/360*6,n/=100,e/=100;var a=Math.floor(t),o=e*(1-n),i=e*(1-(t-a)*n),s=e*(1-(1-t+a)*n),h=a%6;return{r:255*[e,i,o,o,s,e][h],g:255*[s,e,e,i,o,o][h],b:255*[o,o,s,e,e,i][h],a:u}},g=function(r){return{h:u(r.h),s:e(r.s,0,100),l:e(r.l,0,100),a:e(r.a)}},d=function(r){return{h:n(r.h),s:n(r.s),l:n(r.l),a:n(r.a,3)}},f=function(r){return b((n=(t=r).s,{h:t.h,s:(n*=((e=t.l)<50?e:100-e)/100)>0?2*n/(e+n)*100:0,v:e+n,a:t.a}));var t,n,e},c=function(r){return{h:(t=h(r)).h,s:(u=(200-(n=t.s))*(e=t.v)/100)>0&&u<200?n*e/100/(u<=100?u:200-u)*100:0,l:u/2,a:t.a};var t,n,e,u},l=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s*,\s*([+-]?\d*\.?\d+)%\s*,\s*([+-]?\d*\.?\d+)%\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,p=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s+([+-]?\d*\.?\d+)%\s+([+-]?\d*\.?\d+)%\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,v=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,m=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,y={string:[[function(r){var t=i.exec(r);return t?(r=t[1]).length<=4?{r:parseInt(r[0]+r[0],16),g:parseInt(r[1]+r[1],16),b:parseInt(r[2]+r[2],16),a:4===r.length?n(parseInt(r[3]+r[3],16)/255,2):1}:6===r.length||8===r.length?{r:parseInt(r.substr(0,2),16),g:parseInt(r.substr(2,2),16),b:parseInt(r.substr(4,2),16),a:8===r.length?n(parseInt(r.substr(6,2),16)/255,2):1}:null:null},"hex"],[function(r){var t=v.exec(r)||m.exec(r);return t?t[2]!==t[4]||t[4]!==t[6]?null:a({r:Number(t[1])/(t[2]?100/255:1),g:Number(t[3])/(t[4]?100/255:1),b:Number(t[5])/(t[6]?100/255:1),a:void 0===t[7]?1:Number(t[7])/(t[8]?100:1)}):null},"rgb"],[function(t){var n=l.exec(t)||p.exec(t);if(!n)return null;var e,u,a=g({h:(e=n[1],u=n[2],void 0===u&&(u="deg"),Number(e)*(r[u]||1)),s:Number(n[3]),l:Number(n[4]),a:void 0===n[5]?1:Number(n[5])/(n[6]?100:1)});return f(a)},"hsl"]],object:[[function(r){var n=r.r,e=r.g,u=r.b,o=r.a,i=void 0===o?1:o;return t(n)&&t(e)&&t(u)?a({r:Number(n),g:Number(e),b:Number(u),a:Number(i)}):null},"rgb"],[function(r){var n=r.h,e=r.s,u=r.l,a=r.a,o=void 0===a?1:a;if(!t(n)||!t(e)||!t(u))return null;var i=g({h:Number(n),s:Number(e),l:Number(u),a:Number(o)});return f(i)},"hsl"],[function(r){var n=r.h,a=r.s,o=r.v,i=r.a,s=void 0===i?1:i;if(!t(n)||!t(a)||!t(o))return null;var h=function(r){return{h:u(r.h),s:e(r.s,0,100),v:e(r.v,0,100),a:e(r.a)}}({h:Number(n),s:Number(a),v:Number(o),a:Number(s)});return b(h)},"hsv"]]},N=function(r,t){for(var n=0;n<t.length;n++){var e=t[n][0](r);if(e)return[e,t[n][1]]}return[null,void 0]},x=function(r){return"string"==typeof r?N(r.trim(),y.string):"object"==typeof r&&null!==r?N(r,y.object):[null,void 0]},I=function(r){return x(r)[1]},M=function(r,t){var n=c(r);return{h:n.h,s:e(n.s+100*t,0,100),l:n.l,a:n.a}},H=function(r){return(299*r.r+587*r.g+114*r.b)/1e3/255},$=function(r,t){var n=c(r);return{h:n.h,s:n.s,l:e(n.l+100*t,0,100),a:n.a}},j=function(){function r(r){this.parsed=x(r)[0],this.rgba=this.parsed||{r:0,g:0,b:0,a:1}}return r.prototype.isValid=function(){return null!==this.parsed},r.prototype.brightness=function(){return n(H(this.rgba),2)},r.prototype.isDark=function(){return H(this.rgba)<.5},r.prototype.isLight=function(){return H(this.rgba)>=.5},r.prototype.toHex=function(){return r=o(this.rgba),t=r.r,e=r.g,u=r.b,i=(a=r.a)<1?s(n(255*a)):"","#"+s(t)+s(e)+s(u)+i;var r,t,e,u,a,i},r.prototype.toRgb=function(){return o(this.rgba)},r.prototype.toRgbString=function(){return r=o(this.rgba),t=r.r,n=r.g,e=r.b,(u=r.a)<1?"rgba("+t+", "+n+", "+e+", "+u+")":"rgb("+t+", "+n+", "+e+")";var r,t,n,e,u},r.prototype.toHsl=function(){return d(c(this.rgba))},r.prototype.toHslString=function(){return r=d(c(this.rgba)),t=r.h,n=r.s,e=r.l,(u=r.a)<1?"hsla("+t+", "+n+"%, "+e+"%, "+u+")":"hsl("+t+", "+n+"%, "+e+"%)";var r,t,n,e,u},r.prototype.toHsv=function(){return r=h(this.rgba),{h:n(r.h),s:n(r.s),v:n(r.v),a:n(r.a,3)};var r},r.prototype.invert=function(){return w({r:255-(r=this.rgba).r,g:255-r.g,b:255-r.b,a:r.a});var r},r.prototype.saturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,r))},r.prototype.desaturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,-r))},r.prototype.grayscale=function(){return w(M(this.rgba,-1))},r.prototype.lighten=function(r){return void 0===r&&(r=.1),w($(this.rgba,r))},r.prototype.darken=function(r){return void 0===r&&(r=.1),w($(this.rgba,-r))},r.prototype.rotate=function(r){return void 0===r&&(r=15),this.hue(this.hue()+r)},r.prototype.alpha=function(r){return"number"==typeof r?w({r:(t=this.rgba).r,g:t.g,b:t.b,a:r}):n(this.rgba.a,3);var t},r.prototype.hue=function(r){var t=c(this.rgba);return"number"==typeof r?w({h:r,s:t.s,l:t.l,a:t.a}):n(t.h)},r.prototype.isEqual=function(r){return this.toHex()===w(r).toHex()},r}(),w=function(r){return r instanceof j?r:new j(r)},S=[],k=function(r){r.forEach(function(r){S.indexOf(r)<0&&(r(j,y),S.push(r))})},E=function(){return new j({r:255*Math.random(),g:255*Math.random(),b:255*Math.random()})};

;// CONCATENATED MODULE: ./node_modules/colord/plugins/names.mjs
/* harmony default export */ function names(e,f){var a={white:"#ffffff",bisque:"#ffe4c4",blue:"#0000ff",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",antiquewhite:"#faebd7",aqua:"#00ffff",azure:"#f0ffff",whitesmoke:"#f5f5f5",papayawhip:"#ffefd5",plum:"#dda0dd",blanchedalmond:"#ffebcd",black:"#000000",gold:"#ffd700",goldenrod:"#daa520",gainsboro:"#dcdcdc",cornsilk:"#fff8dc",cornflowerblue:"#6495ed",burlywood:"#deb887",aquamarine:"#7fffd4",beige:"#f5f5dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkkhaki:"#bdb76b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",peachpuff:"#ffdab9",darkmagenta:"#8b008b",darkred:"#8b0000",darkorchid:"#9932cc",darkorange:"#ff8c00",darkslateblue:"#483d8b",gray:"#808080",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",deeppink:"#ff1493",deepskyblue:"#00bfff",wheat:"#f5deb3",firebrick:"#b22222",floralwhite:"#fffaf0",ghostwhite:"#f8f8ff",darkviolet:"#9400d3",magenta:"#ff00ff",green:"#008000",dodgerblue:"#1e90ff",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",blueviolet:"#8a2be2",forestgreen:"#228b22",lawngreen:"#7cfc00",indianred:"#cd5c5c",indigo:"#4b0082",fuchsia:"#ff00ff",brown:"#a52a2a",maroon:"#800000",mediumblue:"#0000cd",lightcoral:"#f08080",darkturquoise:"#00ced1",lightcyan:"#e0ffff",ivory:"#fffff0",lightyellow:"#ffffe0",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",linen:"#faf0e6",mediumaquamarine:"#66cdaa",lemonchiffon:"#fffacd",lime:"#00ff00",khaki:"#f0e68c",mediumseagreen:"#3cb371",limegreen:"#32cd32",mediumspringgreen:"#00fa9a",lightskyblue:"#87cefa",lightblue:"#add8e6",midnightblue:"#191970",lightpink:"#ffb6c1",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",mintcream:"#f5fffa",lightslategray:"#778899",lightslategrey:"#778899",navajowhite:"#ffdead",navy:"#000080",mediumvioletred:"#c71585",powderblue:"#b0e0e6",palegoldenrod:"#eee8aa",oldlace:"#fdf5e6",paleturquoise:"#afeeee",mediumturquoise:"#48d1cc",mediumorchid:"#ba55d3",rebeccapurple:"#663399",lightsteelblue:"#b0c4de",mediumslateblue:"#7b68ee",thistle:"#d8bfd8",tan:"#d2b48c",orchid:"#da70d6",mediumpurple:"#9370db",purple:"#800080",pink:"#ffc0cb",skyblue:"#87ceeb",springgreen:"#00ff7f",palegreen:"#98fb98",red:"#ff0000",yellow:"#ffff00",slateblue:"#6a5acd",lavenderblush:"#fff0f5",peru:"#cd853f",palevioletred:"#db7093",violet:"#ee82ee",teal:"#008080",slategray:"#708090",slategrey:"#708090",aliceblue:"#f0f8ff",darkseagreen:"#8fbc8f",darkolivegreen:"#556b2f",greenyellow:"#adff2f",seagreen:"#2e8b57",seashell:"#fff5ee",tomato:"#ff6347",silver:"#c0c0c0",sienna:"#a0522d",lavender:"#e6e6fa",lightgreen:"#90ee90",orange:"#ffa500",orangered:"#ff4500",steelblue:"#4682b4",royalblue:"#4169e1",turquoise:"#40e0d0",yellowgreen:"#9acd32",salmon:"#fa8072",saddlebrown:"#8b4513",sandybrown:"#f4a460",rosybrown:"#bc8f8f",darksalmon:"#e9967a",lightgoldenrodyellow:"#fafad2",snow:"#fffafa",lightgrey:"#d3d3d3",lightgray:"#d3d3d3",dimgray:"#696969",dimgrey:"#696969",olivedrab:"#6b8e23",olive:"#808000"},r={};for(var d in a)r[a[d]]=d;var l={};e.prototype.toName=function(f){if(!(this.rgba.a||this.rgba.r||this.rgba.g||this.rgba.b))return"transparent";var d,i,n=r[this.toHex()];if(n)return n;if(null==f?void 0:f.closest){var o=this.toRgb(),t=1/0,b="black";if(!l.length)for(var c in a)l[c]=new e(a[c]).toRgb();for(var g in a){var u=(d=o,i=l[g],Math.pow(d.r-i.r,2)+Math.pow(d.g-i.g,2)+Math.pow(d.b-i.b,2));u<t&&(t=u,b=g)}return b}};f.string.push([function(f){var r=f.toLowerCase(),d="transparent"===r?"#0000":a[r];return d?new e(d).toRgb():null},"name"])}

;// CONCATENATED MODULE: ./node_modules/fast-average-color/dist/index.esm.js
/*! Fast Average Color | © 2023 Denis Seleznev | MIT License | https://github.com/fast-average-color/fast-average-color */
function toHex(num) {
    var str = num.toString(16);
    return str.length === 1 ? '0' + str : str;
}
function arrayToHex(arr) {
    return '#' + arr.map(toHex).join('');
}
function isDark(color) {
    // http://www.w3.org/TR/AERT#color-contrast
    var result = (color[0] * 299 + color[1] * 587 + color[2] * 114) / 1000;
    return result < 128;
}
function prepareIgnoredColor(color) {
    if (!color) {
        return [];
    }
    return isRGBArray(color) ? color : [color];
}
function isRGBArray(value) {
    return Array.isArray(value[0]);
}
function isIgnoredColor(data, index, ignoredColor) {
    for (var i = 0; i < ignoredColor.length; i++) {
        if (isIgnoredColorAsNumbers(data, index, ignoredColor[i])) {
            return true;
        }
    }
    return false;
}
function isIgnoredColorAsNumbers(data, index, ignoredColor) {
    switch (ignoredColor.length) {
        case 3:
            // [red, green, blue]
            if (isIgnoredRGBColor(data, index, ignoredColor)) {
                return true;
            }
            break;
        case 4:
            // [red, green, blue, alpha]
            if (isIgnoredRGBAColor(data, index, ignoredColor)) {
                return true;
            }
            break;
        case 5:
            // [red, green, blue, alpha, threshold]
            if (isIgnoredRGBAColorWithThreshold(data, index, ignoredColor)) {
                return true;
            }
            break;
        default:
            return false;
    }
}
function isIgnoredRGBColor(data, index, ignoredColor) {
    // Ignore if the pixel are transparent.
    if (data[index + 3] !== 255) {
        return true;
    }
    if (data[index] === ignoredColor[0] &&
        data[index + 1] === ignoredColor[1] &&
        data[index + 2] === ignoredColor[2]) {
        return true;
    }
    return false;
}
function isIgnoredRGBAColor(data, index, ignoredColor) {
    if (data[index + 3] && ignoredColor[3]) {
        return data[index] === ignoredColor[0] &&
            data[index + 1] === ignoredColor[1] &&
            data[index + 2] === ignoredColor[2] &&
            data[index + 3] === ignoredColor[3];
    }
    // Ignore rgb components if the pixel are fully transparent.
    return data[index + 3] === ignoredColor[3];
}
function inRange(colorComponent, ignoredColorComponent, value) {
    return colorComponent >= (ignoredColorComponent - value) &&
        colorComponent <= (ignoredColorComponent + value);
}
function isIgnoredRGBAColorWithThreshold(data, index, ignoredColor) {
    var redIgnored = ignoredColor[0];
    var greenIgnored = ignoredColor[1];
    var blueIgnored = ignoredColor[2];
    var alphaIgnored = ignoredColor[3];
    var threshold = ignoredColor[4];
    var alphaData = data[index + 3];
    var alphaInRange = inRange(alphaData, alphaIgnored, threshold);
    if (!alphaIgnored) {
        return alphaInRange;
    }
    if (!alphaData && alphaInRange) {
        return true;
    }
    if (inRange(data[index], redIgnored, threshold) &&
        inRange(data[index + 1], greenIgnored, threshold) &&
        inRange(data[index + 2], blueIgnored, threshold) &&
        alphaInRange) {
        return true;
    }
    return false;
}

var DEFAULT_DOMINANT_DIVIDER = 24;
function dominantAlgorithm(arr, len, options) {
    var colorHash = {};
    var divider = options.dominantDivider || DEFAULT_DOMINANT_DIVIDER;
    var ignoredColor = options.ignoredColor;
    var step = options.step;
    var max = [0, 0, 0, 0, 0];
    for (var i = 0; i < len; i += step) {
        var red = arr[i];
        var green = arr[i + 1];
        var blue = arr[i + 2];
        var alpha = arr[i + 3];
        if (ignoredColor && isIgnoredColor(arr, i, ignoredColor)) {
            continue;
        }
        var key = Math.round(red / divider) + ',' +
            Math.round(green / divider) + ',' +
            Math.round(blue / divider);
        if (colorHash[key]) {
            colorHash[key] = [
                colorHash[key][0] + red * alpha,
                colorHash[key][1] + green * alpha,
                colorHash[key][2] + blue * alpha,
                colorHash[key][3] + alpha,
                colorHash[key][4] + 1
            ];
        }
        else {
            colorHash[key] = [red * alpha, green * alpha, blue * alpha, alpha, 1];
        }
        if (max[4] < colorHash[key][4]) {
            max = colorHash[key];
        }
    }
    var redTotal = max[0];
    var greenTotal = max[1];
    var blueTotal = max[2];
    var alphaTotal = max[3];
    var count = max[4];
    return alphaTotal ? [
        Math.round(redTotal / alphaTotal),
        Math.round(greenTotal / alphaTotal),
        Math.round(blueTotal / alphaTotal),
        Math.round(alphaTotal / count)
    ] : options.defaultColor;
}

function simpleAlgorithm(arr, len, options) {
    var redTotal = 0;
    var greenTotal = 0;
    var blueTotal = 0;
    var alphaTotal = 0;
    var count = 0;
    var ignoredColor = options.ignoredColor;
    var step = options.step;
    for (var i = 0; i < len; i += step) {
        var alpha = arr[i + 3];
        var red = arr[i] * alpha;
        var green = arr[i + 1] * alpha;
        var blue = arr[i + 2] * alpha;
        if (ignoredColor && isIgnoredColor(arr, i, ignoredColor)) {
            continue;
        }
        redTotal += red;
        greenTotal += green;
        blueTotal += blue;
        alphaTotal += alpha;
        count++;
    }
    return alphaTotal ? [
        Math.round(redTotal / alphaTotal),
        Math.round(greenTotal / alphaTotal),
        Math.round(blueTotal / alphaTotal),
        Math.round(alphaTotal / count)
    ] : options.defaultColor;
}

function sqrtAlgorithm(arr, len, options) {
    var redTotal = 0;
    var greenTotal = 0;
    var blueTotal = 0;
    var alphaTotal = 0;
    var count = 0;
    var ignoredColor = options.ignoredColor;
    var step = options.step;
    for (var i = 0; i < len; i += step) {
        var red = arr[i];
        var green = arr[i + 1];
        var blue = arr[i + 2];
        var alpha = arr[i + 3];
        if (ignoredColor && isIgnoredColor(arr, i, ignoredColor)) {
            continue;
        }
        redTotal += red * red * alpha;
        greenTotal += green * green * alpha;
        blueTotal += blue * blue * alpha;
        alphaTotal += alpha;
        count++;
    }
    return alphaTotal ? [
        Math.round(Math.sqrt(redTotal / alphaTotal)),
        Math.round(Math.sqrt(greenTotal / alphaTotal)),
        Math.round(Math.sqrt(blueTotal / alphaTotal)),
        Math.round(alphaTotal / count)
    ] : options.defaultColor;
}

function getDefaultColor(options) {
    return getOption(options, 'defaultColor', [0, 0, 0, 0]);
}
function getOption(options, name, defaultValue) {
    return (options[name] === undefined ? defaultValue : options[name]);
}

var MIN_SIZE = 10;
var MAX_SIZE = 100;
function isSvg(filename) {
    return filename.search(/\.svg(\?|$)/i) !== -1;
}
function getOriginalSize(resource) {
    if (isInstanceOfHTMLImageElement(resource)) {
        var width = resource.naturalWidth;
        var height = resource.naturalHeight;
        // For SVG images with only viewBox attribute
        if (!resource.naturalWidth && isSvg(resource.src)) {
            width = height = MAX_SIZE;
        }
        return {
            width: width,
            height: height,
        };
    }
    if (isInstanceOfHTMLVideoElement(resource)) {
        return {
            width: resource.videoWidth,
            height: resource.videoHeight
        };
    }
    return {
        width: resource.width,
        height: resource.height
    };
}
function getSrc(resource) {
    if (isInstanceOfHTMLCanvasElement(resource)) {
        return 'canvas';
    }
    if (isInstanceOfOffscreenCanvas(resource)) {
        return 'offscreencanvas';
    }
    if (isInstanceOfImageBitmap(resource)) {
        return 'imagebitmap';
    }
    return resource.src;
}
function isInstanceOfHTMLImageElement(resource) {
    return typeof HTMLImageElement !== 'undefined' && resource instanceof HTMLImageElement;
}
var hasOffscreenCanvas = typeof OffscreenCanvas !== 'undefined';
function isInstanceOfOffscreenCanvas(resource) {
    return hasOffscreenCanvas && resource instanceof OffscreenCanvas;
}
function isInstanceOfHTMLVideoElement(resource) {
    return typeof HTMLVideoElement !== 'undefined' && resource instanceof HTMLVideoElement;
}
function isInstanceOfHTMLCanvasElement(resource) {
    return typeof HTMLCanvasElement !== 'undefined' && resource instanceof HTMLCanvasElement;
}
function isInstanceOfImageBitmap(resource) {
    return typeof ImageBitmap !== 'undefined' && resource instanceof ImageBitmap;
}
function prepareSizeAndPosition(originalSize, options) {
    var srcLeft = getOption(options, 'left', 0);
    var srcTop = getOption(options, 'top', 0);
    var srcWidth = getOption(options, 'width', originalSize.width);
    var srcHeight = getOption(options, 'height', originalSize.height);
    var destWidth = srcWidth;
    var destHeight = srcHeight;
    if (options.mode === 'precision') {
        return {
            srcLeft: srcLeft,
            srcTop: srcTop,
            srcWidth: srcWidth,
            srcHeight: srcHeight,
            destWidth: destWidth,
            destHeight: destHeight
        };
    }
    var factor;
    if (srcWidth > srcHeight) {
        factor = srcWidth / srcHeight;
        destWidth = MAX_SIZE;
        destHeight = Math.round(destWidth / factor);
    }
    else {
        factor = srcHeight / srcWidth;
        destHeight = MAX_SIZE;
        destWidth = Math.round(destHeight / factor);
    }
    if (destWidth > srcWidth || destHeight > srcHeight ||
        destWidth < MIN_SIZE || destHeight < MIN_SIZE) {
        destWidth = srcWidth;
        destHeight = srcHeight;
    }
    return {
        srcLeft: srcLeft,
        srcTop: srcTop,
        srcWidth: srcWidth,
        srcHeight: srcHeight,
        destWidth: destWidth,
        destHeight: destHeight
    };
}
var isWebWorkers = typeof window === 'undefined';
function makeCanvas() {
    if (isWebWorkers) {
        return hasOffscreenCanvas ? new OffscreenCanvas(1, 1) : null;
    }
    return document.createElement('canvas');
}

var ERROR_PREFIX = 'FastAverageColor: ';
function getError(message) {
    return Error(ERROR_PREFIX + message);
}
function outputError(error, silent) {
    if (!silent) {
        console.error(error);
    }
}

var FastAverageColor = /** @class */ (function () {
    function FastAverageColor() {
        this.canvas = null;
        this.ctx = null;
    }
    FastAverageColor.prototype.getColorAsync = function (resource, options) {
        if (!resource) {
            return Promise.reject(getError('call .getColorAsync() without resource'));
        }
        if (typeof resource === 'string') {
            // Web workers
            if (typeof Image === 'undefined') {
                return Promise.reject(getError('resource as string is not supported in this environment'));
            }
            var img = new Image();
            img.crossOrigin = options && options.crossOrigin || '';
            img.src = resource;
            return this.bindImageEvents(img, options);
        }
        else if (isInstanceOfHTMLImageElement(resource) && !resource.complete) {
            return this.bindImageEvents(resource, options);
        }
        else {
            var result = this.getColor(resource, options);
            return result.error ? Promise.reject(result.error) : Promise.resolve(result);
        }
    };
    /**
     * Get the average color from images, videos and canvas.
     */
    FastAverageColor.prototype.getColor = function (resource, options) {
        options = options || {};
        var defaultColor = getDefaultColor(options);
        if (!resource) {
            var error = getError('call .getColor() without resource');
            outputError(error, options.silent);
            return this.prepareResult(defaultColor, error);
        }
        var originalSize = getOriginalSize(resource);
        var size = prepareSizeAndPosition(originalSize, options);
        if (!size.srcWidth || !size.srcHeight || !size.destWidth || !size.destHeight) {
            var error = getError("incorrect sizes for resource \"".concat(getSrc(resource), "\""));
            outputError(error, options.silent);
            return this.prepareResult(defaultColor, error);
        }
        if (!this.canvas) {
            this.canvas = makeCanvas();
            if (!this.canvas) {
                var error = getError('OffscreenCanvas is not supported in this browser');
                outputError(error, options.silent);
                return this.prepareResult(defaultColor, error);
            }
        }
        if (!this.ctx) {
            this.ctx = this.canvas.getContext('2d', { willReadFrequently: true });
            if (!this.ctx) {
                var error = getError('Canvas Context 2D is not supported in this browser');
                outputError(error, options.silent);
                return this.prepareResult(defaultColor);
            }
            this.ctx.imageSmoothingEnabled = false;
        }
        this.canvas.width = size.destWidth;
        this.canvas.height = size.destHeight;
        try {
            this.ctx.clearRect(0, 0, size.destWidth, size.destHeight);
            this.ctx.drawImage(resource, size.srcLeft, size.srcTop, size.srcWidth, size.srcHeight, 0, 0, size.destWidth, size.destHeight);
            var bitmapData = this.ctx.getImageData(0, 0, size.destWidth, size.destHeight).data;
            return this.prepareResult(this.getColorFromArray4(bitmapData, options));
        }
        catch (originalError) {
            var error = getError("security error (CORS) for resource ".concat(getSrc(resource), ".\nDetails: https://developer.mozilla.org/en/docs/Web/HTML/CORS_enabled_image"));
            outputError(error, options.silent);
            !options.silent && console.error(originalError);
            return this.prepareResult(defaultColor, error);
        }
    };
    /**
     * Get the average color from a array when 1 pixel is 4 bytes.
     */
    FastAverageColor.prototype.getColorFromArray4 = function (arr, options) {
        options = options || {};
        var bytesPerPixel = 4;
        var arrLength = arr.length;
        var defaultColor = getDefaultColor(options);
        if (arrLength < bytesPerPixel) {
            return defaultColor;
        }
        var len = arrLength - arrLength % bytesPerPixel;
        var step = (options.step || 1) * bytesPerPixel;
        var algorithm;
        switch (options.algorithm || 'sqrt') {
            case 'simple':
                algorithm = simpleAlgorithm;
                break;
            case 'sqrt':
                algorithm = sqrtAlgorithm;
                break;
            case 'dominant':
                algorithm = dominantAlgorithm;
                break;
            default:
                throw getError("".concat(options.algorithm, " is unknown algorithm"));
        }
        return algorithm(arr, len, {
            defaultColor: defaultColor,
            ignoredColor: prepareIgnoredColor(options.ignoredColor),
            step: step,
            dominantDivider: options.dominantDivider,
        });
    };
    /**
     * Get color data from value ([r, g, b, a]).
     */
    FastAverageColor.prototype.prepareResult = function (value, error) {
        var rgb = value.slice(0, 3);
        var rgba = [value[0], value[1], value[2], value[3] / 255];
        var isDarkColor = isDark(value);
        return {
            value: [value[0], value[1], value[2], value[3]],
            rgb: 'rgb(' + rgb.join(',') + ')',
            rgba: 'rgba(' + rgba.join(',') + ')',
            hex: arrayToHex(rgb),
            hexa: arrayToHex(value),
            isDark: isDarkColor,
            isLight: !isDarkColor,
            error: error,
        };
    };
    /**
     * Destroy the instance.
     */
    FastAverageColor.prototype.destroy = function () {
        if (this.canvas) {
            this.canvas.width = 1;
            this.canvas.height = 1;
            this.canvas = null;
        }
        this.ctx = null;
    };
    FastAverageColor.prototype.bindImageEvents = function (resource, options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var onload = function () {
                unbindEvents();
                var result = _this.getColor(resource, options);
                if (result.error) {
                    reject(result.error);
                }
                else {
                    resolve(result);
                }
            };
            var onerror = function () {
                unbindEvents();
                reject(getError("Error loading image \"".concat(resource.src, "\"")));
            };
            var onabort = function () {
                unbindEvents();
                reject(getError("Image \"".concat(resource.src, "\" loading aborted")));
            };
            var unbindEvents = function () {
                resource.removeEventListener('load', onload);
                resource.removeEventListener('error', onerror);
                resource.removeEventListener('abort', onabort);
            };
            resource.addEventListener('load', onload);
            resource.addEventListener('error', onerror);
            resource.addEventListener('abort', onabort);
        });
    };
    return FastAverageColor;
}());



;// CONCATENATED MODULE: external ["wp","hooks"]
var external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/edit/use-cover-is-dark.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




function retrieveFastAverageColor() {
  if (!retrieveFastAverageColor.fastAverageColor) {
    retrieveFastAverageColor.fastAverageColor = new FastAverageColor();
  }

  return retrieveFastAverageColor.fastAverageColor;
}
/**
 * useCoverIsDark is a hook that returns a boolean variable specifying if the cover
 * background is dark or not.
 *
 * @param {?string} url          Url of the media background.
 * @param {?number} dimRatio     Transparency of the overlay color. If an image and
 *                               color are set, dimRatio is used to decide what is used
 *                               for background darkness checking purposes.
 * @param {?string} overlayColor String containing the overlay color value if one exists.
 *
 * @return {boolean} True if the cover background is considered "dark" and false otherwise.
 */


function useCoverIsDark(url, dimRatio = 50, overlayColor) {
  const [isDark, setIsDark] = (0,external_wp_element_namespaceObject.useState)(false);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // If opacity is lower than 50 the dominant color is the image or video color,
    // so use that color for the dark mode computation.
    if (url && dimRatio <= 50) {
      const imgCrossOrigin = (0,external_wp_hooks_namespaceObject.applyFilters)('media.crossOrigin', undefined, url);
      retrieveFastAverageColor().getColorAsync(url, {
        // Previously the default color was white, but that changed
        // in v6.0.0 so it has to be manually set now.
        defaultColor: [255, 255, 255, 255],
        // Errors that come up don't reject the promise, so error
        // logging has to be silenced with this option.
        silent: "production" === 'production',
        crossOrigin: imgCrossOrigin
      }).then(color => setIsDark(color.isDark));
    }
  }, [url, url && dimRatio <= 50, setIsDark]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // If opacity is greater than 50 the dominant color is the overlay color,
    // so use that color for the dark mode computation.
    if (dimRatio > 50 || !url) {
      if (!overlayColor) {
        // If no overlay color exists the overlay color is black (isDark )
        setIsDark(true);
        return;
      }

      setIsDark(w(overlayColor).isDark());
    }
  }, [overlayColor, dimRatio > 50 || !url, setIsDark]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!url && !overlayColor) {
      // Reset isDark.
      setIsDark(false);
    }
  }, [!url && !overlayColor, setIsDark]);
  return isDark;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/edit/inspector-controls.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function CoverHeightInput({
  onChange,
  onUnitChange,
  unit = 'px',
  value = ''
}) {
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(external_wp_components_namespaceObject.__experimentalUnitControl);
  const inputId = `block-cover-height-input-${instanceId}`;
  const isPx = unit === 'px';
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: (0,external_wp_blockEditor_namespaceObject.useSetting)('spacing.units') || ['px', 'em', 'rem', 'vw', 'vh'],
    defaultValues: {
      px: 430,
      '%': 20,
      em: 20,
      rem: 20,
      vw: 20,
      vh: 50
    }
  });

  const handleOnChange = unprocessedValue => {
    const inputValue = unprocessedValue !== '' ? parseFloat(unprocessedValue) : undefined;

    if (isNaN(inputValue) && inputValue !== undefined) {
      return;
    }

    onChange(inputValue);
  };

  const computedValue = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const [parsedQuantity] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value);
    return [parsedQuantity, unit].join('');
  }, [unit, value]);
  const min = isPx ? COVER_MIN_HEIGHT : 0;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Minimum height of cover'),
    id: inputId,
    isResetValueOnUnitChange: true,
    min: min,
    onChange: handleOnChange,
    onUnitChange: onUnitChange,
    __unstableInputWidth: '80px',
    units: units,
    value: computedValue
  });
}

function CoverInspectorControls({
  attributes,
  setAttributes,
  clientId,
  setOverlayColor,
  coverRef,
  currentSettings
}) {
  const {
    useFeaturedImage,
    dimRatio,
    focalPoint,
    hasParallax,
    isRepeated,
    minHeight,
    minHeightUnit,
    alt,
    tagName
  } = attributes;
  const {
    isVideoBackground,
    isImageBackground,
    mediaElement,
    url,
    isImgElement,
    overlayColor
  } = currentSettings;

  const {
    gradientValue,
    setGradient
  } = (0,external_wp_blockEditor_namespaceObject.__experimentalUseGradient)();

  const toggleParallax = () => {
    setAttributes({
      hasParallax: !hasParallax,
      ...(!hasParallax ? {
        focalPoint: undefined
      } : {})
    });
  };

  const toggleIsRepeated = () => {
    setAttributes({
      isRepeated: !isRepeated
    });
  };

  const showFocalPointPicker = isVideoBackground || isImageBackground && (!hasParallax || isRepeated);

  const imperativeFocalPointPreview = value => {
    const [styleOfRef, property] = mediaElement.current ? [mediaElement.current.style, 'objectPosition'] : [coverRef.current.style, 'backgroundPosition'];
    styleOfRef[property] = mediaPosition(value);
  };

  const colorGradientSettings = (0,external_wp_blockEditor_namespaceObject.__experimentalUseMultipleOriginColorsAndGradients)();
  const htmlElementMessages = {
    header: (0,external_wp_i18n_namespaceObject.__)('The <header> element should represent introductory content, typically a group of introductory or navigational aids.'),
    main: (0,external_wp_i18n_namespaceObject.__)('The <main> element should be used for the primary content of your document only. '),
    section: (0,external_wp_i18n_namespaceObject.__)("The <section> element should represent a standalone portion of the document that can't be better represented by another element."),
    article: (0,external_wp_i18n_namespaceObject.__)('The <article> element should represent a self-contained, syndicatable portion of the document.'),
    aside: (0,external_wp_i18n_namespaceObject.__)("The <aside> element should represent a portion of a document whose content is only indirectly related to the document's main content."),
    footer: (0,external_wp_i18n_namespaceObject.__)('The <footer> element should represent a footer for its nearest sectioning element (e.g.: <section>, <article>, <main> etc.).')
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, !!url && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Media settings')
  }, isImageBackground && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Fixed background'),
    checked: hasParallax,
    onChange: toggleParallax
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Repeated background'),
    checked: isRepeated,
    onChange: toggleIsRepeated
  })), showFocalPointPicker && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FocalPointPicker, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Focal point picker'),
    url: url,
    value: focalPoint,
    onDragStart: imperativeFocalPointPreview,
    onDrag: imperativeFocalPointPreview,
    onChange: newFocalPoint => setAttributes({
      focalPoint: newFocalPoint
    })
  }), !useFeaturedImage && url && isImageBackground && isImgElement && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextareaControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Alternative text'),
    value: alt,
    onChange: newAlt => setAttributes({
      alt: newAlt
    }),
    help: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
      href: "https://www.w3.org/WAI/tutorials/images/decision-tree"
    }, (0,external_wp_i18n_namespaceObject.__)('Describe the purpose of the image.')), (0,external_wp_element_namespaceObject.createElement)("br", null), (0,external_wp_i18n_namespaceObject.__)('Leave empty if decorative.'))
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelRow, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "secondary",
    isSmall: true,
    className: "block-library-cover__reset-button",
    onClick: () => setAttributes({
      url: undefined,
      id: undefined,
      backgroundType: undefined,
      focalPoint: undefined,
      hasParallax: undefined,
      isRepeated: undefined,
      useFeaturedImage: false
    })
  }, (0,external_wp_i18n_namespaceObject.__)('Clear Media'))))), colorGradientSettings.hasColorsOrGradients && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "color"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalColorGradientSettingsDropdown, {
    __experimentalIsRenderedInSidebar: true,
    settings: [{
      colorValue: overlayColor.color,
      gradientValue,
      label: (0,external_wp_i18n_namespaceObject.__)('Overlay'),
      onColorChange: setOverlayColor,
      onGradientChange: setGradient,
      isShownByDefault: true,
      resetAllFilter: () => ({
        overlayColor: undefined,
        customOverlayColor: undefined,
        gradient: undefined,
        customGradient: undefined
      })
    }],
    panelId: clientId,
    ...colorGradientSettings
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    hasValue: () => {
      // If there's a media background the dimRatio will be
      // defaulted to 50 whereas it will be 100 for colors.
      return dimRatio === undefined ? false : dimRatio !== (url ? 50 : 100);
    },
    label: (0,external_wp_i18n_namespaceObject.__)('Overlay opacity'),
    onDeselect: () => setAttributes({
      dimRatio: url ? 50 : 100
    }),
    resetAllFilter: () => ({
      dimRatio: url ? 50 : 100
    }),
    isShownByDefault: true,
    panelId: clientId
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Overlay opacity'),
    value: dimRatio,
    onChange: newDimRation => setAttributes({
      dimRatio: newDimRation
    }),
    min: 0,
    max: 100,
    step: 10,
    required: true
  }))), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "dimensions"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    hasValue: () => !!minHeight,
    label: (0,external_wp_i18n_namespaceObject.__)('Minimum height'),
    onDeselect: () => setAttributes({
      minHeight: undefined,
      minHeightUnit: undefined
    }),
    resetAllFilter: () => ({
      minHeight: undefined,
      minHeightUnit: undefined
    }),
    isShownByDefault: true,
    panelId: clientId
  }, (0,external_wp_element_namespaceObject.createElement)(CoverHeightInput, {
    value: minHeight,
    unit: minHeightUnit,
    onChange: newMinHeight => setAttributes({
      minHeight: newMinHeight
    }),
    onUnitChange: nextUnit => setAttributes({
      minHeightUnit: nextUnit
    })
  }))), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "advanced"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('HTML element'),
    options: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Default (<div>)'),
      value: 'div'
    }, {
      label: '<header>',
      value: 'header'
    }, {
      label: '<main>',
      value: 'main'
    }, {
      label: '<section>',
      value: 'section'
    }, {
      label: '<article>',
      value: 'article'
    }, {
      label: '<aside>',
      value: 'aside'
    }, {
      label: '<footer>',
      value: 'footer'
    }],
    value: tagName,
    onChange: value => setAttributes({
      tagName: value
    }),
    help: htmlElementMessages[tagName]
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/edit/block-controls.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function CoverBlockControls({
  attributes,
  setAttributes,
  onSelectMedia,
  currentSettings,
  toggleUseFeaturedImage
}) {
  const {
    contentPosition,
    id,
    useFeaturedImage,
    minHeight,
    minHeightUnit
  } = attributes;
  const {
    hasInnerBlocks,
    url
  } = currentSettings;
  const [prevMinHeightValue, setPrevMinHeightValue] = (0,external_wp_element_namespaceObject.useState)(minHeight);
  const [prevMinHeightUnit, setPrevMinHeightUnit] = (0,external_wp_element_namespaceObject.useState)(minHeightUnit);
  const isMinFullHeight = minHeightUnit === 'vh' && minHeight === 100;

  const toggleMinFullHeight = () => {
    if (isMinFullHeight) {
      // If there aren't previous values, take the default ones.
      if (prevMinHeightUnit === 'vh' && prevMinHeightValue === 100) {
        return setAttributes({
          minHeight: undefined,
          minHeightUnit: undefined
        });
      } // Set the previous values of height.


      return setAttributes({
        minHeight: prevMinHeightValue,
        minHeightUnit: prevMinHeightUnit
      });
    }

    setPrevMinHeightValue(minHeight);
    setPrevMinHeightUnit(minHeightUnit); // Set full height.

    return setAttributes({
      minHeight: 100,
      minHeightUnit: 'vh'
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalBlockAlignmentMatrixControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Change content position'),
    value: contentPosition,
    onChange: nextPosition => setAttributes({
      contentPosition: nextPosition
    }),
    isDisabled: !hasInnerBlocks
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalBlockFullHeightAligmentControl, {
    isActive: isMinFullHeight,
    onToggle: toggleMinFullHeight,
    isDisabled: !hasInnerBlocks
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "other"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaReplaceFlow, {
    mediaId: id,
    mediaURL: url,
    allowedTypes: shared_ALLOWED_MEDIA_TYPES,
    accept: "image/*,video/*",
    onSelect: onSelectMedia,
    onToggleFeaturedImage: toggleUseFeaturedImage,
    useFeaturedImage: useFeaturedImage,
    name: !url ? (0,external_wp_i18n_namespaceObject.__)('Add Media') : (0,external_wp_i18n_namespaceObject.__)('Replace')
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/edit/cover-placeholder.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function CoverPlaceholder({
  disableMediaButtons = false,
  children,
  onSelectMedia,
  onError,
  style,
  toggleUseFeaturedImage
}) {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
    icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
      icon: library_cover
    }),
    labels: {
      title: (0,external_wp_i18n_namespaceObject.__)('Cover'),
      instructions: (0,external_wp_i18n_namespaceObject.__)('Drag and drop onto this block, upload, or select existing media from your library.')
    },
    onSelect: onSelectMedia,
    accept: "image/*,video/*",
    allowedTypes: shared_ALLOWED_MEDIA_TYPES,
    disableMediaButtons: disableMediaButtons,
    onToggleFeaturedImage: toggleUseFeaturedImage,
    onError: onError,
    style: style
  }, children);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/edit/resizable-cover-popover.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const RESIZABLE_BOX_ENABLE_OPTION = {
  top: false,
  right: false,
  bottom: true,
  left: false,
  topRight: false,
  bottomRight: false,
  bottomLeft: false,
  topLeft: false
};
const {
  ResizableBoxPopover
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
function ResizableCoverPopover({
  className,
  height,
  minHeight,
  onResize,
  onResizeStart,
  onResizeStop,
  showHandle,
  size,
  width,
  ...props
}) {
  const [isResizing, setIsResizing] = (0,external_wp_element_namespaceObject.useState)(false);
  const dimensions = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    height,
    minHeight,
    width
  }), [minHeight, height, width]);
  const resizableBoxProps = {
    className: classnames_default()(className, {
      'is-resizing': isResizing
    }),
    enable: RESIZABLE_BOX_ENABLE_OPTION,
    onResizeStart: (_event, _direction, elt) => {
      onResizeStart(elt.clientHeight);
      onResize(elt.clientHeight);
    },
    onResize: (_event, _direction, elt) => {
      onResize(elt.clientHeight);

      if (!isResizing) {
        setIsResizing(true);
      }
    },
    onResizeStop: (_event, _direction, elt) => {
      onResizeStop(elt.clientHeight);
      setIsResizing(false);
    },
    showHandle,
    size,
    __experimentalShowTooltip: true,
    __experimentalTooltipProps: {
      axis: 'y',
      position: 'bottom',
      isVisible: isResizing
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)(ResizableBoxPopover, {
    className: "block-library-cover__resizable-box-popover",
    __unstableRefreshSize: dimensions,
    resizableBoxProps: resizableBoxProps,
    ...props
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/edit/index.js


/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */







k([names]);

function getInnerBlocksTemplate(attributes) {
  return [['core/paragraph', {
    align: 'center',
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write title…'),
    ...attributes
  }]];
}
/**
 * Is the URL a temporary blob URL? A blob URL is one that is used temporarily while
 * the media (image or video) is being uploaded and will not have an id allocated yet.
 *
 * @param {number} id  The id of the media.
 * @param {string} url The url of the media.
 *
 * @return {boolean} Is the URL a Blob URL.
 */


const isTemporaryMedia = (id, url) => !id && (0,external_wp_blob_namespaceObject.isBlobURL)(url);

function CoverEdit({
  attributes,
  clientId,
  isSelected,
  overlayColor,
  setAttributes,
  setOverlayColor,
  toggleSelection,
  context: {
    postId,
    postType
  }
}) {
  const {
    contentPosition,
    id,
    useFeaturedImage,
    dimRatio,
    focalPoint,
    hasParallax,
    isDark,
    isRepeated,
    minHeight,
    minHeightUnit,
    alt,
    allowedBlocks,
    templateLock,
    tagName: TagName = 'div'
  } = attributes;
  const [featuredImage] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', postType, 'featured_media', postId);
  const media = (0,external_wp_data_namespaceObject.useSelect)(select => featuredImage && select(external_wp_coreData_namespaceObject.store).getMedia(featuredImage, {
    context: 'view'
  }), [featuredImage]);
  const mediaUrl = media?.source_url; // instead of destructuring the attributes
  // we define the url and background type
  // depending on the value of the useFeaturedImage flag
  // to preview in edit the dynamic featured image

  const url = useFeaturedImage ? mediaUrl : // Ensure the url is not malformed due to sanitization through `wp_kses`.
  attributes.url?.replaceAll('&amp;', '&');
  const backgroundType = useFeaturedImage ? IMAGE_BACKGROUND_TYPE : attributes.backgroundType;
  const {
    __unstableMarkNextChangeAsNotPersistent
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);

  const {
    gradientClass,
    gradientValue
  } = (0,external_wp_blockEditor_namespaceObject.__experimentalUseGradient)();

  const onSelectMedia = attributesFromMedia(setAttributes, dimRatio);
  const isUploadingMedia = isTemporaryMedia(id, url);

  const onUploadError = message => {
    createErrorNotice(message, {
      type: 'snackbar'
    });
  };

  const isCoverDark = useCoverIsDark(url, dimRatio, overlayColor.color);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // This side-effect should not create an undo level.
    __unstableMarkNextChangeAsNotPersistent();

    setAttributes({
      isDark: isCoverDark
    });
  }, [isCoverDark]);
  const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
  const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
  const [resizeListener, {
    height,
    width
  }] = (0,external_wp_compose_namespaceObject.useResizeObserver)();
  const resizableBoxDimensions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      height: minHeightUnit === 'px' ? minHeight : 'auto',
      width: 'auto'
    };
  }, [minHeight, minHeightUnit]);
  const minHeightWithUnit = minHeight && minHeightUnit ? `${minHeight}${minHeightUnit}` : minHeight;
  const isImgElement = !(hasParallax || isRepeated);
  const style = {
    minHeight: minHeightWithUnit || undefined
  };
  const backgroundImage = url ? `url(${url})` : undefined;
  const backgroundPosition = mediaPosition(focalPoint);
  const bgStyle = {
    backgroundColor: overlayColor.color
  };
  const mediaStyle = {
    objectPosition: focalPoint && isImgElement ? mediaPosition(focalPoint) : undefined
  };
  const hasBackground = !!(url || overlayColor.color || gradientValue);
  const hasInnerBlocks = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getBlock(clientId).innerBlocks.length > 0, [clientId]);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    ref
  }); // Check for fontSize support before we pass a fontSize attribute to the innerBlocks.

  const hasFontSizes = !!(0,external_wp_blockEditor_namespaceObject.useSetting)('typography.fontSizes')?.length;
  const innerBlocksTemplate = getInnerBlocksTemplate({
    fontSize: hasFontSizes ? 'large' : undefined
  });
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)({
    className: 'wp-block-cover__inner-container'
  }, {
    // Avoid template sync when the `templateLock` value is `all` or `contentOnly`.
    // See: https://github.com/WordPress/gutenberg/pull/45632
    template: !hasInnerBlocks ? innerBlocksTemplate : undefined,
    templateInsertUpdatesSelection: true,
    allowedBlocks,
    templateLock
  });
  const mediaElement = (0,external_wp_element_namespaceObject.useRef)();
  const currentSettings = {
    isVideoBackground,
    isImageBackground,
    mediaElement,
    hasInnerBlocks,
    url,
    isImgElement,
    overlayColor
  };

  const toggleUseFeaturedImage = () => {
    setAttributes({
      id: undefined,
      url: undefined,
      useFeaturedImage: !useFeaturedImage,
      dimRatio: dimRatio === 100 ? 50 : dimRatio,
      backgroundType: useFeaturedImage ? IMAGE_BACKGROUND_TYPE : undefined
    });
  };

  const blockControls = (0,external_wp_element_namespaceObject.createElement)(CoverBlockControls, {
    attributes: attributes,
    setAttributes: setAttributes,
    onSelectMedia: onSelectMedia,
    currentSettings: currentSettings,
    toggleUseFeaturedImage: toggleUseFeaturedImage
  });
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(CoverInspectorControls, {
    attributes: attributes,
    setAttributes: setAttributes,
    clientId: clientId,
    setOverlayColor: setOverlayColor,
    coverRef: ref,
    currentSettings: currentSettings,
    toggleUseFeaturedImage: toggleUseFeaturedImage
  });
  const resizableCoverProps = {
    className: 'block-library-cover__resize-container',
    clientId,
    height,
    minHeight: minHeightWithUnit,
    onResizeStart: () => {
      setAttributes({
        minHeightUnit: 'px'
      });
      toggleSelection(false);
    },
    onResize: value => {
      setAttributes({
        minHeight: value
      });
    },
    onResizeStop: newMinHeight => {
      toggleSelection(true);
      setAttributes({
        minHeight: newMinHeight
      });
    },
    showHandle: true,
    size: resizableBoxDimensions,
    width
  };

  if (!useFeaturedImage && !hasInnerBlocks && !hasBackground) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, inspectorControls, isSelected && (0,external_wp_element_namespaceObject.createElement)(ResizableCoverPopover, { ...resizableCoverProps
    }), (0,external_wp_element_namespaceObject.createElement)(TagName, { ...blockProps,
      className: classnames_default()('is-placeholder', blockProps.className),
      style: { ...blockProps.style,
        minHeight: minHeightWithUnit || undefined
      }
    }, resizeListener, (0,external_wp_element_namespaceObject.createElement)(CoverPlaceholder, {
      onSelectMedia: onSelectMedia,
      onError: onUploadError,
      toggleUseFeaturedImage: toggleUseFeaturedImage
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-cover__placeholder-background-options"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.ColorPalette, {
      disableCustomColors: true,
      value: overlayColor.color,
      onChange: setOverlayColor,
      clearable: false
    })))));
  }

  const classes = classnames_default()({
    'is-dark-theme': isDark,
    'is-light': !isDark,
    'is-transient': isUploadingMedia,
    'has-parallax': hasParallax,
    'is-repeated': isRepeated,
    'has-custom-content-position': !isContentPositionCenter(contentPosition)
  }, getPositionClassName(contentPosition));
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, blockControls, inspectorControls, (0,external_wp_element_namespaceObject.createElement)(TagName, { ...blockProps,
    className: classnames_default()(classes, blockProps.className),
    style: { ...style,
      ...blockProps.style
    },
    "data-url": url
  }, resizeListener, (!useFeaturedImage || url) && (0,external_wp_element_namespaceObject.createElement)("span", {
    "aria-hidden": "true",
    className: classnames_default()('wp-block-cover__background', dimRatioToClass(dimRatio), {
      [overlayColor.class]: overlayColor.class,
      'has-background-dim': dimRatio !== undefined,
      // For backwards compatibility. Former versions of the Cover Block applied
      // `.wp-block-cover__gradient-background` in the presence of
      // media, a gradient and a dim.
      'wp-block-cover__gradient-background': url && gradientValue && dimRatio !== 0,
      'has-background-gradient': gradientValue,
      [gradientClass]: gradientClass
    }),
    style: {
      backgroundImage: gradientValue,
      ...bgStyle
    }
  }), !url && useFeaturedImage && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
    className: "wp-block-cover__image--placeholder-image",
    withIllustration: true
  }), url && isImageBackground && (isImgElement ? (0,external_wp_element_namespaceObject.createElement)("img", {
    ref: mediaElement,
    className: "wp-block-cover__image-background",
    alt: alt,
    src: url,
    style: mediaStyle
  }) : (0,external_wp_element_namespaceObject.createElement)("div", {
    ref: mediaElement,
    role: "img",
    className: classnames_default()(classes, 'wp-block-cover__image-background'),
    style: {
      backgroundImage,
      backgroundPosition
    }
  })), url && isVideoBackground && (0,external_wp_element_namespaceObject.createElement)("video", {
    ref: mediaElement,
    className: "wp-block-cover__video-background",
    autoPlay: true,
    muted: true,
    loop: true,
    src: url,
    style: mediaStyle
  }), isUploadingMedia && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null), (0,external_wp_element_namespaceObject.createElement)(CoverPlaceholder, {
    disableMediaButtons: true,
    onSelectMedia: onSelectMedia,
    onError: onUploadError,
    toggleUseFeaturedImage: toggleUseFeaturedImage
  }), (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  })), isSelected && (0,external_wp_element_namespaceObject.createElement)(ResizableCoverPopover, { ...resizableCoverProps
  }));
}

/* harmony default export */ var cover_edit = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_blockEditor_namespaceObject.withColors)({
  overlayColor: 'background-color'
})])(CoverEdit));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function cover_save_save({
  attributes
}) {
  const {
    backgroundType,
    gradient,
    contentPosition,
    customGradient,
    customOverlayColor,
    dimRatio,
    focalPoint,
    useFeaturedImage,
    hasParallax,
    isDark,
    isRepeated,
    overlayColor,
    url,
    alt,
    id,
    minHeight: minHeightProp,
    minHeightUnit,
    tagName: Tag
  } = attributes;
  const overlayColorClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayColor);

  const gradientClass = (0,external_wp_blockEditor_namespaceObject.__experimentalGetGradientClass)(gradient);

  const minHeight = minHeightProp && minHeightUnit ? `${minHeightProp}${minHeightUnit}` : minHeightProp;
  const isImageBackground = IMAGE_BACKGROUND_TYPE === backgroundType;
  const isVideoBackground = VIDEO_BACKGROUND_TYPE === backgroundType;
  const isImgElement = !(hasParallax || isRepeated);
  const style = {
    minHeight: minHeight || undefined
  };
  const bgStyle = {
    backgroundColor: !overlayColorClass ? customOverlayColor : undefined,
    background: customGradient ? customGradient : undefined
  };
  const objectPosition = // prettier-ignore
  focalPoint && isImgElement ? mediaPosition(focalPoint) : undefined;
  const backgroundImage = url ? `url(${url})` : undefined;
  const backgroundPosition = mediaPosition(focalPoint);
  const classes = classnames_default()({
    'is-light': !isDark,
    'has-parallax': hasParallax,
    'is-repeated': isRepeated,
    'has-custom-content-position': !isContentPositionCenter(contentPosition)
  }, getPositionClassName(contentPosition));
  const imgClasses = classnames_default()('wp-block-cover__image-background', id ? `wp-image-${id}` : null, {
    'has-parallax': hasParallax,
    'is-repeated': isRepeated
  });
  const gradientValue = gradient || customGradient;
  return (0,external_wp_element_namespaceObject.createElement)(Tag, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className: classes,
      style
    })
  }, (0,external_wp_element_namespaceObject.createElement)("span", {
    "aria-hidden": "true",
    className: classnames_default()('wp-block-cover__background', overlayColorClass, dimRatioToClass(dimRatio), {
      'has-background-dim': dimRatio !== undefined,
      // For backwards compatibility. Former versions of the Cover Block applied
      // `.wp-block-cover__gradient-background` in the presence of
      // media, a gradient and a dim.
      'wp-block-cover__gradient-background': url && gradientValue && dimRatio !== 0,
      'has-background-gradient': gradientValue,
      [gradientClass]: gradientClass
    }),
    style: bgStyle
  }), !useFeaturedImage && isImageBackground && url && (isImgElement ? (0,external_wp_element_namespaceObject.createElement)("img", {
    className: imgClasses,
    alt: alt,
    src: url,
    style: {
      objectPosition
    },
    "data-object-fit": "cover",
    "data-object-position": objectPosition
  }) : (0,external_wp_element_namespaceObject.createElement)("div", {
    role: "img",
    className: imgClasses,
    style: {
      backgroundPosition,
      backgroundImage
    }
  })), isVideoBackground && url && (0,external_wp_element_namespaceObject.createElement)("video", {
    className: classnames_default()('wp-block-cover__video-background', 'intrinsic-ignore'),
    autoPlay: true,
    muted: true,
    loop: true,
    playsInline: true,
    src: url,
    style: {
      objectPosition
    },
    "data-object-fit": "cover",
    "data-object-position": objectPosition
  }), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
      className: 'wp-block-cover__inner-container'
    })
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/transforms.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const {
  cleanEmptyObject: transforms_cleanEmptyObject
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
const cover_transforms_transforms = {
  from: [{
    type: 'block',
    blocks: ['core/image'],
    transform: ({
      caption,
      url,
      alt,
      align,
      id,
      anchor,
      style
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/cover', {
      dimRatio: 50,
      url,
      alt,
      align,
      id,
      anchor,
      style: {
        color: {
          duotone: style?.color?.duotone
        }
      }
    }, [(0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
      content: caption,
      fontSize: 'large',
      align: 'center'
    })])
  }, {
    type: 'block',
    blocks: ['core/video'],
    transform: ({
      caption,
      src,
      align,
      id,
      anchor
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/cover', {
      dimRatio: 50,
      url: src,
      align,
      id,
      backgroundType: VIDEO_BACKGROUND_TYPE,
      anchor
    }, [(0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
      content: caption,
      fontSize: 'large',
      align: 'center'
    })])
  }, {
    type: 'block',
    blocks: ['core/group'],
    transform: (attributes, innerBlocks) => {
      const {
        align,
        anchor,
        backgroundColor,
        gradient,
        style
      } = attributes; // If the Group block being transformed has a Cover block as its
      // only child return that Cover block.

      if (innerBlocks?.length === 1 && innerBlocks[0]?.name === 'core/cover') {
        return (0,external_wp_blocks_namespaceObject.createBlock)('core/cover', innerBlocks[0].attributes, innerBlocks[0].innerBlocks);
      } // If no background or gradient color is provided, default to 50% opacity.
      // This matches the styling of a Cover block with a background image,
      // in the state where a background image has been removed.


      const dimRatio = backgroundColor || gradient || style?.color?.background || style?.color?.gradient ? undefined : 50; // Move the background or gradient color to the parent Cover block.

      const parentAttributes = {
        align,
        anchor,
        dimRatio,
        overlayColor: backgroundColor,
        customOverlayColor: style?.color?.background,
        gradient,
        customGradient: style?.color?.gradient
      };
      const attributesWithoutBackgroundColors = { ...attributes,
        backgroundColor: undefined,
        gradient: undefined,
        style: transforms_cleanEmptyObject({ ...attributes?.style,
          color: style?.color ? { ...style?.color,
            background: undefined,
            gradient: undefined
          } : undefined
        })
      }; // Preserve the block by nesting it within the Cover block,
      // instead of converting the Group block directly to the Cover block.

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/cover', parentAttributes, [(0,external_wp_blocks_namespaceObject.createBlock)('core/group', attributesWithoutBackgroundColors, innerBlocks)]);
    }
  }],
  to: [{
    type: 'block',
    blocks: ['core/image'],
    isMatch: ({
      backgroundType,
      url,
      overlayColor,
      customOverlayColor,
      gradient,
      customGradient
    }) => {
      if (url) {
        // If a url exists the transform could happen if that URL represents an image background.
        return backgroundType === IMAGE_BACKGROUND_TYPE;
      } // If a url is not set the transform could happen if the cover has no background color or gradient;


      return !overlayColor && !customOverlayColor && !gradient && !customGradient;
    },
    transform: ({
      title,
      url,
      alt,
      align,
      id,
      anchor,
      style
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
      caption: title,
      url,
      alt,
      align,
      id,
      anchor,
      style: {
        color: {
          duotone: style?.color?.duotone
        }
      }
    })
  }, {
    type: 'block',
    blocks: ['core/video'],
    isMatch: ({
      backgroundType,
      url,
      overlayColor,
      customOverlayColor,
      gradient,
      customGradient
    }) => {
      if (url) {
        // If a url exists the transform could happen if that URL represents a video background.
        return backgroundType === VIDEO_BACKGROUND_TYPE;
      } // If a url is not set the transform could happen if the cover has no background color or gradient;


      return !overlayColor && !customOverlayColor && !gradient && !customGradient;
    },
    transform: ({
      title,
      url,
      align,
      id,
      anchor
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/video', {
      caption: title,
      src: url,
      id,
      align,
      anchor
    })
  }, {
    type: 'block',
    blocks: ['core/group'],
    isMatch: ({
      url,
      useFeaturedImage
    }) => {
      // If the Cover block uses background media, skip this transform,
      // and instead use the Group block's default transform.
      if (url || useFeaturedImage) {
        return false;
      }

      return true;
    },
    transform: (attributes, innerBlocks) => {
      // Convert Cover overlay colors to comparable Group background colors.
      const transformedColorAttributes = {
        backgroundColor: attributes?.overlayColor,
        gradient: attributes?.gradient,
        style: transforms_cleanEmptyObject({ ...attributes?.style,
          color: attributes?.customOverlayColor || attributes?.customGradient || attributes?.style?.color ? {
            background: attributes?.customOverlayColor,
            gradient: attributes?.customGradient,
            ...attributes?.style?.color
          } : undefined
        })
      }; // If the Cover block contains only a single Group block as a direct child,
      // then attempt to merge the Cover's background colors with the child Group block,
      // and remove the Cover block as the wrapper.

      if (innerBlocks?.length === 1 && innerBlocks[0]?.name === 'core/group') {
        const groupAttributes = transforms_cleanEmptyObject(innerBlocks[0].attributes || {}); // If the Group block contains any kind of background color or gradient,
        // skip merging Cover background colors, and preserve the Group block's colors.

        if (groupAttributes?.backgroundColor || groupAttributes?.gradient || groupAttributes?.style?.color?.background || groupAttributes?.style?.color?.gradient) {
          return (0,external_wp_blocks_namespaceObject.createBlock)('core/group', groupAttributes, innerBlocks[0]?.innerBlocks);
        }

        return (0,external_wp_blocks_namespaceObject.createBlock)('core/group', { ...transformedColorAttributes,
          ...groupAttributes,
          style: transforms_cleanEmptyObject({ ...groupAttributes?.style,
            color: transformedColorAttributes?.style?.color || groupAttributes?.style?.color ? { ...transformedColorAttributes?.style?.color,
              ...groupAttributes?.style?.color
            } : undefined
          })
        }, innerBlocks[0]?.innerBlocks);
      } // In all other cases, transform the Cover block directly to a Group block.


      return (0,external_wp_blocks_namespaceObject.createBlock)('core/group', { ...attributes,
        ...transformedColorAttributes
      }, innerBlocks);
    }
  }]
};
/* harmony default export */ var cover_transforms = (cover_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/variations.js
/**
 * WordPress dependencies
 */


const variations_variations = [{
  name: 'cover',
  title: (0,external_wp_i18n_namespaceObject.__)('Cover'),
  description: (0,external_wp_i18n_namespaceObject.__)('Add an image or video with a text overlay.'),
  attributes: {
    layout: {
      type: 'constrained'
    }
  },
  isDefault: true,
  icon: library_cover
}];
/* harmony default export */ var cover_variations = (variations_variations);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/cover/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const cover_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/cover",
  title: "Cover",
  category: "media",
  description: "Add an image or video with a text overlay.",
  textdomain: "default",
  attributes: {
    url: {
      type: "string"
    },
    useFeaturedImage: {
      type: "boolean",
      "default": false
    },
    id: {
      type: "number"
    },
    alt: {
      type: "string",
      source: "attribute",
      selector: "img",
      attribute: "alt",
      "default": ""
    },
    hasParallax: {
      type: "boolean",
      "default": false
    },
    isRepeated: {
      type: "boolean",
      "default": false
    },
    dimRatio: {
      type: "number",
      "default": 100
    },
    overlayColor: {
      type: "string"
    },
    customOverlayColor: {
      type: "string"
    },
    backgroundType: {
      type: "string",
      "default": "image"
    },
    focalPoint: {
      type: "object"
    },
    minHeight: {
      type: "number"
    },
    minHeightUnit: {
      type: "string"
    },
    gradient: {
      type: "string"
    },
    customGradient: {
      type: "string"
    },
    contentPosition: {
      type: "string"
    },
    isDark: {
      type: "boolean",
      "default": true
    },
    allowedBlocks: {
      type: "array"
    },
    templateLock: {
      type: ["string", "boolean"],
      "enum": ["all", "insert", "contentOnly", false]
    },
    tagName: {
      type: "string",
      "default": "div"
    }
  },
  usesContext: ["postId", "postType"],
  supports: {
    anchor: true,
    align: true,
    html: false,
    spacing: {
      padding: true,
      margin: ["top", "bottom"],
      blockGap: true,
      __experimentalDefaultControls: {
        padding: true,
        blockGap: true
      }
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      style: true,
      width: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        style: true,
        width: true
      }
    },
    color: {
      __experimentalDuotone: "> .wp-block-cover__image-background, > .wp-block-cover__video-background",
      text: true,
      background: false,
      __experimentalSkipSerialization: ["gradients"]
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    layout: {
      allowJustification: false
    }
  },
  editorStyle: "wp-block-cover-editor",
  style: "wp-block-cover"
};



const {
  name: cover_name
} = cover_metadata;

const cover_settings = {
  icon: library_cover,
  example: {
    attributes: {
      customOverlayColor: '#065174',
      dimRatio: 40,
      url: 'https://s.w.org/images/core/5.3/Windbuchencom.jpg'
    },
    innerBlocks: [{
      name: 'core/paragraph',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('<strong>Snow Patrol</strong>'),
        align: 'center',
        style: {
          typography: {
            fontSize: 48
          },
          color: {
            text: 'white'
          }
        }
      }
    }]
  },
  transforms: cover_transforms,
  save: cover_save_save,
  edit: cover_edit,
  deprecated: cover_deprecated,
  variations: cover_variations
};
const cover_init = () => initBlock({
  name: cover_name,
  metadata: cover_metadata,
  settings: cover_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/details.js


/**
 * WordPress dependencies
 */

const details = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 16h10v1.5H4V16Zm0-4.5h16V13H4v-1.5ZM10 7h10v1.5H10V7Z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m4 5.25 4 2.5-4 2.5v-5Z"
}));
/* harmony default export */ var library_details = (details);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/details/edit.js


/**
 * WordPress dependencies
 */




const details_edit_TEMPLATE = [['core/paragraph', {
  placeholder: (0,external_wp_i18n_namespaceObject.__)('Type / to add a hidden block')
}]];

function DetailsEdit({
  attributes,
  setAttributes,
  clientId
}) {
  const {
    showContent,
    summary
  } = attributes;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    template: details_edit_TEMPLATE,
    __experimentalCaptureToolbars: true
  }); // Check if either the block or the inner blocks are selected.

  const hasSelection = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isBlockSelected,
      hasSelectedInnerBlock
    } = select(external_wp_blockEditor_namespaceObject.store);
    /* Sets deep to true to also find blocks inside the details content block. */

    return hasSelectedInnerBlock(clientId, true) || isBlockSelected(clientId);
  }, [clientId]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Open by default'),
    checked: showContent,
    onChange: () => setAttributes({
      showContent: !showContent
    })
  }))), (0,external_wp_element_namespaceObject.createElement)("details", { ...innerBlocksProps,
    open: hasSelection || showContent
  }, (0,external_wp_element_namespaceObject.createElement)("summary", {
    onClick: event => event.preventDefault()
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Write summary'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write summary…'),
    allowedFormats: [],
    withoutInteractiveFormatting: true,
    value: summary,
    onChange: newSummary => setAttributes({
      summary: newSummary
    }),
    multiline: false
  })), innerBlocksProps.children));
}

/* harmony default export */ var details_edit = (DetailsEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/details/save.js


/**
 * WordPress dependencies
 */

function details_save_save({
  attributes
}) {
  const {
    showContent
  } = attributes;
  const summary = attributes.summary ? attributes.summary : 'Details';
  const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save();
  return (0,external_wp_element_namespaceObject.createElement)("details", { ...blockProps,
    open: showContent
  }, (0,external_wp_element_namespaceObject.createElement)("summary", null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    value: summary
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/details/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const details_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/details",
  title: "Details",
  category: "text",
  description: "Hide and show additional content.",
  keywords: ["disclosure", "summary", "hide"],
  textdomain: "default",
  attributes: {
    showContent: {
      type: "boolean",
      "default": false
    },
    summary: {
      type: "string"
    }
  },
  supports: {
    align: ["wide", "full"],
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    __experimentalBorder: {
      color: true,
      width: true,
      style: true
    },
    html: false,
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-details-editor",
  style: "wp-block-details"
};


const {
  name: details_name
} = details_metadata;

const details_settings = {
  icon: library_details,
  example: {
    attributes: {
      summary: 'La Mancha',
      showContent: true
    },
    innerBlocks: [{
      name: 'core/paragraph',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('In a village of La Mancha, the name of which I have no desire to call to mind, there lived not long since one of those gentlemen that keep a lance in the lance-rack, an old buckler, a lean hack, and a greyhound for coursing.')
      }
    }]
  },
  save: details_save_save,
  edit: details_edit
};
const details_init = () => initBlock({
  name: details_name,
  metadata: details_metadata,
  settings: details_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/pencil.js


/**
 * WordPress dependencies
 */

const pencil = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z"
}));
/* harmony default export */ var library_pencil = (pencil);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/edit.js
/**
 * Internal dependencies
 */

/* harmony default export */ var library_edit = (library_pencil);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/embed-controls.js


/**
 * WordPress dependencies
 */





function getResponsiveHelp(checked) {
  return checked ? (0,external_wp_i18n_namespaceObject.__)('This embed will preserve its aspect ratio when the browser is resized.') : (0,external_wp_i18n_namespaceObject.__)('This embed may not preserve its aspect ratio when the browser is resized.');
}

const EmbedControls = ({
  blockSupportsResponsive,
  showEditButton,
  themeSupportsResponsive,
  allowResponsive,
  toggleResponsive,
  switchBackToURLInput
}) => (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, showEditButton && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
  className: "components-toolbar__control",
  label: (0,external_wp_i18n_namespaceObject.__)('Edit URL'),
  icon: library_edit,
  onClick: switchBackToURLInput
}))), themeSupportsResponsive && blockSupportsResponsive && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
  title: (0,external_wp_i18n_namespaceObject.__)('Media settings'),
  className: "blocks-responsive"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
  __nextHasNoMarginBottom: true,
  label: (0,external_wp_i18n_namespaceObject.__)('Resize for smaller devices'),
  checked: allowResponsive,
  help: getResponsiveHelp,
  onChange: toggleResponsive
}))));

/* harmony default export */ var embed_controls = (EmbedControls);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/icons.js


/**
 * WordPress dependencies
 */

const embedContentIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm.5 16c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V9.8l4.7-5.3H19c.3 0 .5.2.5.5v14zm-6-9.5L16 12l-2.5 2.8 1.1 1L18 12l-3.5-3.5-1 1zm-3 0l-1-1L6 12l3.5 3.8 1.1-1L8 12l2.5-2.5z"
}));
const embedAudioIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm.5 16c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V9.8l4.7-5.3H19c.3 0 .5.2.5.5v14zM13.2 7.7c-.4.4-.7 1.1-.7 1.9v3.7c-.4-.3-.8-.4-1.3-.4-1.2 0-2.2 1-2.2 2.2 0 1.2 1 2.2 2.2 2.2.5 0 1-.2 1.4-.5.9-.6 1.4-1.6 1.4-2.6V9.6c0-.4.1-.6.2-.8.3-.3 1-.3 1.6-.3h.2V7h-.2c-.7 0-1.8 0-2.6.7z"
}));
const embedPhotoIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9.2 4.5H19c.3 0 .5.2.5.5v8.4l-3-2.9c-.3-.3-.8-.3-1 0L11.9 14 9 12c-.3-.2-.6-.2-.8 0l-3.6 2.6V9.8l4.6-5.3zm9.8 15H5c-.3 0-.5-.2-.5-.5v-2.4l4.1-3 3 1.9c.3.2.7.2.9-.1L16 12l3.5 3.4V19c0 .3-.2.5-.5.5z"
}));
const embedVideoIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm.5 16c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V9.8l4.7-5.3H19c.3 0 .5.2.5.5v14zM10 15l5-3-5-3v6z"
}));
const embedTwitterIcon = {
  foreground: '#1da1f2',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.G, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M22.23 5.924c-.736.326-1.527.547-2.357.646.847-.508 1.498-1.312 1.804-2.27-.793.47-1.67.812-2.606.996C18.325 4.498 17.258 4 16.078 4c-2.266 0-4.103 1.837-4.103 4.103 0 .322.036.635.106.935-3.41-.17-6.433-1.804-8.457-4.287-.353.607-.556 1.312-.556 2.064 0 1.424.724 2.68 1.825 3.415-.673-.022-1.305-.207-1.86-.514v.052c0 1.988 1.415 3.647 3.293 4.023-.344.095-.707.145-1.08.145-.265 0-.522-.026-.773-.074.522 1.63 2.038 2.817 3.833 2.85-1.404 1.1-3.174 1.757-5.096 1.757-.332 0-.66-.02-.98-.057 1.816 1.164 3.973 1.843 6.29 1.843 7.547 0 11.675-6.252 11.675-11.675 0-.178-.004-.355-.012-.53.802-.578 1.497-1.3 2.047-2.124z"
  })))
};
const embedYouTubeIcon = {
  foreground: '#ff0000',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M21.8 8s-.195-1.377-.795-1.984c-.76-.797-1.613-.8-2.004-.847-2.798-.203-6.996-.203-6.996-.203h-.01s-4.197 0-6.996.202c-.39.046-1.242.05-2.003.846C2.395 6.623 2.2 8 2.2 8S2 9.62 2 11.24v1.517c0 1.618.2 3.237.2 3.237s.195 1.378.795 1.985c.76.797 1.76.77 2.205.855 1.6.153 6.8.2 6.8.2s4.203-.005 7-.208c.392-.047 1.244-.05 2.005-.847.6-.607.795-1.985.795-1.985s.2-1.618.2-3.237v-1.517C22 9.62 21.8 8 21.8 8zM9.935 14.595v-5.62l5.403 2.82-5.403 2.8z"
  }))
};
const embedFacebookIcon = {
  foreground: '#3b5998',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M20 3H4c-.6 0-1 .4-1 1v16c0 .5.4 1 1 1h8.6v-7h-2.3v-2.7h2.3v-2c0-2.3 1.4-3.6 3.5-3.6 1 0 1.8.1 2.1.1v2.4h-1.4c-1.1 0-1.3.5-1.3 1.3v1.7h2.7l-.4 2.8h-2.3v7H20c.5 0 1-.4 1-1V4c0-.6-.4-1-1-1z"
  }))
};
const embedInstagramIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.G, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M12 4.622c2.403 0 2.688.01 3.637.052.877.04 1.354.187 1.67.31.42.163.72.358 1.036.673.315.315.51.615.673 1.035.123.317.27.794.31 1.67.043.95.052 1.235.052 3.638s-.01 2.688-.052 3.637c-.04.877-.187 1.354-.31 1.67-.163.42-.358.72-.673 1.036-.315.315-.615.51-1.035.673-.317.123-.794.27-1.67.31-.95.043-1.234.052-3.638.052s-2.688-.01-3.637-.052c-.877-.04-1.354-.187-1.67-.31-.42-.163-.72-.358-1.036-.673-.315-.315-.51-.615-.673-1.035-.123-.317-.27-.794-.31-1.67-.043-.95-.052-1.235-.052-3.638s.01-2.688.052-3.637c.04-.877.187-1.354.31-1.67.163-.42.358-.72.673-1.036.315-.315.615-.51 1.035-.673.317-.123.794-.27 1.67-.31.95-.043 1.235-.052 3.638-.052M12 3c-2.444 0-2.75.01-3.71.054s-1.613.196-2.185.418c-.592.23-1.094.538-1.594 1.04-.5.5-.807 1-1.037 1.593-.223.572-.375 1.226-.42 2.184C3.01 9.25 3 9.555 3 12s.01 2.75.054 3.71.196 1.613.418 2.186c.23.592.538 1.094 1.038 1.594s1.002.808 1.594 1.038c.572.222 1.227.375 2.185.418.96.044 1.266.054 3.71.054s2.75-.01 3.71-.054 1.613-.196 2.186-.418c.592-.23 1.094-.538 1.594-1.038s.808-1.002 1.038-1.594c.222-.572.375-1.227.418-2.185.044-.96.054-1.266.054-3.71s-.01-2.75-.054-3.71-.196-1.613-.418-2.186c-.23-.592-.538-1.094-1.038-1.594s-1.002-.808-1.594-1.038c-.572-.222-1.227-.375-2.185-.418C14.75 3.01 14.445 3 12 3zm0 4.378c-2.552 0-4.622 2.07-4.622 4.622s2.07 4.622 4.622 4.622 4.622-2.07 4.622-4.622S14.552 7.378 12 7.378zM12 15c-1.657 0-3-1.343-3-3s1.343-3 3-3 3 1.343 3 3-1.343 3-3 3zm4.804-8.884c-.596 0-1.08.484-1.08 1.08s.484 1.08 1.08 1.08c.596 0 1.08-.484 1.08-1.08s-.483-1.08-1.08-1.08z"
})));
const embedWordPressIcon = {
  foreground: '#0073AA',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.G, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M12.158 12.786l-2.698 7.84c.806.236 1.657.365 2.54.365 1.047 0 2.05-.18 2.986-.51-.024-.037-.046-.078-.065-.123l-2.762-7.57zM3.008 12c0 3.56 2.07 6.634 5.068 8.092L3.788 8.342c-.5 1.117-.78 2.354-.78 3.658zm15.06-.454c0-1.112-.398-1.88-.74-2.48-.456-.74-.883-1.368-.883-2.11 0-.825.627-1.595 1.51-1.595.04 0 .078.006.116.008-1.598-1.464-3.73-2.36-6.07-2.36-3.14 0-5.904 1.613-7.512 4.053.21.008.41.012.58.012.94 0 2.395-.114 2.395-.114.484-.028.54.684.057.74 0 0-.487.058-1.03.086l3.275 9.74 1.968-5.902-1.4-3.838c-.485-.028-.944-.085-.944-.085-.486-.03-.43-.77.056-.742 0 0 1.484.114 2.368.114.94 0 2.397-.114 2.397-.114.486-.028.543.684.058.74 0 0-.488.058-1.03.086l3.25 9.665.897-2.997c.456-1.17.684-2.137.684-2.907zm1.82-3.86c.04.286.06.593.06.924 0 .912-.17 1.938-.683 3.22l-2.746 7.94c2.672-1.558 4.47-4.454 4.47-7.77 0-1.564-.4-3.033-1.1-4.314zM12 22C6.486 22 2 17.514 2 12S6.486 2 12 2s10 4.486 10 10-4.486 10-10 10z"
  })))
};
const embedSpotifyIcon = {
  foreground: '#1db954',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M12 2C6.477 2 2 6.477 2 12s4.477 10 10 10 10-4.477 10-10S17.523 2 12 2m4.586 14.424c-.18.295-.563.387-.857.207-2.35-1.434-5.305-1.76-8.786-.963-.335.077-.67-.133-.746-.47-.077-.334.132-.67.47-.745 3.808-.87 7.076-.496 9.712 1.115.293.18.386.563.206.857M17.81 13.7c-.226.367-.706.482-1.072.257-2.687-1.652-6.785-2.13-9.965-1.166-.413.127-.848-.106-.973-.517-.125-.413.108-.848.52-.973 3.632-1.102 8.147-.568 11.234 1.328.366.226.48.707.256 1.072m.105-2.835C14.692 8.95 9.375 8.775 6.297 9.71c-.493.15-1.016-.13-1.166-.624-.148-.495.13-1.017.625-1.167 3.532-1.073 9.404-.866 13.115 1.337.445.264.59.838.327 1.282-.264.443-.838.59-1.282.325"
  }))
};
const embedFlickrIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m6.5 7c-2.75 0-5 2.25-5 5s2.25 5 5 5 5-2.25 5-5-2.25-5-5-5zm11 0c-2.75 0-5 2.25-5 5s2.25 5 5 5 5-2.25 5-5-2.25-5-5-5z"
}));
const embedVimeoIcon = {
  foreground: '#1ab7ea',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.G, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M22.396 7.164c-.093 2.026-1.507 4.8-4.245 8.32C15.323 19.16 12.93 21 10.97 21c-1.214 0-2.24-1.12-3.08-3.36-.56-2.052-1.118-4.105-1.68-6.158-.622-2.24-1.29-3.36-2.004-3.36-.156 0-.7.328-1.634.98l-.978-1.26c1.027-.903 2.04-1.806 3.037-2.71C6 3.95 7.03 3.328 7.716 3.265c1.62-.156 2.616.95 2.99 3.32.404 2.558.685 4.148.84 4.77.468 2.12.982 3.18 1.543 3.18.435 0 1.09-.687 1.963-2.064.872-1.376 1.34-2.422 1.402-3.142.125-1.187-.343-1.782-1.4-1.782-.5 0-1.013.115-1.542.34 1.023-3.35 2.977-4.976 5.862-4.883 2.14.063 3.148 1.45 3.024 4.16z"
  })))
};
const embedRedditIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M22 12.068a2.184 2.184 0 0 0-2.186-2.186c-.592 0-1.13.233-1.524.609-1.505-1.075-3.566-1.774-5.86-1.864l1.004-4.695 3.261.699A1.56 1.56 0 1 0 18.255 3c-.61-.001-1.147.357-1.398.877l-3.638-.77a.382.382 0 0 0-.287.053.348.348 0 0 0-.161.251l-1.112 5.233c-2.33.072-4.426.77-5.95 1.864a2.201 2.201 0 0 0-1.523-.61 2.184 2.184 0 0 0-.896 4.176c-.036.215-.053.43-.053.663 0 3.37 3.924 6.111 8.763 6.111s8.763-2.724 8.763-6.11c0-.216-.017-.449-.053-.664A2.207 2.207 0 0 0 22 12.068Zm-15.018 1.56a1.56 1.56 0 0 1 3.118 0c0 .86-.699 1.558-1.559 1.558-.86.018-1.559-.699-1.559-1.559Zm8.728 4.139c-1.076 1.075-3.119 1.147-3.71 1.147-.61 0-2.652-.09-3.71-1.147a.4.4 0 0 1 0-.573.4.4 0 0 1 .574 0c.68.68 2.114.914 3.136.914 1.022 0 2.473-.233 3.136-.914a.4.4 0 0 1 .574 0 .436.436 0 0 1 0 .573Zm-.287-2.563a1.56 1.56 0 0 1 0-3.118c.86 0 1.56.699 1.56 1.56 0 .841-.7 1.558-1.56 1.558Z"
}));
const embedTumblrIcon = {
  foreground: '#35465c',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    viewBox: "0 0 24 24"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    d: "M19 3H5a2 2 0 00-2 2v14c0 1.1.9 2 2 2h14a2 2 0 002-2V5a2 2 0 00-2-2zm-5.69 14.66c-2.72 0-3.1-1.9-3.1-3.16v-3.56H8.49V8.99c1.7-.62 2.54-1.99 2.64-2.87 0-.06.06-.41.06-.58h1.9v3.1h2.17v2.3h-2.18v3.1c0 .47.13 1.3 1.2 1.26h1.1v2.36c-1.01.02-2.07 0-2.07 0z"
  }))
};
const embedAmazonIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M18.42 14.58c-.51-.66-1.05-1.23-1.05-2.5V7.87c0-1.8.15-3.45-1.2-4.68-1.05-1.02-2.79-1.35-4.14-1.35-2.6 0-5.52.96-6.12 4.14-.06.36.18.54.4.57l2.66.3c.24-.03.42-.27.48-.5.24-1.12 1.17-1.63 2.2-1.63.56 0 1.22.21 1.55.7.4.56.33 1.31.33 1.97v.36c-1.59.18-3.66.27-5.16.93a4.63 4.63 0 0 0-2.93 4.44c0 2.82 1.8 4.23 4.1 4.23 1.95 0 3.03-.45 4.53-1.98.51.72.66 1.08 1.59 1.83.18.09.45.09.63-.1v.04l2.1-1.8c.24-.21.2-.48.03-.75zm-5.4-1.2c-.45.75-1.14 1.23-1.92 1.23-1.05 0-1.65-.81-1.65-1.98 0-2.31 2.1-2.73 4.08-2.73v.6c0 1.05.03 1.92-.5 2.88z"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M21.69 19.2a17.62 17.62 0 0 1-21.6-1.57c-.23-.2 0-.5.28-.33a23.88 23.88 0 0 0 20.93 1.3c.45-.19.84.3.39.6z"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M22.8 17.96c-.36-.45-2.22-.2-3.1-.12-.23.03-.3-.18-.05-.36 1.5-1.05 3.96-.75 4.26-.39.3.36-.1 2.82-1.5 4.02-.21.18-.42.1-.3-.15.3-.8 1.02-2.58.69-3z"
}));
const embedAnimotoIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m.0206909 21 19.8160091-13.07806 3.5831 6.20826z",
  fill: "#4bc7ee"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m23.7254 19.0205-10.1074-17.18468c-.6421-1.114428-1.7087-1.114428-2.3249 0l-11.2931 19.16418h22.5655c1.279 0 1.8019-.8905 1.1599-1.9795z",
  fill: "#d4cdcb"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m.0206909 21 15.2439091-16.38571 4.3029 7.32271z",
  fill: "#c3d82e"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m13.618 1.83582c-.6421-1.114428-1.7087-1.114428-2.3249 0l-11.2931 19.16418 15.2646-16.38573z",
  fill: "#e4ecb0"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m.0206909 21 19.5468091-9.063 1.6621 2.8344z",
  fill: "#209dbd"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m.0206909 21 17.9209091-11.82623 1.6259 2.76323z",
  fill: "#7cb3c9"
}));
const embedDailymotionIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "m12.1479 18.5957c-2.4949 0-4.28131-1.7558-4.28131-4.0658 0-2.2176 1.78641-4.0965 4.09651-4.0965 2.2793 0 4.0349 1.7864 4.0349 4.1581 0 2.2794-1.7556 4.0042-3.8501 4.0042zm8.3521-18.5957-4.5329 1v7c-1.1088-1.41691-2.8028-1.8787-4.8049-1.8787-2.09443 0-3.97329.76993-5.5133 2.27917-1.72483 1.66323-2.6489 3.78863-2.6489 6.16033 0 2.5873.98562 4.8049 2.89526 6.499 1.44763 1.2936 3.17251 1.9402 5.17454 1.9402 1.9713 0 3.4498-.5236 4.8973-1.9402v1.9402h4.5329c0-7.6359 0-15.3641 0-23z",
  fill: "#333436"
}));
const embedPinterestIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  version: "1.1"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M12.289,2C6.617,2,3.606,5.648,3.606,9.622c0,1.846,1.025,4.146,2.666,4.878c0.25,0.111,0.381,0.063,0.439-0.169 c0.044-0.175,0.267-1.029,0.365-1.428c0.032-0.128,0.017-0.237-0.091-0.362C6.445,11.911,6.01,10.75,6.01,9.668 c0-2.777,2.194-5.464,5.933-5.464c3.23,0,5.49,2.108,5.49,5.122c0,3.407-1.794,5.768-4.13,5.768c-1.291,0-2.257-1.021-1.948-2.277 c0.372-1.495,1.089-3.112,1.089-4.191c0-0.967-0.542-1.775-1.663-1.775c-1.319,0-2.379,1.309-2.379,3.059 c0,1.115,0.394,1.869,0.394,1.869s-1.302,5.279-1.54,6.261c-0.405,1.666,0.053,4.368,0.094,4.604 c0.021,0.126,0.167,0.169,0.25,0.063c0.129-0.165,1.699-2.419,2.142-4.051c0.158-0.59,0.817-2.995,0.817-2.995 c0.43,0.784,1.681,1.446,3.013,1.446c3.963,0,6.822-3.494,6.822-7.833C20.394,5.112,16.849,2,12.289,2"
}));
const embedWolframIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  viewBox: "0 0 44 44"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M32.59521,22.001l4.31885-4.84473-6.34131-1.38379.646-6.459-5.94336,2.61035L22,6.31934l-3.27344,5.60351L12.78418,9.3125l.645,6.458L7.08643,17.15234,11.40479,21.999,7.08594,26.84375l6.34131,1.38379-.64551,6.458,5.94287-2.60938L22,37.68066l3.27344-5.60351,5.94287,2.61035-.64551-6.458,6.34277-1.38183Zm.44385,2.75244L30.772,23.97827l-1.59558-2.07391,1.97888.735Zm-8.82147,6.1579L22.75,33.424V30.88977l1.52228-2.22168ZM18.56226,13.48816,19.819,15.09534l-2.49219-.88642L15.94037,12.337Zm6.87719.00116,2.62043-1.15027-1.38654,1.86981L24.183,15.0946Zm3.59357,2.6029-1.22546,1.7381.07525-2.73486,1.44507-1.94867ZM22,29.33008l-2.16406-3.15686L22,23.23688l2.16406,2.93634Zm-4.25458-9.582-.10528-3.836,3.60986,1.284v3.73242Zm5.00458-2.552,3.60986-1.284-.10528,3.836L22.75,20.92853Zm-7.78174-1.10559-.29352-2.94263,1.44245,1.94739.07519,2.73321Zm2.30982,5.08319,3.50817,1.18164-2.16247,2.9342-3.678-1.08447Zm2.4486,7.49285L21.25,30.88977v2.53485L19.78052,30.91Zm3.48707-6.31121,3.50817-1.18164,2.33228,3.03137-3.678,1.08447Zm10.87219-4.28113-2.714,3.04529L28.16418,19.928l1.92176-2.72565ZM24.06036,12.81769l-2.06012,2.6322-2.059-2.63318L22,9.292ZM9.91455,18.07227l4.00079-.87195,1.921,2.72735-3.20794,1.19019Zm2.93024,4.565,1.9801-.73462L13.228,23.97827l-2.26838.77429Zm-1.55591,3.58819L13.701,25.4021l2.64935.78058-2.14447.67853Zm3.64868,1.977L18.19,27.17334l.08313,3.46332L14.52979,32.2793Zm10.7876,2.43549.08447-3.464,3.25165,1.03052.407,4.07684Zm4.06824-3.77478-2.14545-.68,2.65063-.781,2.41266.825Z"
}));
const embedPocketCastsIcon = {
  foreground: '#f43e37',
  src: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M24,12A12,12,0,1,1,12,0,12,12,0,0,1,24,12Z"
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M2.67,12a9.33,9.33,0,0,1,18.66,0H19a7,7,0,1,0-7,7v2.33A9.33,9.33,0,0,1,2.67,12ZM12,17.6A5.6,5.6,0,1,1,17.6,12h-2A3.56,3.56,0,1,0,12,15.56Z",
    fill: "#fff"
  }))
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/embed-loading.js


/**
 * WordPress dependencies
 */


const EmbedLoading = () => (0,external_wp_element_namespaceObject.createElement)("div", {
  className: "wp-block-embed is-loading"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null));

/* harmony default export */ var embed_loading = (EmbedLoading);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/embed-placeholder.js


/**
 * WordPress dependencies
 */




const EmbedPlaceholder = ({
  icon,
  label,
  value,
  onSubmit,
  onChange,
  cannotEmbed,
  fallback,
  tryAgain
}) => {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
    icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
      icon: icon,
      showColors: true
    }),
    label: label,
    className: "wp-block-embed",
    instructions: (0,external_wp_i18n_namespaceObject.__)('Paste a link to the content you want to display on your site.')
  }, (0,external_wp_element_namespaceObject.createElement)("form", {
    onSubmit: onSubmit
  }, (0,external_wp_element_namespaceObject.createElement)("input", {
    type: "url",
    value: value || '',
    className: "components-placeholder__input",
    "aria-label": label,
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Enter URL to embed here…'),
    onChange: onChange
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "primary",
    type: "submit"
  }, (0,external_wp_i18n_namespaceObject._x)('Embed', 'button label'))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "components-placeholder__learn-more"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
    href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/documentation/article/embeds/')
  }, (0,external_wp_i18n_namespaceObject.__)('Learn more about embeds'))), cannotEmbed && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "components-placeholder__error"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "components-placeholder__instructions"
  }, (0,external_wp_i18n_namespaceObject.__)('Sorry, this content could not be embedded.')), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "secondary",
    onClick: tryAgain
  }, (0,external_wp_i18n_namespaceObject._x)('Try again', 'button label')), ' ', (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "secondary",
    onClick: fallback
  }, (0,external_wp_i18n_namespaceObject._x)('Convert to link', 'button label'))));
};

/* harmony default export */ var embed_placeholder = (EmbedPlaceholder);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/wp-embed-preview.js


/**
 * WordPress dependencies
 */


/** @typedef {import('@wordpress/element').WPSyntheticEvent} WPSyntheticEvent */

const attributeMap = {
  class: 'className',
  frameborder: 'frameBorder',
  marginheight: 'marginHeight',
  marginwidth: 'marginWidth'
};
function WpEmbedPreview({
  html
}) {
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const props = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const doc = new window.DOMParser().parseFromString(html, 'text/html');
    const iframe = doc.querySelector('iframe');
    const iframeProps = {};
    if (!iframe) return iframeProps;
    Array.from(iframe.attributes).forEach(({
      name,
      value
    }) => {
      if (name === 'style') return;
      iframeProps[attributeMap[name] || name] = value;
    });
    return iframeProps;
  }, [html]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      ownerDocument
    } = ref.current;
    const {
      defaultView
    } = ownerDocument;
    /**
     * Checks for WordPress embed events signaling the height change when
     * iframe content loads or iframe's window is resized.  The event is
     * sent from WordPress core via the window.postMessage API.
     *
     * References:
     * window.postMessage:
     * https://developer.mozilla.org/en-US/docs/Web/API/Window/postMessage
     * WordPress core embed-template on load:
     * https://github.com/WordPress/WordPress/blob/HEAD/wp-includes/js/wp-embed-template.js#L143
     * WordPress core embed-template on resize:
     * https://github.com/WordPress/WordPress/blob/HEAD/wp-includes/js/wp-embed-template.js#L187
     *
     * @param {MessageEvent} event Message event.
     */

    function resizeWPembeds({
      data: {
        secret,
        message,
        value
      } = {}
    }) {
      if (message !== 'height' || secret !== props['data-secret']) {
        return;
      }

      ref.current.height = value;
    }

    defaultView.addEventListener('message', resizeWPembeds);
    return () => {
      defaultView.removeEventListener('message', resizeWPembeds);
    };
  }, []);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-embed__wrapper"
  }, (0,external_wp_element_namespaceObject.createElement)("iframe", {
    ref: (0,external_wp_compose_namespaceObject.useMergeRefs)([ref, (0,external_wp_compose_namespaceObject.useFocusableIframe)()]),
    title: props.title,
    ...props
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/embed-preview.js


/**
 * Internal dependencies
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



class EmbedPreview extends external_wp_element_namespaceObject.Component {
  constructor() {
    super(...arguments);
    this.hideOverlay = this.hideOverlay.bind(this);
    this.state = {
      interactive: false
    };
  }

  static getDerivedStateFromProps(nextProps, state) {
    if (!nextProps.isSelected && state.interactive) {
      // We only want to change this when the block is not selected, because changing it when
      // the block becomes selected makes the overlap disappear too early. Hiding the overlay
      // happens on mouseup when the overlay is clicked.
      return {
        interactive: false
      };
    }

    return null;
  }

  hideOverlay() {
    // This is called onMouseUp on the overlay. We can't respond to the `isSelected` prop
    // changing, because that happens on mouse down, and the overlay immediately disappears,
    // and the mouse event can end up in the preview content. We can't use onClick on
    // the overlay to hide it either, because then the editor misses the mouseup event, and
    // thinks we're multi-selecting blocks.
    this.setState({
      interactive: true
    });
  }

  render() {
    const {
      preview,
      previewable,
      url,
      type,
      caption,
      onCaptionChange,
      isSelected,
      className,
      icon,
      label,
      insertBlocksAfter
    } = this.props;
    const {
      scripts
    } = preview;
    const {
      interactive
    } = this.state;
    const html = 'photo' === type ? getPhotoHtml(preview) : preview.html;
    const parsedHost = new URL(url).host.split('.');
    const parsedHostBaseUrl = parsedHost.splice(parsedHost.length - 2, parsedHost.length - 1).join('.');
    const iframeTitle = (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: host providing embed content e.g: www.youtube.com
    (0,external_wp_i18n_namespaceObject.__)('Embedded content from %s'), parsedHostBaseUrl);
    const sandboxClassnames = dedupe_default()(type, className, 'wp-block-embed__wrapper'); // Disabled because the overlay div doesn't actually have a role or functionality
    // as far as the user is concerned. We're just catching the first click so that
    // the block can be selected without interacting with the embed preview that the overlay covers.

    /* eslint-disable jsx-a11y/no-static-element-interactions */

    const embedWrapper = 'wp-embed' === type ? (0,external_wp_element_namespaceObject.createElement)(WpEmbedPreview, {
      html: html
    }) : (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-embed__wrapper"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SandBox, {
      html: html,
      scripts: scripts,
      title: iframeTitle,
      type: sandboxClassnames,
      onFocus: this.hideOverlay
    }), !interactive && (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-library-embed__interactive-overlay",
      onMouseUp: this.hideOverlay
    }));
    /* eslint-enable jsx-a11y/no-static-element-interactions */

    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: dedupe_default()(className, 'wp-block-embed', {
        'is-type-video': 'video' === type
      })
    }, previewable ? embedWrapper : (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
      icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
        icon: icon,
        showColors: true
      }),
      label: label
    }, (0,external_wp_element_namespaceObject.createElement)("p", {
      className: "components-placeholder__error"
    }, (0,external_wp_element_namespaceObject.createElement)("a", {
      href: url
    }, url)), (0,external_wp_element_namespaceObject.createElement)("p", {
      className: "components-placeholder__error"
    }, (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: host providing embed content e.g: www.youtube.com */
    (0,external_wp_i18n_namespaceObject.__)("Embedded content from %s can't be previewed in the editor."), parsedHostBaseUrl))), (!external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) || isSelected) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
      identifier: "caption",
      tagName: "figcaption",
      className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
      placeholder: (0,external_wp_i18n_namespaceObject.__)('Add caption'),
      value: caption,
      onChange: onCaptionChange,
      inlineToolbar: true,
      __unstableOnSplitAtEnd: () => insertBlocksAfter((0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()))
    }));
  }

}

/* harmony default export */ var embed_preview = (EmbedPreview);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/edit.js


/**
 * Internal dependencies
 */






/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */








const EmbedEdit = props => {
  const {
    attributes: {
      providerNameSlug,
      previewable,
      responsive,
      url: attributesUrl
    },
    attributes,
    isSelected,
    onReplace,
    setAttributes,
    insertBlocksAfter,
    onFocus
  } = props;
  const defaultEmbedInfo = {
    title: (0,external_wp_i18n_namespaceObject._x)('Embed', 'block title'),
    icon: embedContentIcon
  };
  const {
    icon,
    title
  } = getEmbedInfoByProvider(providerNameSlug) || defaultEmbedInfo;
  const [url, setURL] = (0,external_wp_element_namespaceObject.useState)(attributesUrl);
  const [isEditingURL, setIsEditingURL] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    invalidateResolution
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const {
    preview,
    fetching,
    themeSupportsResponsive,
    cannotEmbed
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEmbedPreview,
      isPreviewEmbedFallback,
      isRequestingEmbedPreview,
      getThemeSupports
    } = select(external_wp_coreData_namespaceObject.store);

    if (!attributesUrl) {
      return {
        fetching: false,
        cannotEmbed: false
      };
    }

    const embedPreview = getEmbedPreview(attributesUrl);
    const previewIsFallback = isPreviewEmbedFallback(attributesUrl); // The external oEmbed provider does not exist. We got no type info and no html.

    const badEmbedProvider = embedPreview?.html === false && embedPreview?.type === undefined; // Some WordPress URLs that can't be embedded will cause the API to return
    // a valid JSON response with no HTML and `data.status` set to 404, rather
    // than generating a fallback response as other embeds do.

    const wordpressCantEmbed = embedPreview?.data?.status === 404;
    const validPreview = !!embedPreview && !badEmbedProvider && !wordpressCantEmbed;
    return {
      preview: validPreview ? embedPreview : undefined,
      fetching: isRequestingEmbedPreview(attributesUrl),
      themeSupportsResponsive: getThemeSupports()['responsive-embeds'],
      cannotEmbed: !validPreview || previewIsFallback
    };
  }, [attributesUrl]);
  /**
   * Returns the attributes derived from the preview, merged with the current attributes.
   *
   * @return {Object} Merged attributes.
   */

  const getMergedAttributes = () => getMergedAttributesWithPreview(attributes, preview, title, responsive);

  const toggleResponsive = () => {
    const {
      allowResponsive,
      className
    } = attributes;
    const {
      html
    } = preview;
    const newAllowResponsive = !allowResponsive;
    setAttributes({
      allowResponsive: newAllowResponsive,
      className: getClassNames(html, className, responsive && newAllowResponsive)
    });
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!preview?.html || !cannotEmbed || fetching) {
      return;
    } // At this stage, we're not fetching the preview and know it can't be embedded,
    // so try removing any trailing slash, and resubmit.


    const newURL = attributesUrl.replace(/\/$/, '');
    setURL(newURL);
    setIsEditingURL(false);
    setAttributes({
      url: newURL
    });
  }, [preview?.html, attributesUrl, cannotEmbed, fetching]); // Handle incoming preview.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (preview && !isEditingURL) {
      // When obtaining an incoming preview,
      // we set the attributes derived from the preview data.
      const mergedAttributes = getMergedAttributes();
      setAttributes(mergedAttributes);

      if (onReplace) {
        const upgradedBlock = createUpgradedEmbedBlock(props, mergedAttributes);

        if (upgradedBlock) {
          onReplace(upgradedBlock);
        }
      }
    }
  }, [preview, isEditingURL]);
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();

  if (fetching) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)(embed_loading, null));
  } // translators: %s: type of embed e.g: "YouTube", "Twitter", etc. "Embed" is used when no specific type exists


  const label = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('%s URL'), title); // No preview, or we can't embed the current URL, or we've clicked the edit button.

  const showEmbedPlaceholder = !preview || cannotEmbed || isEditingURL;

  if (showEmbedPlaceholder) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)(embed_placeholder, {
      icon: icon,
      label: label,
      onFocus: onFocus,
      onSubmit: event => {
        if (event) {
          event.preventDefault();
        } // If the embed URL was changed, we need to reset the aspect ratio class.
        // To do this we have to remove the existing ratio class so it can be recalculated.


        const blockClass = removeAspectRatioClasses(attributes.className);
        setIsEditingURL(false);
        setAttributes({
          url,
          className: blockClass
        });
      },
      value: url,
      cannotEmbed: cannotEmbed,
      onChange: event => setURL(event.target.value),
      fallback: () => fallback(url, onReplace),
      tryAgain: () => {
        invalidateResolution('getEmbedPreview', [url]);
      }
    }));
  } // Even though we set attributes that get derived from the preview,
  // we don't access them directly because for the initial render,
  // the `setAttributes` call will not have taken effect. If we're
  // rendering responsive content, setting the responsive classes
  // after the preview has been rendered can result in unwanted
  // clipping or scrollbars. The `getAttributesFromPreview` function
  // that `getMergedAttributes` uses is memoized so that we're not
  // calculating them on every render.


  const {
    caption,
    type,
    allowResponsive,
    className: classFromPreview
  } = getMergedAttributes();
  const className = classnames_default()(classFromPreview, props.className);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(embed_controls, {
    showEditButton: preview && !cannotEmbed,
    themeSupportsResponsive: themeSupportsResponsive,
    blockSupportsResponsive: responsive,
    allowResponsive: allowResponsive,
    toggleResponsive: toggleResponsive,
    switchBackToURLInput: () => setIsEditingURL(true)
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(embed_preview, {
    preview: preview,
    previewable: previewable,
    className: className,
    url: url,
    type: type,
    caption: caption,
    onCaptionChange: value => setAttributes({
      caption: value
    }),
    isSelected: isSelected,
    icon: icon,
    label: label,
    insertBlocksAfter: insertBlocksAfter
  })));
};

/* harmony default export */ var embed_edit = (EmbedEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function embed_save_save({
  attributes
}) {
  const {
    url,
    caption,
    type,
    providerNameSlug
  } = attributes;

  if (!url) {
    return null;
  }

  const className = dedupe_default()('wp-block-embed', {
    [`is-type-${type}`]: type,
    [`is-provider-${providerNameSlug}`]: providerNameSlug,
    [`wp-block-embed-${providerNameSlug}`]: providerNameSlug
  });
  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className
    })
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-embed__wrapper"
  }, `\n${url}\n`
  /* URL needs to be on its own line. */
  ), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
    tagName: "figcaption",
    value: caption
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/transforms.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */

const transforms_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/embed",
  title: "Embed",
  category: "embed",
  description: "Add a block that displays content pulled from other sites, like Twitter or YouTube.",
  textdomain: "default",
  attributes: {
    url: {
      type: "string",
      __experimentalRole: "content"
    },
    caption: {
      type: "string",
      source: "html",
      selector: "figcaption",
      __experimentalRole: "content"
    },
    type: {
      type: "string",
      __experimentalRole: "content"
    },
    providerNameSlug: {
      type: "string",
      __experimentalRole: "content"
    },
    allowResponsive: {
      type: "boolean",
      "default": true
    },
    responsive: {
      type: "boolean",
      "default": false,
      __experimentalRole: "content"
    },
    previewable: {
      type: "boolean",
      "default": true,
      __experimentalRole: "content"
    }
  },
  supports: {
    align: true,
    spacing: {
      margin: true
    }
  },
  editorStyle: "wp-block-embed-editor",
  style: "wp-block-embed"
};
const {
  name: EMBED_BLOCK
} = transforms_metadata;
/**
 * Default transforms for generic embeds.
 */

const embed_transforms_transforms = {
  from: [{
    type: 'raw',
    isMatch: node => node.nodeName === 'P' && /^\s*(https?:\/\/\S+)\s*$/i.test(node.textContent) && node.textContent?.match(/https/gi)?.length === 1,
    transform: node => {
      return (0,external_wp_blocks_namespaceObject.createBlock)(EMBED_BLOCK, {
        url: node.textContent.trim()
      });
    }
  }],
  to: [{
    type: 'block',
    blocks: ['core/paragraph'],
    isMatch: ({
      url
    }) => !!url,
    transform: ({
      url,
      caption
    }) => {
      let value = `<a href="${url}">${url}</a>`;

      if (caption?.trim()) {
        value += `<br />${caption}`;
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
        content: value
      });
    }
  }]
};
/* harmony default export */ var embed_transforms = (embed_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/variations.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/blocks').WPBlockVariation} WPBlockVariation */

/**
 * The embed provider services.
 *
 * @type {WPBlockVariation[]}
 */

const embed_variations_variations = [{
  name: 'twitter',
  title: 'Twitter',
  icon: embedTwitterIcon,
  keywords: ['tweet', (0,external_wp_i18n_namespaceObject.__)('social')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a tweet.'),
  patterns: [/^https?:\/\/(www\.)?twitter\.com\/.+/i],
  attributes: {
    providerNameSlug: 'twitter',
    responsive: true
  }
}, {
  name: 'youtube',
  title: 'YouTube',
  icon: embedYouTubeIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('music'), (0,external_wp_i18n_namespaceObject.__)('video')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a YouTube video.'),
  patterns: [/^https?:\/\/((m|www)\.)?youtube\.com\/.+/i, /^https?:\/\/youtu\.be\/.+/i],
  attributes: {
    providerNameSlug: 'youtube',
    responsive: true
  }
}, {
  // Deprecate Facebook Embed per FB policy
  // See: https://developers.facebook.com/docs/plugins/oembed-legacy
  name: 'facebook',
  title: 'Facebook',
  icon: embedFacebookIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('social')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a Facebook post.'),
  scope: ['block'],
  patterns: [],
  attributes: {
    providerNameSlug: 'facebook',
    previewable: false,
    responsive: true
  }
}, {
  // Deprecate Instagram per FB policy
  // See: https://developers.facebook.com/docs/instagram/oembed-legacy
  name: 'instagram',
  title: 'Instagram',
  icon: embedInstagramIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('image'), (0,external_wp_i18n_namespaceObject.__)('social')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed an Instagram post.'),
  scope: ['block'],
  patterns: [],
  attributes: {
    providerNameSlug: 'instagram',
    responsive: true
  }
}, {
  name: 'wordpress',
  title: 'WordPress',
  icon: embedWordPressIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('post'), (0,external_wp_i18n_namespaceObject.__)('blog')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a WordPress post.'),
  attributes: {
    providerNameSlug: 'wordpress'
  }
}, {
  name: 'soundcloud',
  title: 'SoundCloud',
  icon: embedAudioIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('music'), (0,external_wp_i18n_namespaceObject.__)('audio')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed SoundCloud content.'),
  patterns: [/^https?:\/\/(www\.)?soundcloud\.com\/.+/i],
  attributes: {
    providerNameSlug: 'soundcloud',
    responsive: true
  }
}, {
  name: 'spotify',
  title: 'Spotify',
  icon: embedSpotifyIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('music'), (0,external_wp_i18n_namespaceObject.__)('audio')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Spotify content.'),
  patterns: [/^https?:\/\/(open|play)\.spotify\.com\/.+/i],
  attributes: {
    providerNameSlug: 'spotify',
    responsive: true
  }
}, {
  name: 'flickr',
  title: 'Flickr',
  icon: embedFlickrIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('image')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Flickr content.'),
  patterns: [/^https?:\/\/(www\.)?flickr\.com\/.+/i, /^https?:\/\/flic\.kr\/.+/i],
  attributes: {
    providerNameSlug: 'flickr',
    responsive: true
  }
}, {
  name: 'vimeo',
  title: 'Vimeo',
  icon: embedVimeoIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('video')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a Vimeo video.'),
  patterns: [/^https?:\/\/(www\.)?vimeo\.com\/.+/i],
  attributes: {
    providerNameSlug: 'vimeo',
    responsive: true
  }
}, {
  name: 'animoto',
  title: 'Animoto',
  icon: embedAnimotoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed an Animoto video.'),
  patterns: [/^https?:\/\/(www\.)?(animoto|video214)\.com\/.+/i],
  attributes: {
    providerNameSlug: 'animoto',
    responsive: true
  }
}, {
  name: 'cloudup',
  title: 'Cloudup',
  icon: embedContentIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Cloudup content.'),
  patterns: [/^https?:\/\/cloudup\.com\/.+/i],
  attributes: {
    providerNameSlug: 'cloudup',
    responsive: true
  }
}, {
  // Deprecated since CollegeHumor content is now powered by YouTube.
  name: 'collegehumor',
  title: 'CollegeHumor',
  icon: embedVideoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed CollegeHumor content.'),
  scope: ['block'],
  patterns: [],
  attributes: {
    providerNameSlug: 'collegehumor',
    responsive: true
  }
}, {
  name: 'crowdsignal',
  title: 'Crowdsignal',
  icon: embedContentIcon,
  keywords: ['polldaddy', (0,external_wp_i18n_namespaceObject.__)('survey')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Crowdsignal (formerly Polldaddy) content.'),
  patterns: [/^https?:\/\/((.+\.)?polldaddy\.com|poll\.fm|.+\.crowdsignal\.net|.+\.survey\.fm)\/.+/i],
  attributes: {
    providerNameSlug: 'crowdsignal',
    responsive: true
  }
}, {
  name: 'dailymotion',
  title: 'Dailymotion',
  icon: embedDailymotionIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('video')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a Dailymotion video.'),
  patterns: [/^https?:\/\/(www\.)?dailymotion\.com\/.+/i],
  attributes: {
    providerNameSlug: 'dailymotion',
    responsive: true
  }
}, {
  name: 'imgur',
  title: 'Imgur',
  icon: embedPhotoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Imgur content.'),
  patterns: [/^https?:\/\/(.+\.)?imgur\.com\/.+/i],
  attributes: {
    providerNameSlug: 'imgur',
    responsive: true
  }
}, {
  name: 'issuu',
  title: 'Issuu',
  icon: embedContentIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Issuu content.'),
  patterns: [/^https?:\/\/(www\.)?issuu\.com\/.+/i],
  attributes: {
    providerNameSlug: 'issuu',
    responsive: true
  }
}, {
  name: 'kickstarter',
  title: 'Kickstarter',
  icon: embedContentIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Kickstarter content.'),
  patterns: [/^https?:\/\/(www\.)?kickstarter\.com\/.+/i, /^https?:\/\/kck\.st\/.+/i],
  attributes: {
    providerNameSlug: 'kickstarter',
    responsive: true
  }
}, {
  name: 'mixcloud',
  title: 'Mixcloud',
  icon: embedAudioIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('music'), (0,external_wp_i18n_namespaceObject.__)('audio')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Mixcloud content.'),
  patterns: [/^https?:\/\/(www\.)?mixcloud\.com\/.+/i],
  attributes: {
    providerNameSlug: 'mixcloud',
    responsive: true
  }
}, {
  name: 'pocket-casts',
  title: 'Pocket Casts',
  icon: embedPocketCastsIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('podcast'), (0,external_wp_i18n_namespaceObject.__)('audio')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a podcast player from Pocket Casts.'),
  patterns: [/^https:\/\/pca.st\/\w+/i],
  attributes: {
    providerNameSlug: 'pocket-casts',
    responsive: true
  }
}, {
  name: 'reddit',
  title: 'Reddit',
  icon: embedRedditIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a Reddit thread.'),
  patterns: [/^https?:\/\/(www\.)?reddit\.com\/.+/i],
  attributes: {
    providerNameSlug: 'reddit',
    responsive: true
  }
}, {
  name: 'reverbnation',
  title: 'ReverbNation',
  icon: embedAudioIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed ReverbNation content.'),
  patterns: [/^https?:\/\/(www\.)?reverbnation\.com\/.+/i],
  attributes: {
    providerNameSlug: 'reverbnation',
    responsive: true
  }
}, {
  name: 'screencast',
  title: 'Screencast',
  icon: embedVideoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Screencast content.'),
  patterns: [/^https?:\/\/(www\.)?screencast\.com\/.+/i],
  attributes: {
    providerNameSlug: 'screencast',
    responsive: true
  }
}, {
  name: 'scribd',
  title: 'Scribd',
  icon: embedContentIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Scribd content.'),
  patterns: [/^https?:\/\/(www\.)?scribd\.com\/.+/i],
  attributes: {
    providerNameSlug: 'scribd',
    responsive: true
  }
}, {
  name: 'slideshare',
  title: 'Slideshare',
  icon: embedContentIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Slideshare content.'),
  patterns: [/^https?:\/\/(.+?\.)?slideshare\.net\/.+/i],
  attributes: {
    providerNameSlug: 'slideshare',
    responsive: true
  }
}, {
  name: 'smugmug',
  title: 'SmugMug',
  icon: embedPhotoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed SmugMug content.'),
  patterns: [/^https?:\/\/(.+\.)?smugmug\.com\/.*/i],
  attributes: {
    providerNameSlug: 'smugmug',
    previewable: false,
    responsive: true
  }
}, {
  name: 'speaker-deck',
  title: 'Speaker Deck',
  icon: embedContentIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Speaker Deck content.'),
  patterns: [/^https?:\/\/(www\.)?speakerdeck\.com\/.+/i],
  attributes: {
    providerNameSlug: 'speaker-deck',
    responsive: true
  }
}, {
  name: 'tiktok',
  title: 'TikTok',
  icon: embedVideoIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('video')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a TikTok video.'),
  patterns: [/^https?:\/\/(www\.)?tiktok\.com\/.+/i],
  attributes: {
    providerNameSlug: 'tiktok',
    responsive: true
  }
}, {
  name: 'ted',
  title: 'TED',
  icon: embedVideoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a TED video.'),
  patterns: [/^https?:\/\/(www\.|embed\.)?ted\.com\/.+/i],
  attributes: {
    providerNameSlug: 'ted',
    responsive: true
  }
}, {
  name: 'tumblr',
  title: 'Tumblr',
  icon: embedTumblrIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('social')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a Tumblr post.'),
  patterns: [/^https?:\/\/(.+)\.tumblr\.com\/.+/i],
  attributes: {
    providerNameSlug: 'tumblr',
    responsive: true
  }
}, {
  name: 'videopress',
  title: 'VideoPress',
  icon: embedVideoIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('video')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a VideoPress video.'),
  patterns: [/^https?:\/\/videopress\.com\/.+/i],
  attributes: {
    providerNameSlug: 'videopress',
    responsive: true
  }
}, {
  name: 'wordpress-tv',
  title: 'WordPress.tv',
  icon: embedVideoIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed a WordPress.tv video.'),
  patterns: [/^https?:\/\/wordpress\.tv\/.+/i],
  attributes: {
    providerNameSlug: 'wordpress-tv',
    responsive: true
  }
}, {
  name: 'amazon-kindle',
  title: 'Amazon Kindle',
  icon: embedAmazonIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('ebook')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Amazon Kindle content.'),
  patterns: [/^https?:\/\/([a-z0-9-]+\.)?(amazon|amzn)(\.[a-z]{2,4})+\/.+/i, /^https?:\/\/(www\.)?(a\.co|z\.cn)\/.+/i],
  attributes: {
    providerNameSlug: 'amazon-kindle'
  }
}, {
  name: 'pinterest',
  title: 'Pinterest',
  icon: embedPinterestIcon,
  keywords: [(0,external_wp_i18n_namespaceObject.__)('social'), (0,external_wp_i18n_namespaceObject.__)('bookmark')],
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Pinterest pins, boards, and profiles.'),
  patterns: [/^https?:\/\/([a-z]{2}|www)\.pinterest\.com(\.(au|mx))?\/.*/i],
  attributes: {
    providerNameSlug: 'pinterest'
  }
}, {
  name: 'wolfram-cloud',
  title: 'Wolfram',
  icon: embedWolframIcon,
  description: (0,external_wp_i18n_namespaceObject.__)('Embed Wolfram notebook content.'),
  patterns: [/^https?:\/\/(www\.)?wolframcloud\.com\/obj\/.+/i],
  attributes: {
    providerNameSlug: 'wolfram-cloud',
    responsive: true
  }
}];
/**
 * Add `isActive` function to all `embed` variations, if not defined.
 * `isActive` function is used to find a variation match from a created
 *  Block by providing its attributes.
 */

embed_variations_variations.forEach(variation => {
  if (variation.isActive) return;

  variation.isActive = (blockAttributes, variationAttributes) => blockAttributes.providerNameSlug === variationAttributes.providerNameSlug;
});
/* harmony default export */ var embed_variations = (embed_variations_variations);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/deprecated.js


/**
 * External dependencies
 */

/**
 * Internal dependencies
 */

const embed_deprecated_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/embed",
  title: "Embed",
  category: "embed",
  description: "Add a block that displays content pulled from other sites, like Twitter or YouTube.",
  textdomain: "default",
  attributes: {
    url: {
      type: "string",
      __experimentalRole: "content"
    },
    caption: {
      type: "string",
      source: "html",
      selector: "figcaption",
      __experimentalRole: "content"
    },
    type: {
      type: "string",
      __experimentalRole: "content"
    },
    providerNameSlug: {
      type: "string",
      __experimentalRole: "content"
    },
    allowResponsive: {
      type: "boolean",
      "default": true
    },
    responsive: {
      type: "boolean",
      "default": false,
      __experimentalRole: "content"
    },
    previewable: {
      type: "boolean",
      "default": true,
      __experimentalRole: "content"
    }
  },
  supports: {
    align: true,
    spacing: {
      margin: true
    }
  },
  editorStyle: "wp-block-embed-editor",
  style: "wp-block-embed"
};
/**
 * WordPress dependencies
 */


const {
  attributes: embed_deprecated_blockAttributes
} = embed_deprecated_metadata; // In #41140 support was added to global styles for caption elements which added a `wp-element-caption` classname
// to the embed figcaption element.

const deprecated_v2 = {
  attributes: embed_deprecated_blockAttributes,

  save({
    attributes
  }) {
    const {
      url,
      caption,
      type,
      providerNameSlug
    } = attributes;

    if (!url) {
      return null;
    }

    const className = classnames_default()('wp-block-embed', {
      [`is-type-${type}`]: type,
      [`is-provider-${providerNameSlug}`]: providerNameSlug,
      [`wp-block-embed-${providerNameSlug}`]: providerNameSlug
    });
    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className
      })
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-embed__wrapper"
    }, `\n${url}\n`
    /* URL needs to be on its own line. */
    ), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
  }

};
const embed_deprecated_v1 = {
  attributes: embed_deprecated_blockAttributes,

  save({
    attributes: {
      url,
      caption,
      type,
      providerNameSlug
    }
  }) {
    if (!url) {
      return null;
    }

    const embedClassName = classnames_default()('wp-block-embed', {
      [`is-type-${type}`]: type,
      [`is-provider-${providerNameSlug}`]: providerNameSlug
    });
    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: embedClassName
    }, `\n${url}\n`
    /* URL needs to be on its own line. */
    , !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
  }

};
const embed_deprecated_deprecated = [deprecated_v2, embed_deprecated_v1];
/* harmony default export */ var embed_deprecated = (embed_deprecated_deprecated);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/embed/index.js
/**
 * Internal dependencies
 */



const embed_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/embed",
  title: "Embed",
  category: "embed",
  description: "Add a block that displays content pulled from other sites, like Twitter or YouTube.",
  textdomain: "default",
  attributes: {
    url: {
      type: "string",
      __experimentalRole: "content"
    },
    caption: {
      type: "string",
      source: "html",
      selector: "figcaption",
      __experimentalRole: "content"
    },
    type: {
      type: "string",
      __experimentalRole: "content"
    },
    providerNameSlug: {
      type: "string",
      __experimentalRole: "content"
    },
    allowResponsive: {
      type: "boolean",
      "default": true
    },
    responsive: {
      type: "boolean",
      "default": false,
      __experimentalRole: "content"
    },
    previewable: {
      type: "boolean",
      "default": true,
      __experimentalRole: "content"
    }
  },
  supports: {
    align: true,
    spacing: {
      margin: true
    }
  },
  editorStyle: "wp-block-embed-editor",
  style: "wp-block-embed"
};




const {
  name: embed_name
} = embed_metadata;

const embed_settings = {
  icon: embedContentIcon,
  edit: embed_edit,
  save: embed_save_save,
  transforms: embed_transforms,
  variations: embed_variations,
  deprecated: embed_deprecated
};
const embed_init = () => initBlock({
  name: embed_name,
  metadata: embed_metadata,
  settings: embed_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/file.js


/**
 * WordPress dependencies
 */

const file = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 6.2h-5.9l-.6-1.1c-.3-.7-1-1.1-1.8-1.1H5c-1.1 0-2 .9-2 2v11.8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V8.2c0-1.1-.9-2-2-2zm.5 11.6c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h5.8c.2 0 .4.1.4.3l1 2H19c.3 0 .5.2.5.5v9.5z"
}));
/* harmony default export */ var library_file = (file);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


 // Version of the file block without PR#43050 removing the translated aria-label.

const deprecated_v3 = {
  attributes: {
    id: {
      type: 'number'
    },
    href: {
      type: 'string'
    },
    fileId: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'id'
    },
    fileName: {
      type: 'string',
      source: 'html',
      selector: 'a:not([download])'
    },
    textLinkHref: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'href'
    },
    textLinkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'target'
    },
    showDownloadButton: {
      type: 'boolean',
      default: true
    },
    downloadButtonText: {
      type: 'string',
      source: 'html',
      selector: 'a[download]'
    },
    displayPreview: {
      type: 'boolean'
    },
    previewHeight: {
      type: 'number',
      default: 600
    }
  },
  supports: {
    anchor: true,
    align: true
  },

  save({
    attributes
  }) {
    const {
      href,
      fileId,
      fileName,
      textLinkHref,
      textLinkTarget,
      showDownloadButton,
      downloadButtonText,
      displayPreview,
      previewHeight
    } = attributes;
    const pdfEmbedLabel = external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName) ? (0,external_wp_i18n_namespaceObject.__)('PDF embed') : (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: filename. */
    (0,external_wp_i18n_namespaceObject.__)('Embed of %s.'), fileName);
    const hasFilename = !external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName); // Only output an `aria-describedby` when the element it's referring to is
    // actually rendered.

    const describedById = hasFilename ? fileId : undefined;
    return href && (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
    }, displayPreview && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("object", {
      className: "wp-block-file__embed",
      data: href,
      type: "application/pdf",
      style: {
        width: '100%',
        height: `${previewHeight}px`
      },
      "aria-label": pdfEmbedLabel
    })), hasFilename && (0,external_wp_element_namespaceObject.createElement)("a", {
      id: describedById,
      href: textLinkHref,
      target: textLinkTarget,
      rel: textLinkTarget ? 'noreferrer noopener' : undefined
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: fileName
    })), showDownloadButton && (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href,
      className: classnames_default()('wp-block-file__button', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('button')),
      download: true,
      "aria-describedby": describedById
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: downloadButtonText
    })));
  }

}; // In #41239 the button was made an element button which added a `wp-element-button` classname
// to the download link element.

const file_deprecated_v2 = {
  attributes: {
    id: {
      type: 'number'
    },
    href: {
      type: 'string'
    },
    fileId: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'id'
    },
    fileName: {
      type: 'string',
      source: 'html',
      selector: 'a:not([download])'
    },
    textLinkHref: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'href'
    },
    textLinkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'target'
    },
    showDownloadButton: {
      type: 'boolean',
      default: true
    },
    downloadButtonText: {
      type: 'string',
      source: 'html',
      selector: 'a[download]'
    },
    displayPreview: {
      type: 'boolean'
    },
    previewHeight: {
      type: 'number',
      default: 600
    }
  },
  supports: {
    anchor: true,
    align: true
  },

  save({
    attributes
  }) {
    const {
      href,
      fileId,
      fileName,
      textLinkHref,
      textLinkTarget,
      showDownloadButton,
      downloadButtonText,
      displayPreview,
      previewHeight
    } = attributes;
    const pdfEmbedLabel = external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName) ? (0,external_wp_i18n_namespaceObject.__)('PDF embed') : (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: filename. */
    (0,external_wp_i18n_namespaceObject.__)('Embed of %s.'), fileName);
    const hasFilename = !external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName); // Only output an `aria-describedby` when the element it's referring to is
    // actually rendered.

    const describedById = hasFilename ? fileId : undefined;
    return href && (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
    }, displayPreview && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("object", {
      className: "wp-block-file__embed",
      data: href,
      type: "application/pdf",
      style: {
        width: '100%',
        height: `${previewHeight}px`
      },
      "aria-label": pdfEmbedLabel
    })), hasFilename && (0,external_wp_element_namespaceObject.createElement)("a", {
      id: describedById,
      href: textLinkHref,
      target: textLinkTarget,
      rel: textLinkTarget ? 'noreferrer noopener' : undefined
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: fileName
    })), showDownloadButton && (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href,
      className: "wp-block-file__button",
      download: true,
      "aria-describedby": describedById
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: downloadButtonText
    })));
  }

}; // Version of the file block without PR#28062 accessibility fix.

const file_deprecated_v1 = {
  attributes: {
    id: {
      type: 'number'
    },
    href: {
      type: 'string'
    },
    fileName: {
      type: 'string',
      source: 'html',
      selector: 'a:not([download])'
    },
    textLinkHref: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'href'
    },
    textLinkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'a:not([download])',
      attribute: 'target'
    },
    showDownloadButton: {
      type: 'boolean',
      default: true
    },
    downloadButtonText: {
      type: 'string',
      source: 'html',
      selector: 'a[download]'
    },
    displayPreview: {
      type: 'boolean'
    },
    previewHeight: {
      type: 'number',
      default: 600
    }
  },
  supports: {
    anchor: true,
    align: true
  },

  save({
    attributes
  }) {
    const {
      href,
      fileName,
      textLinkHref,
      textLinkTarget,
      showDownloadButton,
      downloadButtonText,
      displayPreview,
      previewHeight
    } = attributes;
    const pdfEmbedLabel = external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName) ? (0,external_wp_i18n_namespaceObject.__)('PDF embed') : (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: filename. */
    (0,external_wp_i18n_namespaceObject.__)('Embed of %s.'), fileName);
    return href && (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
    }, displayPreview && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("object", {
      className: "wp-block-file__embed",
      data: href,
      type: "application/pdf",
      style: {
        width: '100%',
        height: `${previewHeight}px`
      },
      "aria-label": pdfEmbedLabel
    })), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName) && (0,external_wp_element_namespaceObject.createElement)("a", {
      href: textLinkHref,
      target: textLinkTarget,
      rel: textLinkTarget ? 'noreferrer noopener' : undefined
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: fileName
    })), showDownloadButton && (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href,
      className: "wp-block-file__button",
      download: true
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: downloadButtonText
    })));
  }

};
const file_deprecated_deprecated = [deprecated_v3, file_deprecated_v2, file_deprecated_v1];
/* harmony default export */ var file_deprecated = (file_deprecated_deprecated);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/inspector.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function FileBlockInspector({
  hrefs,
  openInNewWindow,
  showDownloadButton,
  changeLinkDestinationOption,
  changeOpenInNewWindow,
  changeShowDownloadButton,
  displayPreview,
  changeDisplayPreview,
  previewHeight,
  changePreviewHeight
}) {
  const {
    href,
    textLinkHref,
    attachmentPage
  } = hrefs;
  let linkDestinationOptions = [{
    value: href,
    label: (0,external_wp_i18n_namespaceObject.__)('URL')
  }];

  if (attachmentPage) {
    linkDestinationOptions = [{
      value: href,
      label: (0,external_wp_i18n_namespaceObject.__)('Media file')
    }, {
      value: attachmentPage,
      label: (0,external_wp_i18n_namespaceObject.__)('Attachment page')
    }];
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, href.endsWith('.pdf') && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('PDF settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show inline embed'),
    help: displayPreview ? (0,external_wp_i18n_namespaceObject.__)("Note: Most phone and tablet browsers won't display embedded PDFs.") : null,
    checked: !!displayPreview,
    onChange: changeDisplayPreview
  }), displayPreview && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Height in pixels'),
    min: MIN_PREVIEW_HEIGHT,
    max: Math.max(MAX_PREVIEW_HEIGHT, previewHeight),
    value: previewHeight,
    onChange: changePreviewHeight
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Link to'),
    value: textLinkHref,
    options: linkDestinationOptions,
    onChange: changeLinkDestinationOption
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Open in new tab'),
    checked: openInNewWindow,
    onChange: changeOpenInNewWindow
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Show download button'),
    checked: showDownloadButton,
    onChange: changeShowDownloadButton
  }))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/utils/index.js
/**
 * Uses a combination of user agent matching and feature detection to determine whether
 * the current browser supports rendering PDFs inline.
 *
 * @return {boolean} Whether or not the browser supports inline PDFs.
 */
const browserSupportsPdfs = () => {
  // Most mobile devices include "Mobi" in their UA.
  if (window.navigator.userAgent.indexOf('Mobi') > -1) {
    return false;
  } // Android tablets are the noteable exception.


  if (window.navigator.userAgent.indexOf('Android') > -1) {
    return false;
  } // iPad pretends to be a Mac.


  if (window.navigator.userAgent.indexOf('Macintosh') > -1 && window.navigator.maxTouchPoints && window.navigator.maxTouchPoints > 2) {
    return false;
  } // IE only supports PDFs when there's an ActiveX object available for it.


  if (!!(window.ActiveXObject || 'ActiveXObject' in window) && !(createActiveXObject('AcroPDF.PDF') || createActiveXObject('PDF.PdfCtrl'))) {
    return false;
  }

  return true;
};
/**
 * Helper function for creating ActiveX objects, catching any errors that are thrown
 * when it's generated.
 *
 * @param {string} type The name of the ActiveX object to create.
 * @return {window.ActiveXObject|undefined} The generated ActiveXObject, or null if it failed.
 */

const createActiveXObject = type => {
  let ax;

  try {
    ax = new window.ActiveXObject(type);
  } catch (e) {
    ax = undefined;
  }

  return ax;
};
/**
 * Hides all .wp-block-file__embed elements on the document. This function is only intended
 * to be run on the front-end, it may have weird side effects running in the block editor.
 */


const hidePdfEmbedsOnUnsupportedBrowsers = () => {
  if (!browserSupportsPdfs()) {
    const embeds = document.getElementsByClassName('wp-block-file__embed');
    Array.from(embeds).forEach(embed => {
      embed.style.display = 'none';
    });
  }
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */



const MIN_PREVIEW_HEIGHT = 200;
const MAX_PREVIEW_HEIGHT = 2000;

function ClipboardToolbarButton({
  text,
  disabled
}) {
  const {
    createNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const ref = (0,external_wp_compose_namespaceObject.useCopyToClipboard)(text, () => {
    createNotice('info', (0,external_wp_i18n_namespaceObject.__)('Copied URL to clipboard.'), {
      isDismissible: true,
      type: 'snackbar'
    });
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    className: "components-clipboard-toolbar-button",
    ref: ref,
    disabled: disabled
  }, (0,external_wp_i18n_namespaceObject.__)('Copy URL'));
}

function FileEdit({
  attributes,
  isSelected,
  setAttributes,
  clientId
}) {
  const {
    id,
    fileId,
    fileName,
    href,
    textLinkHref,
    textLinkTarget,
    showDownloadButton,
    downloadButtonText,
    displayPreview,
    previewHeight
  } = attributes;
  const {
    media,
    mediaUpload
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    media: id === undefined ? undefined : select(external_wp_coreData_namespaceObject.store).getMedia(id),
    mediaUpload: select(external_wp_blockEditor_namespaceObject.store).getSettings().mediaUpload
  }), [id]);
  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    toggleSelection,
    __unstableMarkNextChangeAsNotPersistent
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Upload a file drag-and-dropped into the editor.
    if ((0,external_wp_blob_namespaceObject.isBlobURL)(href)) {
      const file = (0,external_wp_blob_namespaceObject.getBlobByURL)(href);
      mediaUpload({
        filesList: [file],
        onFileChange: ([newMedia]) => onSelectFile(newMedia),
        onError: onUploadError
      });
      (0,external_wp_blob_namespaceObject.revokeBlobURL)(href);
    }

    if (downloadButtonText === undefined) {
      changeDownloadButtonText((0,external_wp_i18n_namespaceObject._x)('Download', 'button label'));
    }
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!fileId && href) {
      // Add a unique fileId to each file block.
      __unstableMarkNextChangeAsNotPersistent();

      setAttributes({
        fileId: `wp-block-file--media-${clientId}`
      });
    }
  }, [href, fileId, clientId]);

  function onSelectFile(newMedia) {
    if (newMedia && newMedia.url) {
      const isPdf = newMedia.url.endsWith('.pdf');
      setAttributes({
        href: newMedia.url,
        fileName: newMedia.title,
        textLinkHref: newMedia.url,
        id: newMedia.id,
        displayPreview: isPdf ? true : undefined,
        previewHeight: isPdf ? 600 : undefined
      });
    }
  }

  function onUploadError(message) {
    setAttributes({
      href: undefined
    });
    createErrorNotice(message, {
      type: 'snackbar'
    });
  }

  function changeLinkDestinationOption(newHref) {
    // Choose Media File or Attachment Page (when file is in Media Library).
    setAttributes({
      textLinkHref: newHref
    });
  }

  function changeOpenInNewWindow(newValue) {
    setAttributes({
      textLinkTarget: newValue ? '_blank' : false
    });
  }

  function changeShowDownloadButton(newValue) {
    setAttributes({
      showDownloadButton: newValue
    });
  }

  function changeDownloadButtonText(newValue) {
    // Remove anchor tags from button text content.
    setAttributes({
      downloadButtonText: newValue.replace(/<\/?a[^>]*>/g, '')
    });
  }

  function changeDisplayPreview(newValue) {
    setAttributes({
      displayPreview: newValue
    });
  }

  function handleOnResizeStop(event, direction, elt, delta) {
    toggleSelection(true);
    const newHeight = parseInt(previewHeight + delta.height, 10);
    setAttributes({
      previewHeight: newHeight
    });
  }

  function changePreviewHeight(newValue) {
    const newHeight = Math.max(parseInt(newValue, 10), MIN_PREVIEW_HEIGHT);
    setAttributes({
      previewHeight: newHeight
    });
  }

  const attachmentPage = media && media.link;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()((0,external_wp_blob_namespaceObject.isBlobURL)(href) && (0,external_wp_components_namespaceObject.__unstableGetAnimateClassName)({
      type: 'loading'
    }), {
      'is-transient': (0,external_wp_blob_namespaceObject.isBlobURL)(href)
    })
  });
  const displayPreviewInEditor = browserSupportsPdfs() && displayPreview;

  if (!href) {
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
      icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
        icon: library_file
      }),
      labels: {
        title: (0,external_wp_i18n_namespaceObject.__)('File'),
        instructions: (0,external_wp_i18n_namespaceObject.__)('Upload a file or pick one from your media library.')
      },
      onSelect: onSelectFile,
      onError: onUploadError,
      accept: "*"
    }));
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(FileBlockInspector, {
    hrefs: {
      href,
      textLinkHref,
      attachmentPage
    },
    openInNewWindow: !!textLinkTarget,
    showDownloadButton,
    changeLinkDestinationOption,
    changeOpenInNewWindow,
    changeShowDownloadButton,
    displayPreview,
    changeDisplayPreview,
    previewHeight,
    changePreviewHeight
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "other"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaReplaceFlow, {
    mediaId: id,
    mediaURL: href,
    accept: "*",
    onSelect: onSelectFile,
    onError: onUploadError
  }), (0,external_wp_element_namespaceObject.createElement)(ClipboardToolbarButton, {
    text: href,
    disabled: (0,external_wp_blob_namespaceObject.isBlobURL)(href)
  })), (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, displayPreviewInEditor && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ResizableBox, {
    size: {
      height: previewHeight
    },
    minHeight: MIN_PREVIEW_HEIGHT,
    maxHeight: MAX_PREVIEW_HEIGHT,
    minWidth: "100%",
    grid: [10, 10],
    enable: {
      top: false,
      right: false,
      bottom: true,
      left: false,
      topRight: false,
      bottomRight: false,
      bottomLeft: false,
      topLeft: false
    },
    onResizeStart: () => toggleSelection(false),
    onResizeStop: handleOnResizeStop,
    showHandle: isSelected
  }, (0,external_wp_element_namespaceObject.createElement)("object", {
    className: "wp-block-file__preview",
    data: href,
    type: "application/pdf",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Embed of the selected PDF file.')
  }), !isSelected && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-file__preview-overlay"
  })), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: 'wp-block-file__content-wrapper'
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    tagName: "a",
    value: fileName,
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write file name…'),
    withoutInteractiveFormatting: true,
    onChange: text => setAttributes({
      fileName: text
    }),
    href: textLinkHref
  }), showDownloadButton && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: 'wp-block-file__button-richtext-wrapper'
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    tagName: "div" // Must be block-level or else cursor disappears.
    ,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Download button text'),
    className: classnames_default()('wp-block-file__button', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('button')),
    value: downloadButtonText,
    withoutInteractiveFormatting: true,
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Add text…'),
    onChange: text => changeDownloadButtonText(text)
  })))));
}

/* harmony default export */ var file_edit = (FileEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function file_save_save({
  attributes
}) {
  const {
    href,
    fileId,
    fileName,
    textLinkHref,
    textLinkTarget,
    showDownloadButton,
    downloadButtonText,
    displayPreview,
    previewHeight
  } = attributes;
  const pdfEmbedLabel = external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName) ? 'PDF embed' : fileName;
  const hasFilename = !external_wp_blockEditor_namespaceObject.RichText.isEmpty(fileName); // Only output an `aria-describedby` when the element it's referring to is
  // actually rendered.

  const describedById = hasFilename ? fileId : undefined;
  return href && (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
  }, displayPreview && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("object", {
    className: "wp-block-file__embed",
    data: href,
    type: "application/pdf",
    style: {
      width: '100%',
      height: `${previewHeight}px`
    },
    "aria-label": pdfEmbedLabel
  })), hasFilename && (0,external_wp_element_namespaceObject.createElement)("a", {
    id: describedById,
    href: textLinkHref,
    target: textLinkTarget,
    rel: textLinkTarget ? 'noreferrer noopener' : undefined
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    value: fileName
  })), showDownloadButton && (0,external_wp_element_namespaceObject.createElement)("a", {
    href: href,
    className: classnames_default()('wp-block-file__button', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('button')),
    download: true,
    "aria-describedby": describedById
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    value: downloadButtonText
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/transforms.js
/**
 * WordPress dependencies
 */





const file_transforms_transforms = {
  from: [{
    type: 'files',

    isMatch(files) {
      return files.length > 0;
    },

    // We define a lower priorty (higher number) than the default of 10. This
    // ensures that the File block is only created as a fallback.
    priority: 15,
    transform: files => {
      const blocks = [];
      files.forEach(file => {
        const blobURL = (0,external_wp_blob_namespaceObject.createBlobURL)(file); // File will be uploaded in componentDidMount()

        blocks.push((0,external_wp_blocks_namespaceObject.createBlock)('core/file', {
          href: blobURL,
          fileName: file.name,
          textLinkHref: blobURL
        }));
      });
      return blocks;
    }
  }, {
    type: 'block',
    blocks: ['core/audio'],
    transform: attributes => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/file', {
        href: attributes.src,
        fileName: attributes.caption,
        textLinkHref: attributes.src,
        id: attributes.id,
        anchor: attributes.anchor
      });
    }
  }, {
    type: 'block',
    blocks: ['core/video'],
    transform: attributes => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/file', {
        href: attributes.src,
        fileName: attributes.caption,
        textLinkHref: attributes.src,
        id: attributes.id,
        anchor: attributes.anchor
      });
    }
  }, {
    type: 'block',
    blocks: ['core/image'],
    transform: attributes => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/file', {
        href: attributes.url,
        fileName: attributes.caption || (0,external_wp_url_namespaceObject.getFilename)(attributes.url),
        textLinkHref: attributes.url,
        id: attributes.id,
        anchor: attributes.anchor
      });
    }
  }],
  to: [{
    type: 'block',
    blocks: ['core/audio'],
    isMatch: ({
      id
    }) => {
      if (!id) {
        return false;
      }

      const {
        getMedia
      } = (0,external_wp_data_namespaceObject.select)(external_wp_coreData_namespaceObject.store);
      const media = getMedia(id);
      return !!media && media.mime_type.includes('audio');
    },
    transform: attributes => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/audio', {
        src: attributes.href,
        caption: attributes.fileName,
        id: attributes.id,
        anchor: attributes.anchor
      });
    }
  }, {
    type: 'block',
    blocks: ['core/video'],
    isMatch: ({
      id
    }) => {
      if (!id) {
        return false;
      }

      const {
        getMedia
      } = (0,external_wp_data_namespaceObject.select)(external_wp_coreData_namespaceObject.store);
      const media = getMedia(id);
      return !!media && media.mime_type.includes('video');
    },
    transform: attributes => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/video', {
        src: attributes.href,
        caption: attributes.fileName,
        id: attributes.id,
        anchor: attributes.anchor
      });
    }
  }, {
    type: 'block',
    blocks: ['core/image'],
    isMatch: ({
      id
    }) => {
      if (!id) {
        return false;
      }

      const {
        getMedia
      } = (0,external_wp_data_namespaceObject.select)(external_wp_coreData_namespaceObject.store);
      const media = getMedia(id);
      return !!media && media.mime_type.includes('image');
    },
    transform: attributes => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
        url: attributes.href,
        caption: attributes.fileName,
        id: attributes.id,
        anchor: attributes.anchor
      });
    }
  }]
};
/* harmony default export */ var file_transforms = (file_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/file/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const file_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/file",
  title: "File",
  category: "media",
  description: "Add a link to a downloadable file.",
  keywords: ["document", "pdf", "download"],
  textdomain: "default",
  attributes: {
    id: {
      type: "number"
    },
    href: {
      type: "string"
    },
    fileId: {
      type: "string",
      source: "attribute",
      selector: "a:not([download])",
      attribute: "id"
    },
    fileName: {
      type: "string",
      source: "html",
      selector: "a:not([download])"
    },
    textLinkHref: {
      type: "string",
      source: "attribute",
      selector: "a:not([download])",
      attribute: "href"
    },
    textLinkTarget: {
      type: "string",
      source: "attribute",
      selector: "a:not([download])",
      attribute: "target"
    },
    showDownloadButton: {
      type: "boolean",
      "default": true
    },
    downloadButtonText: {
      type: "string",
      source: "html",
      selector: "a[download]"
    },
    displayPreview: {
      type: "boolean"
    },
    previewHeight: {
      type: "number",
      "default": 600
    }
  },
  supports: {
    anchor: true,
    align: true,
    color: {
      gradients: true,
      link: true,
      text: false,
      __experimentalDefaultControls: {
        background: true,
        link: true
      }
    }
  },
  viewScript: "file:./view.min.js",
  editorStyle: "wp-block-file-editor",
  style: "wp-block-file"
};


const {
  name: file_name
} = file_metadata;

const file_settings = {
  icon: library_file,
  example: {
    attributes: {
      href: 'https://upload.wikimedia.org/wikipedia/commons/d/dd/Armstrong_Small_Step.ogg',
      fileName: (0,external_wp_i18n_namespaceObject._x)('Armstrong_Small_Step', 'Name of the file')
    }
  },
  transforms: file_transforms,
  deprecated: file_deprecated,
  edit: file_edit,
  save: file_save_save
};
const file_init = () => initBlock({
  name: file_name,
  metadata: file_metadata,
  settings: file_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/gallery.js


/**
 * WordPress dependencies
 */

const gallery = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M16.375 4.5H4.625a.125.125 0 0 0-.125.125v8.254l2.859-1.54a.75.75 0 0 1 .68-.016l2.384 1.142 2.89-2.074a.75.75 0 0 1 .874 0l2.313 1.66V4.625a.125.125 0 0 0-.125-.125Zm.125 9.398-2.75-1.975-2.813 2.02a.75.75 0 0 1-.76.067l-2.444-1.17L4.5 14.583v1.792c0 .069.056.125.125.125h11.75a.125.125 0 0 0 .125-.125v-2.477ZM4.625 3C3.728 3 3 3.728 3 4.625v11.75C3 17.273 3.728 18 4.625 18h11.75c.898 0 1.625-.727 1.625-1.625V4.625C18 3.728 17.273 3 16.375 3H4.625ZM20 8v11c0 .69-.31 1-.999 1H6v1.5h13.001c1.52 0 2.499-.982 2.499-2.5V8H20Z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ var library_gallery = (gallery);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/constants.js
const LINK_DESTINATION_NONE = 'none';
const LINK_DESTINATION_MEDIA = 'media';
const LINK_DESTINATION_ATTACHMENT = 'attachment';
const LINK_DESTINATION_MEDIA_WP_CORE = 'file';
const LINK_DESTINATION_ATTACHMENT_WP_CORE = 'post';

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/shared.js
/**
 * WordPress dependencies
 */

function defaultColumnsNumber(imageCount) {
  return imageCount ? Math.min(3, imageCount) : 3;
}
const pickRelevantMediaFiles = (image, sizeSlug = 'large') => {
  const imageProps = Object.fromEntries(Object.entries(image !== null && image !== void 0 ? image : {}).filter(([key]) => ['alt', 'id', 'link'].includes(key)));
  imageProps.url = image?.sizes?.[sizeSlug]?.url || image?.media_details?.sizes?.[sizeSlug]?.source_url || image?.url || image?.source_url;
  const fullUrl = image?.sizes?.full?.url || image?.media_details?.sizes?.full?.source_url;

  if (fullUrl) {
    imageProps.fullUrl = fullUrl;
  }

  return imageProps;
};

function getGalleryBlockV2Enabled() {
  // We want to fail early here, at least during beta testing phase, to ensure
  // there aren't instances where undefined values cause false negatives.
  if (!window.wp || typeof window.wp.galleryBlockV2Enabled !== 'boolean') {
    throw 'window.wp.galleryBlockV2Enabled is not defined';
  }

  return window.wp.galleryBlockV2Enabled;
}
/**
 * The new gallery block format is not compatible with the use_BalanceTags option
 * in WP versions <= 5.8 https://core.trac.wordpress.org/ticket/54130. The
 * window.wp.galleryBlockV2Enabled flag is set in lib/compat.php. This method
 * can be removed when minimum supported WP version >=5.9.
 */


function isGalleryV2Enabled() {
  if (external_wp_element_namespaceObject.Platform.isNative) {
    return getGalleryBlockV2Enabled();
  }

  return true;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const DEPRECATED_LINK_DESTINATION_MEDIA = 'file';
const DEPRECATED_LINK_DESTINATION_ATTACHMENT = 'post';
/**
 * Original function to determine default number of columns from a block's
 * attributes.
 *
 * Used in deprecations: v1-6, for versions of the gallery block that didn't use inner blocks.
 *
 * @param {Object} attributes Block attributes.
 * @return {number}           Default number of columns for the gallery.
 */

function defaultColumnsNumberV1(attributes) {
  return Math.min(3, attributes?.images?.length);
}
/**
 * Original function to determine new href and linkDestination values for an image block from the
 * supplied Gallery link destination.
 *
 * Used in deprecations: v1-6.
 *
 * @param {Object} image       Gallery image.
 * @param {string} destination Gallery's selected link destination.
 * @return {Object}            New attributes to assign to image block.
 */

function getHrefAndDestination(image, destination) {
  // Need to determine the URL that the selected destination maps to.
  // Gutenberg and WordPress use different constants so the new link
  // destination also needs to be tweaked.
  switch (destination) {
    case DEPRECATED_LINK_DESTINATION_MEDIA:
      return {
        href: image?.source_url || image?.url,
        // eslint-disable-line camelcase
        linkDestination: LINK_DESTINATION_MEDIA
      };

    case DEPRECATED_LINK_DESTINATION_ATTACHMENT:
      return {
        href: image?.link,
        linkDestination: LINK_DESTINATION_ATTACHMENT
      };

    case LINK_DESTINATION_MEDIA:
      return {
        href: image?.source_url || image?.url,
        // eslint-disable-line camelcase
        linkDestination: LINK_DESTINATION_MEDIA
      };

    case LINK_DESTINATION_ATTACHMENT:
      return {
        href: image?.link,
        linkDestination: LINK_DESTINATION_ATTACHMENT
      };

    case LINK_DESTINATION_NONE:
      return {
        href: undefined,
        linkDestination: LINK_DESTINATION_NONE
      };
  }

  return {};
}

function runV2Migration(attributes) {
  let linkTo = attributes.linkTo ? attributes.linkTo : 'none';

  if (linkTo === 'post') {
    linkTo = 'attachment';
  } else if (linkTo === 'file') {
    linkTo = 'media';
  }

  const imageBlocks = attributes.images.map(image => {
    return getImageBlock(image, attributes.sizeSlug, linkTo);
  });
  const {
    images,
    ids,
    ...restAttributes
  } = attributes;
  return [{ ...restAttributes,
    linkTo,
    allowResize: false
  }, imageBlocks];
}
/**
 * Gets an Image block from gallery image data
 *
 * Used to migrate Galleries to nested Image InnerBlocks.
 *
 * @param {Object} image    Image properties.
 * @param {string} sizeSlug Gallery sizeSlug attribute.
 * @param {string} linkTo   Gallery linkTo attribute.
 * @return {Object}         Image block.
 */


function getImageBlock(image, sizeSlug, linkTo) {
  return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', { ...(image.id && {
      id: parseInt(image.id)
    }),
    url: image.url,
    alt: image.alt,
    caption: image.caption,
    sizeSlug,
    ...getHrefAndDestination(image, linkTo)
  });
} // In #41140 support was added to global styles for caption elements which added a `wp-element-caption` classname
// to the gallery figcaption element.

const deprecated_v7 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: '.blocks-gallery-item',
      query: {
        url: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'src'
        },
        fullUrl: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-full-url'
        },
        link: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-link'
        },
        alt: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'alt',
          default: ''
        },
        id: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-id'
        },
        caption: {
          type: 'string',
          source: 'html',
          selector: '.blocks-gallery-item__caption'
        }
      }
    },
    ids: {
      type: 'array',
      items: {
        type: 'number'
      },
      default: []
    },
    shortCodeTransforms: {
      type: 'array',
      default: [],
      items: {
        type: 'object'
      }
    },
    columns: {
      type: 'number',
      minimum: 1,
      maximum: 8
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: '.blocks-gallery-caption'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    fixedHeight: {
      type: 'boolean',
      default: true
    },
    linkTarget: {
      type: 'string'
    },
    linkTo: {
      type: 'string'
    },
    sizeSlug: {
      type: 'string',
      default: 'large'
    },
    allowResize: {
      type: 'boolean',
      default: false
    }
  },

  save({
    attributes
  }) {
    const {
      caption,
      columns,
      imageCrop
    } = attributes;
    const className = classnames_default()('has-nested-images', {
      [`columns-${columns}`]: columns !== undefined,
      [`columns-default`]: columns === undefined,
      'is-cropped': imageCrop
    });
    const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className
    });
    const innerBlocksProps = external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(blockProps);
    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...innerBlocksProps
    }, innerBlocksProps.children, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      className: "blocks-gallery-caption",
      value: caption
    }));
  }

};
const deprecated_v6 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: '.blocks-gallery-item',
      query: {
        url: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'src'
        },
        fullUrl: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-full-url'
        },
        link: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-link'
        },
        alt: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'alt',
          default: ''
        },
        id: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-id'
        },
        caption: {
          type: 'string',
          source: 'html',
          selector: '.blocks-gallery-item__caption'
        }
      }
    },
    ids: {
      type: 'array',
      items: {
        type: 'number'
      },
      default: []
    },
    columns: {
      type: 'number',
      minimum: 1,
      maximum: 8
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: '.blocks-gallery-caption'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    fixedHeight: {
      type: 'boolean',
      default: true
    },
    linkTo: {
      type: 'string'
    },
    sizeSlug: {
      type: 'string',
      default: 'large'
    }
  },
  supports: {
    anchor: true,
    align: true
  },

  save({
    attributes
  }) {
    const {
      images,
      columns = defaultColumnsNumberV1(attributes),
      imageCrop,
      caption,
      linkTo
    } = attributes;
    const className = `columns-${columns} ${imageCrop ? 'is-cropped' : ''}`;
    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className
      })
    }, (0,external_wp_element_namespaceObject.createElement)("ul", {
      className: "blocks-gallery-grid"
    }, images.map(image => {
      let href;

      switch (linkTo) {
        case DEPRECATED_LINK_DESTINATION_MEDIA:
          href = image.fullUrl || image.url;
          break;

        case DEPRECATED_LINK_DESTINATION_ATTACHMENT:
          href = image.link;
          break;
      }

      const img = (0,external_wp_element_namespaceObject.createElement)("img", {
        src: image.url,
        alt: image.alt,
        "data-id": image.id,
        "data-full-url": image.fullUrl,
        "data-link": image.link,
        className: image.id ? `wp-image-${image.id}` : null
      });
      return (0,external_wp_element_namespaceObject.createElement)("li", {
        key: image.id || image.url,
        className: "blocks-gallery-item"
      }, (0,external_wp_element_namespaceObject.createElement)("figure", null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(image.caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
        tagName: "figcaption",
        className: "blocks-gallery-item__caption",
        value: image.caption
      })));
    })), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      className: "blocks-gallery-caption",
      value: caption
    }));
  },

  migrate(attributes) {
    if (isGalleryV2Enabled()) {
      return runV2Migration(attributes);
    }

    return attributes;
  }

};
const deprecated_v5 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: '.blocks-gallery-item',
      query: {
        url: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'src'
        },
        fullUrl: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-full-url'
        },
        link: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-link'
        },
        alt: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'alt',
          default: ''
        },
        id: {
          type: 'string',
          source: 'attribute',
          selector: 'img',
          attribute: 'data-id'
        },
        caption: {
          type: 'string',
          source: 'html',
          selector: '.blocks-gallery-item__caption'
        }
      }
    },
    ids: {
      type: 'array',
      items: {
        type: 'number'
      },
      default: []
    },
    columns: {
      type: 'number',
      minimum: 1,
      maximum: 8
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: '.blocks-gallery-caption'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    linkTo: {
      type: 'string',
      default: 'none'
    },
    sizeSlug: {
      type: 'string',
      default: 'large'
    }
  },
  supports: {
    align: true
  },

  isEligible({
    linkTo
  }) {
    return !linkTo || linkTo === 'attachment' || linkTo === 'media';
  },

  migrate(attributes) {
    if (isGalleryV2Enabled()) {
      return runV2Migration(attributes);
    }

    let linkTo = attributes.linkTo;

    if (!attributes.linkTo) {
      linkTo = 'none';
    } else if (attributes.linkTo === 'attachment') {
      linkTo = 'post';
    } else if (attributes.linkTo === 'media') {
      linkTo = 'file';
    }

    return { ...attributes,
      linkTo
    };
  },

  save({
    attributes
  }) {
    const {
      images,
      columns = defaultColumnsNumberV1(attributes),
      imageCrop,
      caption,
      linkTo
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: `columns-${columns} ${imageCrop ? 'is-cropped' : ''}`
    }, (0,external_wp_element_namespaceObject.createElement)("ul", {
      className: "blocks-gallery-grid"
    }, images.map(image => {
      let href;

      switch (linkTo) {
        case 'media':
          href = image.fullUrl || image.url;
          break;

        case 'attachment':
          href = image.link;
          break;
      }

      const img = (0,external_wp_element_namespaceObject.createElement)("img", {
        src: image.url,
        alt: image.alt,
        "data-id": image.id,
        "data-full-url": image.fullUrl,
        "data-link": image.link,
        className: image.id ? `wp-image-${image.id}` : null
      });
      return (0,external_wp_element_namespaceObject.createElement)("li", {
        key: image.id || image.url,
        className: "blocks-gallery-item"
      }, (0,external_wp_element_namespaceObject.createElement)("figure", null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(image.caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
        tagName: "figcaption",
        className: "blocks-gallery-item__caption",
        value: image.caption
      })));
    })), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      className: "blocks-gallery-caption",
      value: caption
    }));
  }

};
const deprecated_v4 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: '.blocks-gallery-item',
      query: {
        url: {
          source: 'attribute',
          selector: 'img',
          attribute: 'src'
        },
        fullUrl: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-full-url'
        },
        link: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-link'
        },
        alt: {
          source: 'attribute',
          selector: 'img',
          attribute: 'alt',
          default: ''
        },
        id: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-id'
        },
        caption: {
          type: 'string',
          source: 'html',
          selector: '.blocks-gallery-item__caption'
        }
      }
    },
    ids: {
      type: 'array',
      default: []
    },
    columns: {
      type: 'number'
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: '.blocks-gallery-caption'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    linkTo: {
      type: 'string',
      default: 'none'
    }
  },
  supports: {
    align: true
  },

  isEligible({
    ids
  }) {
    return ids && ids.some(id => typeof id === 'string');
  },

  migrate(attributes) {
    var _attributes$ids;

    if (isGalleryV2Enabled()) {
      return runV2Migration(attributes);
    }

    return { ...attributes,
      ids: ((_attributes$ids = attributes.ids) !== null && _attributes$ids !== void 0 ? _attributes$ids : []).map(id => {
        const parsedId = parseInt(id, 10);
        return Number.isInteger(parsedId) ? parsedId : null;
      })
    };
  },

  save({
    attributes
  }) {
    const {
      images,
      columns = defaultColumnsNumberV1(attributes),
      imageCrop,
      caption,
      linkTo
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: `columns-${columns} ${imageCrop ? 'is-cropped' : ''}`
    }, (0,external_wp_element_namespaceObject.createElement)("ul", {
      className: "blocks-gallery-grid"
    }, images.map(image => {
      let href;

      switch (linkTo) {
        case 'media':
          href = image.fullUrl || image.url;
          break;

        case 'attachment':
          href = image.link;
          break;
      }

      const img = (0,external_wp_element_namespaceObject.createElement)("img", {
        src: image.url,
        alt: image.alt,
        "data-id": image.id,
        "data-full-url": image.fullUrl,
        "data-link": image.link,
        className: image.id ? `wp-image-${image.id}` : null
      });
      return (0,external_wp_element_namespaceObject.createElement)("li", {
        key: image.id || image.url,
        className: "blocks-gallery-item"
      }, (0,external_wp_element_namespaceObject.createElement)("figure", null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(image.caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
        tagName: "figcaption",
        className: "blocks-gallery-item__caption",
        value: image.caption
      })));
    })), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      className: "blocks-gallery-caption",
      value: caption
    }));
  }

};
const gallery_deprecated_v3 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: 'ul.wp-block-gallery .blocks-gallery-item',
      query: {
        url: {
          source: 'attribute',
          selector: 'img',
          attribute: 'src'
        },
        fullUrl: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-full-url'
        },
        alt: {
          source: 'attribute',
          selector: 'img',
          attribute: 'alt',
          default: ''
        },
        id: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-id'
        },
        link: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-link'
        },
        caption: {
          type: 'string',
          source: 'html',
          selector: 'figcaption'
        }
      }
    },
    ids: {
      type: 'array',
      default: []
    },
    columns: {
      type: 'number'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    linkTo: {
      type: 'string',
      default: 'none'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      images,
      columns = defaultColumnsNumberV1(attributes),
      imageCrop,
      linkTo
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("ul", {
      className: `columns-${columns} ${imageCrop ? 'is-cropped' : ''}`
    }, images.map(image => {
      let href;

      switch (linkTo) {
        case 'media':
          href = image.fullUrl || image.url;
          break;

        case 'attachment':
          href = image.link;
          break;
      }

      const img = (0,external_wp_element_namespaceObject.createElement)("img", {
        src: image.url,
        alt: image.alt,
        "data-id": image.id,
        "data-full-url": image.fullUrl,
        "data-link": image.link,
        className: image.id ? `wp-image-${image.id}` : null
      });
      return (0,external_wp_element_namespaceObject.createElement)("li", {
        key: image.id || image.url,
        className: "blocks-gallery-item"
      }, (0,external_wp_element_namespaceObject.createElement)("figure", null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img, image.caption && image.caption.length > 0 && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
        tagName: "figcaption",
        value: image.caption
      })));
    }));
  },

  migrate(attributes) {
    if (isGalleryV2Enabled()) {
      return runV2Migration(attributes);
    }

    return attributes;
  }

};
const gallery_deprecated_v2 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: 'ul.wp-block-gallery .blocks-gallery-item',
      query: {
        url: {
          source: 'attribute',
          selector: 'img',
          attribute: 'src'
        },
        alt: {
          source: 'attribute',
          selector: 'img',
          attribute: 'alt',
          default: ''
        },
        id: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-id'
        },
        link: {
          source: 'attribute',
          selector: 'img',
          attribute: 'data-link'
        },
        caption: {
          type: 'string',
          source: 'html',
          selector: 'figcaption'
        }
      }
    },
    columns: {
      type: 'number'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    linkTo: {
      type: 'string',
      default: 'none'
    }
  },

  isEligible({
    images,
    ids
  }) {
    return images && images.length > 0 && (!ids && images || ids && images && ids.length !== images.length || images.some((id, index) => {
      if (!id && ids[index] !== null) {
        return true;
      }

      return parseInt(id, 10) !== ids[index];
    }));
  },

  migrate(attributes) {
    var _attributes$images;

    if (isGalleryV2Enabled()) {
      return runV2Migration(attributes);
    }

    return { ...attributes,
      ids: ((_attributes$images = attributes.images) !== null && _attributes$images !== void 0 ? _attributes$images : []).map(({
        id
      }) => {
        if (!id) {
          return null;
        }

        return parseInt(id, 10);
      })
    };
  },

  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      images,
      columns = defaultColumnsNumberV1(attributes),
      imageCrop,
      linkTo
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)("ul", {
      className: `columns-${columns} ${imageCrop ? 'is-cropped' : ''}`
    }, images.map(image => {
      let href;

      switch (linkTo) {
        case 'media':
          href = image.url;
          break;

        case 'attachment':
          href = image.link;
          break;
      }

      const img = (0,external_wp_element_namespaceObject.createElement)("img", {
        src: image.url,
        alt: image.alt,
        "data-id": image.id,
        "data-link": image.link,
        className: image.id ? `wp-image-${image.id}` : null
      });
      return (0,external_wp_element_namespaceObject.createElement)("li", {
        key: image.id || image.url,
        className: "blocks-gallery-item"
      }, (0,external_wp_element_namespaceObject.createElement)("figure", null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img, image.caption && image.caption.length > 0 && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
        tagName: "figcaption",
        value: image.caption
      })));
    }));
  }

};
const gallery_deprecated_v1 = {
  attributes: {
    images: {
      type: 'array',
      default: [],
      source: 'query',
      selector: 'div.wp-block-gallery figure.blocks-gallery-image img',
      query: {
        url: {
          source: 'attribute',
          attribute: 'src'
        },
        alt: {
          source: 'attribute',
          attribute: 'alt',
          default: ''
        },
        id: {
          source: 'attribute',
          attribute: 'data-id'
        }
      }
    },
    columns: {
      type: 'number'
    },
    imageCrop: {
      type: 'boolean',
      default: true
    },
    linkTo: {
      type: 'string',
      default: 'none'
    },
    align: {
      type: 'string',
      default: 'none'
    }
  },
  supports: {
    align: true
  },

  save({
    attributes
  }) {
    const {
      images,
      columns = defaultColumnsNumberV1(attributes),
      align,
      imageCrop,
      linkTo
    } = attributes;
    const className = classnames_default()(`columns-${columns}`, {
      alignnone: align === 'none',
      'is-cropped': imageCrop
    });
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className
    }, images.map(image => {
      let href;

      switch (linkTo) {
        case 'media':
          href = image.url;
          break;

        case 'attachment':
          href = image.link;
          break;
      }

      const img = (0,external_wp_element_namespaceObject.createElement)("img", {
        src: image.url,
        alt: image.alt,
        "data-id": image.id
      });
      return (0,external_wp_element_namespaceObject.createElement)("figure", {
        key: image.id || image.url,
        className: "blocks-gallery-image"
      }, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img);
    }));
  },

  migrate(attributes) {
    if (isGalleryV2Enabled()) {
      return runV2Migration(attributes);
    }

    return attributes;
  }

};
/* harmony default export */ var gallery_deprecated = ([deprecated_v7, deprecated_v6, deprecated_v5, deprecated_v4, gallery_deprecated_v3, gallery_deprecated_v2, gallery_deprecated_v1]);

;// CONCATENATED MODULE: external ["wp","viewport"]
var external_wp_viewport_namespaceObject = window["wp"]["viewport"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/shared-icon.js


/**
 * WordPress dependencies
 */


const sharedIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
  icon: library_gallery
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/constants.js
const constants_MIN_SIZE = 20;
const constants_LINK_DESTINATION_NONE = 'none';
const constants_LINK_DESTINATION_MEDIA = 'media';
const constants_LINK_DESTINATION_ATTACHMENT = 'attachment';
const LINK_DESTINATION_CUSTOM = 'custom';
const constants_NEW_TAB_REL = ['noreferrer', 'noopener'];
const constants_ALLOWED_MEDIA_TYPES = ['image'];
const MEDIA_ID_NO_FEATURED_IMAGE_SET = 0;

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/utils.js
/**
 * Internal dependencies
 */


/**
 * Determines new href and linkDestination values for an Image block from the
 * supplied Gallery link destination, or falls back to the Image blocks link.
 *
 * @param {Object} image              Gallery image.
 * @param {string} galleryDestination Gallery's selected link destination.
 * @param {Object} imageDestination   Image blocks attributes.
 * @return {Object}            New attributes to assign to image block.
 */

function utils_getHrefAndDestination(image, galleryDestination, imageDestination) {
  // Gutenberg and WordPress use different constants so if image_default_link_type
  // option is set we need to map from the WP Core values.
  switch (imageDestination ? imageDestination : galleryDestination) {
    case LINK_DESTINATION_MEDIA_WP_CORE:
    case LINK_DESTINATION_MEDIA:
      return {
        href: image?.source_url || image?.url,
        // eslint-disable-line camelcase
        linkDestination: constants_LINK_DESTINATION_MEDIA
      };

    case LINK_DESTINATION_ATTACHMENT_WP_CORE:
    case LINK_DESTINATION_ATTACHMENT:
      return {
        href: image?.link,
        linkDestination: constants_LINK_DESTINATION_ATTACHMENT
      };

    case LINK_DESTINATION_NONE:
      return {
        href: undefined,
        linkDestination: constants_LINK_DESTINATION_NONE
      };
  }

  return {};
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/utils.js
/**
 * Internal dependencies
 */

/**
 * Evaluates a CSS aspect-ratio property value as a number.
 *
 * Degenerate or invalid ratios behave as 'auto'. And 'auto' ratios return NaN.
 *
 * @see https://drafts.csswg.org/css-sizing-4/#aspect-ratio
 *
 * @param {string} value CSS aspect-ratio property value.
 * @return {number} Numerical aspect ratio or NaN if invalid.
 */

function evalAspectRatio(value) {
  const [width, height = 1] = value.split('/').map(Number);
  const aspectRatio = width / height;
  return aspectRatio === Infinity || aspectRatio === 0 ? NaN : aspectRatio;
}
function removeNewTabRel(currentRel) {
  let newRel = currentRel;

  if (currentRel !== undefined && newRel) {
    constants_NEW_TAB_REL.forEach(relVal => {
      const regExp = new RegExp('\\b' + relVal + '\\b', 'gi');
      newRel = newRel.replace(regExp, '');
    }); // Only trim if NEW_TAB_REL values was replaced.

    if (newRel !== currentRel) {
      newRel = newRel.trim();
    }

    if (!newRel) {
      newRel = undefined;
    }
  }

  return newRel;
}
/**
 * Helper to get the link target settings to be stored.
 *
 * @param {boolean} value          The new link target value.
 * @param {Object}  attributes     Block attributes.
 * @param {Object}  attributes.rel Image block's rel attribute.
 *
 * @return {Object} Updated link target settings.
 */

function getUpdatedLinkTargetSettings(value, {
  rel
}) {
  const linkTarget = value ? '_blank' : undefined;
  let updatedRel;

  if (!linkTarget && !rel) {
    updatedRel = undefined;
  } else {
    updatedRel = removeNewTabRel(rel);
  }

  return {
    linkTarget,
    rel: updatedRel
  };
}
/**
 * Determines new Image block attributes size selection.
 *
 * @param {Object} image Media file object for gallery image.
 * @param {string} size  Selected size slug to apply.
 */

function getImageSizeAttributes(image, size) {
  const url = image?.media_details?.sizes?.[size]?.source_url;

  if (url) {
    return {
      url,
      width: undefined,
      height: undefined,
      sizeSlug: size
    };
  }

  return {};
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/gallery.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






const Gallery = (props, captionRef) => {
  const {
    attributes,
    isSelected,
    setAttributes,
    mediaPlaceholder,
    insertBlocksAfter,
    blockProps,
    __unstableLayoutClassNames: layoutClassNames,
    showCaption
  } = props;
  const {
    align,
    columns,
    caption,
    imageCrop
  } = attributes;
  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...blockProps,
    className: classnames_default()(blockProps.className, layoutClassNames, 'blocks-gallery-grid', {
      [`align${align}`]: align,
      [`columns-${columns}`]: columns !== undefined,
      [`columns-default`]: columns === undefined,
      'is-cropped': imageCrop
    })
  }, blockProps.children, isSelected && !blockProps.children && (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, {
    className: "blocks-gallery-media-placeholder-wrapper"
  }, mediaPlaceholder), showCaption && (!external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) || isSelected) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    identifier: "caption",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Gallery caption text'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write gallery caption…'),
    value: caption,
    className: classnames_default()('blocks-gallery-caption', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption')),
    ref: captionRef,
    tagName: "figcaption",
    onChange: value => setAttributes({
      caption: value
    }),
    inlineToolbar: true,
    __unstableOnSplitAtEnd: () => insertBlocksAfter((0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()))
  }));
};
/* harmony default export */ var gallery_gallery = ((0,external_wp_element_namespaceObject.forwardRef)(Gallery));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/use-image-sizes.js
/**
 * WordPress dependencies
 */

/**
 * Calculates the image sizes that are avaible for the current gallery images in order to
 * populate the 'Resolution' selector.
 *
 * @param {Array}    images      Basic image block data taken from current gallery innerBlock
 * @param {boolean}  isSelected  Is the block currently selected in the editor.
 * @param {Function} getSettings Block editor store selector.
 *
 * @return {Array} An array of image size options.
 */

function useImageSizes(images, isSelected, getSettings) {
  return (0,external_wp_element_namespaceObject.useMemo)(() => getImageSizing(), [images, isSelected]);

  function getImageSizing() {
    if (!images || images.length === 0) {
      return;
    }

    const {
      imageSizes
    } = getSettings();
    let resizedImages = {};

    if (isSelected) {
      resizedImages = images.reduce((currentResizedImages, img) => {
        if (!img.id) {
          return currentResizedImages;
        }

        const sizes = imageSizes.reduce((currentSizes, size) => {
          const defaultUrl = img.sizes?.[size.slug]?.url;
          const mediaDetailsUrl = img.media_details?.sizes?.[size.slug]?.source_url;
          return { ...currentSizes,
            [size.slug]: defaultUrl || mediaDetailsUrl
          };
        }, {});
        return { ...currentResizedImages,
          [parseInt(img.id, 10)]: sizes
        };
      }, {});
    }

    const resizedImageSizes = Object.values(resizedImages);
    return imageSizes.filter(({
      slug
    }) => resizedImageSizes.some(sizes => sizes[slug])).map(({
      name,
      slug
    }) => ({
      value: slug,
      label: name
    }));
  }
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/use-get-new-images.js
/**
 * WordPress dependencies
 */

/**
 * Keeps track of images already in the gallery to allow new innerBlocks to be identified. This
 * is required so default gallery attributes can be applied without overwriting any custom
 * attributes applied to existing images.
 *
 * @param {Array} images    Basic image block data taken from current gallery innerBlock
 * @param {Array} imageData The related image data for each of the current gallery images.
 *
 * @return {Array} An array of any new images that have been added to the gallery.
 */

function useGetNewImages(images, imageData) {
  const [currentImages, setCurrentImages] = (0,external_wp_element_namespaceObject.useState)([]);
  return (0,external_wp_element_namespaceObject.useMemo)(() => getNewImages(), [images, imageData]);

  function getNewImages() {
    let imagesUpdated = false; // First lets check if any images have been deleted.

    const newCurrentImages = currentImages.filter(currentImg => images.find(img => {
      return currentImg.clientId === img.clientId;
    }));

    if (newCurrentImages.length < currentImages.length) {
      imagesUpdated = true;
    } // Now lets see if we have any images hydrated from saved content and if so
    // add them to currentImages state.


    images.forEach(image => {
      if (image.fromSavedContent && !newCurrentImages.find(currentImage => currentImage.id === image.id)) {
        imagesUpdated = true;
        newCurrentImages.push(image);
      }
    }); // Now check for any new images that have been added to InnerBlocks and for which
    // we have the imageData we need for setting default block attributes.

    const newImages = images.filter(image => !newCurrentImages.find(currentImage => image.clientId && currentImage.clientId === image.clientId) && imageData?.find(img => img.id === image.id) && !image.fromSavedConent);

    if (imagesUpdated || newImages?.length > 0) {
      setCurrentImages([...newCurrentImages, ...newImages]);
    }

    return newImages.length > 0 ? newImages : null;
  }
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/use-get-media.js
/**
 * WordPress dependencies
 */


const EMPTY_IMAGE_MEDIA = [];
/**
 * Retrieves the extended media info for each gallery image from the store. This is used to
 * determine which image size options are available for the current gallery.
 *
 * @param {Array} innerBlockImages An array of the innerBlock images currently in the gallery.
 *
 * @return {Array} An array of media info options for each gallery image.
 */

function useGetMedia(innerBlockImages) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getMediaItems;

    const imageIds = innerBlockImages.map(imageBlock => imageBlock.attributes.id).filter(id => id !== undefined);

    if (imageIds.length === 0) {
      return EMPTY_IMAGE_MEDIA;
    }

    return (_select$getMediaItems = select(external_wp_coreData_namespaceObject.store).getMediaItems({
      include: imageIds.join(','),
      per_page: -1,
      orderby: 'include'
    })) !== null && _select$getMediaItems !== void 0 ? _select$getMediaItems : EMPTY_IMAGE_MEDIA;
  }, [innerBlockImages]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/gap-styles.js


/**
 * WordPress dependencies
 */


function GapStyles({
  blockGap,
  clientId
}) {
  const styleElement = (0,external_wp_element_namespaceObject.useContext)(external_wp_blockEditor_namespaceObject.BlockList.__unstableElementContext); // --gallery-block--gutter-size is deprecated. --wp--style--gallery-gap-default should be used by themes that want to set a default
  // gap on the gallery.

  const fallbackValue = `var( --wp--style--gallery-gap-default, var( --gallery-block--gutter-size, var( --wp--style--block-gap, 0.5em ) ) )`;
  let gapValue = fallbackValue;
  let column = fallbackValue;
  let row; // Check for the possibility of split block gap values. See: https://github.com/WordPress/gutenberg/pull/37736

  if (!!blockGap) {
    row = typeof blockGap === 'string' ? (0,external_wp_blockEditor_namespaceObject.__experimentalGetGapCSSValue)(blockGap) : (0,external_wp_blockEditor_namespaceObject.__experimentalGetGapCSSValue)(blockGap?.top) || fallbackValue;
    column = typeof blockGap === 'string' ? (0,external_wp_blockEditor_namespaceObject.__experimentalGetGapCSSValue)(blockGap) : (0,external_wp_blockEditor_namespaceObject.__experimentalGetGapCSSValue)(blockGap?.left) || fallbackValue;
    gapValue = row === column ? row : `${row} ${column}`;
  } // The unstable gallery gap calculation requires a real value (such as `0px`) and not `0`.


  const gap = `#block-${clientId} {
		--wp--style--unstable-gallery-gap: ${column === '0' ? '0px' : column};
		gap: ${gapValue}
	}`;

  const GapStyle = () => {
    return (0,external_wp_element_namespaceObject.createElement)("style", null, gap);
  };

  return gap && styleElement ? (0,external_wp_element_namespaceObject.createPortal)((0,external_wp_element_namespaceObject.createElement)(GapStyle, null), styleElement) : null;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */













/**
 * Internal dependencies
 */











const MAX_COLUMNS = 8;
const linkOptions = [{
  value: LINK_DESTINATION_ATTACHMENT,
  label: (0,external_wp_i18n_namespaceObject.__)('Attachment Page')
}, {
  value: LINK_DESTINATION_MEDIA,
  label: (0,external_wp_i18n_namespaceObject.__)('Media File')
}, {
  value: LINK_DESTINATION_NONE,
  label: (0,external_wp_i18n_namespaceObject._x)('None', 'Media item link option')
}];
const edit_ALLOWED_MEDIA_TYPES = ['image'];
const allowedBlocks = ['core/image'];
const PLACEHOLDER_TEXT = external_wp_element_namespaceObject.Platform.isNative ? (0,external_wp_i18n_namespaceObject.__)('ADD MEDIA') : (0,external_wp_i18n_namespaceObject.__)('Drag images, upload new ones or select files from your library.');
const MOBILE_CONTROL_PROPS_RANGE_CONTROL = external_wp_element_namespaceObject.Platform.isNative ? {
  type: 'stepper'
} : {};

function GalleryEdit(props) {
  const {
    setAttributes,
    attributes,
    className,
    clientId,
    isSelected,
    insertBlocksAfter,
    isContentLocked
  } = props;
  const {
    columns,
    imageCrop,
    linkTarget,
    linkTo,
    sizeSlug,
    caption
  } = attributes;
  const [showCaption, setShowCaption] = (0,external_wp_element_namespaceObject.useState)(!!caption);
  const prevCaption = (0,external_wp_compose_namespaceObject.usePrevious)(caption); // We need to show the caption when changes come from
  // history navigation(undo/redo).

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (caption && !prevCaption) {
      setShowCaption(true);
    }
  }, [caption, prevCaption]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isSelected && !caption) {
      setShowCaption(false);
    }
  }, [isSelected, caption]); // Focus the caption when we click to add one.

  const captionRef = (0,external_wp_element_namespaceObject.useCallback)(node => {
    if (node && !caption) {
      node.focus();
    }
  }, [caption]);
  const {
    __unstableMarkNextChangeAsNotPersistent,
    replaceInnerBlocks,
    updateBlockAttributes,
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    createSuccessNotice,
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    getBlock,
    getSettings,
    preferredStyle
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const settings = select(external_wp_blockEditor_namespaceObject.store).getSettings();
    const preferredStyleVariations = settings.__experimentalPreferredStyleVariations;
    return {
      getBlock: select(external_wp_blockEditor_namespaceObject.store).getBlock,
      getSettings: select(external_wp_blockEditor_namespaceObject.store).getSettings,
      preferredStyle: preferredStyleVariations?.value?.['core/image']
    };
  }, []);
  const innerBlockImages = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getBlock$inne;

    const innerBlocks = (_select$getBlock$inne = select(external_wp_blockEditor_namespaceObject.store).getBlock(clientId)?.innerBlocks) !== null && _select$getBlock$inne !== void 0 ? _select$getBlock$inne : [];
    return innerBlocks;
  }, [clientId]);
  const wasBlockJustInserted = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(external_wp_blockEditor_namespaceObject.store).wasBlockJustInserted(clientId, 'inserter_menu');
  }, [clientId]);
  const images = (0,external_wp_element_namespaceObject.useMemo)(() => innerBlockImages?.map(block => ({
    clientId: block.clientId,
    id: block.attributes.id,
    url: block.attributes.url,
    attributes: block.attributes,
    fromSavedContent: Boolean(block.originalContent)
  })), [innerBlockImages]);
  const imageData = useGetMedia(innerBlockImages);
  const newImages = useGetNewImages(images, imageData);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    newImages?.forEach(newImage => {
      // Update the images data without creating new undo levels.
      __unstableMarkNextChangeAsNotPersistent();

      updateBlockAttributes(newImage.clientId, { ...buildImageAttributes(newImage.attributes),
        id: newImage.id,
        align: undefined
      });
    });
  }, [newImages]);
  const imageSizeOptions = useImageSizes(imageData, isSelected, getSettings);
  /**
   * Determines the image attributes that should be applied to an image block
   * after the gallery updates.
   *
   * The gallery will receive the full collection of images when a new image
   * is added. As a result we need to reapply the image's original settings if
   * it already existed in the gallery. If the image is in fact new, we need
   * to apply the gallery's current settings to the image.
   *
   * @param {Object} imageAttributes Media object for the actual image.
   * @return {Object}                Attributes to set on the new image block.
   */

  function buildImageAttributes(imageAttributes) {
    const image = imageAttributes.id ? imageData.find(({
      id
    }) => id === imageAttributes.id) : null;
    let newClassName;

    if (imageAttributes.className && imageAttributes.className !== '') {
      newClassName = imageAttributes.className;
    } else {
      newClassName = preferredStyle ? `is-style-${preferredStyle}` : undefined;
    }

    let newLinkTarget;

    if (imageAttributes.linkTarget || imageAttributes.rel) {
      // When transformed from image blocks, the link destination and rel attributes are inherited.
      newLinkTarget = {
        linkTarget: imageAttributes.linkTarget,
        rel: imageAttributes.rel
      };
    } else {
      // When an image is added, update the link destination and rel attributes according to the gallery settings
      newLinkTarget = getUpdatedLinkTargetSettings(linkTarget, attributes);
    }

    return { ...pickRelevantMediaFiles(image, sizeSlug),
      ...utils_getHrefAndDestination(image, linkTo, imageAttributes?.linkDestination),
      ...newLinkTarget,
      className: newClassName,
      sizeSlug,
      caption: imageAttributes.caption || image.caption?.raw,
      alt: imageAttributes.alt || image.alt_text
    };
  }

  function isValidFileType(file) {
    // It's necessary to retrieve the media type from the raw image data for already-uploaded images on native.
    const nativeFileData = external_wp_element_namespaceObject.Platform.isNative && file.id ? imageData.find(({
      id
    }) => id === file.id) : null;
    const mediaTypeSelector = nativeFileData ? nativeFileData?.media_type : file.type;
    return edit_ALLOWED_MEDIA_TYPES.some(mediaType => mediaTypeSelector?.indexOf(mediaType) === 0) || file.url?.indexOf('blob:') === 0;
  }

  function updateImages(selectedImages) {
    const newFileUploads = Object.prototype.toString.call(selectedImages) === '[object FileList]';
    const imageArray = newFileUploads ? Array.from(selectedImages).map(file => {
      if (!file.url) {
        return pickRelevantMediaFiles({
          url: (0,external_wp_blob_namespaceObject.createBlobURL)(file)
        });
      }

      return file;
    }) : selectedImages;

    if (!imageArray.every(isValidFileType)) {
      createErrorNotice((0,external_wp_i18n_namespaceObject.__)('If uploading to a gallery all files need to be image formats'), {
        id: 'gallery-upload-invalid-file',
        type: 'snackbar'
      });
    }

    const processedImages = imageArray.filter(file => file.url || isValidFileType(file)).map(file => {
      if (!file.url) {
        return pickRelevantMediaFiles({
          url: (0,external_wp_blob_namespaceObject.createBlobURL)(file)
        });
      }

      return file;
    }); // Because we are reusing existing innerImage blocks any reordering
    // done in the media library will be lost so we need to reapply that ordering
    // once the new image blocks are merged in with existing.

    const newOrderMap = processedImages.reduce((result, image, index) => (result[image.id] = index, result), {});
    const existingImageBlocks = !newFileUploads ? innerBlockImages.filter(block => processedImages.find(img => img.id === block.attributes.id)) : innerBlockImages;
    const newImageList = processedImages.filter(img => !existingImageBlocks.find(existingImg => img.id === existingImg.attributes.id));
    const newBlocks = newImageList.map(image => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
        id: image.id,
        url: image.url,
        caption: image.caption,
        alt: image.alt
      });
    });
    replaceInnerBlocks(clientId, existingImageBlocks.concat(newBlocks).sort((a, b) => newOrderMap[a.attributes.id] - newOrderMap[b.attributes.id])); // Select the first block to scroll into view when new blocks are added.

    if (newBlocks?.length > 0) {
      selectBlock(newBlocks[0].clientId);
    }
  }

  function onUploadError(message) {
    createErrorNotice(message, {
      type: 'snackbar'
    });
  }

  function setLinkTo(value) {
    setAttributes({
      linkTo: value
    });
    const changedAttributes = {};
    const blocks = [];
    getBlock(clientId).innerBlocks.forEach(block => {
      blocks.push(block.clientId);
      const image = block.attributes.id ? imageData.find(({
        id
      }) => id === block.attributes.id) : null;
      changedAttributes[block.clientId] = utils_getHrefAndDestination(image, value);
    });
    updateBlockAttributes(blocks, changedAttributes, true);
    const linkToText = [...linkOptions].find(linkType => linkType.value === value);
    createSuccessNotice((0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: image size settings */
    (0,external_wp_i18n_namespaceObject.__)('All gallery image links updated to: %s'), linkToText.label), {
      id: 'gallery-attributes-linkTo',
      type: 'snackbar'
    });
  }

  function setColumnsNumber(value) {
    setAttributes({
      columns: value
    });
  }

  function toggleImageCrop() {
    setAttributes({
      imageCrop: !imageCrop
    });
  }

  function getImageCropHelp(checked) {
    return checked ? (0,external_wp_i18n_namespaceObject.__)('Thumbnails are cropped to align.') : (0,external_wp_i18n_namespaceObject.__)('Thumbnails are not cropped.');
  }

  function toggleOpenInNewTab(openInNewTab) {
    const newLinkTarget = openInNewTab ? '_blank' : undefined;
    setAttributes({
      linkTarget: newLinkTarget
    });
    const changedAttributes = {};
    const blocks = [];
    getBlock(clientId).innerBlocks.forEach(block => {
      blocks.push(block.clientId);
      changedAttributes[block.clientId] = getUpdatedLinkTargetSettings(newLinkTarget, block.attributes);
    });
    updateBlockAttributes(blocks, changedAttributes, true);
    const noticeText = openInNewTab ? (0,external_wp_i18n_namespaceObject.__)('All gallery images updated to open in new tab') : (0,external_wp_i18n_namespaceObject.__)('All gallery images updated to not open in new tab');
    createSuccessNotice(noticeText, {
      id: 'gallery-attributes-openInNewTab',
      type: 'snackbar'
    });
  }

  function updateImagesSize(newSizeSlug) {
    setAttributes({
      sizeSlug: newSizeSlug
    });
    const changedAttributes = {};
    const blocks = [];
    getBlock(clientId).innerBlocks.forEach(block => {
      blocks.push(block.clientId);
      const image = block.attributes.id ? imageData.find(({
        id
      }) => id === block.attributes.id) : null;
      changedAttributes[block.clientId] = getImageSizeAttributes(image, newSizeSlug);
    });
    updateBlockAttributes(blocks, changedAttributes, true);
    const imageSize = imageSizeOptions.find(size => size.value === newSizeSlug);
    createSuccessNotice((0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: image size settings */
    (0,external_wp_i18n_namespaceObject.__)('All gallery image sizes updated to: %s'), imageSize.label), {
      id: 'gallery-attributes-sizeSlug',
      type: 'snackbar'
    });
  }

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // linkTo attribute must be saved so blocks don't break when changing image_default_link_type in options.php.
    if (!linkTo) {
      __unstableMarkNextChangeAsNotPersistent();

      setAttributes({
        linkTo: window?.wp?.media?.view?.settings?.defaultProps?.link || LINK_DESTINATION_NONE
      });
    }
  }, [linkTo]);
  const hasImages = !!images.length;
  const hasImageIds = hasImages && images.some(image => !!image.id);
  const imagesUploading = images.some(img => !external_wp_element_namespaceObject.Platform.isNative ? !img.id && img.url?.indexOf('blob:') === 0 : img.url?.indexOf('file:') === 0); // MediaPlaceholder props are different between web and native hence, we provide a platform-specific set.

  const mediaPlaceholderProps = external_wp_element_namespaceObject.Platform.select({
    web: {
      addToGallery: false,
      disableMediaButtons: imagesUploading,
      value: {}
    },
    native: {
      addToGallery: hasImageIds,
      isAppender: hasImages,
      disableMediaButtons: hasImages && !isSelected || imagesUploading,
      value: hasImageIds ? images : {},
      autoOpenMediaUpload: !hasImages && isSelected && wasBlockJustInserted
    }
  });
  const mediaPlaceholder = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
    handleUpload: false,
    icon: sharedIcon,
    labels: {
      title: (0,external_wp_i18n_namespaceObject.__)('Gallery'),
      instructions: PLACEHOLDER_TEXT
    },
    onSelect: updateImages,
    accept: "image/*",
    allowedTypes: edit_ALLOWED_MEDIA_TYPES,
    multiple: true,
    onError: onUploadError,
    ...mediaPlaceholderProps
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()(className, 'has-nested-images')
  });
  const nativeInnerBlockProps = external_wp_element_namespaceObject.Platform.isNative && {
    marginHorizontal: 0,
    marginVertical: 0
  };
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    allowedBlocks,
    orientation: 'horizontal',
    renderAppender: false,
    ...nativeInnerBlockProps
  });

  if (!hasImages) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, { ...innerBlocksProps
    }, innerBlocksProps.children, mediaPlaceholder);
  }

  const hasLinkTo = linkTo && linkTo !== 'none';
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, images.length > 1 && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
    value: columns ? columns : defaultColumnsNumber(images.length),
    onChange: setColumnsNumber,
    min: 1,
    max: Math.min(MAX_COLUMNS, images.length),
    ...MOBILE_CONTROL_PROPS_RANGE_CONTROL,
    required: true,
    size: "__unstable-large"
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Crop images'),
    checked: !!imageCrop,
    onChange: toggleImageCrop,
    help: getImageCropHelp
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Link to'),
    value: linkTo,
    onChange: setLinkTo,
    options: linkOptions,
    hideCancelButton: true,
    size: "__unstable-large"
  }), hasLinkTo && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Open in new tab'),
    checked: linkTarget === '_blank',
    onChange: toggleOpenInNewTab
  }), imageSizeOptions?.length > 0 && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Resolution'),
    help: (0,external_wp_i18n_namespaceObject.__)('Select the size of the source images.'),
    value: sizeSlug,
    options: imageSizeOptions,
    onChange: updateImagesSize,
    hideCancelButton: true,
    size: "__unstable-large"
  }), external_wp_element_namespaceObject.Platform.isWeb && !imageSizeOptions && hasImageIds && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl, {
    className: 'gallery-image-sizes'
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, null, (0,external_wp_i18n_namespaceObject.__)('Resolution')), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, {
    className: 'gallery-image-sizes__loading'
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null), (0,external_wp_i18n_namespaceObject.__)('Loading options…'))))), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, !isContentLocked && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: () => {
      setShowCaption(!showCaption);

      if (showCaption && caption) {
        setAttributes({
          caption: undefined
        });
      }
    },
    icon: library_caption,
    isPressed: showCaption,
    label: showCaption ? (0,external_wp_i18n_namespaceObject.__)('Remove caption') : (0,external_wp_i18n_namespaceObject.__)('Add caption')
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "other"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaReplaceFlow, {
    allowedTypes: edit_ALLOWED_MEDIA_TYPES,
    accept: "image/*",
    handleUpload: false,
    onSelect: updateImages,
    name: (0,external_wp_i18n_namespaceObject.__)('Add'),
    multiple: true,
    mediaIds: images.filter(image => image.id).map(image => image.id),
    addToGallery: hasImageIds
  })), external_wp_element_namespaceObject.Platform.isWeb && (0,external_wp_element_namespaceObject.createElement)(GapStyles, {
    blockGap: attributes.style?.spacing?.blockGap,
    clientId: clientId
  }), (0,external_wp_element_namespaceObject.createElement)(gallery_gallery, { ...props,
    showCaption: showCaption,
    ref: external_wp_element_namespaceObject.Platform.isWeb ? captionRef : undefined,
    images: images,
    mediaPlaceholder: !hasImages || external_wp_element_namespaceObject.Platform.isNative ? mediaPlaceholder : undefined,
    blockProps: innerBlocksProps,
    insertBlocksAfter: insertBlocksAfter
  }));
}

/* harmony default export */ var gallery_edit = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_viewport_namespaceObject.withViewportMatch)({
  isNarrow: '< small'
})])(GalleryEdit));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/v1/shared.js
const shared_pickRelevantMediaFiles = (image, sizeSlug = 'large') => {
  const imageProps = Object.fromEntries(Object.entries(image !== null && image !== void 0 ? image : {}).filter(([key]) => ['alt', 'id', 'link', 'caption'].includes(key)));
  imageProps.url = image?.sizes?.[sizeSlug]?.url || image?.media_details?.sizes?.[sizeSlug]?.source_url || image?.url;
  const fullUrl = image?.sizes?.full?.url || image?.media_details?.sizes?.full?.source_url;

  if (fullUrl) {
    imageProps.fullUrl = fullUrl;
  }

  return imageProps;
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/image.js


/**
 * WordPress dependencies
 */

const image_image = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5 4.5h14c.3 0 .5.2.5.5v8.4l-3-2.9c-.3-.3-.8-.3-1 0L11.9 14 9 12c-.3-.2-.6-.2-.8 0l-3.6 2.6V5c-.1-.3.1-.5.4-.5zm14 15H5c-.3 0-.5-.2-.5-.5v-2.4l4.1-3 3 1.9c.3.2.7.2.9-.1L16 12l3.5 3.4V19c0 .3-.2.5-.5.5z"
}));
/* harmony default export */ var library_image = (image_image);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-left.js


/**
 * WordPress dependencies
 */

const chevronLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14.6 7l-1.2-1L8 12l5.4 6 1.2-1-4.6-5z"
}));
/* harmony default export */ var chevron_left = (chevronLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-right.js


/**
 * WordPress dependencies
 */

const chevronRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M10.6 6L9.4 7l4.6 5-4.6 5 1.2 1 5.4-6z"
}));
/* harmony default export */ var chevron_right = (chevronRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/close-small.js


/**
 * WordPress dependencies
 */

const closeSmall = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M12 13.06l3.712 3.713 1.061-1.06L13.061 12l3.712-3.712-1.06-1.06L12 10.938 8.288 7.227l-1.061 1.06L10.939 12l-3.712 3.712 1.06 1.061L12 13.061z"
}));
/* harmony default export */ var close_small = (closeSmall);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/v1/constants.js
const v1_constants_LINK_DESTINATION_NONE = 'none';
const v1_constants_LINK_DESTINATION_MEDIA = 'file';
const v1_constants_LINK_DESTINATION_ATTACHMENT = 'post';

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/v1/gallery-image.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */




const isTemporaryImage = (id, url) => !id && (0,external_wp_blob_namespaceObject.isBlobURL)(url);

class GalleryImage extends external_wp_element_namespaceObject.Component {
  constructor() {
    super(...arguments);
    this.onSelectImage = this.onSelectImage.bind(this);
    this.onRemoveImage = this.onRemoveImage.bind(this);
    this.bindContainer = this.bindContainer.bind(this);
    this.onEdit = this.onEdit.bind(this);
    this.onSelectImageFromLibrary = this.onSelectImageFromLibrary.bind(this);
    this.onSelectCustomURL = this.onSelectCustomURL.bind(this);
    this.state = {
      isEditing: false
    };
  }

  bindContainer(ref) {
    this.container = ref;
  }

  onSelectImage() {
    if (!this.props.isSelected) {
      this.props.onSelect();
    }
  }

  onRemoveImage(event) {
    if (this.container === this.container.ownerDocument.activeElement && this.props.isSelected && [external_wp_keycodes_namespaceObject.BACKSPACE, external_wp_keycodes_namespaceObject.DELETE].indexOf(event.keyCode) !== -1) {
      event.preventDefault();
      this.props.onRemove();
    }
  }

  onEdit() {
    this.setState({
      isEditing: true
    });
  }

  componentDidUpdate() {
    const {
      image,
      url,
      __unstableMarkNextChangeAsNotPersistent
    } = this.props;

    if (image && !url) {
      __unstableMarkNextChangeAsNotPersistent();

      this.props.setAttributes({
        url: image.source_url,
        alt: image.alt_text
      });
    }
  }

  deselectOnBlur() {
    this.props.onDeselect();
  }

  onSelectImageFromLibrary(media) {
    const {
      setAttributes,
      id,
      url,
      alt,
      caption,
      sizeSlug
    } = this.props;

    if (!media || !media.url) {
      return;
    }

    let mediaAttributes = shared_pickRelevantMediaFiles(media, sizeSlug); // If the current image is temporary but an alt text was meanwhile
    // written by the user, make sure the text is not overwritten.

    if (isTemporaryImage(id, url)) {
      if (alt) {
        const {
          alt: omittedAlt,
          ...restMediaAttributes
        } = mediaAttributes;
        mediaAttributes = restMediaAttributes;
      }
    } // If a caption text was meanwhile written by the user,
    // make sure the text is not overwritten by empty captions.


    if (caption && !mediaAttributes.caption) {
      const {
        caption: omittedCaption,
        ...restMediaAttributes
      } = mediaAttributes;
      mediaAttributes = restMediaAttributes;
    }

    setAttributes(mediaAttributes);
    this.setState({
      isEditing: false
    });
  }

  onSelectCustomURL(newURL) {
    const {
      setAttributes,
      url
    } = this.props;

    if (newURL !== url) {
      setAttributes({
        url: newURL,
        id: undefined
      });
      this.setState({
        isEditing: false
      });
    }
  }

  render() {
    const {
      url,
      alt,
      id,
      linkTo,
      link,
      isFirstItem,
      isLastItem,
      isSelected,
      caption,
      onRemove,
      onMoveForward,
      onMoveBackward,
      setAttributes,
      'aria-label': ariaLabel
    } = this.props;
    const {
      isEditing
    } = this.state;
    let href;

    switch (linkTo) {
      case v1_constants_LINK_DESTINATION_MEDIA:
        href = url;
        break;

      case v1_constants_LINK_DESTINATION_ATTACHMENT:
        href = link;
        break;
    }

    const img = // Disable reason: Image itself is not meant to be interactive, but should
    // direct image selection and unfocus caption fields.

    /* eslint-disable jsx-a11y/no-noninteractive-element-interactions */
    (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      "data-id": id,
      onKeyDown: this.onRemoveImage,
      tabIndex: "0",
      "aria-label": ariaLabel,
      ref: this.bindContainer
    }), (0,external_wp_blob_namespaceObject.isBlobURL)(url) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null))
    /* eslint-enable jsx-a11y/no-noninteractive-element-interactions */
    ;
    const className = classnames_default()({
      'is-selected': isSelected,
      'is-transient': (0,external_wp_blob_namespaceObject.isBlobURL)(url)
    });
    return (// eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-noninteractive-element-interactions
      (0,external_wp_element_namespaceObject.createElement)("figure", {
        className: className,
        onClick: this.onSelectImage,
        onFocus: this.onSelectImage
      }, !isEditing && (href ? (0,external_wp_element_namespaceObject.createElement)("a", {
        href: href
      }, img) : img), isEditing && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
        labels: {
          title: (0,external_wp_i18n_namespaceObject.__)('Edit gallery image')
        },
        icon: library_image,
        onSelect: this.onSelectImageFromLibrary,
        onSelectURL: this.onSelectCustomURL,
        accept: "image/*",
        allowedTypes: ['image'],
        value: {
          id,
          src: url
        }
      }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ButtonGroup, {
        className: "block-library-gallery-item__inline-menu is-left"
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        icon: chevron_left,
        onClick: isFirstItem ? undefined : onMoveBackward,
        label: (0,external_wp_i18n_namespaceObject.__)('Move image backward'),
        "aria-disabled": isFirstItem,
        disabled: !isSelected
      }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        icon: chevron_right,
        onClick: isLastItem ? undefined : onMoveForward,
        label: (0,external_wp_i18n_namespaceObject.__)('Move image forward'),
        "aria-disabled": isLastItem,
        disabled: !isSelected
      })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ButtonGroup, {
        className: "block-library-gallery-item__inline-menu is-right"
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        icon: library_edit,
        onClick: this.onEdit,
        label: (0,external_wp_i18n_namespaceObject.__)('Replace image'),
        disabled: !isSelected
      }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        icon: close_small,
        onClick: onRemove,
        label: (0,external_wp_i18n_namespaceObject.__)('Remove image'),
        disabled: !isSelected
      })), !isEditing && (isSelected || caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
        tagName: "figcaption",
        className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
        "aria-label": (0,external_wp_i18n_namespaceObject.__)('Image caption text'),
        placeholder: isSelected ? (0,external_wp_i18n_namespaceObject.__)('Add caption') : null,
        value: caption,
        onChange: newCaption => setAttributes({
          caption: newCaption
        }),
        inlineToolbar: true
      }))
    );
  }

}

/* harmony default export */ var gallery_image = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)((select, ownProps) => {
  const {
    getMedia
  } = select(external_wp_coreData_namespaceObject.store);
  const {
    id
  } = ownProps;
  return {
    image: id ? getMedia(parseInt(id, 10)) : null
  };
}), (0,external_wp_data_namespaceObject.withDispatch)(dispatch => {
  const {
    __unstableMarkNextChangeAsNotPersistent
  } = dispatch(external_wp_blockEditor_namespaceObject.store);
  return {
    __unstableMarkNextChangeAsNotPersistent
  };
})])(GalleryImage));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/v1/gallery.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const gallery_Gallery = props => {
  const {
    attributes,
    isSelected,
    setAttributes,
    selectedImage,
    mediaPlaceholder,
    onMoveBackward,
    onMoveForward,
    onRemoveImage,
    onSelectImage,
    onDeselectImage,
    onSetImageAttributes,
    insertBlocksAfter,
    blockProps
  } = props;
  const {
    align,
    columns = defaultColumnsNumberV1(attributes),
    caption,
    imageCrop,
    images
  } = attributes;
  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...blockProps,
    className: classnames_default()(blockProps.className, {
      [`align${align}`]: align,
      [`columns-${columns}`]: columns,
      'is-cropped': imageCrop
    })
  }, (0,external_wp_element_namespaceObject.createElement)("ul", {
    className: "blocks-gallery-grid"
  }, images.map((img, index) => {
    const ariaLabel = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: 1: the order number of the image. 2: the total number of images. */
    (0,external_wp_i18n_namespaceObject.__)('image %1$d of %2$d in gallery'), index + 1, images.length);
    return (0,external_wp_element_namespaceObject.createElement)("li", {
      className: "blocks-gallery-item",
      key: img.id ? `${img.id}-${index}` : img.url
    }, (0,external_wp_element_namespaceObject.createElement)(gallery_image, {
      url: img.url,
      alt: img.alt,
      id: img.id,
      isFirstItem: index === 0,
      isLastItem: index + 1 === images.length,
      isSelected: isSelected && selectedImage === index,
      onMoveBackward: onMoveBackward(index),
      onMoveForward: onMoveForward(index),
      onRemove: onRemoveImage(index),
      onSelect: onSelectImage(index),
      onDeselect: onDeselectImage(index),
      setAttributes: attrs => onSetImageAttributes(index, attrs),
      caption: img.caption,
      "aria-label": ariaLabel,
      sizeSlug: attributes.sizeSlug
    }));
  })), mediaPlaceholder, (0,external_wp_element_namespaceObject.createElement)(RichTextVisibilityHelper, {
    isHidden: !isSelected && external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption),
    tagName: "figcaption",
    className: classnames_default()('blocks-gallery-caption', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption')),
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Gallery caption text'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write gallery caption…'),
    value: caption,
    onChange: value => setAttributes({
      caption: value
    }),
    inlineToolbar: true,
    __unstableOnSplitAtEnd: () => insertBlocksAfter((0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()))
  }));
};

function RichTextVisibilityHelper({
  isHidden,
  ...richTextProps
}) {
  return isHidden ? (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, {
    as: external_wp_blockEditor_namespaceObject.RichText,
    ...richTextProps
  }) : (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, { ...richTextProps
  });
}

/* harmony default export */ var v1_gallery = (gallery_Gallery);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/v1/edit.js


/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */






const edit_MAX_COLUMNS = 8;
const edit_linkOptions = [{
  value: v1_constants_LINK_DESTINATION_ATTACHMENT,
  label: (0,external_wp_i18n_namespaceObject.__)('Attachment Page')
}, {
  value: v1_constants_LINK_DESTINATION_MEDIA,
  label: (0,external_wp_i18n_namespaceObject.__)('Media File')
}, {
  value: v1_constants_LINK_DESTINATION_NONE,
  label: (0,external_wp_i18n_namespaceObject.__)('None')
}];
const v1_edit_ALLOWED_MEDIA_TYPES = ['image'];
const edit_PLACEHOLDER_TEXT = external_wp_element_namespaceObject.Platform.select({
  web: (0,external_wp_i18n_namespaceObject.__)('Drag images, upload new ones or select files from your library.'),
  native: (0,external_wp_i18n_namespaceObject.__)('ADD MEDIA')
});
const edit_MOBILE_CONTROL_PROPS_RANGE_CONTROL = external_wp_element_namespaceObject.Platform.select({
  web: {},
  native: {
    type: 'stepper'
  }
});

function edit_GalleryEdit(props) {
  const {
    attributes,
    clientId,
    isSelected,
    noticeUI,
    noticeOperations,
    onFocus
  } = props;
  const {
    columns = defaultColumnsNumberV1(attributes),
    imageCrop,
    images,
    linkTo,
    sizeSlug
  } = attributes;
  const [selectedImage, setSelectedImage] = (0,external_wp_element_namespaceObject.useState)();
  const [attachmentCaptions, setAttachmentCaptions] = (0,external_wp_element_namespaceObject.useState)();
  const {
    __unstableMarkNextChangeAsNotPersistent
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    imageSizes,
    mediaUpload,
    getMedia,
    wasBlockJustInserted
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const settings = select(external_wp_blockEditor_namespaceObject.store).getSettings();
    return {
      imageSizes: settings.imageSizes,
      mediaUpload: settings.mediaUpload,
      getMedia: select(external_wp_coreData_namespaceObject.store).getMedia,
      wasBlockJustInserted: select(external_wp_blockEditor_namespaceObject.store).wasBlockJustInserted(clientId, 'inserter_menu')
    };
  });
  const resizedImages = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (isSelected) {
      var _attributes$ids;

      return ((_attributes$ids = attributes.ids) !== null && _attributes$ids !== void 0 ? _attributes$ids : []).reduce((currentResizedImages, id) => {
        if (!id) {
          return currentResizedImages;
        }

        const image = getMedia(id);
        const sizes = imageSizes.reduce((currentSizes, size) => {
          const defaultUrl = image?.sizes?.[size.slug]?.url;
          const mediaDetailsUrl = image?.media_details?.sizes?.[size.slug]?.source_url;
          return { ...currentSizes,
            [size.slug]: defaultUrl || mediaDetailsUrl
          };
        }, {});
        return { ...currentResizedImages,
          [parseInt(id, 10)]: sizes
        };
      }, {});
    }

    return {};
  }, [isSelected, attributes.ids, imageSizes]);

  function onFocusGalleryCaption() {
    setSelectedImage();
  }

  function setAttributes(newAttrs) {
    if (newAttrs.ids) {
      throw new Error('The "ids" attribute should not be changed directly. It is managed automatically when "images" attribute changes');
    }

    if (newAttrs.images) {
      newAttrs = { ...newAttrs,
        // Unlike images[ n ].id which is a string, always ensure the
        // ids array contains numbers as per its attribute type.
        ids: newAttrs.images.map(({
          id
        }) => parseInt(id, 10))
      };
    }

    props.setAttributes(newAttrs);
  }

  function onSelectImage(index) {
    return () => {
      setSelectedImage(index);
    };
  }

  function onDeselectImage() {
    return () => {
      setSelectedImage();
    };
  }

  function onMove(oldIndex, newIndex) {
    const newImages = [...images];
    newImages.splice(newIndex, 1, images[oldIndex]);
    newImages.splice(oldIndex, 1, images[newIndex]);
    setSelectedImage(newIndex);
    setAttributes({
      images: newImages
    });
  }

  function onMoveForward(oldIndex) {
    return () => {
      if (oldIndex === images.length - 1) {
        return;
      }

      onMove(oldIndex, oldIndex + 1);
    };
  }

  function onMoveBackward(oldIndex) {
    return () => {
      if (oldIndex === 0) {
        return;
      }

      onMove(oldIndex, oldIndex - 1);
    };
  }

  function onRemoveImage(index) {
    return () => {
      const newImages = images.filter((img, i) => index !== i);
      setSelectedImage();
      setAttributes({
        images: newImages,
        columns: attributes.columns ? Math.min(newImages.length, attributes.columns) : attributes.columns
      });
    };
  }

  function selectCaption(newImage) {
    // The image id in both the images and attachmentCaptions arrays is a
    // string, so ensure comparison works correctly by converting the
    // newImage.id to a string.
    const newImageId = newImage.id.toString();
    const currentImage = images.find(({
      id
    }) => id === newImageId);
    const currentImageCaption = currentImage ? currentImage.caption : newImage.caption;

    if (!attachmentCaptions) {
      return currentImageCaption;
    }

    const attachment = attachmentCaptions.find(({
      id
    }) => id === newImageId); // If the attachment caption is updated.

    if (attachment && attachment.caption !== newImage.caption) {
      return newImage.caption;
    }

    return currentImageCaption;
  }

  function onSelectImages(newImages) {
    setAttachmentCaptions(newImages.map(newImage => ({
      // Store the attachmentCaption id as a string for consistency
      // with the type of the id in the images attribute.
      id: newImage.id.toString(),
      caption: newImage.caption
    })));
    setAttributes({
      images: newImages.map(newImage => ({ ...shared_pickRelevantMediaFiles(newImage, sizeSlug),
        caption: selectCaption(newImage, images, attachmentCaptions),
        // The id value is stored in a data attribute, so when the
        // block is parsed it's converted to a string. Converting
        // to a string here ensures it's type is consistent.
        id: newImage.id.toString()
      })),
      columns: attributes.columns ? Math.min(newImages.length, attributes.columns) : attributes.columns
    });
  }

  function onUploadError(message) {
    noticeOperations.removeAllNotices();
    noticeOperations.createErrorNotice(message);
  }

  function setLinkTo(value) {
    setAttributes({
      linkTo: value
    });
  }

  function setColumnsNumber(value) {
    setAttributes({
      columns: value
    });
  }

  function toggleImageCrop() {
    setAttributes({
      imageCrop: !imageCrop
    });
  }

  function getImageCropHelp(checked) {
    return checked ? (0,external_wp_i18n_namespaceObject.__)('Thumbnails are cropped to align.') : (0,external_wp_i18n_namespaceObject.__)('Thumbnails are not cropped.');
  }

  function setImageAttributes(index, newAttributes) {
    if (!images[index]) {
      return;
    }

    setAttributes({
      images: [...images.slice(0, index), { ...images[index],
        ...newAttributes
      }, ...images.slice(index + 1)]
    });
  }

  function getImagesSizeOptions() {
    const resizedImageSizes = Object.values(resizedImages);
    return imageSizes.filter(({
      slug
    }) => resizedImageSizes.some(sizes => sizes[slug])).map(({
      name,
      slug
    }) => ({
      value: slug,
      label: name
    }));
  }

  function updateImagesSize(newSizeSlug) {
    const updatedImages = (images !== null && images !== void 0 ? images : []).map(image => {
      if (!image.id) {
        return image;
      }

      const url = resizedImages[parseInt(image.id, 10)]?.[newSizeSlug];
      return { ...image,
        ...(url && {
          url
        })
      };
    });
    setAttributes({
      images: updatedImages,
      sizeSlug: newSizeSlug
    });
  }

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (external_wp_element_namespaceObject.Platform.OS === 'web' && images && images.length > 0 && images.every(({
      url
    }) => (0,external_wp_blob_namespaceObject.isBlobURL)(url))) {
      const filesList = images.map(({
        url
      }) => (0,external_wp_blob_namespaceObject.getBlobByURL)(url));
      images.forEach(({
        url
      }) => (0,external_wp_blob_namespaceObject.revokeBlobURL)(url));
      mediaUpload({
        filesList,
        onFileChange: onSelectImages,
        allowedTypes: ['image']
      });
    }
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Deselect images when deselecting the block.
    if (!isSelected) {
      setSelectedImage();
    }
  }, [isSelected]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // linkTo attribute must be saved so blocks don't break when changing
    // image_default_link_type in options.php.
    if (!linkTo) {
      __unstableMarkNextChangeAsNotPersistent();

      setAttributes({
        linkTo: window?.wp?.media?.view?.settings?.defaultProps?.link || v1_constants_LINK_DESTINATION_NONE
      });
    }
  }, [linkTo]);
  const hasImages = !!images.length;
  const hasImageIds = hasImages && images.some(image => !!image.id);
  const mediaPlaceholder = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
    addToGallery: hasImageIds,
    isAppender: hasImages,
    disableMediaButtons: hasImages && !isSelected,
    icon: !hasImages && sharedIcon,
    labels: {
      title: !hasImages && (0,external_wp_i18n_namespaceObject.__)('Gallery'),
      instructions: !hasImages && edit_PLACEHOLDER_TEXT
    },
    onSelect: onSelectImages,
    accept: "image/*",
    allowedTypes: v1_edit_ALLOWED_MEDIA_TYPES,
    multiple: true,
    value: hasImageIds ? images : {},
    onError: onUploadError,
    notices: hasImages ? undefined : noticeUI,
    onFocus: onFocus,
    autoOpenMediaUpload: !hasImages && isSelected && wasBlockJustInserted
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)();

  if (!hasImages) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, { ...blockProps
    }, mediaPlaceholder);
  }

  const imageSizeOptions = getImagesSizeOptions();
  const shouldShowSizeOptions = hasImages && imageSizeOptions.length > 0;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, images.length > 1 && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
    value: columns,
    onChange: setColumnsNumber,
    min: 1,
    max: Math.min(edit_MAX_COLUMNS, images.length),
    ...edit_MOBILE_CONTROL_PROPS_RANGE_CONTROL,
    required: true
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Crop images'),
    checked: !!imageCrop,
    onChange: toggleImageCrop,
    help: getImageCropHelp
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Link to'),
    value: linkTo,
    onChange: setLinkTo,
    options: edit_linkOptions,
    hideCancelButton: true
  }), shouldShowSizeOptions && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Image size'),
    value: sizeSlug,
    options: imageSizeOptions,
    onChange: updateImagesSize,
    hideCancelButton: true
  }))), noticeUI, (0,external_wp_element_namespaceObject.createElement)(v1_gallery, { ...props,
    selectedImage: selectedImage,
    mediaPlaceholder: mediaPlaceholder,
    onMoveBackward: onMoveBackward,
    onMoveForward: onMoveForward,
    onRemoveImage: onRemoveImage,
    onSelectImage: onSelectImage,
    onDeselectImage: onDeselectImage,
    onSetImageAttributes: setImageAttributes,
    blockProps: blockProps // This prop is used by gallery.native.js.
    ,
    onFocusGalleryCaption: onFocusGalleryCaption
  }));
}

/* harmony default export */ var v1_edit = ((0,external_wp_compose_namespaceObject.compose)([external_wp_components_namespaceObject.withNotices, (0,external_wp_viewport_namespaceObject.withViewportMatch)({
  isNarrow: '< small'
})])(edit_GalleryEdit));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/edit-wrapper.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/*
 * Using a wrapper around the logic to load the edit for v1 of Gallery block
 * or the refactored version with InnerBlocks. This is to prevent conditional
 * use of hooks lint errors if adding this logic to the top of the edit component.
 */

function GalleryEditWrapper(props) {
  if (!isGalleryV2Enabled()) {
    return (0,external_wp_element_namespaceObject.createElement)(v1_edit, { ...props
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)(gallery_edit, { ...props
  });
}

/* harmony default export */ var edit_wrapper = ((0,external_wp_compose_namespaceObject.compose)([external_wp_components_namespaceObject.withNotices])(GalleryEditWrapper));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/v1/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function saveV1({
  attributes
}) {
  const {
    images,
    columns = defaultColumnsNumberV1(attributes),
    imageCrop,
    caption,
    linkTo
  } = attributes;
  const className = `columns-${columns} ${imageCrop ? 'is-cropped' : ''}`;
  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className
    })
  }, (0,external_wp_element_namespaceObject.createElement)("ul", {
    className: "blocks-gallery-grid"
  }, images.map(image => {
    let href;

    switch (linkTo) {
      case v1_constants_LINK_DESTINATION_MEDIA:
        href = image.fullUrl || image.url;
        break;

      case v1_constants_LINK_DESTINATION_ATTACHMENT:
        href = image.link;
        break;
    }

    const img = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: image.url,
      alt: image.alt,
      "data-id": image.id,
      "data-full-url": image.fullUrl,
      "data-link": image.link,
      className: image.id ? `wp-image-${image.id}` : null
    });
    return (0,external_wp_element_namespaceObject.createElement)("li", {
      key: image.id || image.url,
      className: "blocks-gallery-item"
    }, (0,external_wp_element_namespaceObject.createElement)("figure", null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href
    }, img) : img, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(image.caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      className: classnames_default()('blocks-gallery-item__caption', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption')),
      value: image.caption
    })));
  })), !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    tagName: "figcaption",
    className: classnames_default()('blocks-gallery-caption', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption')),
    value: caption
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function saveWithInnerBlocks({
  attributes
}) {
  if (!isGalleryV2Enabled()) {
    return saveV1({
      attributes
    });
  }

  const {
    caption,
    columns,
    imageCrop
  } = attributes;
  const className = classnames_default()('has-nested-images', {
    [`columns-${columns}`]: columns !== undefined,
    [`columns-default`]: columns === undefined,
    'is-cropped': imageCrop
  });
  const blockProps = external_wp_blockEditor_namespaceObject.useBlockProps.save({
    className
  });
  const innerBlocksProps = external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(blockProps);
  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...innerBlocksProps
  }, innerBlocksProps.children, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    tagName: "figcaption",
    className: classnames_default()('blocks-gallery-caption', (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption')),
    value: caption
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/transforms.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





const parseShortcodeIds = ids => {
  if (!ids) {
    return [];
  }

  return ids.split(',').map(id => parseInt(id, 10));
};
/**
 * Third party block plugins don't have an easy way to detect if the
 * innerBlocks version of the Gallery is running when they run a
 * 3rdPartyBlock -> GalleryBlock transform so this tranform filter
 * will handle this. Once the innerBlocks version is the default
 * in a core release, this could be deprecated and removed after
 * plugin authors have been given time to update transforms.
 *
 * @typedef  {Object} Attributes
 * @typedef  {Object} Block
 * @property {Attributes} attributes The attributes of the block.
 * @param    {Block}      block      The transformed block.
 * @return   {Block}                 The transformed block.
 */


function updateThirdPartyTransformToGallery(block) {
  if (isGalleryV2Enabled() && block.name === 'core/gallery' && block.attributes?.images.length > 0) {
    const innerBlocks = block.attributes.images.map(({
      url,
      id,
      alt
    }) => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
        url,
        id: id ? parseInt(id, 10) : null,
        alt,
        sizeSlug: block.attributes.sizeSlug,
        linkDestination: block.attributes.linkDestination
      });
    });
    delete block.attributes.ids;
    delete block.attributes.images;
    block.innerBlocks = innerBlocks;
  }

  return block;
}

(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/gallery/update-third-party-transform-to', updateThirdPartyTransformToGallery);
/**
 * Third party block plugins don't have an easy way to detect if the
 * innerBlocks version of the Gallery is running when they run a
 * GalleryBlock -> 3rdPartyBlock transform so this transform filter
 * will handle this. Once the innerBlocks version is the default
 * in a core release, this could be deprecated and removed after
 * plugin authors have been given time to update transforms.
 *
 * @typedef  {Object} Attributes
 * @typedef  {Object} Block
 * @property {Attributes} attributes The attributes of the block.
 * @param    {Block}      toBlock    The block to transform to.
 * @param    {Block[]}    fromBlocks The blocks to transform from.
 * @return   {Block}                 The transformed block.
 */

function updateThirdPartyTransformFromGallery(toBlock, fromBlocks) {
  const from = Array.isArray(fromBlocks) ? fromBlocks : [fromBlocks];
  const galleryBlock = from.find(transformedBlock => transformedBlock.name === 'core/gallery' && transformedBlock.innerBlocks.length > 0 && !transformedBlock.attributes.images?.length > 0 && !toBlock.name.includes('core/'));

  if (galleryBlock) {
    const images = galleryBlock.innerBlocks.map(({
      attributes: {
        url,
        id,
        alt
      }
    }) => ({
      url,
      id: id ? parseInt(id, 10) : null,
      alt
    }));
    const ids = images.map(({
      id
    }) => id);
    galleryBlock.attributes.images = images;
    galleryBlock.attributes.ids = ids;
  }

  return toBlock;
}

(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/gallery/update-third-party-transform-from', updateThirdPartyTransformFromGallery);
const gallery_transforms_transforms = {
  from: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['core/image'],
    transform: attributes => {
      // Init the align and size from the first item which may be either the placeholder or an image.
      let {
        align,
        sizeSlug
      } = attributes[0]; // Loop through all the images and check if they have the same align and size.

      align = attributes.every(attribute => attribute.align === align) ? align : undefined;
      sizeSlug = attributes.every(attribute => attribute.sizeSlug === sizeSlug) ? sizeSlug : undefined;
      const validImages = attributes.filter(({
        url
      }) => url);

      if (isGalleryV2Enabled()) {
        const innerBlocks = validImages.map(image => {
          // Gallery images can't currently be resized so make sure height and width are undefined.
          image.width = undefined;
          image.height = undefined;
          return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', image);
        });
        return (0,external_wp_blocks_namespaceObject.createBlock)('core/gallery', {
          align,
          sizeSlug
        }, innerBlocks);
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/gallery', {
        images: validImages.map(({
          id,
          url,
          alt,
          caption
        }) => ({
          id: id.toString(),
          url,
          alt,
          caption
        })),
        ids: validImages.map(({
          id
        }) => parseInt(id, 10)),
        align,
        sizeSlug
      });
    }
  }, {
    type: 'shortcode',
    tag: 'gallery',
    attributes: {
      images: {
        type: 'array',
        shortcode: ({
          named: {
            ids
          }
        }) => {
          if (!isGalleryV2Enabled()) {
            return parseShortcodeIds(ids).map(id => ({
              id: id.toString()
            }));
          }
        }
      },
      ids: {
        type: 'array',
        shortcode: ({
          named: {
            ids
          }
        }) => {
          if (!isGalleryV2Enabled()) {
            return parseShortcodeIds(ids);
          }
        }
      },
      columns: {
        type: 'number',
        shortcode: ({
          named: {
            columns = '3'
          }
        }) => {
          return parseInt(columns, 10);
        }
      },
      linkTo: {
        type: 'string',
        shortcode: ({
          named: {
            link
          }
        }) => {
          if (!isGalleryV2Enabled()) {
            switch (link) {
              case 'post':
                return v1_constants_LINK_DESTINATION_ATTACHMENT;

              case 'file':
                return v1_constants_LINK_DESTINATION_MEDIA;

              default:
                return v1_constants_LINK_DESTINATION_ATTACHMENT;
            }
          }

          switch (link) {
            case 'post':
              return LINK_DESTINATION_ATTACHMENT;

            case 'file':
              return LINK_DESTINATION_MEDIA;

            default:
              return LINK_DESTINATION_NONE;
          }
        }
      }
    },

    transform({
      named: {
        ids,
        columns = 3,
        link
      }
    }) {
      const imageIds = parseShortcodeIds(ids).map(id => parseInt(id, 10));
      let linkTo = LINK_DESTINATION_NONE;

      if (link === 'post') {
        linkTo = LINK_DESTINATION_ATTACHMENT;
      } else if (link === 'file') {
        linkTo = LINK_DESTINATION_MEDIA;
      }

      const galleryBlock = (0,external_wp_blocks_namespaceObject.createBlock)('core/gallery', {
        columns: parseInt(columns, 10),
        linkTo
      }, imageIds.map(imageId => (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
        id: imageId
      })));
      return galleryBlock;
    },

    isMatch({
      named
    }) {
      return undefined !== named.ids;
    }

  }, {
    // When created by drag and dropping multiple files on an insertion point. Because multiple
    // files must not be transformed to a gallery when dropped within a gallery there is another transform
    // within the image block to handle that case. Therefore this transform has to have priority 1
    // set so that it overrrides the image block transformation when mulitple images are dropped outside
    // of a gallery block.
    type: 'files',
    priority: 1,

    isMatch(files) {
      return files.length !== 1 && files.every(file => file.type.indexOf('image/') === 0);
    },

    transform(files) {
      if (isGalleryV2Enabled()) {
        const innerBlocks = files.map(file => (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
          url: (0,external_wp_blob_namespaceObject.createBlobURL)(file)
        }));
        return (0,external_wp_blocks_namespaceObject.createBlock)('core/gallery', {}, innerBlocks);
      }

      const block = (0,external_wp_blocks_namespaceObject.createBlock)('core/gallery', {
        images: files.map(file => pickRelevantMediaFiles({
          url: (0,external_wp_blob_namespaceObject.createBlobURL)(file)
        }))
      });
      return block;
    }

  }],
  to: [{
    type: 'block',
    blocks: ['core/image'],
    transform: ({
      align,
      images,
      ids,
      sizeSlug
    }, innerBlocks) => {
      if (isGalleryV2Enabled()) {
        if (innerBlocks.length > 0) {
          return innerBlocks.map(({
            attributes: {
              url,
              alt,
              caption,
              title,
              href,
              rel,
              linkClass,
              id,
              sizeSlug: imageSizeSlug,
              linkDestination,
              linkTarget,
              anchor,
              className
            }
          }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
            align,
            url,
            alt,
            caption,
            title,
            href,
            rel,
            linkClass,
            id,
            sizeSlug: imageSizeSlug,
            linkDestination,
            linkTarget,
            anchor,
            className
          }));
        }

        return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
          align
        });
      }

      if (images.length > 0) {
        return images.map(({
          url,
          alt,
          caption
        }, index) => (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
          id: ids[index],
          url,
          alt,
          caption,
          align,
          sizeSlug
        }));
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
        align
      });
    }
  }]
};
/* harmony default export */ var gallery_transforms = (gallery_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/gallery/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const gallery_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/gallery",
  title: "Gallery",
  category: "media",
  description: "Display multiple images in a rich gallery.",
  keywords: ["images", "photos"],
  textdomain: "default",
  attributes: {
    images: {
      type: "array",
      "default": [],
      source: "query",
      selector: ".blocks-gallery-item",
      query: {
        url: {
          type: "string",
          source: "attribute",
          selector: "img",
          attribute: "src"
        },
        fullUrl: {
          type: "string",
          source: "attribute",
          selector: "img",
          attribute: "data-full-url"
        },
        link: {
          type: "string",
          source: "attribute",
          selector: "img",
          attribute: "data-link"
        },
        alt: {
          type: "string",
          source: "attribute",
          selector: "img",
          attribute: "alt",
          "default": ""
        },
        id: {
          type: "string",
          source: "attribute",
          selector: "img",
          attribute: "data-id"
        },
        caption: {
          type: "string",
          source: "html",
          selector: ".blocks-gallery-item__caption"
        }
      }
    },
    ids: {
      type: "array",
      items: {
        type: "number"
      },
      "default": []
    },
    shortCodeTransforms: {
      type: "array",
      "default": [],
      items: {
        type: "object"
      }
    },
    columns: {
      type: "number",
      minimum: 1,
      maximum: 8
    },
    caption: {
      type: "string",
      source: "html",
      selector: ".blocks-gallery-caption"
    },
    imageCrop: {
      type: "boolean",
      "default": true
    },
    fixedHeight: {
      type: "boolean",
      "default": true
    },
    linkTarget: {
      type: "string"
    },
    linkTo: {
      type: "string"
    },
    sizeSlug: {
      type: "string",
      "default": "large"
    },
    allowResize: {
      type: "boolean",
      "default": false
    }
  },
  providesContext: {
    allowResize: "allowResize",
    imageCrop: "imageCrop",
    fixedHeight: "fixedHeight"
  },
  supports: {
    anchor: true,
    align: true,
    html: false,
    units: ["px", "em", "rem", "vh", "vw"],
    spacing: {
      margin: true,
      padding: true,
      blockGap: ["horizontal", "vertical"],
      __experimentalSkipSerialization: ["blockGap"],
      __experimentalDefaultControls: {
        blockGap: true,
        margin: false,
        padding: false
      }
    },
    color: {
      text: false,
      background: true,
      gradients: true
    },
    layout: {
      allowSwitching: false,
      allowInheriting: false,
      allowEditing: false,
      "default": {
        type: "flex"
      }
    }
  },
  editorStyle: "wp-block-gallery-editor",
  style: "wp-block-gallery"
};


const {
  name: gallery_name
} = gallery_metadata;

const gallery_settings = {
  icon: library_gallery,
  example: {
    attributes: {
      columns: 2
    },
    innerBlocks: [{
      name: 'core/image',
      attributes: {
        url: 'https://s.w.org/images/core/5.3/Glacial_lakes%2C_Bhutan.jpg'
      }
    }, {
      name: 'core/image',
      attributes: {
        url: 'https://s.w.org/images/core/5.3/Sediment_off_the_Yucatan_Peninsula.jpg'
      }
    }]
  },
  transforms: gallery_transforms,
  edit: edit_wrapper,
  save: saveWithInnerBlocks,
  deprecated: gallery_deprecated
};
const gallery_init = () => initBlock({
  name: gallery_name,
  metadata: gallery_metadata,
  settings: gallery_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/group.js


/**
 * WordPress dependencies
 */

const group = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 4h-7c-1.1 0-2 .9-2 2v3H6c-1.1 0-2 .9-2 2v7c0 1.1.9 2 2 2h7c1.1 0 2-.9 2-2v-3h3c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-4.5 14c0 .3-.2.5-.5.5H6c-.3 0-.5-.2-.5-.5v-7c0-.3.2-.5.5-.5h3V13c0 1.1.9 2 2 2h2.5v3zm0-4.5H11c-.3 0-.5-.2-.5-.5v-2.5H13c.3 0 .5.2.5.5v2.5zm5-.5c0 .3-.2.5-.5.5h-3V11c0-1.1-.9-2-2-2h-2.5V6c0-.3.2-.5.5-.5h7c.3 0 .5.2.5.5v7z"
}));
/* harmony default export */ var library_group = (group);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



const migrateAttributes = attributes => {
  if (!attributes.tagName) {
    attributes = { ...attributes,
      tagName: 'div'
    };
  }

  if (!attributes.customTextColor && !attributes.customBackgroundColor) {
    return attributes;
  }

  const style = {
    color: {}
  };

  if (attributes.customTextColor) {
    style.color.text = attributes.customTextColor;
  }

  if (attributes.customBackgroundColor) {
    style.color.background = attributes.customBackgroundColor;
  }

  const {
    customTextColor,
    customBackgroundColor,
    ...restAttributes
  } = attributes;
  return { ...restAttributes,
    style
  };
};

const group_deprecated_deprecated = [// Version with default layout.
{
  attributes: {
    tagName: {
      type: 'string',
      default: 'div'
    },
    templateLock: {
      type: ['string', 'boolean'],
      enum: ['all', 'insert', false]
    }
  },
  supports: {
    __experimentalOnEnter: true,
    __experimentalSettings: true,
    align: ['wide', 'full'],
    anchor: true,
    ariaLabel: true,
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: ['top', 'bottom'],
      padding: true,
      blockGap: true,
      __experimentalDefaultControls: {
        padding: true,
        blockGap: true
      }
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      style: true,
      width: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        style: true,
        width: true
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontStyle: true,
      __experimentalFontWeight: true,
      __experimentalLetterSpacing: true,
      __experimentalTextTransform: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    layout: true
  },

  save({
    attributes: {
      tagName: Tag
    }
  }) {
    return (0,external_wp_element_namespaceObject.createElement)(Tag, { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(external_wp_blockEditor_namespaceObject.useBlockProps.save())
    });
  },

  isEligible: ({
    layout
  }) => !layout || layout.inherit || layout.contentSize && layout.type !== 'constrained',
  migrate: attributes => {
    const {
      layout = null
    } = attributes;

    if (!layout) {
      return attributes;
    }

    if (layout.inherit || layout.contentSize) {
      return { ...attributes,
        layout: { ...layout,
          type: 'constrained'
        }
      };
    }
  }
}, // Version of the block with the double div.
{
  attributes: {
    tagName: {
      type: 'string',
      default: 'div'
    },
    templateLock: {
      type: ['string', 'boolean'],
      enum: ['all', 'insert', false]
    }
  },
  supports: {
    align: ['wide', 'full'],
    anchor: true,
    color: {
      gradients: true,
      link: true
    },
    spacing: {
      padding: true
    },
    __experimentalBorder: {
      radius: true
    }
  },

  save({
    attributes
  }) {
    const {
      tagName: Tag
    } = attributes;
    return (0,external_wp_element_namespaceObject.createElement)(Tag, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-group__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  }

}, // Version of the block without global styles support
{
  attributes: {
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    customTextColor: {
      type: 'string'
    }
  },
  supports: {
    align: ['wide', 'full'],
    anchor: true,
    html: false
  },
  migrate: migrateAttributes,

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor,
      textColor,
      customTextColor
    } = attributes;
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const className = classnames_default()(backgroundClass, textClass, {
      'has-text-color': textColor || customTextColor,
      'has-background': backgroundColor || customBackgroundColor
    });
    const styles = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      color: textClass ? undefined : customTextColor
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className,
      style: styles
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-group__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  }

}, // Version of the group block with a bug that made text color class not applied.
{
  attributes: {
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    },
    customTextColor: {
      type: 'string'
    }
  },
  migrate: migrateAttributes,
  supports: {
    align: ['wide', 'full'],
    anchor: true,
    html: false
  },

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor,
      textColor,
      customTextColor
    } = attributes;
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const className = classnames_default()(backgroundClass, {
      'has-text-color': textColor || customTextColor,
      'has-background': backgroundColor || customBackgroundColor
    });
    const styles = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      color: textClass ? undefined : customTextColor
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className,
      style: styles
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-group__inner-container"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  }

}, // v1 of group block. Deprecated to add an inner-container div around `InnerBlocks.Content`.
{
  attributes: {
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    }
  },
  supports: {
    align: ['wide', 'full'],
    anchor: true,
    html: false
  },
  migrate: migrateAttributes,

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor
    } = attributes;
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const className = classnames_default()(backgroundClass, {
      'has-background': backgroundColor || customBackgroundColor
    });
    const styles = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className,
      style: styles
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
  }

}];
/* harmony default export */ var group_deprecated = (group_deprecated_deprecated);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/placeholder.js


/**
 * WordPress dependencies
 */






/**
 * Returns a custom variation icon.
 *
 * @param {string} name The block variation name.
 *
 * @return {JSX.Element} The SVG element.
 */

const getGroupPlaceholderIcons = (name = 'group') => {
  const icons = {
    group: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
      xmlns: "http://www.w3.org/2000/svg",
      width: "44",
      height: "32",
      viewBox: "0 0 44 32"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
      d: "M42 0H2C.9 0 0 .9 0 2v28c0 1.1.9 2 2 2h40c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2z"
    })),
    'group-row': (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
      xmlns: "http://www.w3.org/2000/svg",
      width: "44",
      height: "32",
      viewBox: "0 0 44 32"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
      d: "M42 0H23.5c-.6 0-1 .4-1 1v30c0 .6.4 1 1 1H42c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2zM20.5 0H2C.9 0 0 .9 0 2v28c0 1.1.9 2 2 2h18.5c.6 0 1-.4 1-1V1c0-.6-.4-1-1-1z"
    })),
    'group-stack': (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
      xmlns: "http://www.w3.org/2000/svg",
      width: "44",
      height: "32",
      viewBox: "0 0 44 32"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
      d: "M42 0H2C.9 0 0 .9 0 2v12.5c0 .6.4 1 1 1h42c.6 0 1-.4 1-1V2c0-1.1-.9-2-2-2zm1 16.5H1c-.6 0-1 .4-1 1V30c0 1.1.9 2 2 2h40c1.1 0 2-.9 2-2V17.5c0-.6-.4-1-1-1z"
    })),
    'group-grid': (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
      xmlns: "http://www.w3.org/2000/svg",
      width: "44",
      height: "32",
      viewBox: "0 0 44 32"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
      d: "m20.30137,-0.00025l-18.9728,0c-0.86524,0.07234 -1.41711,0.79149 -1.41711,1.89149l0,12.64468c0,0.6 0.73401,0.96383 1.0304,0.96383l19.67469,0.03617c0.29639,0 1.0304,-0.4 1.0304,-1l-0.03576,-12.7532c0,-1.1 -0.76644,-1.78297 -1.30983,-1.78297zm0.52975,16.60851l-19.99654,-0.03617c-0.29639,0 -0.92312,0.36383 -0.92312,0.96383l-0.03576,12.68085c0,1.1 0.8022,1.81915 1.34559,1.81915l19.00857,0c0.54339,0 1.45287,-0.71915 1.45287,-1.81915l0,-12.53617c0,-0.6 -0.5552,-1.07234 -0.8516,-1.07234z"
    }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
      d: "m42.73056,-0.03617l-18.59217,0c-0.84788,0.07234 -1.38868,0.79149 -1.38868,1.89149l0,12.64468c0,0.6 0.71928,0.96383 1.00973,0.96383l19.27997,0.03617c0.29045,0 1.00973,-0.4 1.00973,-1l-0.03504,-12.7532c0,-1.1 -0.75106,-1.78297 -1.28355,-1.78297zm0.51912,16.60851l-19.59537,-0.03617c-0.29045,0 -0.9046,0.36383 -0.9046,0.96383l-0.03504,12.68085c0,1.1 0.78611,1.81915 1.31859,1.81915l18.62721,0c0.53249,0 1.42372,-0.71915 1.42372,-1.81915l0,-12.53617c0,-0.6 -0.54407,-1.07234 -0.83451,-1.07234z"
    }))
  };
  return icons?.[name];
};
/**
 * A custom hook to tell the Group block whether to show the variation placeholder.
 *
 * @param {Object}  props                  Arguments to pass to hook.
 * @param {Object}  [props.attributes]     The block's attributes.
 * @param {string}  [props.usedLayoutType] The block's current layout type.
 * @param {boolean} [props.hasInnerBlocks] Whether the block has inner blocks.
 *
 * @return {[boolean, Function]} A state value and setter function.
 */


function useShouldShowPlaceHolder({
  attributes = {
    style: undefined,
    backgroundColor: undefined,
    textColor: undefined,
    fontSize: undefined
  },
  usedLayoutType = '',
  hasInnerBlocks = false
}) {
  const {
    style,
    backgroundColor,
    textColor,
    fontSize
  } = attributes;
  /*
   * Shows the placeholder when no known styles are set,
   * or when a non-default layout has been selected.
   * Should the Group block support more style presets in the
   * future, e.g., attributes.spacingSize, we can add them to the
   * condition.
   */

  const [showPlaceholder, setShowPlaceholder] = (0,external_wp_element_namespaceObject.useState)(!hasInnerBlocks && !backgroundColor && !fontSize && !textColor && !style && usedLayoutType !== 'flex' && usedLayoutType !== 'grid');
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!!hasInnerBlocks || !!backgroundColor || !!fontSize || !!textColor || !!style || usedLayoutType === 'flex') {
      setShowPlaceholder(false);
    }
  }, [backgroundColor, fontSize, textColor, style, usedLayoutType, hasInnerBlocks]);
  return [showPlaceholder, setShowPlaceholder];
}
/**
 * Display group variations if none is selected.
 *
 * @param {Object}   props          Component props.
 * @param {string}   props.name     The block's name.
 * @param {Function} props.onSelect Function to set block's attributes.
 *
 * @return {JSX.Element}                The placeholder.
 */

function GroupPlaceHolder({
  name,
  onSelect
}) {
  const variations = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blocks_namespaceObject.store).getBlockVariations(name, 'block'), [name]);
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: 'wp-block-group__placeholder'
  });
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
    instructions: (0,external_wp_i18n_namespaceObject.__)('Group blocks together. Select a layout:')
  }, (0,external_wp_element_namespaceObject.createElement)("ul", {
    role: "list",
    className: "wp-block-group-placeholder__variations",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Block variations')
  }, variations.map(variation => (0,external_wp_element_namespaceObject.createElement)("li", {
    key: variation.name
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "tertiary",
    icon: getGroupPlaceholderIcons(variation.name),
    iconSize: 44,
    onClick: () => onSelect(variation),
    className: "wp-block-group-placeholder__variation-button",
    label: `${variation.title}: ${variation.description}`
  }))))));
}

/* harmony default export */ var placeholder = (GroupPlaceHolder);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/edit.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


/**
 * Render inspector controls for the Group block.
 *
 * @param {Object}   props                 Component props.
 * @param {string}   props.tagName         The HTML tag name.
 * @param {Function} props.onSelectTagName onChange function for the SelectControl.
 *
 * @return {JSX.Element}                The control group.
 */

function GroupEditControls({
  tagName,
  onSelectTagName
}) {
  const htmlElementMessages = {
    header: (0,external_wp_i18n_namespaceObject.__)('The <header> element should represent introductory content, typically a group of introductory or navigational aids.'),
    main: (0,external_wp_i18n_namespaceObject.__)('The <main> element should be used for the primary content of your document only. '),
    section: (0,external_wp_i18n_namespaceObject.__)("The <section> element should represent a standalone portion of the document that can't be better represented by another element."),
    article: (0,external_wp_i18n_namespaceObject.__)('The <article> element should represent a self-contained, syndicatable portion of the document.'),
    aside: (0,external_wp_i18n_namespaceObject.__)("The <aside> element should represent a portion of a document whose content is only indirectly related to the document's main content."),
    footer: (0,external_wp_i18n_namespaceObject.__)('The <footer> element should represent a footer for its nearest sectioning element (e.g.: <section>, <article>, <main> etc.).')
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "advanced"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('HTML element'),
    options: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Default (<div>)'),
      value: 'div'
    }, {
      label: '<header>',
      value: 'header'
    }, {
      label: '<main>',
      value: 'main'
    }, {
      label: '<section>',
      value: 'section'
    }, {
      label: '<article>',
      value: 'article'
    }, {
      label: '<aside>',
      value: 'aside'
    }, {
      label: '<footer>',
      value: 'footer'
    }],
    value: tagName,
    onChange: onSelectTagName,
    help: htmlElementMessages[tagName]
  }));
}

function GroupEdit({
  attributes,
  name,
  setAttributes,
  clientId,
  __unstableLayoutClassNames: layoutClassNames
}) {
  const {
    hasInnerBlocks,
    themeSupportsLayout
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlock,
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const block = getBlock(clientId);
    return {
      hasInnerBlocks: !!(block && block.innerBlocks.length),
      themeSupportsLayout: getSettings()?.supportsLayout
    };
  }, [clientId]);
  const {
    tagName: TagName = 'div',
    templateLock,
    allowedBlocks,
    layout = {}
  } = attributes; // Layout settings.

  const defaultLayout = (0,external_wp_blockEditor_namespaceObject.useSetting)('layout') || {};
  const usedLayout = !layout?.type ? { ...defaultLayout,
    ...layout,
    type: 'default'
  } : { ...defaultLayout,
    ...layout
  };
  const {
    type = 'default'
  } = usedLayout;
  const layoutSupportEnabled = themeSupportsLayout || type === 'flex' || type === 'grid'; // Hooks.

  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: !layoutSupportEnabled ? layoutClassNames : null
  });
  const [showPlaceholder, setShowPlaceholder] = useShouldShowPlaceHolder({
    attributes,
    usedLayoutType: usedLayout?.type,
    hasInnerBlocks
  }); // Default to the regular appender being rendered.

  let renderAppender;

  if (showPlaceholder) {
    // In the placeholder state, ensure the appender is not rendered.
    // This is needed because `...innerBlocksProps` is used in the placeholder
    // state so that blocks can dragged onto the placeholder area
    // from both the list view and in the editor canvas.
    renderAppender = false;
  } else if (!hasInnerBlocks) {
    // When there is no placeholder, but the block is also empty,
    // use the larger button appender.
    renderAppender = external_wp_blockEditor_namespaceObject.InnerBlocks.ButtonBlockAppender;
  }

  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(layoutSupportEnabled ? blockProps : {
    className: 'wp-block-group__inner-container'
  }, {
    templateLock,
    allowedBlocks,
    renderAppender,
    __unstableDisableLayoutClassNames: !layoutSupportEnabled
  });
  const {
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);

  const selectVariation = nextVariation => {
    setAttributes(nextVariation.attributes);
    selectBlock(clientId, -1);
    setShowPlaceholder(false);
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(GroupEditControls, {
    tagName: TagName,
    onSelectTagName: value => setAttributes({
      tagName: value
    })
  }), showPlaceholder && (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.View, null, innerBlocksProps.children, (0,external_wp_element_namespaceObject.createElement)(placeholder, {
    clientId: clientId,
    name: name,
    onSelect: selectVariation
  })), layoutSupportEnabled && !showPlaceholder && (0,external_wp_element_namespaceObject.createElement)(TagName, { ...innerBlocksProps
  }), !layoutSupportEnabled && !showPlaceholder && (0,external_wp_element_namespaceObject.createElement)(TagName, { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  })));
}

/* harmony default export */ var group_edit = (GroupEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/save.js


/**
 * WordPress dependencies
 */

function group_save_save({
  attributes: {
    tagName: Tag
  }
}) {
  return (0,external_wp_element_namespaceObject.createElement)(Tag, { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save(external_wp_blockEditor_namespaceObject.useBlockProps.save())
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/transforms.js
/**
 * WordPress dependencies
 */

const group_transforms_transforms = {
  from: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['*'],

    __experimentalConvert(blocks) {
      const alignments = ['wide', 'full']; // Determine the widest setting of all the blocks to be grouped

      const widestAlignment = blocks.reduce((accumulator, block) => {
        const {
          align
        } = block.attributes;
        return alignments.indexOf(align) > alignments.indexOf(accumulator) ? align : accumulator;
      }, undefined); // Clone the Blocks to be Grouped
      // Failing to create new block references causes the original blocks
      // to be replaced in the switchToBlockType call thereby meaning they
      // are removed both from their original location and within the
      // new group block.

      const groupInnerBlocks = blocks.map(block => {
        return (0,external_wp_blocks_namespaceObject.createBlock)(block.name, block.attributes, block.innerBlocks);
      });
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/group', {
        align: widestAlignment,
        layout: {
          type: 'constrained'
        }
      }, groupInnerBlocks);
    }

  }]
};
/* harmony default export */ var group_transforms = (group_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/row.js


/**
 * WordPress dependencies
 */

const row = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 6.5h5a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H4V16h5a.5.5 0 0 0 .5-.5v-7A.5.5 0 0 0 9 8H4V6.5Zm16 0h-5a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h5V16h-5a.5.5 0 0 1-.5-.5v-7A.5.5 0 0 1 15 8h5V6.5Z"
}));
/* harmony default export */ var library_row = (row);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/stack.js


/**
 * WordPress dependencies
 */

const stack = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M17.5 4v5a2 2 0 0 1-2 2h-7a2 2 0 0 1-2-2V4H8v5a.5.5 0 0 0 .5.5h7A.5.5 0 0 0 16 9V4h1.5Zm0 16v-5a2 2 0 0 0-2-2h-7a2 2 0 0 0-2 2v5H8v-5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 .5.5v5h1.5Z"
}));
/* harmony default export */ var library_stack = (stack);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/grid.js


/**
 * WordPress dependencies
 */

const grid = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m3 5c0-1.10457.89543-2 2-2h13.5c1.1046 0 2 .89543 2 2v13.5c0 1.1046-.8954 2-2 2h-13.5c-1.10457 0-2-.8954-2-2zm2-.5h6v6.5h-6.5v-6c0-.27614.22386-.5.5-.5zm-.5 8v6c0 .2761.22386.5.5.5h6v-6.5zm8 0v6.5h6c.2761 0 .5-.2239.5-.5v-6zm0-8v6.5h6.5v-6c0-.27614-.2239-.5-.5-.5z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ var library_grid = (grid);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/variations.js
/**
 * WordPress dependencies
 */


const group_variations_variations = [{
  name: 'group',
  title: (0,external_wp_i18n_namespaceObject.__)('Group'),
  description: (0,external_wp_i18n_namespaceObject.__)('Gather blocks in a container.'),
  attributes: {
    layout: {
      type: 'constrained'
    }
  },
  isDefault: true,
  scope: ['block', 'inserter', 'transform'],
  isActive: blockAttributes => !blockAttributes.layout || !blockAttributes.layout?.type || blockAttributes.layout?.type === 'default' || blockAttributes.layout?.type === 'constrained',
  icon: library_group
}, {
  name: 'group-row',
  title: (0,external_wp_i18n_namespaceObject._x)('Row', 'single horizontal line'),
  description: (0,external_wp_i18n_namespaceObject.__)('Arrange blocks horizontally.'),
  attributes: {
    layout: {
      type: 'flex',
      flexWrap: 'nowrap'
    }
  },
  scope: ['block', 'inserter', 'transform'],
  isActive: blockAttributes => blockAttributes.layout?.type === 'flex' && (!blockAttributes.layout?.orientation || blockAttributes.layout?.orientation === 'horizontal'),
  icon: library_row
}, {
  name: 'group-stack',
  title: (0,external_wp_i18n_namespaceObject.__)('Stack'),
  description: (0,external_wp_i18n_namespaceObject.__)('Arrange blocks vertically.'),
  attributes: {
    layout: {
      type: 'flex',
      orientation: 'vertical'
    }
  },
  scope: ['block', 'inserter', 'transform'],
  isActive: blockAttributes => blockAttributes.layout?.type === 'flex' && blockAttributes.layout?.orientation === 'vertical',
  icon: library_stack
}];

if (window?.__experimentalEnableGroupGridVariation) {
  group_variations_variations.push({
    name: 'group-grid',
    title: (0,external_wp_i18n_namespaceObject.__)('Grid'),
    description: (0,external_wp_i18n_namespaceObject.__)('Arrange blocks in a grid.'),
    attributes: {
      layout: {
        type: 'grid'
      }
    },
    scope: ['block', 'inserter', 'transform'],
    isActive: blockAttributes => blockAttributes.layout?.type === 'grid',
    icon: library_grid
  });
}

/* harmony default export */ var group_variations = (group_variations_variations);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/group/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const group_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/group",
  title: "Group",
  category: "design",
  description: "Gather blocks in a layout container.",
  keywords: ["container", "wrapper", "row", "section"],
  textdomain: "default",
  attributes: {
    tagName: {
      type: "string",
      "default": "div"
    },
    templateLock: {
      type: ["string", "boolean"],
      "enum": ["all", "insert", "contentOnly", false]
    },
    allowedBlocks: {
      type: "array"
    }
  },
  supports: {
    __experimentalOnEnter: true,
    __experimentalSettings: true,
    align: ["wide", "full"],
    anchor: true,
    ariaLabel: true,
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: ["top", "bottom"],
      padding: true,
      blockGap: true,
      __experimentalDefaultControls: {
        padding: true,
        blockGap: true
      }
    },
    dimensions: {
      minHeight: true
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      style: true,
      width: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        style: true,
        width: true
      }
    },
    position: {
      sticky: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    layout: {
      allowSizingOnChildren: true
    }
  },
  editorStyle: "wp-block-group-editor",
  style: "wp-block-group"
};



const {
  name: group_name
} = group_metadata;

const group_settings = {
  icon: library_group,
  example: {
    attributes: {
      style: {
        color: {
          text: '#000000',
          background: '#ffffff'
        }
      }
    },
    innerBlocks: [{
      name: 'core/paragraph',
      attributes: {
        customTextColor: '#cf2e2e',
        fontSize: 'large',
        content: (0,external_wp_i18n_namespaceObject.__)('One.')
      }
    }, {
      name: 'core/paragraph',
      attributes: {
        customTextColor: '#ff6900',
        fontSize: 'large',
        content: (0,external_wp_i18n_namespaceObject.__)('Two.')
      }
    }, {
      name: 'core/paragraph',
      attributes: {
        customTextColor: '#fcb900',
        fontSize: 'large',
        content: (0,external_wp_i18n_namespaceObject.__)('Three.')
      }
    }, {
      name: 'core/paragraph',
      attributes: {
        customTextColor: '#00d084',
        fontSize: 'large',
        content: (0,external_wp_i18n_namespaceObject.__)('Four.')
      }
    }, {
      name: 'core/paragraph',
      attributes: {
        customTextColor: '#0693e3',
        fontSize: 'large',
        content: (0,external_wp_i18n_namespaceObject.__)('Five.')
      }
    }, {
      name: 'core/paragraph',
      attributes: {
        customTextColor: '#9b51e0',
        fontSize: 'large',
        content: (0,external_wp_i18n_namespaceObject.__)('Six.')
      }
    }]
  },
  transforms: group_transforms,
  edit: group_edit,
  save: group_save_save,
  deprecated: group_deprecated,
  variations: group_variations
};
const group_init = () => initBlock({
  name: group_name,
  metadata: group_metadata,
  settings: group_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/heading.js


/**
 * WordPress dependencies
 */

const heading = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M6 5V18.5911L12 13.8473L18 18.5911V5H6Z"
}));
/* harmony default export */ var library_heading = (heading);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


const blockSupports = {
  className: false,
  anchor: true
};
const heading_deprecated_blockAttributes = {
  align: {
    type: 'string'
  },
  content: {
    type: 'string',
    source: 'html',
    selector: 'h1,h2,h3,h4,h5,h6',
    default: ''
  },
  level: {
    type: 'number',
    default: 2
  },
  placeholder: {
    type: 'string'
  }
};

const deprecated_migrateCustomColors = attributes => {
  if (!attributes.customTextColor) {
    return attributes;
  }

  const style = {
    color: {
      text: attributes.customTextColor
    }
  };
  const {
    customTextColor,
    ...restAttributes
  } = attributes;
  return { ...restAttributes,
    style
  };
};

const TEXT_ALIGN_OPTIONS = ['left', 'right', 'center'];

const migrateTextAlign = attributes => {
  const {
    align,
    ...rest
  } = attributes;
  return TEXT_ALIGN_OPTIONS.includes(align) ? { ...rest,
    textAlign: align
  } : attributes;
};

const heading_deprecated_v1 = {
  supports: blockSupports,
  attributes: { ...heading_deprecated_blockAttributes,
    customTextColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    }
  },
  migrate: attributes => deprecated_migrateCustomColors(migrateTextAlign(attributes)),

  save({
    attributes
  }) {
    const {
      align,
      level,
      content,
      textColor,
      customTextColor
    } = attributes;
    const tagName = 'h' + level;
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const className = classnames_default()({
      [textClass]: textClass
    });
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      className: className ? className : undefined,
      tagName: tagName,
      style: {
        textAlign: align,
        color: textClass ? undefined : customTextColor
      },
      value: content
    });
  }

};
const heading_deprecated_v2 = {
  attributes: { ...heading_deprecated_blockAttributes,
    customTextColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    }
  },
  migrate: attributes => deprecated_migrateCustomColors(migrateTextAlign(attributes)),

  save({
    attributes
  }) {
    const {
      align,
      content,
      customTextColor,
      level,
      textColor
    } = attributes;
    const tagName = 'h' + level;
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const className = classnames_default()({
      [textClass]: textClass,
      [`has-text-align-${align}`]: align
    });
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      className: className ? className : undefined,
      tagName: tagName,
      style: {
        color: textClass ? undefined : customTextColor
      },
      value: content
    });
  },

  supports: blockSupports
};
const heading_deprecated_v3 = {
  supports: blockSupports,
  attributes: { ...heading_deprecated_blockAttributes,
    customTextColor: {
      type: 'string'
    },
    textColor: {
      type: 'string'
    }
  },
  migrate: attributes => deprecated_migrateCustomColors(migrateTextAlign(attributes)),

  save({
    attributes
  }) {
    const {
      align,
      content,
      customTextColor,
      level,
      textColor
    } = attributes;
    const tagName = 'h' + level;
    const textClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', textColor);
    const className = classnames_default()({
      [textClass]: textClass,
      'has-text-color': textColor || customTextColor,
      [`has-text-align-${align}`]: align
    });
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      className: className ? className : undefined,
      tagName: tagName,
      style: {
        color: textClass ? undefined : customTextColor
      },
      value: content
    });
  }

};
const heading_deprecated_v4 = {
  supports: {
    align: ['wide', 'full'],
    anchor: true,
    className: false,
    color: {
      link: true
    },
    fontSize: true,
    lineHeight: true,
    __experimentalSelector: {
      'core/heading/h1': 'h1',
      'core/heading/h2': 'h2',
      'core/heading/h3': 'h3',
      'core/heading/h4': 'h4',
      'core/heading/h5': 'h5',
      'core/heading/h6': 'h6'
    },
    __unstablePasteTextInline: true
  },
  attributes: heading_deprecated_blockAttributes,
  isEligible: ({
    align
  }) => TEXT_ALIGN_OPTIONS.includes(align),
  migrate: migrateTextAlign,

  save({
    attributes
  }) {
    const {
      align,
      content,
      level
    } = attributes;
    const TagName = 'h' + level;
    const className = classnames_default()({
      [`has-text-align-${align}`]: align
    });
    return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: content
    }));
  }

}; // This deprecation covers the serialization of the `wp-block-heading` class
// into the block's markup after className support was enabled.

const heading_deprecated_v5 = {
  supports: {
    align: ['wide', 'full'],
    anchor: true,
    className: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontStyle: true,
      __experimentalFontWeight: true,
      __experimentalLetterSpacing: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalDefaultControls: {
        fontSize: true,
        fontAppearance: true,
        textTransform: true
      }
    },
    __experimentalSelector: 'h1,h2,h3,h4,h5,h6',
    __unstablePasteTextInline: true,
    __experimentalSlashInserter: true
  },
  attributes: {
    textAlign: {
      type: 'string'
    },
    content: {
      type: 'string',
      source: 'html',
      selector: 'h1,h2,h3,h4,h5,h6',
      default: '',
      __experimentalRole: 'content'
    },
    level: {
      type: 'number',
      default: 2
    },
    placeholder: {
      type: 'string'
    }
  },

  save({
    attributes
  }) {
    const {
      textAlign,
      content,
      level
    } = attributes;
    const TagName = 'h' + level;
    const className = classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    });
    return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: content
    }));
  }

};
const heading_deprecated_deprecated = [heading_deprecated_v5, heading_deprecated_v4, heading_deprecated_v3, heading_deprecated_v2, heading_deprecated_v1];
/* harmony default export */ var heading_deprecated = (heading_deprecated_deprecated);

// EXTERNAL MODULE: ./node_modules/remove-accents/index.js
var remove_accents = __webpack_require__(4793);
var remove_accents_default = /*#__PURE__*/__webpack_require__.n(remove_accents);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/autogenerate-anchors.js
/**
 * External dependencies
 */

/**
 * Object map tracking anchors.
 *
 * @type {Record<string, string | null>}
 */

const autogenerate_anchors_anchors = {};
/**
 * Returns the text without markup.
 *
 * @param {string} text The text.
 *
 * @return {string} The text without markup.
 */

const getTextWithoutMarkup = text => {
  const dummyElement = document.createElement('div');
  dummyElement.innerHTML = text;
  return dummyElement.innerText;
};
/**
 * Get the slug from the content.
 *
 * @param {string} content The block content.
 *
 * @return {string} Returns the slug.
 */


const getSlug = content => {
  // Get the slug.
  return remove_accents_default()(getTextWithoutMarkup(content)) // Convert anything that's not a letter or number to a hyphen.
  .replace(/[^\p{L}\p{N}]+/gu, '-') // Convert to lowercase
  .toLowerCase() // Remove any remaining leading or trailing hyphens.
  .replace(/(^-+)|(-+$)/g, '');
};
/**
 * Generate the anchor for a heading.
 *
 * @param {string} clientId The block ID.
 * @param {string} content  The block content.
 *
 * @return {string|null} Return the heading anchor.
 */


const generateAnchor = (clientId, content) => {
  const slug = getSlug(content); // If slug is empty, then return null.
  // Returning null instead of an empty string allows us to check again when the content changes.

  if ('' === slug) {
    return null;
  }

  delete autogenerate_anchors_anchors[clientId];
  let anchor = slug;
  let i = 0; // If the anchor already exists in another heading, append -i.

  while (Object.values(autogenerate_anchors_anchors).includes(anchor)) {
    i += 1;
    anchor = slug + '-' + i;
  }

  return anchor;
};
/**
 * Set the anchor for a heading.
 *
 * @param {string}      clientId The block ID.
 * @param {string|null} anchor   The block anchor.
 */

const setAnchor = (clientId, anchor) => {
  autogenerate_anchors_anchors[clientId] = anchor;
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function HeadingEdit({
  attributes,
  setAttributes,
  mergeBlocks,
  onReplace,
  style,
  clientId
}) {
  const {
    textAlign,
    content,
    level,
    placeholder,
    anchor
  } = attributes;
  const tagName = 'h' + level;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      [`has-text-align-${textAlign}`]: textAlign
    }),
    style
  });
  const {
    canGenerateAnchors
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getGlobalBlockCount,
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const settings = getSettings();
    return {
      canGenerateAnchors: !!settings.generateAnchors || getGlobalBlockCount('core/table-of-contents') > 0
    };
  }, []);
  const {
    __unstableMarkNextChangeAsNotPersistent
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store); // Initially set anchor for headings that have content but no anchor set.
  // This is used when transforming a block to heading, or for legacy anchors.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!canGenerateAnchors) {
      return;
    }

    if (!anchor && content) {
      // This side-effect should not create an undo level.
      __unstableMarkNextChangeAsNotPersistent();

      setAttributes({
        anchor: generateAnchor(clientId, content)
      });
    }

    setAnchor(clientId, anchor); // Remove anchor map when block unmounts.

    return () => setAnchor(clientId, null);
  }, [anchor, content, clientId, canGenerateAnchors]);

  const onContentChange = value => {
    const newAttrs = {
      content: value
    };

    if (canGenerateAnchors && (!anchor || !value || generateAnchor(clientId, content) === anchor)) {
      newAttrs.anchor = generateAnchor(clientId, value);
    }

    setAttributes(newAttrs);
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.HeadingLevelDropdown, {
    value: level,
    onChange: newLevel => setAttributes({
      level: newLevel
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.AlignmentControl, {
    value: textAlign,
    onChange: nextAlign => {
      setAttributes({
        textAlign: nextAlign
      });
    }
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    identifier: "content",
    tagName: tagName,
    value: content,
    onChange: onContentChange,
    onMerge: mergeBlocks,
    onSplit: (value, isOriginal) => {
      let block;

      if (isOriginal || value) {
        block = (0,external_wp_blocks_namespaceObject.createBlock)('core/heading', { ...attributes,
          content: value
        });
      } else {
        var _getDefaultBlockName;

        block = (0,external_wp_blocks_namespaceObject.createBlock)((_getDefaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)()) !== null && _getDefaultBlockName !== void 0 ? _getDefaultBlockName : 'core/heading');
      }

      if (isOriginal) {
        block.clientId = clientId;
      }

      return block;
    },
    onReplace: onReplace,
    onRemove: () => onReplace([]),
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Heading text'),
    placeholder: placeholder || (0,external_wp_i18n_namespaceObject.__)('Heading'),
    textAlign: textAlign,
    ...(external_wp_element_namespaceObject.Platform.isNative && {
      deleteEnter: true
    }),
    ...blockProps
  }));
}

/* harmony default export */ var heading_edit = (HeadingEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function heading_save_save({
  attributes
}) {
  const {
    textAlign,
    content,
    level
  } = attributes;
  const TagName = 'h' + level;
  const className = classnames_default()({
    [`has-text-align-${textAlign}`]: textAlign
  });
  return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    value: content
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/shared.js
/**
 * Given a node name string for a heading node, returns its numeric level.
 *
 * @param {string} nodeName Heading node name.
 *
 * @return {number} Heading level.
 */
function getLevelFromHeadingNodeName(nodeName) {
  return Number(nodeName.substr(1));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/transforms.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const {
  name: heading_transforms_name
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/heading",
  title: "Heading",
  category: "text",
  description: "Introduce new sections and organize content to help visitors (and search engines) understand the structure of your content.",
  keywords: ["title", "subtitle"],
  textdomain: "default",
  attributes: {
    textAlign: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "h1,h2,h3,h4,h5,h6",
      "default": "",
      __experimentalRole: "content"
    },
    level: {
      type: "number",
      "default": 2
    },
    placeholder: {
      type: "string"
    }
  },
  supports: {
    align: ["wide", "full"],
    anchor: true,
    className: true,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontStyle: true,
      __experimentalFontWeight: true,
      __experimentalLetterSpacing: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalDefaultControls: {
        fontSize: true,
        fontAppearance: true,
        textTransform: true
      }
    },
    __unstablePasteTextInline: true,
    __experimentalSlashInserter: true
  },
  editorStyle: "wp-block-heading-editor",
  style: "wp-block-heading"
};
const heading_transforms_transforms = {
  from: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['core/paragraph'],
    transform: attributes => attributes.map(({
      content,
      anchor,
      align: textAlign
    }) => (0,external_wp_blocks_namespaceObject.createBlock)(heading_transforms_name, {
      content,
      anchor,
      textAlign
    }))
  }, {
    type: 'raw',
    selector: 'h1,h2,h3,h4,h5,h6',
    schema: ({
      phrasingContentSchema,
      isPaste
    }) => {
      const schema = {
        children: phrasingContentSchema,
        attributes: isPaste ? [] : ['style', 'id']
      };
      return {
        h1: schema,
        h2: schema,
        h3: schema,
        h4: schema,
        h5: schema,
        h6: schema
      };
    },

    transform(node) {
      const attributes = (0,external_wp_blocks_namespaceObject.getBlockAttributes)(heading_transforms_name, node.outerHTML);
      const {
        textAlign
      } = node.style || {};
      attributes.level = getLevelFromHeadingNodeName(node.nodeName);

      if (textAlign === 'left' || textAlign === 'center' || textAlign === 'right') {
        attributes.align = textAlign;
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)(heading_transforms_name, attributes);
    }

  }, ...[1, 2, 3, 4, 5, 6].map(level => ({
    type: 'prefix',
    prefix: Array(level + 1).join('#'),

    transform(content) {
      return (0,external_wp_blocks_namespaceObject.createBlock)(heading_transforms_name, {
        level,
        content
      });
    }

  })), ...[1, 2, 3, 4, 5, 6].map(level => ({
    type: 'enter',
    regExp: new RegExp(`^/(h|H)${level}$`),

    transform(content) {
      return (0,external_wp_blocks_namespaceObject.createBlock)(heading_transforms_name, {
        level,
        content
      });
    }

  }))],
  to: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['core/paragraph'],
    transform: attributes => attributes.map(({
      content,
      textAlign: align
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', {
      content,
      align
    }))
  }]
};
/* harmony default export */ var heading_transforms = (heading_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/heading/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const heading_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/heading",
  title: "Heading",
  category: "text",
  description: "Introduce new sections and organize content to help visitors (and search engines) understand the structure of your content.",
  keywords: ["title", "subtitle"],
  textdomain: "default",
  attributes: {
    textAlign: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "h1,h2,h3,h4,h5,h6",
      "default": "",
      __experimentalRole: "content"
    },
    level: {
      type: "number",
      "default": 2
    },
    placeholder: {
      type: "string"
    }
  },
  supports: {
    align: ["wide", "full"],
    anchor: true,
    className: true,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontStyle: true,
      __experimentalFontWeight: true,
      __experimentalLetterSpacing: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalDefaultControls: {
        fontSize: true,
        fontAppearance: true,
        textTransform: true
      }
    },
    __unstablePasteTextInline: true,
    __experimentalSlashInserter: true
  },
  editorStyle: "wp-block-heading-editor",
  style: "wp-block-heading"
};


const {
  name: heading_name
} = heading_metadata;

const heading_settings = {
  icon: library_heading,
  example: {
    attributes: {
      content: (0,external_wp_i18n_namespaceObject.__)('Code is Poetry'),
      level: 2
    }
  },

  __experimentalLabel(attributes, {
    context
  }) {
    const {
      content,
      level
    } = attributes; // In the list view, use the block's content as the label.
    // If the content is empty, fall back to the default label.

    if (context === 'list-view' && content) {
      return content;
    }

    if (context === 'accessibility') {
      return !content || content.length === 0 ? (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: accessibility text. %s: heading level. */
      (0,external_wp_i18n_namespaceObject.__)('Level %s. Empty.'), level) : (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: accessibility text. 1: heading level. 2: heading content. */
      (0,external_wp_i18n_namespaceObject.__)('Level %1$s. %2$s'), level, content);
    }
  },

  transforms: heading_transforms,
  deprecated: heading_deprecated,

  merge(attributes, attributesToMerge) {
    return {
      content: (attributes.content || '') + (attributesToMerge.content || '')
    };
  },

  edit: heading_edit,
  save: heading_save_save
};
const heading_init = () => initBlock({
  name: heading_name,
  metadata: heading_metadata,
  settings: heading_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/home.js


/**
 * WordPress dependencies
 */

const home = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M12 4L4 7.9V20h16V7.9L12 4zm6.5 14.5H14V13h-4v5.5H5.5V8.8L12 5.7l6.5 3.1v9.7z"
}));
/* harmony default export */ var library_home = (home);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/home-link/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */







const preventDefault = event => event.preventDefault();

function HomeEdit({
  attributes,
  setAttributes,
  context
}) {
  const {
    homeUrl
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getUnstableBase // Site index.

    } = select(external_wp_coreData_namespaceObject.store);
    return {
      homeUrl: getUnstableBase()?.home
    };
  }, []);
  const {
    __unstableMarkNextChangeAsNotPersistent
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    textColor,
    backgroundColor,
    style
  } = context;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()('wp-block-navigation-item', {
      'has-text-color': !!textColor || !!style?.color?.text,
      [`has-${textColor}-color`]: !!textColor,
      'has-background': !!backgroundColor || !!style?.color?.background,
      [`has-${backgroundColor}-background-color`]: !!backgroundColor
    }),
    style: {
      color: style?.color?.text,
      backgroundColor: style?.color?.background
    }
  });
  const {
    label
  } = attributes;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (label === undefined) {
      __unstableMarkNextChangeAsNotPersistent();

      setAttributes({
        label: (0,external_wp_i18n_namespaceObject.__)('Home')
      });
    }
  }, [label]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    className: "wp-block-home-link__content wp-block-navigation-item__content",
    href: homeUrl,
    onClick: preventDefault
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    identifier: "label",
    className: "wp-block-home-link__label",
    value: label,
    onChange: labelValue => {
      setAttributes({
        label: labelValue
      });
    },
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Home link text'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Add home link'),
    withoutInteractiveFormatting: true,
    allowedFormats: ['core/bold', 'core/italic', 'core/image', 'core/strikethrough']
  }))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/home-link/save.js


/**
 * WordPress dependencies
 */

function home_link_save_save() {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/home-link/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const home_link_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/home-link",
  category: "design",
  parent: ["core/navigation"],
  title: "Home Link",
  description: "Create a link that always points to the homepage of the site. Usually not necessary if there is already a site title link present in the header.",
  textdomain: "default",
  attributes: {
    label: {
      type: "string"
    }
  },
  usesContext: ["textColor", "customTextColor", "backgroundColor", "customBackgroundColor", "fontSize", "customFontSize", "style"],
  supports: {
    reusable: false,
    html: false,
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-home-link-editor",
  style: "wp-block-home-link"
};


const {
  name: home_link_name
} = home_link_metadata;

const home_link_settings = {
  icon: library_home,
  edit: HomeEdit,
  save: home_link_save_save,
  example: {
    attributes: {
      label: (0,external_wp_i18n_namespaceObject._x)('Home Link', 'block example')
    }
  }
};
const home_link_init = () => initBlock({
  name: home_link_name,
  metadata: home_link_metadata,
  settings: home_link_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/html.js


/**
 * WordPress dependencies
 */

const html = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4.8 11.4H2.1V9H1v6h1.1v-2.6h2.7V15h1.1V9H4.8v2.4zm1.9-1.3h1.7V15h1.1v-4.9h1.7V9H6.7v1.1zM16.2 9l-1.5 2.7L13.3 9h-.9l-.8 6h1.1l.5-4 1.5 2.8 1.5-2.8.5 4h1.1L17 9h-.8zm3.8 5V9h-1.1v6h3.6v-1H20z"
}));
/* harmony default export */ var library_html = (html);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/html/preview.js


/**
 * WordPress dependencies
 */



 // Default styles used to unset some of the styles
// that might be inherited from the editor style.

const DEFAULT_STYLES = `
	html,body,:root {
		margin: 0 !important;
		padding: 0 !important;
		overflow: visible !important;
		min-height: auto !important;
	}
`;
function HTMLEditPreview({
  content,
  isSelected
}) {
  const settingStyles = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(external_wp_blockEditor_namespaceObject.store).getSettings()?.styles;
  }, []);
  const styles = (0,external_wp_element_namespaceObject.useMemo)(() => [DEFAULT_STYLES, ...(0,external_wp_blockEditor_namespaceObject.transformStyles)(settingStyles)], [settingStyles]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SandBox, {
    html: content,
    styles: styles
  }), !isSelected && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-library-html__preview-overlay"
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/html/edit.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function HTMLEdit({
  attributes,
  setAttributes,
  isSelected
}) {
  const [isPreview, setIsPreview] = (0,external_wp_element_namespaceObject.useState)();
  const isDisabled = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.Disabled.Context);

  function switchToPreview() {
    setIsPreview(true);
  }

  function switchToHTML() {
    setIsPreview(false);
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)({
      className: 'block-library-html__edit'
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    className: "components-tab-button",
    isPressed: !isPreview,
    onClick: switchToHTML
  }, "HTML"), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    className: "components-tab-button",
    isPressed: isPreview,
    onClick: switchToPreview
  }, (0,external_wp_i18n_namespaceObject.__)('Preview')))), isPreview || isDisabled ? (0,external_wp_element_namespaceObject.createElement)(HTMLEditPreview, {
    content: attributes.content,
    isSelected: isSelected
  }) : (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.PlainText, {
    value: attributes.content,
    onChange: content => setAttributes({
      content
    }),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Write HTML…'),
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('HTML')
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/html/save.js


/**
 * WordPress dependencies
 */

function html_save_save({
  attributes
}) {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, attributes.content);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/html/transforms.js
/**
 * WordPress dependencies
 */

const html_transforms_transforms = {
  from: [{
    type: 'block',
    blocks: ['core/code'],
    transform: ({
      content
    }) => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/html', {
        content
      });
    }
  }]
};
/* harmony default export */ var html_transforms = (html_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/html/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const html_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/html",
  title: "Custom HTML",
  category: "widgets",
  description: "Add custom HTML code and preview it as you edit.",
  keywords: ["embed"],
  textdomain: "default",
  attributes: {
    content: {
      type: "string",
      source: "raw"
    }
  },
  supports: {
    customClassName: false,
    className: false,
    html: false
  },
  editorStyle: "wp-block-html-editor"
};


const {
  name: html_name
} = html_metadata;

const html_settings = {
  icon: library_html,
  example: {
    attributes: {
      content: '<marquee>' + (0,external_wp_i18n_namespaceObject.__)('Welcome to the wonderful world of blocks…') + '</marquee>'
    }
  },
  edit: HTMLEdit,
  save: html_save_save,
  transforms: html_transforms
};
const html_init = () => initBlock({
  name: html_name,
  metadata: html_metadata,
  settings: html_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Deprecation for adding the `wp-image-${id}` class to the image block for
 * responsive images.
 *
 * @see https://github.com/WordPress/gutenberg/pull/4898
 */

const image_deprecated_v1 = {
  attributes: {
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: ''
    },
    caption: {
      type: 'array',
      source: 'children',
      selector: 'figcaption'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'href'
    },
    id: {
      type: 'number'
    },
    align: {
      type: 'string'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      width,
      height
    } = attributes;
    const extraImageProps = width || height ? {
      width,
      height
    } : {};
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      ...extraImageProps
    });
    let figureStyle = {};

    if (width) {
      figureStyle = {
        width
      };
    } else if (align === 'left' || align === 'right') {
      figureStyle = {
        maxWidth: '50%'
      };
    }

    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: align ? `align${align}` : null,
      style: figureStyle
    }, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
  }

};
/**
 * Deprecation for adding the `is-resized` class to the image block to fix
 * captions on resized images.
 *
 * @see https://github.com/WordPress/gutenberg/pull/6496
 */

const image_deprecated_v2 = {
  attributes: {
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: ''
    },
    caption: {
      type: 'array',
      source: 'children',
      selector: 'figcaption'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'a',
      attribute: 'href'
    },
    id: {
      type: 'number'
    },
    align: {
      type: 'string'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      width,
      height,
      id
    } = attributes;
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      className: id ? `wp-image-${id}` : null,
      width: width,
      height: height
    });
    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: align ? `align${align}` : null
    }, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
  }

};
/**
 * Deprecation for image floats including a wrapping div.
 *
 * @see https://github.com/WordPress/gutenberg/pull/7721
 */

const image_deprecated_v3 = {
  attributes: {
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: ''
    },
    caption: {
      type: 'array',
      source: 'children',
      selector: 'figcaption'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'href'
    },
    id: {
      type: 'number'
    },
    align: {
      type: 'string'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    },
    linkDestination: {
      type: 'string',
      default: 'none'
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      width,
      height,
      id
    } = attributes;
    const classes = classnames_default()({
      [`align${align}`]: align,
      'is-resized': width || height
    });
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      className: id ? `wp-image-${id}` : null,
      width: width,
      height: height
    });
    return (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: classes
    }, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      href: href
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
  }

};
/**
 * Deprecation for removing the outer div wrapper around aligned images.
 *
 * @see https://github.com/WordPress/gutenberg/pull/38657
 */

const image_deprecated_v4 = {
  attributes: {
    align: {
      type: 'string'
    },
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: ''
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: 'figcaption'
    },
    title: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'title'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'href'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'rel'
    },
    linkClass: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'class'
    },
    id: {
      type: 'number'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    },
    sizeSlug: {
      type: 'string'
    },
    linkDestination: {
      type: 'string'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'target'
    }
  },
  supports: {
    anchor: true
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      rel,
      linkClass,
      width,
      height,
      id,
      linkTarget,
      sizeSlug,
      title
    } = attributes;
    const newRel = !rel ? undefined : rel;
    const classes = classnames_default()({
      [`align${align}`]: align,
      [`size-${sizeSlug}`]: sizeSlug,
      'is-resized': width || height
    });
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      className: id ? `wp-image-${id}` : null,
      width: width,
      height: height,
      title: title
    });
    const figure = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      className: linkClass,
      href: href,
      target: linkTarget,
      rel: newRel
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));

    if ('left' === align || 'right' === align || 'center' === align) {
      return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
      }, (0,external_wp_element_namespaceObject.createElement)("figure", {
        className: classes
      }, figure));
    }

    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes
      })
    }, figure);
  }

};
/**
 * Deprecation for moving existing border radius styles onto the inner img
 * element where new border block support styles must be applied.
 * It will also add a new `.has-custom-border` class for existing blocks
 * with border radii set. This class is required to improve caption position
 * and styling when an image within a gallery has a custom border or
 * rounded corners.
 *
 * @see https://github.com/WordPress/gutenberg/pull/31366
 */

const image_deprecated_v5 = {
  attributes: {
    align: {
      type: 'string'
    },
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: ''
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: 'figcaption'
    },
    title: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'title'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'href'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'rel'
    },
    linkClass: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'class'
    },
    id: {
      type: 'number'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    },
    sizeSlug: {
      type: 'string'
    },
    linkDestination: {
      type: 'string'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'target'
    }
  },
  supports: {
    anchor: true,
    color: {
      __experimentalDuotone: 'img',
      text: false,
      background: false
    },
    __experimentalBorder: {
      radius: true,
      __experimentalDefaultControls: {
        radius: true
      }
    },
    __experimentalStyle: {
      spacing: {
        margin: '0 0 1em 0'
      }
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      rel,
      linkClass,
      width,
      height,
      id,
      linkTarget,
      sizeSlug,
      title
    } = attributes;
    const newRel = !rel ? undefined : rel;
    const classes = classnames_default()({
      [`align${align}`]: align,
      [`size-${sizeSlug}`]: sizeSlug,
      'is-resized': width || height
    });
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      className: id ? `wp-image-${id}` : null,
      width: width,
      height: height,
      title: title
    });
    const figure = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      className: linkClass,
      href: href,
      target: linkTarget,
      rel: newRel
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      tagName: "figcaption",
      value: caption
    }));
    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes
      })
    }, figure);
  }

};
/**
 * Deprecation for adding width and height as style rules on the inner img.
 *
 * @see https://github.com/WordPress/gutenberg/pull/31366
 */

const image_deprecated_v6 = {
  attributes: {
    align: {
      type: 'string'
    },
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src',
      __experimentalRole: 'content'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: '',
      __experimentalRole: 'content'
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: 'figcaption',
      __experimentalRole: 'content'
    },
    title: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'title',
      __experimentalRole: 'content'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'href',
      __experimentalRole: 'content'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'rel'
    },
    linkClass: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'class'
    },
    id: {
      type: 'number',
      __experimentalRole: 'content'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    },
    aspectRatio: {
      type: 'string'
    },
    scale: {
      type: 'string'
    },
    sizeSlug: {
      type: 'string'
    },
    linkDestination: {
      type: 'string'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'target'
    }
  },
  supports: {
    anchor: true,
    behaviors: {
      lightbox: true
    },
    color: {
      text: false,
      background: false
    },
    filter: {
      duotone: true
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      width: true,
      __experimentalSkipSerialization: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        width: true
      }
    }
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      rel,
      linkClass,
      width,
      height,
      aspectRatio,
      scale,
      id,
      linkTarget,
      sizeSlug,
      title
    } = attributes;
    const newRel = !rel ? undefined : rel;
    const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetBorderClassesAndStyles)(attributes);
    const classes = classnames_default()({
      [`align${align}`]: align,
      [`size-${sizeSlug}`]: sizeSlug,
      'is-resized': width || height,
      'has-custom-border': !!borderProps.className || borderProps.style && Object.keys(borderProps.style).length > 0
    });
    const imageClasses = classnames_default()(borderProps.className, {
      [`wp-image-${id}`]: !!id
    });
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      className: imageClasses || undefined,
      style: { ...borderProps.style,
        aspectRatio,
        objectFit: scale
      },
      width: width,
      height: height,
      title: title
    });
    const figure = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      className: linkClass,
      href: href,
      target: linkTarget,
      rel: newRel
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
      tagName: "figcaption",
      value: caption
    }));
    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes
      })
    }, figure);
  }

};
/**
 * Deprecation for converting to string width and height block attributes and
 * removing the width and height img element attributes which are not needed
 * as they get added by the TODO hook.
 *
 * @see https://github.com/WordPress/gutenberg/pull/53274
 */

const image_deprecated_v7 = {
  attributes: {
    align: {
      type: 'string'
    },
    url: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'src',
      __experimentalRole: 'content'
    },
    alt: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'alt',
      default: '',
      __experimentalRole: 'content'
    },
    caption: {
      type: 'string',
      source: 'html',
      selector: 'figcaption',
      __experimentalRole: 'content'
    },
    title: {
      type: 'string',
      source: 'attribute',
      selector: 'img',
      attribute: 'title',
      __experimentalRole: 'content'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'href',
      __experimentalRole: 'content'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'rel'
    },
    linkClass: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'class'
    },
    id: {
      type: 'number',
      __experimentalRole: 'content'
    },
    width: {
      type: 'number'
    },
    height: {
      type: 'number'
    },
    aspectRatio: {
      type: 'string'
    },
    scale: {
      type: 'string'
    },
    sizeSlug: {
      type: 'string'
    },
    linkDestination: {
      type: 'string'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'figure > a',
      attribute: 'target'
    }
  },
  supports: {
    anchor: true,
    behaviors: {
      lightbox: true
    },
    color: {
      text: false,
      background: false
    },
    filter: {
      duotone: true
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      width: true,
      __experimentalSkipSerialization: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        width: true
      }
    }
  },

  migrate({
    width,
    height,
    ...attributes
  }) {
    return { ...attributes,
      width: `${width}px`,
      height: `${height}px`
    };
  },

  save({
    attributes
  }) {
    const {
      url,
      alt,
      caption,
      align,
      href,
      rel,
      linkClass,
      width,
      height,
      aspectRatio,
      scale,
      id,
      linkTarget,
      sizeSlug,
      title
    } = attributes;
    const newRel = !rel ? undefined : rel;
    const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetBorderClassesAndStyles)(attributes);
    const classes = classnames_default()({
      [`align${align}`]: align,
      [`size-${sizeSlug}`]: sizeSlug,
      'is-resized': width || height,
      'has-custom-border': !!borderProps.className || borderProps.style && Object.keys(borderProps.style).length > 0
    });
    const imageClasses = classnames_default()(borderProps.className, {
      [`wp-image-${id}`]: !!id
    });
    const image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: url,
      alt: alt,
      className: imageClasses || undefined,
      style: { ...borderProps.style,
        aspectRatio,
        objectFit: scale,
        width,
        height
      },
      width: width,
      height: height,
      title: title
    });
    const figure = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
      className: linkClass,
      href: href,
      target: linkTarget,
      rel: newRel
    }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
      tagName: "figcaption",
      value: caption
    }));
    return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className: classes
      })
    }, figure);
  }

};
/* harmony default export */ var image_deprecated = ([image_deprecated_v7, image_deprecated_v6, image_deprecated_v5, image_deprecated_v4, image_deprecated_v3, image_deprecated_v2, image_deprecated_v1]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/crop.js


/**
 * WordPress dependencies
 */

const crop = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M16.5 7.8v7H18v-7c0-1-.8-1.8-1.8-1.8h-7v1.5h7c.2 0 .3.1.3.3zm-8.7 8.7c-.1 0-.2-.1-.2-.2V2H6v4H2v1.5h4v8.8c0 1 .8 1.8 1.8 1.8h8.8v4H18v-4h4v-1.5H7.8z"
}));
/* harmony default export */ var library_crop = (crop);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/overlay-text.js


/**
 * WordPress dependencies
 */

const overlayText = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12-9.8c.4 0 .8-.3.9-.7l1.1-3h3.6l.5 1.7h1.9L13 9h-2.2l-3.4 9.5H6c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h12c.3 0 .5.2.5.5v12H20V6c0-1.1-.9-2-2-2zm-6 7l1.4 3.9h-2.7L12 11z"
}));
/* harmony default export */ var overlay_text = (overlayText);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/upload.js


/**
 * WordPress dependencies
 */

const upload = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18.5 15v3.5H13V6.7l4.5 4.1 1-1.1-6.2-5.8-5.8 5.8 1 1.1 4-4v11.7h-6V15H4v5h16v-5z"
}));
/* harmony default export */ var library_upload = (upload);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/use-client-width.js
/**
 * WordPress dependencies
 */

function useClientWidth(ref, dependencies) {
  const [clientWidth, setClientWidth] = (0,external_wp_element_namespaceObject.useState)();

  function calculateClientWidth() {
    setClientWidth(ref.current?.clientWidth);
  }

  (0,external_wp_element_namespaceObject.useEffect)(calculateClientWidth, dependencies);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      defaultView
    } = ref.current.ownerDocument;
    defaultView.addEventListener('resize', calculateClientWidth);
    return () => {
      defaultView.removeEventListener('resize', calculateClientWidth);
    };
  }, []);
  return clientWidth;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/image.js


/**
 * WordPress dependencies
 */












/**
 * Internal dependencies
 */





/**
 * Module constants
 */



const {
  DimensionsTool,
  ResolutionTool
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
const scaleOptions = [{
  value: 'cover',
  label: (0,external_wp_i18n_namespaceObject._x)('Cover', 'Scale option for dimensions control'),
  help: (0,external_wp_i18n_namespaceObject.__)('Image covers the space evenly.')
}, {
  value: 'contain',
  label: (0,external_wp_i18n_namespaceObject._x)('Contain', 'Scale option for dimensions control'),
  help: (0,external_wp_i18n_namespaceObject.__)('Image is contained without distortion.')
}];
function image_Image({
  temporaryURL,
  attributes,
  setAttributes,
  isSelected,
  insertBlocksAfter,
  onReplace,
  onSelectImage,
  onSelectURL,
  onUploadError,
  containerRef,
  context,
  clientId,
  blockEditingMode
}) {
  const {
    url = '',
    alt,
    caption,
    align,
    id,
    href,
    rel,
    linkClass,
    linkDestination,
    title,
    width,
    height,
    aspectRatio,
    scale,
    linkTarget,
    sizeSlug
  } = attributes; // The only supported unit is px, so we can parseInt to strip the px here.

  const numericWidth = width ? parseInt(width, 10) : undefined;
  const numericHeight = height ? parseInt(height, 10) : undefined;
  const imageRef = (0,external_wp_element_namespaceObject.useRef)();
  const prevCaption = (0,external_wp_compose_namespaceObject.usePrevious)(caption);
  const [showCaption, setShowCaption] = (0,external_wp_element_namespaceObject.useState)(!!caption);
  const {
    allowResize = true
  } = context;
  const {
    getBlock
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const {
    image,
    multiImageSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getMedia
    } = select(external_wp_coreData_namespaceObject.store);
    const {
      getMultiSelectedBlockClientIds,
      getBlockName
    } = select(external_wp_blockEditor_namespaceObject.store);
    const multiSelectedClientIds = getMultiSelectedBlockClientIds();
    return {
      image: id && isSelected ? getMedia(id, {
        context: 'view'
      }) : null,
      multiImageSelection: multiSelectedClientIds.length && multiSelectedClientIds.every(_clientId => getBlockName(_clientId) === 'core/image')
    };
  }, [id, isSelected]);
  const {
    canInsertCover,
    imageEditing,
    imageSizes,
    maxWidth,
    mediaUpload
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockRootClientId,
      getSettings,
      canInsertBlockType
    } = select(external_wp_blockEditor_namespaceObject.store);
    const rootClientId = getBlockRootClientId(clientId);
    const settings = getSettings();
    return {
      imageEditing: settings.imageEditing,
      imageSizes: settings.imageSizes,
      maxWidth: settings.maxWidth,
      mediaUpload: settings.mediaUpload,
      canInsertCover: canInsertBlockType('core/cover', rootClientId)
    };
  }, [clientId]);
  const {
    replaceBlocks,
    toggleSelection
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    createErrorNotice,
    createSuccessNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const isLargeViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium');
  const isWideAligned = ['wide', 'full'].includes(align);
  const [{
    loadedNaturalWidth,
    loadedNaturalHeight
  }, setLoadedNaturalSize] = (0,external_wp_element_namespaceObject.useState)({});
  const [isEditingImage, setIsEditingImage] = (0,external_wp_element_namespaceObject.useState)(false);
  const [externalBlob, setExternalBlob] = (0,external_wp_element_namespaceObject.useState)();
  const clientWidth = useClientWidth(containerRef, [align]);
  const hasNonContentControls = blockEditingMode === 'default';
  const isResizable = allowResize && hasNonContentControls && !(isWideAligned && isLargeViewport);
  const imageSizeOptions = imageSizes.filter(({
    slug
  }) => image?.media_details?.sizes?.[slug]?.source_url).map(({
    name,
    slug
  }) => ({
    value: slug,
    label: name
  }));
  const canUploadMedia = !!mediaUpload; // If an image is externally hosted, try to fetch the image data. This may
  // fail if the image host doesn't allow CORS with the domain. If it works,
  // we can enable a button in the toolbar to upload the image.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isExternalImage(id, url) || !isSelected || !canUploadMedia) {
      setExternalBlob();
      return;
    }

    if (externalBlob) return;
    window // Avoid cache, which seems to help avoid CORS problems.
    .fetch(url.includes('?') ? url : url + '?').then(response => response.blob()).then(blob => setExternalBlob(blob)) // Do nothing, cannot upload.
    .catch(() => {});
  }, [id, url, isSelected, externalBlob, canUploadMedia]); // We need to show the caption when changes come from
  // history navigation(undo/redo).

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (caption && !prevCaption) {
      setShowCaption(true);
    }
  }, [caption, prevCaption]); // Focus the caption when we click to add one.

  const captionRef = (0,external_wp_element_namespaceObject.useCallback)(node => {
    if (node && !caption) {
      node.focus();
    }
  }, [caption]); // Get naturalWidth and naturalHeight from image ref, and fall back to loaded natural
  // width and height. This resolves an issue in Safari where the loaded natural
  // width and height is otherwise lost when switching between alignments.
  // See: https://github.com/WordPress/gutenberg/pull/37210.

  const {
    naturalWidth,
    naturalHeight
  } = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      naturalWidth: imageRef.current?.naturalWidth || loadedNaturalWidth || undefined,
      naturalHeight: imageRef.current?.naturalHeight || loadedNaturalHeight || undefined
    };
  }, [loadedNaturalWidth, loadedNaturalHeight, imageRef.current?.complete]);

  function onResizeStart() {
    toggleSelection(false);
  }

  function onResizeStop() {
    toggleSelection(true);
  }

  function onImageError() {
    // Check if there's an embed block that handles this URL, e.g., instagram URL.
    // See: https://github.com/WordPress/gutenberg/pull/11472
    const embedBlock = createUpgradedEmbedBlock({
      attributes: {
        url
      }
    });

    if (undefined !== embedBlock) {
      onReplace(embedBlock);
    }
  }

  function onSetHref(props) {
    setAttributes(props);
  }

  function onSetTitle(value) {
    // This is the HTML title attribute, separate from the media object
    // title.
    setAttributes({
      title: value
    });
  }

  function updateAlt(newAlt) {
    setAttributes({
      alt: newAlt
    });
  }

  function updateImage(newSizeSlug) {
    const newUrl = image?.media_details?.sizes?.[newSizeSlug]?.source_url;

    if (!newUrl) {
      return null;
    }

    setAttributes({
      url: newUrl,
      sizeSlug: newSizeSlug
    });
  }

  function uploadExternal() {
    mediaUpload({
      filesList: [externalBlob],

      onFileChange([img]) {
        onSelectImage(img);

        if ((0,external_wp_blob_namespaceObject.isBlobURL)(img.url)) {
          return;
        }

        setExternalBlob();
        createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Image uploaded.'), {
          type: 'snackbar'
        });
      },

      allowedTypes: constants_ALLOWED_MEDIA_TYPES,

      onError(message) {
        createErrorNotice(message, {
          type: 'snackbar'
        });
      }

    });
  }

  function updateAlignment(nextAlign) {
    const extraUpdatedAttributes = ['wide', 'full'].includes(nextAlign) ? {
      width: undefined,
      height: undefined,
      aspectRatio: undefined,
      scale: undefined
    } : {};
    setAttributes({ ...extraUpdatedAttributes,
      align: nextAlign
    });
  }

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isSelected) {
      setIsEditingImage(false);

      if (!caption) {
        setShowCaption(false);
      }
    }
  }, [isSelected, caption]);
  const canEditImage = id && naturalWidth && naturalHeight && imageEditing;
  const allowCrop = !multiImageSelection && canEditImage && !isEditingImage;

  function switchToCover() {
    replaceBlocks(clientId, (0,external_wp_blocks_namespaceObject.switchToBlockType)(getBlock(clientId), 'core/cover'));
  } // TODO: Can allow more units after figuring out how they should interact
  // with the ResizableBox and ImageEditor components. Calculations later on
  // for those components are currently assuming px units.


  const dimensionsUnitsOptions = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: ['px']
  });
  const controls = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, hasNonContentControls && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockAlignmentControl, {
    value: align,
    onChange: updateAlignment
  }), hasNonContentControls && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: () => {
      setShowCaption(!showCaption);

      if (showCaption && caption) {
        setAttributes({
          caption: undefined
        });
      }
    },
    icon: library_caption,
    isPressed: showCaption,
    label: showCaption ? (0,external_wp_i18n_namespaceObject.__)('Remove caption') : (0,external_wp_i18n_namespaceObject.__)('Add caption')
  }), !multiImageSelection && !isEditingImage && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalImageURLInputUI, {
    url: href || '',
    onChangeUrl: onSetHref,
    linkDestination: linkDestination,
    mediaUrl: image && image.source_url || url,
    mediaLink: image && image.link,
    linkTarget: linkTarget,
    linkClass: linkClass,
    rel: rel
  }), allowCrop && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: () => setIsEditingImage(true),
    icon: library_crop,
    label: (0,external_wp_i18n_namespaceObject.__)('Crop')
  }), !multiImageSelection && canInsertCover && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: overlay_text,
    label: (0,external_wp_i18n_namespaceObject.__)('Add text over image'),
    onClick: switchToCover
  })), !multiImageSelection && !isEditingImage && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "other"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaReplaceFlow, {
    mediaId: id,
    mediaURL: url,
    allowedTypes: constants_ALLOWED_MEDIA_TYPES,
    accept: "image/*",
    onSelect: onSelectImage,
    onSelectURL: onSelectURL,
    onError: onUploadError
  })), !multiImageSelection && externalBlob && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    onClick: uploadExternal,
    icon: library_upload,
    label: (0,external_wp_i18n_namespaceObject.__)('Upload external image')
  }))), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    label: (0,external_wp_i18n_namespaceObject.__)('Settings'),
    resetAll: () => setAttributes({
      width: undefined,
      height: undefined,
      scale: undefined,
      aspectRatio: undefined
    })
  }, !multiImageSelection && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    label: (0,external_wp_i18n_namespaceObject.__)('Alternative text'),
    isShownByDefault: true,
    hasValue: () => alt !== '',
    onDeselect: () => setAttributes({
      alt: undefined
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextareaControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Alternative text'),
    value: alt,
    onChange: updateAlt,
    help: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
      href: "https://www.w3.org/WAI/tutorials/images/decision-tree"
    }, (0,external_wp_i18n_namespaceObject.__)('Describe the purpose of the image.')), (0,external_wp_element_namespaceObject.createElement)("br", null), (0,external_wp_i18n_namespaceObject.__)('Leave empty if decorative.')),
    __nextHasNoMarginBottom: true
  })), isResizable && (0,external_wp_element_namespaceObject.createElement)(DimensionsTool, {
    value: {
      width,
      height,
      scale,
      aspectRatio
    },
    onChange: newValue => {
      // Rebuilding the object forces setting `undefined`
      // for values that are removed since setAttributes
      // doesn't do anything with keys that aren't set.
      setAttributes({
        width: newValue.width,
        height: newValue.height,
        scale: newValue.scale,
        aspectRatio: newValue.aspectRatio
      });
    },
    defaultScale: "cover",
    defaultAspectRatio: "auto",
    scaleOptions: scaleOptions,
    unitsOptions: dimensionsUnitsOptions
  }), (0,external_wp_element_namespaceObject.createElement)(ResolutionTool, {
    value: sizeSlug,
    onChange: updateImage,
    options: imageSizeOptions
  }))), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, {
    group: "advanced"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Title attribute'),
    value: title || '',
    onChange: onSetTitle,
    help: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_i18n_namespaceObject.__)('Describe the role of this image on the page.'), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
      href: "https://www.w3.org/TR/html52/dom.html#the-title-attribute"
    }, (0,external_wp_i18n_namespaceObject.__)('(Note: many devices and browsers do not display this text.)')))
  })));
  const filename = (0,external_wp_url_namespaceObject.getFilename)(url);
  let defaultedAlt;

  if (alt) {
    defaultedAlt = alt;
  } else if (filename) {
    defaultedAlt = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: file name */
    (0,external_wp_i18n_namespaceObject.__)('This image has an empty alt attribute; its file name is %s'), filename);
  } else {
    defaultedAlt = (0,external_wp_i18n_namespaceObject.__)('This image has an empty alt attribute');
  }

  const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalUseBorderProps)(attributes);
  const isRounded = attributes.className?.includes('is-style-rounded');
  let img = // Disable reason: Image itself is not meant to be interactive, but
  // should direct focus to block.

  /* eslint-disable jsx-a11y/no-noninteractive-element-interactions, jsx-a11y/click-events-have-key-events */
  (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("img", {
    src: temporaryURL || url,
    alt: defaultedAlt,
    onError: () => onImageError(),
    onLoad: event => {
      setLoadedNaturalSize({
        loadedNaturalWidth: event.target?.naturalWidth,
        loadedNaturalHeight: event.target?.naturalHeight
      });
    },
    ref: imageRef,
    className: borderProps.className,
    style: {
      width: width && height || aspectRatio ? '100%' : undefined,
      height: width && height || aspectRatio ? '100%' : undefined,
      objectFit: scale,
      ...borderProps.style
    }
  }), temporaryURL && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null))
  /* eslint-enable jsx-a11y/no-noninteractive-element-interactions, jsx-a11y/click-events-have-key-events */
  ; // clientWidth needs to be a number for the image Cropper to work, but sometimes it's 0
  // So we try using the imageRef width first and fallback to clientWidth.

  const fallbackClientWidth = imageRef.current?.width || clientWidth;

  if (canEditImage && isEditingImage) {
    img = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalImageEditor, {
      id: id,
      url: url,
      width: numericWidth,
      height: numericHeight,
      clientWidth: fallbackClientWidth,
      naturalHeight: naturalHeight,
      naturalWidth: naturalWidth,
      onSaveImage: imageAttributes => setAttributes(imageAttributes),
      onFinishEditing: () => {
        setIsEditingImage(false);
      },
      borderProps: isRounded ? undefined : borderProps
    });
  } else if (!isResizable) {
    img = (0,external_wp_element_namespaceObject.createElement)("div", {
      style: {
        width,
        height,
        aspectRatio
      }
    }, img);
  } else {
    const numericRatio = aspectRatio && evalAspectRatio(aspectRatio);
    const customRatio = numericWidth / numericHeight;
    const ratio = numericRatio || customRatio || naturalWidth / naturalHeight || 1;
    const currentWidth = !numericWidth && numericHeight ? numericHeight * ratio : numericWidth;
    const currentHeight = !numericHeight && numericWidth ? numericWidth / ratio : numericHeight;
    const minWidth = naturalWidth < naturalHeight ? constants_MIN_SIZE : constants_MIN_SIZE * ratio;
    const minHeight = naturalHeight < naturalWidth ? constants_MIN_SIZE : constants_MIN_SIZE / ratio; // With the current implementation of ResizableBox, an image needs an
    // explicit pixel value for the max-width. In absence of being able to
    // set the content-width, this max-width is currently dictated by the
    // vanilla editor style. The following variable adds a buffer to this
    // vanilla style, so 3rd party themes have some wiggleroom. This does,
    // in most cases, allow you to scale the image beyond the width of the
    // main column, though not infinitely.
    // @todo It would be good to revisit this once a content-width variable
    // becomes available.

    const maxWidthBuffer = maxWidth * 2.5;
    let showRightHandle = false;
    let showLeftHandle = false;
    /* eslint-disable no-lonely-if */
    // See https://github.com/WordPress/gutenberg/issues/7584.

    if (align === 'center') {
      // When the image is centered, show both handles.
      showRightHandle = true;
      showLeftHandle = true;
    } else if ((0,external_wp_i18n_namespaceObject.isRTL)()) {
      // In RTL mode the image is on the right by default.
      // Show the right handle and hide the left handle only when it is
      // aligned left. Otherwise always show the left handle.
      if (align === 'left') {
        showRightHandle = true;
      } else {
        showLeftHandle = true;
      }
    } else {
      // Show the left handle and hide the right handle only when the
      // image is aligned right. Otherwise always show the right handle.
      if (align === 'right') {
        showLeftHandle = true;
      } else {
        showRightHandle = true;
      }
    }
    /* eslint-enable no-lonely-if */


    img = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ResizableBox, {
      style: {
        display: 'block',
        objectFit: scale,
        aspectRatio: !width && !height && aspectRatio ? aspectRatio : undefined
      },
      size: {
        width: currentWidth !== null && currentWidth !== void 0 ? currentWidth : 'auto',
        height: currentHeight !== null && currentHeight !== void 0 ? currentHeight : 'auto'
      },
      showHandle: isSelected,
      minWidth: minWidth,
      maxWidth: maxWidthBuffer,
      minHeight: minHeight,
      maxHeight: maxWidthBuffer / ratio,
      lockAspectRatio: ratio,
      enable: {
        top: false,
        right: showRightHandle,
        bottom: true,
        left: showLeftHandle
      },
      onResizeStart: onResizeStart,
      onResizeStop: (event, direction, elt) => {
        onResizeStop(); // Since the aspect ratio is locked when resizing, we can
        // use the width of the resized element to calculate the
        // height in CSS to prevent stretching when the max-width
        // is reached.

        setAttributes({
          width: `${elt.offsetWidth}px`,
          height: 'auto',
          aspectRatio: `${ratio}`
        });
      },
      resizeRatio: align === 'center' ? 2 : 1
    }, img);
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, !temporaryURL && controls, img, showCaption && (!external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) || isSelected) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    identifier: "caption",
    className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
    ref: captionRef,
    tagName: "figcaption",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Image caption text'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Add caption'),
    value: caption,
    onChange: value => setAttributes({
      caption: value
    }),
    inlineToolbar: true,
    __unstableOnSplitAtEnd: () => insertBlocksAfter((0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()))
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */



/**
 * Module constants
 */


const {
  useBlockEditingMode
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
const edit_pickRelevantMediaFiles = (image, size) => {
  const imageProps = Object.fromEntries(Object.entries(image !== null && image !== void 0 ? image : {}).filter(([key]) => ['alt', 'id', 'link', 'caption'].includes(key)));
  imageProps.url = image?.sizes?.[size]?.url || image?.media_details?.sizes?.[size]?.source_url || image.url;
  return imageProps;
};
/**
 * Is the URL a temporary blob URL? A blob URL is one that is used temporarily
 * while the image is being uploaded and will not have an id yet allocated.
 *
 * @param {number=} id  The id of the image.
 * @param {string=} url The url of the image.
 *
 * @return {boolean} Is the URL a Blob URL
 */

const edit_isTemporaryImage = (id, url) => !id && (0,external_wp_blob_namespaceObject.isBlobURL)(url);
/**
 * Is the url for the image hosted externally. An externally hosted image has no
 * id and is not a blob url.
 *
 * @param {number=} id  The id of the image.
 * @param {string=} url The url of the image.
 *
 * @return {boolean} Is the url an externally hosted url?
 */


const isExternalImage = (id, url) => url && !id && !(0,external_wp_blob_namespaceObject.isBlobURL)(url);
/**
 * Checks if WP generated default image size. Size generation is skipped
 * when the image is smaller than the said size.
 *
 * @param {Object} image
 * @param {string} defaultSize
 *
 * @return {boolean} Whether or not it has default image size.
 */

function hasDefaultSize(image, defaultSize) {
  var _image$sizes$defaultS, _image$media_details$;

  return 'url' in ((_image$sizes$defaultS = image?.sizes?.[defaultSize]) !== null && _image$sizes$defaultS !== void 0 ? _image$sizes$defaultS : {}) || 'source_url' in ((_image$media_details$ = image?.media_details?.sizes?.[defaultSize]) !== null && _image$media_details$ !== void 0 ? _image$media_details$ : {});
}

function ImageEdit({
  attributes,
  setAttributes,
  isSelected,
  className,
  insertBlocksAfter,
  onReplace,
  context,
  clientId
}) {
  const {
    url = '',
    alt,
    caption,
    align,
    id,
    width,
    height,
    sizeSlug
  } = attributes;
  const [temporaryURL, setTemporaryURL] = (0,external_wp_element_namespaceObject.useState)();
  const altRef = (0,external_wp_element_namespaceObject.useRef)();
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    altRef.current = alt;
  }, [alt]);
  const captionRef = (0,external_wp_element_namespaceObject.useRef)();
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    captionRef.current = caption;
  }, [caption]);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const {
    imageDefaultSize,
    mediaUpload
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const settings = getSettings();
    return {
      imageDefaultSize: settings.imageDefaultSize,
      mediaUpload: settings.mediaUpload
    };
  }, []);
  const blockEditingMode = useBlockEditingMode();
  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);

  function onUploadError(message) {
    createErrorNotice(message, {
      type: 'snackbar'
    });
    setAttributes({
      src: undefined,
      id: undefined,
      url: undefined
    });
    setTemporaryURL(undefined);
  }

  function onSelectImage(media) {
    if (!media || !media.url) {
      setAttributes({
        url: undefined,
        alt: undefined,
        id: undefined,
        title: undefined,
        caption: undefined
      });
      return;
    }

    if ((0,external_wp_blob_namespaceObject.isBlobURL)(media.url)) {
      setTemporaryURL(media.url);
      return;
    }

    setTemporaryURL();
    let mediaAttributes = edit_pickRelevantMediaFiles(media, imageDefaultSize); // If a caption text was meanwhile written by the user,
    // make sure the text is not overwritten by empty captions.

    if (captionRef.current && !mediaAttributes.caption) {
      const {
        caption: omittedCaption,
        ...restMediaAttributes
      } = mediaAttributes;
      mediaAttributes = restMediaAttributes;
    }

    let additionalAttributes; // Reset the dimension attributes if changing to a different image.

    if (!media.id || media.id !== id) {
      additionalAttributes = {
        // Fallback to size "full" if there's no default image size.
        // It means the image is smaller, and the block will use a full-size URL.
        sizeSlug: hasDefaultSize(media, imageDefaultSize) ? imageDefaultSize : 'full'
      };
    } else {
      // Keep the same url when selecting the same file, so "Resolution"
      // option is not changed.
      additionalAttributes = {
        url
      };
    } // Check if default link setting should be used.


    let linkDestination = attributes.linkDestination;

    if (!linkDestination) {
      // Use the WordPress option to determine the proper default.
      // The constants used in Gutenberg do not match WP options so a little more complicated than ideal.
      // TODO: fix this in a follow up PR, requires updating media-text and ui component.
      switch (window?.wp?.media?.view?.settings?.defaultProps?.link || constants_LINK_DESTINATION_NONE) {
        case 'file':
        case constants_LINK_DESTINATION_MEDIA:
          linkDestination = constants_LINK_DESTINATION_MEDIA;
          break;

        case 'post':
        case constants_LINK_DESTINATION_ATTACHMENT:
          linkDestination = constants_LINK_DESTINATION_ATTACHMENT;
          break;

        case LINK_DESTINATION_CUSTOM:
          linkDestination = LINK_DESTINATION_CUSTOM;
          break;

        case constants_LINK_DESTINATION_NONE:
          linkDestination = constants_LINK_DESTINATION_NONE;
          break;
      }
    } // Check if the image is linked to it's media.


    let href;

    switch (linkDestination) {
      case constants_LINK_DESTINATION_MEDIA:
        href = media.url;
        break;

      case constants_LINK_DESTINATION_ATTACHMENT:
        href = media.link;
        break;
    }

    mediaAttributes.href = href;
    setAttributes({ ...mediaAttributes,
      ...additionalAttributes,
      linkDestination
    });
  }

  function onSelectURL(newURL) {
    if (newURL !== url) {
      setAttributes({
        url: newURL,
        id: undefined,
        sizeSlug: imageDefaultSize
      });
    }
  }

  function updateAlignment(nextAlign) {
    const extraUpdatedAttributes = ['wide', 'full'].includes(nextAlign) ? {
      width: undefined,
      height: undefined
    } : {};
    setAttributes({ ...extraUpdatedAttributes,
      align: nextAlign
    });
  }

  let isTemp = edit_isTemporaryImage(id, url); // Upload a temporary image on mount.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isTemp) {
      return;
    }

    const file = (0,external_wp_blob_namespaceObject.getBlobByURL)(url);

    if (file) {
      mediaUpload({
        filesList: [file],
        onFileChange: ([img]) => {
          onSelectImage(img);
        },
        allowedTypes: constants_ALLOWED_MEDIA_TYPES,
        onError: message => {
          isTemp = false;
          onUploadError(message);
        }
      });
    }
  }, []); // If an image is temporary, revoke the Blob url when it is uploaded (and is
  // no longer temporary).

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (isTemp) {
      setTemporaryURL(url);
      return;
    }

    (0,external_wp_blob_namespaceObject.revokeBlobURL)(temporaryURL);
  }, [isTemp, url]);
  const isExternal = isExternalImage(id, url);
  const src = isExternal ? url : undefined;
  const mediaPreview = !!url && (0,external_wp_element_namespaceObject.createElement)("img", {
    alt: (0,external_wp_i18n_namespaceObject.__)('Edit image'),
    title: (0,external_wp_i18n_namespaceObject.__)('Edit image'),
    className: 'edit-image-preview',
    src: url
  });
  const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalUseBorderProps)(attributes);
  const classes = classnames_default()(className, {
    'is-transient': temporaryURL,
    'is-resized': !!width || !!height,
    [`size-${sizeSlug}`]: sizeSlug,
    'has-custom-border': !!borderProps.className || borderProps.style && Object.keys(borderProps.style).length > 0
  });
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    ref,
    className: classes
  }); // Much of this description is duplicated from MediaPlaceholder.

  const placeholder = content => {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
      className: classnames_default()('block-editor-media-placeholder', {
        [borderProps.className]: !!borderProps.className && !isSelected
      }),
      withIllustration: true,
      icon: library_image,
      label: (0,external_wp_i18n_namespaceObject.__)('Image'),
      instructions: (0,external_wp_i18n_namespaceObject.__)('Upload an image file, pick one from your media library, or add one with a URL.'),
      style: isSelected ? undefined : borderProps.style
    }, content);
  };

  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...blockProps
  }, (temporaryURL || url) && (0,external_wp_element_namespaceObject.createElement)(image_Image, {
    temporaryURL: temporaryURL,
    attributes: attributes,
    setAttributes: setAttributes,
    isSelected: isSelected,
    insertBlocksAfter: insertBlocksAfter,
    onReplace: onReplace,
    onSelectImage: onSelectImage,
    onSelectURL: onSelectURL,
    onUploadError: onUploadError,
    containerRef: ref,
    context: context,
    clientId: clientId,
    blockEditingMode: blockEditingMode
  }), !url && blockEditingMode === 'default' && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockAlignmentControl, {
    value: align,
    onChange: updateAlignment
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
    icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
      icon: library_image
    }),
    onSelect: onSelectImage,
    onSelectURL: onSelectURL,
    onError: onUploadError,
    placeholder: placeholder,
    accept: "image/*",
    allowedTypes: constants_ALLOWED_MEDIA_TYPES,
    value: {
      id,
      src
    },
    mediaPreview: mediaPreview,
    disableMediaButtons: temporaryURL || url
  }));
}
/* harmony default export */ var image_edit = (ImageEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


function image_save_save({
  attributes
}) {
  const {
    url,
    alt,
    caption,
    align,
    href,
    rel,
    linkClass,
    width,
    height,
    aspectRatio,
    scale,
    id,
    linkTarget,
    sizeSlug,
    title
  } = attributes;
  const newRel = !rel ? undefined : rel;
  const borderProps = (0,external_wp_blockEditor_namespaceObject.__experimentalGetBorderClassesAndStyles)(attributes);
  const classes = classnames_default()({
    [`align${align}`]: align,
    [`size-${sizeSlug}`]: sizeSlug,
    'is-resized': width || height,
    'has-custom-border': !!borderProps.className || borderProps.style && Object.keys(borderProps.style).length > 0
  });
  const imageClasses = classnames_default()(borderProps.className, {
    [`wp-image-${id}`]: !!id
  });
  const image = (0,external_wp_element_namespaceObject.createElement)("img", {
    src: url,
    alt: alt,
    className: imageClasses || undefined,
    style: { ...borderProps.style,
      aspectRatio,
      objectFit: scale,
      width,
      height
    },
    title: title
  });
  const figure = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, href ? (0,external_wp_element_namespaceObject.createElement)("a", {
    className: linkClass,
    href: href,
    target: linkTarget,
    rel: newRel
  }, image) : image, !external_wp_blockEditor_namespaceObject.RichText.isEmpty(caption) && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    className: (0,external_wp_blockEditor_namespaceObject.__experimentalGetElementClassName)('caption'),
    tagName: "figcaption",
    value: caption
  }));
  return (0,external_wp_element_namespaceObject.createElement)("figure", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className: classes
    })
  }, figure);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/transforms.js
/**
 * WordPress dependencies
 */





function stripFirstImage(attributes, {
  shortcode
}) {
  const {
    body
  } = document.implementation.createHTMLDocument('');
  body.innerHTML = shortcode.content;
  let nodeToRemove = body.querySelector('img'); // If an image has parents, find the topmost node to remove.

  while (nodeToRemove && nodeToRemove.parentNode && nodeToRemove.parentNode !== body) {
    nodeToRemove = nodeToRemove.parentNode;
  }

  if (nodeToRemove) {
    nodeToRemove.parentNode.removeChild(nodeToRemove);
  }

  return body.innerHTML.trim();
}

function getFirstAnchorAttributeFormHTML(html, attributeName) {
  const {
    body
  } = document.implementation.createHTMLDocument('');
  body.innerHTML = html;
  const {
    firstElementChild
  } = body;

  if (firstElementChild && firstElementChild.nodeName === 'A') {
    return firstElementChild.getAttribute(attributeName) || undefined;
  }
}

const imageSchema = {
  img: {
    attributes: ['src', 'alt', 'title'],
    classes: ['alignleft', 'aligncenter', 'alignright', 'alignnone', /^wp-image-\d+$/]
  }
};

const schema = ({
  phrasingContentSchema
}) => ({
  figure: {
    require: ['img'],
    children: { ...imageSchema,
      a: {
        attributes: ['href', 'rel', 'target'],
        children: imageSchema
      },
      figcaption: {
        children: phrasingContentSchema
      }
    }
  }
});

const image_transforms_transforms = {
  from: [{
    type: 'raw',
    isMatch: node => node.nodeName === 'FIGURE' && !!node.querySelector('img'),
    schema,
    transform: node => {
      // Search both figure and image classes. Alignment could be
      // set on either. ID is set on the image.
      const className = node.className + ' ' + node.querySelector('img').className;
      const alignMatches = /(?:^|\s)align(left|center|right)(?:$|\s)/.exec(className);
      const anchor = node.id === '' ? undefined : node.id;
      const align = alignMatches ? alignMatches[1] : undefined;
      const idMatches = /(?:^|\s)wp-image-(\d+)(?:$|\s)/.exec(className);
      const id = idMatches ? Number(idMatches[1]) : undefined;
      const anchorElement = node.querySelector('a');
      const linkDestination = anchorElement && anchorElement.href ? 'custom' : undefined;
      const href = anchorElement && anchorElement.href ? anchorElement.href : undefined;
      const rel = anchorElement && anchorElement.rel ? anchorElement.rel : undefined;
      const linkClass = anchorElement && anchorElement.className ? anchorElement.className : undefined;
      const attributes = (0,external_wp_blocks_namespaceObject.getBlockAttributes)('core/image', node.outerHTML, {
        align,
        id,
        linkDestination,
        href,
        rel,
        linkClass,
        anchor
      });
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', attributes);
    }
  }, {
    // Note: when dragging and dropping multiple files onto a gallery this overrides the
    // gallery transform in order to add new images to the gallery instead of
    // creating a new gallery.
    type: 'files',

    isMatch(files) {
      // The following check is intended to catch non-image files when dropped together with images.
      if (files.some(file => file.type.indexOf('image/') === 0) && files.some(file => file.type.indexOf('image/') !== 0)) {
        const {
          createErrorNotice
        } = (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store);
        createErrorNotice((0,external_wp_i18n_namespaceObject.__)('If uploading to a gallery all files need to be image formats'), {
          id: 'gallery-transform-invalid-file',
          type: 'snackbar'
        });
      }

      return files.every(file => file.type.indexOf('image/') === 0);
    },

    transform(files) {
      const blocks = files.map(file => {
        return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
          url: (0,external_wp_blob_namespaceObject.createBlobURL)(file)
        });
      });
      return blocks;
    }

  }, {
    type: 'shortcode',
    tag: 'caption',
    attributes: {
      url: {
        type: 'string',
        source: 'attribute',
        attribute: 'src',
        selector: 'img'
      },
      alt: {
        type: 'string',
        source: 'attribute',
        attribute: 'alt',
        selector: 'img'
      },
      caption: {
        shortcode: stripFirstImage
      },
      href: {
        shortcode: (attributes, {
          shortcode
        }) => {
          return getFirstAnchorAttributeFormHTML(shortcode.content, 'href');
        }
      },
      rel: {
        shortcode: (attributes, {
          shortcode
        }) => {
          return getFirstAnchorAttributeFormHTML(shortcode.content, 'rel');
        }
      },
      linkClass: {
        shortcode: (attributes, {
          shortcode
        }) => {
          return getFirstAnchorAttributeFormHTML(shortcode.content, 'class');
        }
      },
      id: {
        type: 'number',
        shortcode: ({
          named: {
            id
          }
        }) => {
          if (!id) {
            return;
          }

          return parseInt(id.replace('attachment_', ''), 10);
        }
      },
      align: {
        type: 'string',
        shortcode: ({
          named: {
            align = 'alignnone'
          }
        }) => {
          return align.replace('align', '');
        }
      }
    }
  }]
};
/* harmony default export */ var image_transforms = (image_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/image/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const image_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/image",
  title: "Image",
  category: "media",
  usesContext: ["allowResize", "imageCrop", "fixedHeight"],
  description: "Insert an image to make a visual statement.",
  keywords: ["img", "photo", "picture"],
  textdomain: "default",
  attributes: {
    align: {
      type: "string"
    },
    url: {
      type: "string",
      source: "attribute",
      selector: "img",
      attribute: "src",
      __experimentalRole: "content"
    },
    alt: {
      type: "string",
      source: "attribute",
      selector: "img",
      attribute: "alt",
      "default": "",
      __experimentalRole: "content"
    },
    caption: {
      type: "string",
      source: "html",
      selector: "figcaption",
      __experimentalRole: "content"
    },
    title: {
      type: "string",
      source: "attribute",
      selector: "img",
      attribute: "title",
      __experimentalRole: "content"
    },
    href: {
      type: "string",
      source: "attribute",
      selector: "figure > a",
      attribute: "href",
      __experimentalRole: "content"
    },
    rel: {
      type: "string",
      source: "attribute",
      selector: "figure > a",
      attribute: "rel"
    },
    linkClass: {
      type: "string",
      source: "attribute",
      selector: "figure > a",
      attribute: "class"
    },
    id: {
      type: "number",
      __experimentalRole: "content"
    },
    width: {
      type: "string"
    },
    height: {
      type: "string"
    },
    aspectRatio: {
      type: "string"
    },
    scale: {
      type: "string"
    },
    sizeSlug: {
      type: "string"
    },
    linkDestination: {
      type: "string"
    },
    linkTarget: {
      type: "string",
      source: "attribute",
      selector: "figure > a",
      attribute: "target"
    }
  },
  supports: {
    anchor: true,
    behaviors: {
      lightbox: true
    },
    color: {
      text: false,
      background: false
    },
    filter: {
      duotone: true
    },
    __experimentalBorder: {
      color: true,
      radius: true,
      width: true,
      __experimentalSkipSerialization: true,
      __experimentalDefaultControls: {
        color: true,
        radius: true,
        width: true
      }
    }
  },
  selectors: {
    border: ".wp-block-image img, .wp-block-image .wp-block-image__crop-area, .wp-block-image .components-placeholder",
    filter: {
      duotone: ".wp-block-image img, .wp-block-image .components-placeholder"
    }
  },
  styles: [{
    name: "default",
    label: "Default",
    isDefault: true
  }, {
    name: "rounded",
    label: "Rounded"
  }],
  editorStyle: "wp-block-image-editor",
  style: "wp-block-image"
};


const {
  name: image_name
} = image_metadata;

const image_settings = {
  icon: library_image,
  example: {
    attributes: {
      sizeSlug: 'large',
      url: 'https://s.w.org/images/core/5.3/MtBlanc1.jpg',
      // translators: Caption accompanying an image of the Mont Blanc, which serves as an example for the Image block.
      caption: (0,external_wp_i18n_namespaceObject.__)('Mont Blanc appears—still, snowy, and serene.')
    }
  },

  __experimentalLabel(attributes, {
    context
  }) {
    if (context === 'accessibility') {
      const {
        caption,
        alt,
        url
      } = attributes;

      if (!url) {
        return (0,external_wp_i18n_namespaceObject.__)('Empty');
      }

      if (!alt) {
        return caption || '';
      } // This is intended to be read by a screen reader.
      // A period simply means a pause, no need to translate it.


      return alt + (caption ? '. ' + caption : '');
    }
  },

  getEditWrapperProps(attributes) {
    return {
      'data-align': attributes.align
    };
  },

  transforms: image_transforms,
  edit: image_edit,
  save: image_save_save,
  deprecated: image_deprecated
};
const image_init = () => initBlock({
  name: image_name,
  metadata: image_metadata,
  settings: image_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/comment.js


/**
 * WordPress dependencies
 */

const comment = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 4H6c-1.1 0-2 .9-2 2v12.9c0 .6.5 1.1 1.1 1.1.3 0 .5-.1.8-.3L8.5 17H18c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm.5 11c0 .3-.2.5-.5.5H7.9l-2.4 2.4V6c0-.3.2-.5.5-.5h12c.3 0 .5.2.5.5v9z"
}));
/* harmony default export */ var library_comment = (comment);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/latest-comments/edit.js


/**
 * WordPress dependencies
 */




/**
 * Minimum number of comments a user can show using this block.
 *
 * @type {number}
 */

const MIN_COMMENTS = 1;
/**
 * Maximum number of comments a user can show using this block.
 *
 * @type {number}
 */

const MAX_COMMENTS = 100;
function LatestComments({
  attributes,
  setAttributes
}) {
  const {
    commentsToShow,
    displayAvatar,
    displayDate,
    displayExcerpt
  } = attributes;
  const serverSideAttributes = { ...attributes,
    style: { ...attributes?.style,
      spacing: undefined
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)()
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display avatar'),
    checked: displayAvatar,
    onChange: () => setAttributes({
      displayAvatar: !displayAvatar
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display date'),
    checked: displayDate,
    onChange: () => setAttributes({
      displayDate: !displayDate
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display excerpt'),
    checked: displayExcerpt,
    onChange: () => setAttributes({
      displayExcerpt: !displayExcerpt
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Number of comments'),
    value: commentsToShow,
    onChange: value => setAttributes({
      commentsToShow: value
    }),
    min: MIN_COMMENTS,
    max: MAX_COMMENTS,
    required: true
  }))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, null, (0,external_wp_element_namespaceObject.createElement)((external_wp_serverSideRender_default()), {
    block: "core/latest-comments",
    attributes: serverSideAttributes // The preview uses the site's locale to make it more true to how
    // the block appears on the frontend. Setting the locale
    // explicitly prevents any middleware from setting it to 'user'.
    ,
    urlQueryArgs: {
      _locale: 'site'
    }
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/latest-comments/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const latest_comments_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/latest-comments",
  title: "Latest Comments",
  category: "widgets",
  description: "Display a list of your most recent comments.",
  keywords: ["recent comments"],
  textdomain: "default",
  attributes: {
    commentsToShow: {
      type: "number",
      "default": 5,
      minimum: 1,
      maximum: 100
    },
    displayAvatar: {
      type: "boolean",
      "default": true
    },
    displayDate: {
      type: "boolean",
      "default": true
    },
    displayExcerpt: {
      type: "boolean",
      "default": true
    }
  },
  supports: {
    align: true,
    html: false,
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-latest-comments-editor",
  style: "wp-block-latest-comments"
};

const {
  name: latest_comments_name
} = latest_comments_metadata;

const latest_comments_settings = {
  icon: library_comment,
  example: {},
  edit: LatestComments
};
const latest_comments_init = () => initBlock({
  name: latest_comments_name,
  metadata: latest_comments_metadata,
  settings: latest_comments_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/post-list.js


/**
 * WordPress dependencies
 */

const postList = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm.5 14c0 .3-.2.5-.5.5H6c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h12c.3 0 .5.2.5.5v12zM7 11h2V9H7v2zm0 4h2v-2H7v2zm3-4h7V9h-7v2zm0 4h7v-2h-7v2z"
}));
/* harmony default export */ var post_list = (postList);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/latest-posts/deprecated.js
/**
 * Internal dependencies
 */
const latest_posts_deprecated_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/latest-posts",
  title: "Latest Posts",
  category: "widgets",
  description: "Display a list of your most recent posts.",
  keywords: ["recent posts"],
  textdomain: "default",
  attributes: {
    categories: {
      type: "array",
      items: {
        type: "object"
      }
    },
    selectedAuthor: {
      type: "number"
    },
    postsToShow: {
      type: "number",
      "default": 5
    },
    displayPostContent: {
      type: "boolean",
      "default": false
    },
    displayPostContentRadio: {
      type: "string",
      "default": "excerpt"
    },
    excerptLength: {
      type: "number",
      "default": 55
    },
    displayAuthor: {
      type: "boolean",
      "default": false
    },
    displayPostDate: {
      type: "boolean",
      "default": false
    },
    postLayout: {
      type: "string",
      "default": "list"
    },
    columns: {
      type: "number",
      "default": 3
    },
    order: {
      type: "string",
      "default": "desc"
    },
    orderBy: {
      type: "string",
      "default": "date"
    },
    displayFeaturedImage: {
      type: "boolean",
      "default": false
    },
    featuredImageAlign: {
      type: "string",
      "enum": ["left", "center", "right"]
    },
    featuredImageSizeSlug: {
      type: "string",
      "default": "thumbnail"
    },
    featuredImageSizeWidth: {
      type: "number",
      "default": null
    },
    featuredImageSizeHeight: {
      type: "number",
      "default": null
    },
    addLinkToFeaturedImage: {
      type: "boolean",
      "default": false
    }
  },
  supports: {
    align: true,
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-latest-posts-editor",
  style: "wp-block-latest-posts"
};
const {
  attributes: deprecated_attributes
} = latest_posts_deprecated_metadata;
/* harmony default export */ var latest_posts_deprecated = ([{
  attributes: { ...deprecated_attributes,
    categories: {
      type: 'string'
    }
  },
  supports: {
    align: true,
    html: false
  },
  migrate: oldAttributes => {
    // This needs the full category object, not just the ID.
    return { ...oldAttributes,
      categories: [{
        id: Number(oldAttributes.categories)
      }]
    };
  },
  isEligible: ({
    categories
  }) => categories && 'string' === typeof categories,
  save: () => null
}]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/list.js


/**
 * WordPress dependencies
 */

const list = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 4v1.5h16V4H4zm8 8.5h8V11h-8v1.5zM4 20h16v-1.5H4V20zm4-8c0-1.1-.9-2-2-2s-2 .9-2 2 .9 2 2 2 2-.9 2-2z"
}));
/* harmony default export */ var library_list = (list);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/latest-posts/constants.js
const MIN_EXCERPT_LENGTH = 10;
const MAX_EXCERPT_LENGTH = 100;
const MAX_POSTS_COLUMNS = 6;

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/latest-posts/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */


/**
 * Module Constants
 */

const CATEGORIES_LIST_QUERY = {
  per_page: -1,
  context: 'view'
};
const USERS_LIST_QUERY = {
  per_page: -1,
  has_published_posts: ['post'],
  context: 'view'
};

function getFeaturedImageDetails(post, size) {
  var _image$media_details$;

  const image = post._embedded?.['wp:featuredmedia']?.['0'];
  return {
    url: (_image$media_details$ = image?.media_details?.sizes?.[size]?.source_url) !== null && _image$media_details$ !== void 0 ? _image$media_details$ : image?.source_url,
    alt: image?.alt_text
  };
}

function LatestPostsEdit({
  attributes,
  setAttributes
}) {
  var _categoriesList$reduc;

  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(LatestPostsEdit);
  const {
    postsToShow,
    order,
    orderBy,
    categories,
    selectedAuthor,
    displayFeaturedImage,
    displayPostContentRadio,
    displayPostContent,
    displayPostDate,
    displayAuthor,
    postLayout,
    columns,
    excerptLength,
    featuredImageAlign,
    featuredImageSizeSlug,
    featuredImageSizeWidth,
    featuredImageSizeHeight,
    addLinkToFeaturedImage
  } = attributes;
  const {
    imageSizes,
    latestPosts,
    defaultImageWidth,
    defaultImageHeight,
    categoriesList,
    authorList
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _settings$imageDimens, _settings$imageDimens2;

    const {
      getEntityRecords,
      getUsers
    } = select(external_wp_coreData_namespaceObject.store);
    const settings = select(external_wp_blockEditor_namespaceObject.store).getSettings();
    const catIds = categories && categories.length > 0 ? categories.map(cat => cat.id) : [];
    const latestPostsQuery = Object.fromEntries(Object.entries({
      categories: catIds,
      author: selectedAuthor,
      order,
      orderby: orderBy,
      per_page: postsToShow,
      _embed: 'wp:featuredmedia'
    }).filter(([, value]) => typeof value !== 'undefined'));
    return {
      defaultImageWidth: (_settings$imageDimens = settings.imageDimensions?.[featuredImageSizeSlug]?.width) !== null && _settings$imageDimens !== void 0 ? _settings$imageDimens : 0,
      defaultImageHeight: (_settings$imageDimens2 = settings.imageDimensions?.[featuredImageSizeSlug]?.height) !== null && _settings$imageDimens2 !== void 0 ? _settings$imageDimens2 : 0,
      imageSizes: settings.imageSizes,
      latestPosts: getEntityRecords('postType', 'post', latestPostsQuery),
      categoriesList: getEntityRecords('taxonomy', 'category', CATEGORIES_LIST_QUERY),
      authorList: getUsers(USERS_LIST_QUERY)
    };
  }, [featuredImageSizeSlug, postsToShow, order, orderBy, categories, selectedAuthor]); // If a user clicks to a link prevent redirection and show a warning.

  const {
    createWarningNotice,
    removeNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  let noticeId;

  const showRedirectionPreventedNotice = event => {
    event.preventDefault(); // Remove previous warning if any, to show one at a time per block.

    removeNotice(noticeId);
    noticeId = `block-library/core/latest-posts/redirection-prevented/${instanceId}`;
    createWarningNotice((0,external_wp_i18n_namespaceObject.__)('Links are disabled in the editor.'), {
      id: noticeId,
      type: 'snackbar'
    });
  };

  const imageSizeOptions = imageSizes.filter(({
    slug
  }) => slug !== 'full').map(({
    name,
    slug
  }) => ({
    value: slug,
    label: name
  }));
  const categorySuggestions = (_categoriesList$reduc = categoriesList?.reduce((accumulator, category) => ({ ...accumulator,
    [category.name]: category
  }), {})) !== null && _categoriesList$reduc !== void 0 ? _categoriesList$reduc : {};

  const selectCategories = tokens => {
    const hasNoSuggestion = tokens.some(token => typeof token === 'string' && !categorySuggestions[token]);

    if (hasNoSuggestion) {
      return;
    } // Categories that are already will be objects, while new additions will be strings (the name).
    // allCategories nomalizes the array so that they are all objects.


    const allCategories = tokens.map(token => {
      return typeof token === 'string' ? categorySuggestions[token] : token;
    }); // We do nothing if the category is not selected
    // from suggestions.

    if (allCategories.includes(null)) {
      return false;
    }

    setAttributes({
      categories: allCategories
    });
  };

  const hasPosts = !!latestPosts?.length;
  const inspectorControls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Post content')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Post content'),
    checked: displayPostContent,
    onChange: value => setAttributes({
      displayPostContent: value
    })
  }), displayPostContent && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RadioControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Show:'),
    selected: displayPostContentRadio,
    options: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Excerpt'),
      value: 'excerpt'
    }, {
      label: (0,external_wp_i18n_namespaceObject.__)('Full post'),
      value: 'full_post'
    }],
    onChange: value => setAttributes({
      displayPostContentRadio: value
    })
  }), displayPostContent && displayPostContentRadio === 'excerpt' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Max number of words'),
    value: excerptLength,
    onChange: value => setAttributes({
      excerptLength: value
    }),
    min: MIN_EXCERPT_LENGTH,
    max: MAX_EXCERPT_LENGTH
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Post meta')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display author name'),
    checked: displayAuthor,
    onChange: value => setAttributes({
      displayAuthor: value
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display post date'),
    checked: displayPostDate,
    onChange: value => setAttributes({
      displayPostDate: value
    })
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Featured image')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display featured image'),
    checked: displayFeaturedImage,
    onChange: value => setAttributes({
      displayFeaturedImage: value
    })
  }), displayFeaturedImage && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalImageSizeControl, {
    onChange: value => {
      const newAttrs = {};

      if (value.hasOwnProperty('width')) {
        newAttrs.featuredImageSizeWidth = value.width;
      }

      if (value.hasOwnProperty('height')) {
        newAttrs.featuredImageSizeHeight = value.height;
      }

      setAttributes(newAttrs);
    },
    slug: featuredImageSizeSlug,
    width: featuredImageSizeWidth,
    height: featuredImageSizeHeight,
    imageWidth: defaultImageWidth,
    imageHeight: defaultImageHeight,
    imageSizeOptions: imageSizeOptions,
    imageSizeHelp: (0,external_wp_i18n_namespaceObject.__)('Select the size of the source image.'),
    onChangeImage: value => setAttributes({
      featuredImageSizeSlug: value,
      featuredImageSizeWidth: undefined,
      featuredImageSizeHeight: undefined
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl, {
    className: "editor-latest-posts-image-alignment-control"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, null, (0,external_wp_i18n_namespaceObject.__)('Image alignment')), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockAlignmentToolbar, {
    value: featuredImageAlign,
    onChange: value => setAttributes({
      featuredImageAlign: value
    }),
    controls: ['left', 'center', 'right'],
    isCollapsed: false
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Add link to featured image'),
    checked: addLinkToFeaturedImage,
    onChange: value => setAttributes({
      addLinkToFeaturedImage: value
    })
  }))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Sorting and filtering')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.QueryControls, {
    order,
    orderBy,
    numberOfItems: postsToShow,
    onOrderChange: value => setAttributes({
      order: value
    }),
    onOrderByChange: value => setAttributes({
      orderBy: value
    }),
    onNumberOfItemsChange: value => setAttributes({
      postsToShow: value
    }),
    categorySuggestions: categorySuggestions,
    onCategoryChange: selectCategories,
    selectedCategories: categories,
    onAuthorChange: value => setAttributes({
      selectedAuthor: '' !== value ? Number(value) : undefined
    }),
    authorList: authorList !== null && authorList !== void 0 ? authorList : [],
    selectedAuthorId: selectedAuthor
  }), postLayout === 'grid' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
    value: columns,
    onChange: value => setAttributes({
      columns: value
    }),
    min: 2,
    max: !hasPosts ? MAX_POSTS_COLUMNS : Math.min(MAX_POSTS_COLUMNS, latestPosts.length),
    required: true
  })));
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classnames_default()({
      'wp-block-latest-posts__list': true,
      'is-grid': postLayout === 'grid',
      'has-dates': displayPostDate,
      'has-author': displayAuthor,
      [`columns-${columns}`]: postLayout === 'grid'
    })
  });

  if (!hasPosts) {
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
    }, inspectorControls, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
      icon: library_pin,
      label: (0,external_wp_i18n_namespaceObject.__)('Latest Posts')
    }, !Array.isArray(latestPosts) ? (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null) : (0,external_wp_i18n_namespaceObject.__)('No posts found.')));
  } // Removing posts from display should be instant.


  const displayPosts = latestPosts.length > postsToShow ? latestPosts.slice(0, postsToShow) : latestPosts;
  const layoutControls = [{
    icon: library_list,
    title: (0,external_wp_i18n_namespaceObject.__)('List view'),
    onClick: () => setAttributes({
      postLayout: 'list'
    }),
    isActive: postLayout === 'list'
  }, {
    icon: library_grid,
    title: (0,external_wp_i18n_namespaceObject.__)('Grid view'),
    onClick: () => setAttributes({
      postLayout: 'grid'
    }),
    isActive: postLayout === 'grid'
  }];
  const dateFormat = (0,external_wp_date_namespaceObject.getSettings)().formats.date;
  return (0,external_wp_element_namespaceObject.createElement)("div", null, inspectorControls, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, {
    controls: layoutControls
  })), (0,external_wp_element_namespaceObject.createElement)("ul", { ...blockProps
  }, displayPosts.map(post => {
    const titleTrimmed = post.title.rendered.trim();
    let excerpt = post.excerpt.rendered;
    const currentAuthor = authorList?.find(author => author.id === post.author);
    const excerptElement = document.createElement('div');
    excerptElement.innerHTML = excerpt;
    excerpt = excerptElement.textContent || excerptElement.innerText || '';
    const {
      url: imageSourceUrl,
      alt: featuredImageAlt
    } = getFeaturedImageDetails(post, featuredImageSizeSlug);
    const imageClasses = classnames_default()({
      'wp-block-latest-posts__featured-image': true,
      [`align${featuredImageAlign}`]: !!featuredImageAlign
    });
    const renderFeaturedImage = displayFeaturedImage && imageSourceUrl;
    const featuredImage = renderFeaturedImage && (0,external_wp_element_namespaceObject.createElement)("img", {
      src: imageSourceUrl,
      alt: featuredImageAlt,
      style: {
        maxWidth: featuredImageSizeWidth,
        maxHeight: featuredImageSizeHeight
      }
    });
    const needsReadMore = excerptLength < excerpt.trim().split(' ').length && post.excerpt.raw === '';
    const postExcerpt = needsReadMore ? (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, excerpt.trim().split(' ', excerptLength).join(' '), (0,external_wp_element_namespaceObject.createInterpolateElement)(
    /* translators: excerpt truncation character, default …  */
    (0,external_wp_i18n_namespaceObject.__)(' … <a>Read more</a>'), {
      a: // eslint-disable-next-line jsx-a11y/anchor-has-content
      (0,external_wp_element_namespaceObject.createElement)("a", {
        href: post.link,
        rel: "noopener noreferrer",
        onClick: showRedirectionPreventedNotice
      })
    })) : excerpt;
    return (0,external_wp_element_namespaceObject.createElement)("li", {
      key: post.id
    }, renderFeaturedImage && (0,external_wp_element_namespaceObject.createElement)("div", {
      className: imageClasses
    }, addLinkToFeaturedImage ? (0,external_wp_element_namespaceObject.createElement)("a", {
      className: "wp-block-latest-posts__post-title",
      href: post.link,
      rel: "noreferrer noopener",
      onClick: showRedirectionPreventedNotice
    }, featuredImage) : featuredImage), (0,external_wp_element_namespaceObject.createElement)("a", {
      href: post.link,
      rel: "noreferrer noopener",
      dangerouslySetInnerHTML: !!titleTrimmed ? {
        __html: titleTrimmed
      } : undefined,
      onClick: showRedirectionPreventedNotice
    }, !titleTrimmed ? (0,external_wp_i18n_namespaceObject.__)('(no title)') : null), displayAuthor && currentAuthor && (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-latest-posts__post-author"
    }, (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: byline. %s: current author. */
    (0,external_wp_i18n_namespaceObject.__)('by %s'), currentAuthor.name)), displayPostDate && post.date_gmt && (0,external_wp_element_namespaceObject.createElement)("time", {
      dateTime: (0,external_wp_date_namespaceObject.format)('c', post.date_gmt),
      className: "wp-block-latest-posts__post-date"
    }, (0,external_wp_date_namespaceObject.dateI18n)(dateFormat, post.date_gmt)), displayPostContent && displayPostContentRadio === 'excerpt' && (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-latest-posts__post-excerpt"
    }, postExcerpt), displayPostContent && displayPostContentRadio === 'full_post' && (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-latest-posts__post-full-content",
      dangerouslySetInnerHTML: {
        __html: post.content.raw.trim()
      }
    }));
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/latest-posts/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const latest_posts_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/latest-posts",
  title: "Latest Posts",
  category: "widgets",
  description: "Display a list of your most recent posts.",
  keywords: ["recent posts"],
  textdomain: "default",
  attributes: {
    categories: {
      type: "array",
      items: {
        type: "object"
      }
    },
    selectedAuthor: {
      type: "number"
    },
    postsToShow: {
      type: "number",
      "default": 5
    },
    displayPostContent: {
      type: "boolean",
      "default": false
    },
    displayPostContentRadio: {
      type: "string",
      "default": "excerpt"
    },
    excerptLength: {
      type: "number",
      "default": 55
    },
    displayAuthor: {
      type: "boolean",
      "default": false
    },
    displayPostDate: {
      type: "boolean",
      "default": false
    },
    postLayout: {
      type: "string",
      "default": "list"
    },
    columns: {
      type: "number",
      "default": 3
    },
    order: {
      type: "string",
      "default": "desc"
    },
    orderBy: {
      type: "string",
      "default": "date"
    },
    displayFeaturedImage: {
      type: "boolean",
      "default": false
    },
    featuredImageAlign: {
      type: "string",
      "enum": ["left", "center", "right"]
    },
    featuredImageSizeSlug: {
      type: "string",
      "default": "thumbnail"
    },
    featuredImageSizeWidth: {
      type: "number",
      "default": null
    },
    featuredImageSizeHeight: {
      type: "number",
      "default": null
    },
    addLinkToFeaturedImage: {
      type: "boolean",
      "default": false
    }
  },
  supports: {
    align: true,
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true,
        link: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-latest-posts-editor",
  style: "wp-block-latest-posts"
};
const {
  name: latest_posts_name
} = latest_posts_metadata;

const latest_posts_settings = {
  icon: post_list,
  example: {},
  edit: LatestPostsEdit,
  deprecated: latest_posts_deprecated
};
const latest_posts_init = () => initBlock({
  name: latest_posts_name,
  metadata: latest_posts_metadata,
  settings: latest_posts_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/utils.js
/**
 * WordPress dependencies
 */

function createListBlockFromDOMElement(listElement) {
  var _listElement$getAttri;

  const listAttributes = {
    ordered: 'OL' === listElement.tagName,
    anchor: listElement.id === '' ? undefined : listElement.id,
    start: listElement.getAttribute('start') ? parseInt(listElement.getAttribute('start'), 10) : undefined,
    reversed: listElement.hasAttribute('reversed') ? true : undefined,
    type: (_listElement$getAttri = listElement.getAttribute('type')) !== null && _listElement$getAttri !== void 0 ? _listElement$getAttri : undefined
  };
  const innerBlocks = Array.from(listElement.children).map(listItem => {
    const children = Array.from(listItem.childNodes).filter(node => node.nodeType !== node.TEXT_NODE || node.textContent.trim().length !== 0);
    children.reverse();
    const [nestedList, ...nodes] = children;
    const hasNestedList = nestedList?.tagName === 'UL' || nestedList?.tagName === 'OL';

    if (!hasNestedList) {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', {
        content: listItem.innerHTML
      });
    }

    const htmlNodes = nodes.map(node => {
      if (node.nodeType === node.TEXT_NODE) {
        return node.textContent;
      }

      return node.outerHTML;
    });
    htmlNodes.reverse();
    const childAttributes = {
      content: htmlNodes.join('').trim()
    };
    const childInnerBlocks = [createListBlockFromDOMElement(nestedList)];
    return (0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', childAttributes, childInnerBlocks);
  });
  return (0,external_wp_blocks_namespaceObject.createBlock)('core/list', listAttributes, innerBlocks);
}
function migrateToListV2(attributes) {
  const {
    values,
    start,
    reversed,
    ordered,
    type,
    ...otherAttributes
  } = attributes;
  const list = document.createElement(ordered ? 'ol' : 'ul');
  list.innerHTML = values;

  if (start) {
    list.setAttribute('start', start);
  }

  if (reversed) {
    list.setAttribute('reversed', true);
  }

  if (type) {
    list.setAttribute('type', type);
  }

  const [listBlock] = (0,external_wp_blocks_namespaceObject.rawHandler)({
    HTML: list.outerHTML
  });
  return [{ ...otherAttributes,
    ...listBlock.attributes
  }, listBlock.innerBlocks];
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/deprecated.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const v0 = {
  attributes: {
    ordered: {
      type: 'boolean',
      default: false,
      __experimentalRole: 'content'
    },
    values: {
      type: 'string',
      source: 'html',
      selector: 'ol,ul',
      multiline: 'li',
      __unstableMultilineWrapperTags: ['ol', 'ul'],
      default: '',
      __experimentalRole: 'content'
    },
    type: {
      type: 'string'
    },
    start: {
      type: 'number'
    },
    reversed: {
      type: 'boolean'
    },
    placeholder: {
      type: 'string'
    }
  },
  supports: {
    anchor: true,
    className: false,
    typography: {
      fontSize: true,
      __experimentalFontFamily: true
    },
    color: {
      gradients: true,
      link: true
    },
    __unstablePasteTextInline: true,
    __experimentalSelector: 'ol,ul',
    __experimentalSlashInserter: true
  },

  save({
    attributes
  }) {
    const {
      ordered,
      values,
      type,
      reversed,
      start
    } = attributes;
    const TagName = ordered ? 'ol' : 'ul';
    return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        type,
        reversed,
        start
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: values,
      multiline: "li"
    }));
  },

  migrate: migrate_font_family,

  isEligible({
    style
  }) {
    return style?.typography?.fontFamily;
  }

};
const list_deprecated_v1 = {
  attributes: {
    ordered: {
      type: 'boolean',
      default: false,
      __experimentalRole: 'content'
    },
    values: {
      type: 'string',
      source: 'html',
      selector: 'ol,ul',
      multiline: 'li',
      __unstableMultilineWrapperTags: ['ol', 'ul'],
      default: '',
      __experimentalRole: 'content'
    },
    type: {
      type: 'string'
    },
    start: {
      type: 'number'
    },
    reversed: {
      type: 'boolean'
    },
    placeholder: {
      type: 'string'
    }
  },
  supports: {
    anchor: true,
    className: false,
    typography: {
      fontSize: true,
      __experimentalFontFamily: true,
      lineHeight: true,
      __experimentalFontStyle: true,
      __experimentalFontWeight: true,
      __experimentalLetterSpacing: true,
      __experimentalTextTransform: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    __unstablePasteTextInline: true,
    __experimentalSelector: 'ol,ul',
    __experimentalSlashInserter: true
  },

  save({
    attributes
  }) {
    const {
      ordered,
      values,
      type,
      reversed,
      start
    } = attributes;
    const TagName = ordered ? 'ol' : 'ul';
    return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        type,
        reversed,
        start
      })
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
      value: values,
      multiline: "li"
    }));
  },

  migrate: migrateToListV2
};
/**
 * New deprecations need to be placed first
 * for them to have higher priority.
 *
 * Old deprecations may need to be updated as well.
 *
 * See block-deprecation.md
 */

/* harmony default export */ var list_deprecated = ([list_deprecated_v1, v0]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-outdent-rtl.js


/**
 * WordPress dependencies
 */

const formatOutdentRTL = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20 5.5H4V4H20V5.5ZM12 12.5H4V11H12V12.5ZM20 20V18.5H4V20H20ZM15.4697 14.9697L18.4393 12L15.4697 9.03033L16.5303 7.96967L20.0303 11.4697L20.5607 12L20.0303 12.5303L16.5303 16.0303L15.4697 14.9697Z"
}));
/* harmony default export */ var format_outdent_rtl = (formatOutdentRTL);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-outdent.js


/**
 * WordPress dependencies
 */

const formatOutdent = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 7.2v1.5h16V7.2H4zm8 8.6h8v-1.5h-8v1.5zm-4-4.6l-4 4 4 4 1-1-3-3 3-3-1-1z"
}));
/* harmony default export */ var format_outdent = (formatOutdent);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-list-bullets-rtl.js


/**
 * WordPress dependencies
 */

const formatListBulletsRTL = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 8.8h8.9V7.2H4v1.6zm0 7h8.9v-1.5H4v1.5zM18 13c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-3c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2z"
}));
/* harmony default export */ var format_list_bullets_rtl = (formatListBulletsRTL);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-list-bullets.js


/**
 * WordPress dependencies
 */

const formatListBullets = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M11.1 15.8H20v-1.5h-8.9v1.5zm0-8.6v1.5H20V7.2h-8.9zM6 13c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-7c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
}));
/* harmony default export */ var format_list_bullets = (formatListBullets);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-list-numbered-rtl.js


/**
 * WordPress dependencies
 */

const formatListNumberedRTL = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M3.8 15.8h8.9v-1.5H3.8v1.5zm0-7h8.9V7.2H3.8v1.6zm14.7-2.1V10h1V5.3l-2.2.7.3 1 .9-.3zm1.2 6.1c-.5-.6-1.2-.5-1.7-.4-.3.1-.5.2-.7.3l.1 1.1c.2-.2.5-.4.8-.5.3-.1.6 0 .7.1.2.3 0 .8-.2 1.1-.5.8-.9 1.6-1.4 2.5H20v-1h-.9c.3-.6.8-1.4.9-2.1 0-.3 0-.8-.3-1.1z"
}));
/* harmony default export */ var format_list_numbered_rtl = (formatListNumberedRTL);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-list-numbered.js


/**
 * WordPress dependencies
 */

const formatListNumbered = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M11.1 15.8H20v-1.5h-8.9v1.5zm0-8.6v1.5H20V7.2h-8.9zM5 6.7V10h1V5.3L3.8 6l.4 1 .8-.3zm-.4 5.7c-.3.1-.5.2-.7.3l.1 1.1c.2-.2.5-.4.8-.5.3-.1.6 0 .7.1.2.3 0 .8-.2 1.1-.5.8-.9 1.6-1.4 2.5h2.7v-1h-1c.3-.6.8-1.4.9-2.1.1-.3 0-.8-.2-1.1-.5-.6-1.3-.5-1.7-.4z"
}));
/* harmony default export */ var format_list_numbered = (formatListNumbered);

;// CONCATENATED MODULE: external ["wp","deprecated"]
var external_wp_deprecated_namespaceObject = window["wp"]["deprecated"];
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/ordered-list-settings.js


/**
 * WordPress dependencies
 */




const OrderedListSettings = ({
  setAttributes,
  reversed,
  start,
  type
}) => (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
  title: (0,external_wp_i18n_namespaceObject.__)('Ordered list settings')
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
  __nextHasNoMarginBottom: true,
  label: (0,external_wp_i18n_namespaceObject.__)('Start value'),
  type: "number",
  onChange: value => {
    const int = parseInt(value, 10);
    setAttributes({
      // It should be possible to unset the value,
      // e.g. with an empty string.
      start: isNaN(int) ? undefined : int
    });
  },
  value: Number.isInteger(start) ? start.toString(10) : '',
  step: "1"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
  __nextHasNoMarginBottom: true,
  label: (0,external_wp_i18n_namespaceObject.__)('Numbering style'),
  options: [{
    value: '1',
    label: (0,external_wp_i18n_namespaceObject.__)('Numbers')
  }, {
    value: 'A',
    label: (0,external_wp_i18n_namespaceObject.__)('Uppercase letters')
  }, {
    value: 'a',
    label: (0,external_wp_i18n_namespaceObject.__)('Lowercase letters')
  }, {
    value: 'I',
    label: (0,external_wp_i18n_namespaceObject.__)('Uppercase Roman numerals')
  }, {
    value: 'i',
    label: (0,external_wp_i18n_namespaceObject.__)('Lowercase Roman numerals')
  }],
  value: type,
  onChange: newValue => setAttributes({
    type: newValue
  })
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
  __nextHasNoMarginBottom: true,
  label: (0,external_wp_i18n_namespaceObject.__)('Reverse list numbering'),
  checked: reversed || false,
  onChange: value => {
    setAttributes({
      // Unset the attribute if not reversed.
      reversed: value || undefined
    });
  }
})));

/* harmony default export */ var ordered_list_settings = (OrderedListSettings);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/tag-name.js


/**
 * WordPress dependencies
 */


function TagName(props, ref) {
  const {
    ordered,
    ...extraProps
  } = props;
  const Tag = ordered ? 'ol' : 'ul';
  return (0,external_wp_element_namespaceObject.createElement)(Tag, {
    ref: ref,
    ...extraProps
  });
}

/* harmony default export */ var tag_name = ((0,external_wp_element_namespaceObject.forwardRef)(TagName));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/edit.js


/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */




const list_edit_TEMPLATE = [['core/list-item']];
const NATIVE_MARGIN_SPACING = 8;
/**
 * At the moment, deprecations don't handle create blocks from attributes
 * (like when using CPT templates). For this reason, this hook is necessary
 * to avoid breaking templates using the old list block format.
 *
 * @param {Object} attributes Block attributes.
 * @param {string} clientId   Block client ID.
 */

function useMigrateOnLoad(attributes, clientId) {
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const {
    updateBlockAttributes,
    replaceInnerBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // As soon as the block is loaded, migrate it to the new version.
    if (!attributes.values) {
      return;
    }

    const [newAttributes, newInnerBlocks] = migrateToListV2(attributes);
    external_wp_deprecated_default()('Value attribute on the list block', {
      since: '6.0',
      version: '6.5',
      alternative: 'inner blocks'
    });
    registry.batch(() => {
      updateBlockAttributes(clientId, newAttributes);
      replaceInnerBlocks(clientId, newInnerBlocks);
    });
  }, [attributes.values]);
}

function useOutdentList(clientId) {
  const {
    canOutdent
  } = (0,external_wp_data_namespaceObject.useSelect)(innerSelect => {
    const {
      getBlockRootClientId,
      getBlock
    } = innerSelect(external_wp_blockEditor_namespaceObject.store);
    const parentId = getBlockRootClientId(clientId);
    return {
      canOutdent: !!parentId && getBlock(parentId).name === 'core/list-item'
    };
  }, [clientId]);
  const {
    replaceBlocks,
    selectionChange
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    getBlockRootClientId,
    getBlockAttributes,
    getBlock
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  return [canOutdent, (0,external_wp_element_namespaceObject.useCallback)(() => {
    const parentBlockId = getBlockRootClientId(clientId);
    const parentBlockAttributes = getBlockAttributes(parentBlockId); // Create a new parent block without the inner blocks.

    const newParentBlock = (0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', parentBlockAttributes);
    const {
      innerBlocks
    } = getBlock(clientId); // Replace the parent block with a new parent block without inner blocks,
    // and make the inner blocks siblings of the parent.

    replaceBlocks([parentBlockId], [newParentBlock, ...innerBlocks]); // Select the last child of the list being outdent.

    selectionChange(innerBlocks[innerBlocks.length - 1].clientId);
  }, [clientId])];
}

function IndentUI({
  clientId
}) {
  const [canOutdent, outdentList] = useOutdentList(clientId);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? format_outdent_rtl : format_outdent,
    title: (0,external_wp_i18n_namespaceObject.__)('Outdent'),
    describedBy: (0,external_wp_i18n_namespaceObject.__)('Outdent list item'),
    disabled: !canOutdent,
    onClick: outdentList
  }));
}

function list_edit_Edit({
  attributes,
  setAttributes,
  clientId,
  style
}) {
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({ ...(external_wp_element_namespaceObject.Platform.isNative && {
      style
    })
  });
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    allowedBlocks: ['core/list-item'],
    template: list_edit_TEMPLATE,
    templateLock: false,
    templateInsertUpdatesSelection: true,
    ...(external_wp_element_namespaceObject.Platform.isNative && {
      marginVertical: NATIVE_MARGIN_SPACING,
      marginHorizontal: NATIVE_MARGIN_SPACING,
      renderAppender: false
    })
  });
  useMigrateOnLoad(attributes, clientId);
  const {
    ordered,
    type,
    reversed,
    start
  } = attributes;
  const controls = (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? format_list_bullets_rtl : format_list_bullets,
    title: (0,external_wp_i18n_namespaceObject.__)('Unordered'),
    describedBy: (0,external_wp_i18n_namespaceObject.__)('Convert to unordered list'),
    isActive: ordered === false,
    onClick: () => {
      setAttributes({
        ordered: false
      });
    }
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? format_list_numbered_rtl : format_list_numbered,
    title: (0,external_wp_i18n_namespaceObject.__)('Ordered'),
    describedBy: (0,external_wp_i18n_namespaceObject.__)('Convert to ordered list'),
    isActive: ordered === true,
    onClick: () => {
      setAttributes({
        ordered: true
      });
    }
  }), (0,external_wp_element_namespaceObject.createElement)(IndentUI, {
    clientId: clientId
  }));
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(tag_name, {
    ordered: ordered,
    reversed: reversed,
    start: start,
    type: type,
    ...innerBlocksProps
  }), controls, ordered && (0,external_wp_element_namespaceObject.createElement)(ordered_list_settings, {
    setAttributes,
    reversed,
    start,
    type
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/save.js


/**
 * WordPress dependencies
 */

function list_save_save({
  attributes
}) {
  const {
    ordered,
    type,
    reversed,
    start
  } = attributes;
  const TagName = ordered ? 'ol' : 'ul';
  return (0,external_wp_element_namespaceObject.createElement)(TagName, { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      type,
      reversed,
      start
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/transforms.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function getListContentSchema({
  phrasingContentSchema
}) {
  const listContentSchema = { ...phrasingContentSchema,
    ul: {},
    ol: {
      attributes: ['type', 'start', 'reversed']
    }
  }; // Recursion is needed.
  // Possible: ul > li > ul.
  // Impossible: ul > ul.

  ['ul', 'ol'].forEach(tag => {
    listContentSchema[tag].children = {
      li: {
        children: listContentSchema
      }
    };
  });
  return listContentSchema;
}

function getListContentFlat(blocks) {
  return blocks.flatMap(({
    name,
    attributes,
    innerBlocks = []
  }) => {
    if (name === 'core/list-item') {
      return [attributes.content, ...getListContentFlat(innerBlocks)];
    }

    return getListContentFlat(innerBlocks);
  });
}

const list_transforms_transforms = {
  from: [{
    type: 'block',
    isMultiBlock: true,
    blocks: ['core/paragraph', 'core/heading'],
    transform: blockAttributes => {
      let childBlocks = [];

      if (blockAttributes.length > 1) {
        childBlocks = blockAttributes.map(({
          content
        }) => {
          return (0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', {
            content
          });
        });
      } else if (blockAttributes.length === 1) {
        const value = (0,external_wp_richText_namespaceObject.create)({
          html: blockAttributes[0].content
        });
        childBlocks = (0,external_wp_richText_namespaceObject.split)(value, '\n').map(result => {
          return (0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', {
            content: (0,external_wp_richText_namespaceObject.toHTMLString)({
              value: result
            })
          });
        });
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/list', {
        anchor: blockAttributes.anchor
      }, childBlocks);
    }
  }, {
    type: 'raw',
    selector: 'ol,ul',
    schema: args => ({
      ol: getListContentSchema(args).ol,
      ul: getListContentSchema(args).ul
    }),
    transform: createListBlockFromDOMElement
  }, ...['*', '-'].map(prefix => ({
    type: 'prefix',
    prefix,

    transform(content) {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/list', {}, [(0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', {
        content
      })]);
    }

  })), ...['1.', '1)'].map(prefix => ({
    type: 'prefix',
    prefix,

    transform(content) {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/list', {
        ordered: true
      }, [(0,external_wp_blocks_namespaceObject.createBlock)('core/list-item', {
        content
      })]);
    }

  }))],
  to: [...['core/paragraph', 'core/heading'].map(block => ({
    type: 'block',
    blocks: [block],
    transform: (_attributes, childBlocks) => {
      return getListContentFlat(childBlocks).map(content => (0,external_wp_blocks_namespaceObject.createBlock)(block, {
        content
      }));
    }
  }))]
};
/* harmony default export */ var list_transforms = (list_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const list_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/list",
  title: "List",
  category: "text",
  description: "Create a bulleted or numbered list.",
  keywords: ["bullet list", "ordered list", "numbered list"],
  textdomain: "default",
  attributes: {
    ordered: {
      type: "boolean",
      "default": false,
      __experimentalRole: "content"
    },
    values: {
      type: "string",
      source: "html",
      selector: "ol,ul",
      multiline: "li",
      __unstableMultilineWrapperTags: ["ol", "ul"],
      "default": "",
      __experimentalRole: "content"
    },
    type: {
      type: "string"
    },
    start: {
      type: "number"
    },
    reversed: {
      type: "boolean"
    },
    placeholder: {
      type: "string"
    }
  },
  supports: {
    anchor: true,
    className: false,
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    __unstablePasteTextInline: true,
    __experimentalSelector: "ol,ul",
    __experimentalSlashInserter: true
  },
  editorStyle: "wp-block-list-editor",
  style: "wp-block-list"
};


const {
  name: list_name
} = list_metadata;

const list_settings = {
  icon: library_list,
  example: {
    innerBlocks: [{
      name: 'core/list-item',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('Alice.')
      }
    }, {
      name: 'core/list-item',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('The White Rabbit.')
      }
    }, {
      name: 'core/list-item',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('The Cheshire Cat.')
      }
    }, {
      name: 'core/list-item',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('The Mad Hatter.')
      }
    }, {
      name: 'core/list-item',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('The Queen of Hearts.')
      }
    }]
  },
  transforms: list_transforms,
  edit: list_edit_Edit,
  save: list_save_save,
  deprecated: list_deprecated
};

const list_init = () => initBlock({
  name: list_name,
  metadata: list_metadata,
  settings: list_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/list-item.js


/**
 * WordPress dependencies
 */

const listItem = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M12 11v1.5h8V11h-8zm-6-1c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
}));
/* harmony default export */ var list_item = (listItem);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-indent-rtl.js


/**
 * WordPress dependencies
 */

const formatIndentRTL = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20 5.5H4V4H20V5.5ZM12 12.5H4V11H12V12.5ZM20 20V18.5H4V20H20ZM20.0303 9.03033L17.0607 12L20.0303 14.9697L18.9697 16.0303L15.4697 12.5303L14.9393 12L15.4697 11.4697L18.9697 7.96967L20.0303 9.03033Z"
}));
/* harmony default export */ var format_indent_rtl = (formatIndentRTL);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-indent.js


/**
 * WordPress dependencies
 */

const formatIndent = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 7.2v1.5h16V7.2H4zm8 8.6h8v-1.5h-8v1.5zm-8-3.5l3 3-3 3 1 1 4-4-4-4-1 1z"
}));
/* harmony default export */ var format_indent = (formatIndent);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-indent-list-item.js
/**
 * WordPress dependencies
 */




function useIndentListItem(clientId) {
  const canIndent = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getBlockIndex(clientId) > 0, [clientId]);
  const {
    replaceBlocks,
    selectionChange,
    multiSelect
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    getBlock,
    getPreviousBlockClientId,
    getSelectionStart,
    getSelectionEnd,
    hasMultiSelection,
    getMultiSelectedBlockClientIds
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  return [canIndent, (0,external_wp_element_namespaceObject.useCallback)(() => {
    const _hasMultiSelection = hasMultiSelection();

    const clientIds = _hasMultiSelection ? getMultiSelectedBlockClientIds() : [clientId];
    const clonedBlocks = clientIds.map(_clientId => (0,external_wp_blocks_namespaceObject.cloneBlock)(getBlock(_clientId)));
    const previousSiblingId = getPreviousBlockClientId(clientId);
    const newListItem = (0,external_wp_blocks_namespaceObject.cloneBlock)(getBlock(previousSiblingId)); // If the sibling has no innerBlocks, create a new `list` block.

    if (!newListItem.innerBlocks?.length) {
      newListItem.innerBlocks = [(0,external_wp_blocks_namespaceObject.createBlock)('core/list')];
    } // A list item usually has one `list`, but it's possible to have
    // more. So we need to preserve the previous `list` blocks and
    // merge the new blocks to the last `list`.


    newListItem.innerBlocks[newListItem.innerBlocks.length - 1].innerBlocks.push(...clonedBlocks); // We get the selection start/end here, because when
    // we replace blocks, the selection is updated too.

    const selectionStart = getSelectionStart();
    const selectionEnd = getSelectionEnd(); // Replace the previous sibling of the block being indented and the indented blocks,
    // with a new block whose attributes are equal to the ones of the previous sibling and
    // whose descendants are the children of the previous sibling, followed by the indented blocks.

    replaceBlocks([previousSiblingId, ...clientIds], [newListItem]);

    if (!_hasMultiSelection) {
      selectionChange(clonedBlocks[0].clientId, selectionEnd.attributeKey, selectionEnd.clientId === selectionStart.clientId ? selectionStart.offset : selectionEnd.offset, selectionEnd.offset);
    } else {
      multiSelect(clonedBlocks[0].clientId, clonedBlocks[clonedBlocks.length - 1].clientId);
    }
  }, [clientId])];
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-outdent-list-item.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

const {
  name: listItemName
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/list-item",
  title: "List item",
  category: "text",
  parent: ["core/list"],
  description: "Create a list item.",
  textdomain: "default",
  attributes: {
    placeholder: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "li",
      "default": "",
      __experimentalRole: "content"
    }
  },
  supports: {
    className: false,
    __experimentalSelector: "li",
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};
function useOutdentListItem(clientId) {
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const {
    canOutdent
  } = (0,external_wp_data_namespaceObject.useSelect)(innerSelect => {
    const {
      getBlockRootClientId,
      getBlockName
    } = innerSelect(external_wp_blockEditor_namespaceObject.store);
    const grandParentId = getBlockRootClientId(getBlockRootClientId(clientId));
    const grandParentName = getBlockName(grandParentId);
    const isListItem = grandParentName === listItemName;
    return {
      canOutdent: isListItem
    };
  }, [clientId]);
  const {
    moveBlocksToPosition,
    removeBlock,
    insertBlock,
    updateBlockListSettings
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    getBlockRootClientId,
    getBlockName,
    getBlockOrder,
    getBlockIndex,
    getSelectedBlockClientIds,
    getBlock,
    getBlockListSettings
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);

  function getParentListItemId(id) {
    const listId = getBlockRootClientId(id);
    const parentListItemId = getBlockRootClientId(listId);
    if (!parentListItemId) return;
    if (getBlockName(parentListItemId) !== listItemName) return;
    return parentListItemId;
  }

  return [canOutdent, (0,external_wp_element_namespaceObject.useCallback)((clientIds = getSelectedBlockClientIds()) => {
    if (!Array.isArray(clientIds)) {
      clientIds = [clientIds];
    }

    if (!clientIds.length) return;
    const firstClientId = clientIds[0]; // Can't outdent if it's not a list item.

    if (getBlockName(firstClientId) !== listItemName) return;
    const parentListItemId = getParentListItemId(firstClientId); // Can't outdent if it's at the top level.

    if (!parentListItemId) return;
    const parentListId = getBlockRootClientId(firstClientId);
    const lastClientId = clientIds[clientIds.length - 1];
    const order = getBlockOrder(parentListId);
    const followingListItems = order.slice(getBlockIndex(lastClientId) + 1);
    registry.batch(() => {
      if (followingListItems.length) {
        let nestedListId = getBlockOrder(firstClientId)[0];

        if (!nestedListId) {
          const nestedListBlock = (0,external_wp_blocks_namespaceObject.cloneBlock)(getBlock(parentListId), {}, []);
          nestedListId = nestedListBlock.clientId;
          insertBlock(nestedListBlock, 0, firstClientId, false); // Immediately update the block list settings, otherwise
          // blocks can't be moved here due to canInsert checks.

          updateBlockListSettings(nestedListId, getBlockListSettings(parentListId));
        }

        moveBlocksToPosition(followingListItems, parentListId, nestedListId);
      }

      moveBlocksToPosition(clientIds, parentListId, getBlockRootClientId(parentListItemId), getBlockIndex(parentListItemId) + 1);

      if (!getBlockOrder(parentListId).length) {
        const shouldSelectParent = false;
        removeBlock(parentListId, shouldSelectParent);
      }
    });
  }, [])];
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-copy.js
/**
 * WordPress dependencies
 */



function useCopy(clientId) {
  const {
    getBlockRootClientId,
    getBlockName,
    getBlockAttributes
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function onCopy(event) {
      // The event propagates through all nested lists, so don't override
      // when copying nested list items.
      if (event.clipboardData.getData('__unstableWrapperBlockName')) {
        return;
      }

      const rootClientId = getBlockRootClientId(clientId);
      event.clipboardData.setData('__unstableWrapperBlockName', getBlockName(rootClientId));
      event.clipboardData.setData('__unstableWrapperBlockAttributes', JSON.stringify(getBlockAttributes(rootClientId)));
    }

    node.addEventListener('copy', onCopy);
    node.addEventListener('cut', onCopy);
    return () => {
      node.removeEventListener('copy', onCopy);
      node.removeEventListener('cut', onCopy);
    };
  }, []);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-enter.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


function useEnter(props) {
  const {
    replaceBlocks,
    selectionChange
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    getBlock,
    getBlockRootClientId,
    getBlockIndex
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const propsRef = (0,external_wp_element_namespaceObject.useRef)(props);
  propsRef.current = props;
  const [canOutdent, outdentListItem] = useOutdentListItem(propsRef.current.clientId);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    function onKeyDown(event) {
      if (event.defaultPrevented || event.keyCode !== external_wp_keycodes_namespaceObject.ENTER) {
        return;
      }

      const {
        content,
        clientId
      } = propsRef.current;

      if (content.length) {
        return;
      }

      event.preventDefault();

      if (canOutdent) {
        outdentListItem();
        return;
      } // Here we are in top level list so we need to split.


      const topParentListBlock = getBlock(getBlockRootClientId(clientId));
      const blockIndex = getBlockIndex(clientId);
      const head = (0,external_wp_blocks_namespaceObject.cloneBlock)({ ...topParentListBlock,
        innerBlocks: topParentListBlock.innerBlocks.slice(0, blockIndex)
      });
      const middle = (0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()); // Last list item might contain a `list` block innerBlock
      // In that case append remaining innerBlocks blocks.

      const after = [...(topParentListBlock.innerBlocks[blockIndex].innerBlocks[0]?.innerBlocks || []), ...topParentListBlock.innerBlocks.slice(blockIndex + 1)];
      const tail = after.length ? [(0,external_wp_blocks_namespaceObject.cloneBlock)({ ...topParentListBlock,
        innerBlocks: after
      })] : [];
      replaceBlocks(topParentListBlock.clientId, [head, middle, ...tail], 1); // We manually change the selection here because we are replacing
      // a different block than the selected one.

      selectionChange(middle.clientId);
    }

    element.addEventListener('keydown', onKeyDown);
    return () => {
      element.removeEventListener('keydown', onKeyDown);
    };
  }, [canOutdent]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-space.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function useSpace(clientId) {
  const {
    getSelectionStart,
    getSelectionEnd
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const [canIndent, indentListItem] = useIndentListItem(clientId);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    function onKeyDown(event) {
      const {
        keyCode,
        shiftKey,
        altKey,
        metaKey,
        ctrlKey
      } = event;

      if (event.defaultPrevented || !canIndent || keyCode !== external_wp_keycodes_namespaceObject.SPACE || // Only override when no modifiers are pressed.
      shiftKey || altKey || metaKey || ctrlKey) {
        return;
      }

      const selectionStart = getSelectionStart();
      const selectionEnd = getSelectionEnd();

      if (selectionStart.offset === 0 && selectionEnd.offset === 0) {
        event.preventDefault();
        indentListItem();
      }
    }

    element.addEventListener('keydown', onKeyDown);
    return () => {
      element.removeEventListener('keydown', onKeyDown);
    };
  }, [canIndent, indentListItem]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-split.js
/**
 * WordPress dependencies
 */




function useSplit(clientId) {
  // We can not rely on the isAfterOriginal parameter of the callback,
  // because if the value after the split is empty isAfterOriginal is false
  // while the value is in fact after the original. So to avoid that issue we use
  // a flag where the first execution of the callback is false (it is the before value)
  // and the second execution is true, it is the after value.
  const isAfter = (0,external_wp_element_namespaceObject.useRef)(false);
  const {
    getBlock
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  return (0,external_wp_element_namespaceObject.useCallback)(value => {
    const block = getBlock(clientId);

    if (isAfter.current) {
      return (0,external_wp_blocks_namespaceObject.cloneBlock)(block, {
        content: value
      });
    }

    isAfter.current = true;
    return (0,external_wp_blocks_namespaceObject.createBlock)(block.name, { ...block.attributes,
      content: value
    });
  }, [clientId, getBlock]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/hooks/use-merge.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const {
  name: use_merge_listItemName
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/list-item",
  title: "List item",
  category: "text",
  parent: ["core/list"],
  description: "Create a list item.",
  textdomain: "default",
  attributes: {
    placeholder: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "li",
      "default": "",
      __experimentalRole: "content"
    }
  },
  supports: {
    className: false,
    __experimentalSelector: "li",
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};
function useMerge(clientId, onMerge) {
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const {
    getPreviousBlockClientId,
    getNextBlockClientId,
    getBlockOrder,
    getBlockRootClientId,
    getBlockName
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const {
    mergeBlocks,
    moveBlocksToPosition
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const [, outdentListItem] = useOutdentListItem(clientId);

  function getTrailingId(id) {
    const order = getBlockOrder(id);

    if (!order.length) {
      return id;
    }

    return getTrailingId(order[order.length - 1]);
  }

  function getParentListItemId(id) {
    const listId = getBlockRootClientId(id);
    const parentListItemId = getBlockRootClientId(listId);
    if (!parentListItemId) return;
    if (getBlockName(parentListItemId) !== use_merge_listItemName) return;
    return parentListItemId;
  }
  /**
   * Return the next list item with respect to the given list item. If none,
   * return the next list item of the parent list item if it exists.
   *
   * @param {string} id A list item client ID.
   * @return {string?} The client ID of the next list item.
   */


  function _getNextId(id) {
    const next = getNextBlockClientId(id);
    if (next) return next;
    const parentListItemId = getParentListItemId(id);
    if (!parentListItemId) return;
    return _getNextId(parentListItemId);
  }
  /**
   * Given a client ID, return the client ID of the list item on the next
   * line, regardless of indentation level.
   *
   * @param {string} id The client ID of the current list item.
   * @return {string?} The client ID of the next list item.
   */


  function getNextId(id) {
    const order = getBlockOrder(id); // If the list item does not have a nested list, return the next list
    // item.

    if (!order.length) {
      return _getNextId(id);
    } // Get the first list item in the nested list.


    return getBlockOrder(order[0])[0];
  }

  return forward => {
    if (forward) {
      const nextBlockClientId = getNextId(clientId);

      if (!nextBlockClientId) {
        onMerge(forward);
        return;
      }

      if (getParentListItemId(nextBlockClientId)) {
        outdentListItem(nextBlockClientId);
      } else {
        registry.batch(() => {
          moveBlocksToPosition(getBlockOrder(nextBlockClientId), nextBlockClientId, getPreviousBlockClientId(nextBlockClientId));
          mergeBlocks(clientId, nextBlockClientId);
        });
      }
    } else {
      // Merging is only done from the top level. For lowel levels, the
      // list item is outdented instead.
      const previousBlockClientId = getPreviousBlockClientId(clientId);

      if (getParentListItemId(clientId)) {
        outdentListItem(clientId);
      } else if (previousBlockClientId) {
        const trailingId = getTrailingId(previousBlockClientId);
        registry.batch(() => {
          moveBlocksToPosition(getBlockOrder(clientId), clientId, previousBlockClientId);
          mergeBlocks(trailingId, clientId);
        });
      } else {
        onMerge(forward);
      }
    }
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/utils.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */

const {
  name: utils_listItemName
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/list-item",
  title: "List item",
  category: "text",
  parent: ["core/list"],
  description: "Create a list item.",
  textdomain: "default",
  attributes: {
    placeholder: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "li",
      "default": "",
      __experimentalRole: "content"
    }
  },
  supports: {
    className: false,
    __experimentalSelector: "li",
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};
const {
  name: listName
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/list",
  title: "List",
  category: "text",
  description: "Create a bulleted or numbered list.",
  keywords: ["bullet list", "ordered list", "numbered list"],
  textdomain: "default",
  attributes: {
    ordered: {
      type: "boolean",
      "default": false,
      __experimentalRole: "content"
    },
    values: {
      type: "string",
      source: "html",
      selector: "ol,ul",
      multiline: "li",
      __unstableMultilineWrapperTags: ["ol", "ul"],
      "default": "",
      __experimentalRole: "content"
    },
    type: {
      type: "string"
    },
    start: {
      type: "number"
    },
    reversed: {
      type: "boolean"
    },
    placeholder: {
      type: "string"
    }
  },
  supports: {
    anchor: true,
    className: false,
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    __unstablePasteTextInline: true,
    __experimentalSelector: "ol,ul",
    __experimentalSlashInserter: true
  },
  editorStyle: "wp-block-list-editor",
  style: "wp-block-list"
};
const {
  name: paragraphName
} = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/paragraph",
  title: "Paragraph",
  category: "text",
  description: "Start with the basic building block of all narrative.",
  keywords: ["text"],
  textdomain: "default",
  attributes: {
    align: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "p",
      "default": "",
      __experimentalRole: "content"
    },
    dropCap: {
      type: "boolean",
      "default": false
    },
    placeholder: {
      type: "string"
    },
    direction: {
      type: "string",
      "enum": ["ltr", "rtl"]
    }
  },
  supports: {
    anchor: true,
    className: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true,
      __experimentalDefaultControls: {
        margin: false,
        padding: false
      }
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalTextDecoration: true,
      __experimentalFontStyle: true,
      __experimentalFontWeight: true,
      __experimentalLetterSpacing: true,
      __experimentalTextTransform: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    },
    __experimentalSelector: "p",
    __unstablePasteTextInline: true
  },
  editorStyle: "wp-block-paragraph-editor",
  style: "wp-block-paragraph"
};
function createListItem(listItemAttributes, listAttributes, children) {
  return createBlock(utils_listItemName, listItemAttributes, !children?.length ? [] : [createBlock(listName, listAttributes, children)]);
}

function convertBlockToList(block) {
  const list = (0,external_wp_blocks_namespaceObject.switchToBlockType)(block, listName);
  if (list) return list;
  const paragraph = (0,external_wp_blocks_namespaceObject.switchToBlockType)(block, paragraphName);
  if (paragraph) return (0,external_wp_blocks_namespaceObject.switchToBlockType)(paragraph, listName);
  return null;
}

function convertToListItems(blocks) {
  const listItems = [];

  for (let block of blocks) {
    if (block.name === utils_listItemName) {
      listItems.push(block);
    } else if (block.name === listName) {
      listItems.push(...block.innerBlocks);
    } else if (block = convertBlockToList(block)) {
      for (const {
        innerBlocks
      } of block) {
        listItems.push(...innerBlocks);
      }
    }
  }

  return listItems;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/edit.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function edit_IndentUI({
  clientId
}) {
  const [canIndent, indentListItem] = useIndentListItem(clientId);
  const [canOutdent, outdentListItem] = useOutdentListItem(clientId);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? format_outdent_rtl : format_outdent,
    title: (0,external_wp_i18n_namespaceObject.__)('Outdent'),
    describedBy: (0,external_wp_i18n_namespaceObject.__)('Outdent list item'),
    disabled: !canOutdent,
    onClick: () => outdentListItem()
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? format_indent_rtl : format_indent,
    title: (0,external_wp_i18n_namespaceObject.__)('Indent'),
    describedBy: (0,external_wp_i18n_namespaceObject.__)('Indent list item'),
    isDisabled: !canIndent,
    onClick: () => indentListItem()
  }));
}
function ListItemEdit({
  attributes,
  setAttributes,
  onReplace,
  clientId,
  mergeBlocks
}) {
  const {
    placeholder,
    content
  } = attributes;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    ref: useCopy(clientId)
  });
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)(blockProps, {
    allowedBlocks: ['core/list'],
    renderAppender: false,
    __unstableDisableDropZone: true
  });
  const useEnterRef = useEnter({
    content,
    clientId
  });
  const useSpaceRef = useSpace(clientId);
  const onSplit = useSplit(clientId);
  const onMerge = useMerge(clientId, mergeBlocks);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("li", { ...innerBlocksProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText, {
    ref: (0,external_wp_compose_namespaceObject.useMergeRefs)([useEnterRef, useSpaceRef]),
    identifier: "content",
    tagName: "div",
    onChange: nextContent => setAttributes({
      content: nextContent
    }),
    value: content,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('List text'),
    placeholder: placeholder || (0,external_wp_i18n_namespaceObject.__)('List'),
    onSplit: onSplit,
    onMerge: onMerge,
    onReplace: onReplace ? (blocks, ...args) => {
      onReplace(convertToListItems(blocks), ...args);
    } : undefined
  }), innerBlocksProps.children), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, (0,external_wp_element_namespaceObject.createElement)(edit_IndentUI, {
    clientId: clientId
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/save.js


/**
 * WordPress dependencies
 */

function list_item_save_save({
  attributes
}) {
  return (0,external_wp_element_namespaceObject.createElement)("li", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save()
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.RichText.Content, {
    value: attributes.content
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/transforms.js
/**
 * WordPress dependencies
 */

const list_item_transforms_transforms = {
  to: [{
    type: 'block',
    blocks: ['core/paragraph'],
    transform: (attributes, innerBlocks = []) => [(0,external_wp_blocks_namespaceObject.createBlock)('core/paragraph', attributes), ...innerBlocks.map(block => (0,external_wp_blocks_namespaceObject.cloneBlock)(block))]
  }]
};
/* harmony default export */ var list_item_transforms = (list_item_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/list-item/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const list_item_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/list-item",
  title: "List item",
  category: "text",
  parent: ["core/list"],
  description: "Create a list item.",
  textdomain: "default",
  attributes: {
    placeholder: {
      type: "string"
    },
    content: {
      type: "string",
      source: "html",
      selector: "li",
      "default": "",
      __experimentalRole: "content"
    }
  },
  supports: {
    className: false,
    __experimentalSelector: "li",
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};



const {
  name: list_item_name
} = list_item_metadata;

const list_item_settings = {
  icon: list_item,
  edit: ListItemEdit,
  save: list_item_save_save,

  merge(attributes, attributesToMerge) {
    return { ...attributes,
      content: attributes.content + attributesToMerge.content
    };
  },

  transforms: list_item_transforms
};
const list_item_init = () => initBlock({
  name: list_item_name,
  metadata: list_item_metadata,
  settings: list_item_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/login.js


/**
 * WordPress dependencies
 */

const login = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M11 14.5l1.1 1.1 3-3 .5-.5-.6-.6-3-3-1 1 1.7 1.7H5v1.5h7.7L11 14.5zM16.8 5h-7c-1.1 0-2 .9-2 2v1.5h1.5V7c0-.3.2-.5.5-.5h7c.3 0 .5.2.5.5v10c0 .3-.2.5-.5.5h-7c-.3 0-.5-.2-.5-.5v-1.5H7.8V17c0 1.1.9 2 2 2h7c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2z"
}));
/* harmony default export */ var library_login = (login);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/loginout/edit.js


/**
 * WordPress dependencies
 */



function LoginOutEdit({
  attributes,
  setAttributes
}) {
  const {
    displayLoginAsForm,
    redirectToCurrent
  } = attributes;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Display login as form'),
    checked: displayLoginAsForm,
    onChange: () => setAttributes({
      displayLoginAsForm: !displayLoginAsForm
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Redirect to current URL'),
    checked: redirectToCurrent,
    onChange: () => setAttributes({
      redirectToCurrent: !redirectToCurrent
    })
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)({
      className: 'logged-in'
    })
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    href: "#login-pseudo-link"
  }, (0,external_wp_i18n_namespaceObject.__)('Log out'))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/loginout/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const loginout_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/loginout",
  title: "Login/out",
  category: "theme",
  description: "Show login & logout links.",
  keywords: ["login", "logout", "form"],
  textdomain: "default",
  attributes: {
    displayLoginAsForm: {
      type: "boolean",
      "default": false
    },
    redirectToCurrent: {
      type: "boolean",
      "default": true
    }
  },
  supports: {
    className: true,
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  }
};
const {
  name: loginout_name
} = loginout_metadata;

const loginout_settings = {
  icon: library_login,
  edit: LoginOutEdit
};
const loginout_init = () => initBlock({
  name: loginout_name,
  metadata: loginout_metadata,
  settings: loginout_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/media-and-text.js


/**
 * WordPress dependencies
 */

const mediaAndText = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M3 6v11.5h8V6H3Zm11 3h7V7.5h-7V9Zm7 3.5h-7V11h7v1.5ZM14 16h7v-1.5h-7V16Z"
}));
/* harmony default export */ var media_and_text = (mediaAndText);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/constants.js
/**
 * WordPress dependencies
 */

const DEFAULT_MEDIA_SIZE_SLUG = 'full';
const WIDTH_CONSTRAINT_PERCENTAGE = 15;
const media_text_constants_LINK_DESTINATION_MEDIA = 'media';
const media_text_constants_LINK_DESTINATION_ATTACHMENT = 'attachment';
const constants_TEMPLATE = [['core/paragraph', {
  placeholder: (0,external_wp_i18n_namespaceObject._x)('Content…', 'content placeholder')
}]];

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/deprecated.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const v1ToV5ImageFillStyles = (url, focalPoint) => {
  return url ? {
    backgroundImage: `url(${url})`,
    backgroundPosition: focalPoint ? `${focalPoint.x * 100}% ${focalPoint.y * 100}%` : `50% 50%`
  } : {};
};

const v6ImageFillStyles = (url, focalPoint) => {
  return url ? {
    backgroundImage: `url(${url})`,
    backgroundPosition: focalPoint ? `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%` : `50% 50%`
  } : {};
};

const DEFAULT_MEDIA_WIDTH = 50;

const noop = () => {};

const media_text_deprecated_migrateCustomColors = attributes => {
  if (!attributes.customBackgroundColor) {
    return attributes;
  }

  const style = {
    color: {
      background: attributes.customBackgroundColor
    }
  };
  const {
    customBackgroundColor,
    ...restAttributes
  } = attributes;
  return { ...restAttributes,
    style
  };
}; // After align attribute's default was updated this function explicitly sets
// the align value for deprecated blocks to the `wide` value which was default
// for their versions of this block.


const migrateDefaultAlign = attributes => {
  if (attributes.align) {
    return attributes;
  }

  return { ...attributes,
    align: 'wide'
  };
};

const baseAttributes = {
  align: {
    type: 'string',
    default: 'wide'
  },
  mediaAlt: {
    type: 'string',
    source: 'attribute',
    selector: 'figure img',
    attribute: 'alt',
    default: ''
  },
  mediaPosition: {
    type: 'string',
    default: 'left'
  },
  mediaId: {
    type: 'number'
  },
  mediaType: {
    type: 'string'
  },
  mediaWidth: {
    type: 'number',
    default: 50
  },
  isStackedOnMobile: {
    type: 'boolean',
    default: true
  }
};
const v4ToV5BlockAttributes = { ...baseAttributes,
  mediaUrl: {
    type: 'string',
    source: 'attribute',
    selector: 'figure video,figure img',
    attribute: 'src'
  },
  mediaLink: {
    type: 'string'
  },
  linkDestination: {
    type: 'string'
  },
  linkTarget: {
    type: 'string',
    source: 'attribute',
    selector: 'figure a',
    attribute: 'target'
  },
  href: {
    type: 'string',
    source: 'attribute',
    selector: 'figure a',
    attribute: 'href'
  },
  rel: {
    type: 'string',
    source: 'attribute',
    selector: 'figure a',
    attribute: 'rel'
  },
  linkClass: {
    type: 'string',
    source: 'attribute',
    selector: 'figure a',
    attribute: 'class'
  },
  mediaSizeSlug: {
    type: 'string'
  },
  verticalAlignment: {
    type: 'string'
  },
  imageFill: {
    type: 'boolean'
  },
  focalPoint: {
    type: 'object'
  }
};
const v6Attributes = { ...v4ToV5BlockAttributes,
  mediaAlt: {
    type: 'string',
    source: 'attribute',
    selector: 'figure img',
    attribute: 'alt',
    default: '',
    __experimentalRole: 'content'
  },
  mediaId: {
    type: 'number',
    __experimentalRole: 'content'
  },
  mediaUrl: {
    type: 'string',
    source: 'attribute',
    selector: 'figure video,figure img',
    attribute: 'src',
    __experimentalRole: 'content'
  },
  href: {
    type: 'string',
    source: 'attribute',
    selector: 'figure a',
    attribute: 'href',
    __experimentalRole: 'content'
  },
  mediaType: {
    type: 'string',
    __experimentalRole: 'content'
  }
};
const v4ToV5Supports = {
  anchor: true,
  align: ['wide', 'full'],
  html: false,
  color: {
    gradients: true,
    link: true
  }
};
const v6Supports = { ...v4ToV5Supports,
  color: {
    gradients: true,
    link: true,
    __experimentalDefaultControls: {
      background: true,
      text: true
    }
  },
  spacing: {
    margin: true,
    padding: true
  },
  typography: {
    fontSize: true,
    lineHeight: true,
    __experimentalFontFamily: true,
    __experimentalFontWeight: true,
    __experimentalFontStyle: true,
    __experimentalTextTransform: true,
    __experimentalTextDecoration: true,
    __experimentalLetterSpacing: true,
    __experimentalDefaultControls: {
      fontSize: true
    }
  }
}; // Version with wide as the default alignment.
// See: https://github.com/WordPress/gutenberg/pull/48404

const media_text_deprecated_v6 = {
  attributes: v6Attributes,
  supports: v6Supports,

  save({
    attributes
  }) {
    const {
      isStackedOnMobile,
      mediaAlt,
      mediaPosition,
      mediaType,
      mediaUrl,
      mediaWidth,
      mediaId,
      verticalAlignment,
      imageFill,
      focalPoint,
      linkClass,
      href,
      linkTarget,
      rel
    } = attributes;
    const mediaSizeSlug = attributes.mediaSizeSlug || DEFAULT_MEDIA_SIZE_SLUG;
    const newRel = !rel ? undefined : rel;
    const imageClasses = classnames_default()({
      [`wp-image-${mediaId}`]: mediaId && mediaType === 'image',
      [`size-${mediaSizeSlug}`]: mediaId && mediaType === 'image'
    });
    let image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: mediaUrl,
      alt: mediaAlt,
      className: imageClasses || null
    });

    if (href) {
      image = (0,external_wp_element_namespaceObject.createElement)("a", {
        className: linkClass,
        href: href,
        target: linkTarget,
        rel: newRel
      }, image);
    }

    const mediaTypeRenders = {
      image: () => image,
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    const className = classnames_default()({
      'has-media-on-the-right': 'right' === mediaPosition,
      'is-stacked-on-mobile': isStackedOnMobile,
      [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
      'is-image-fill': imageFill
    });
    const backgroundStyles = imageFill ? v6ImageFillStyles(mediaUrl, focalPoint) : {};
    let gridTemplateColumns;

    if (mediaWidth !== DEFAULT_MEDIA_WIDTH) {
      gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
    }

    const style = {
      gridTemplateColumns
    };

    if ('right' === mediaPosition) {
      return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
          className,
          style
        })
      }, (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
          className: 'wp-block-media-text__content'
        })
      }), (0,external_wp_element_namespaceObject.createElement)("figure", {
        className: "wp-block-media-text__media",
        style: backgroundStyles
      }, (mediaTypeRenders[mediaType] || noop)()));
    }

    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media",
      style: backgroundStyles
    }, (mediaTypeRenders[mediaType] || noop)()), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-media-text__content'
      })
    }));
  },

  migrate: migrateDefaultAlign,

  isEligible(attributes, innerBlocks, {
    block
  }) {
    const {
      attributes: finalizedAttributes
    } = block; // When the align attribute defaults to none, valid block markup should
    // not contain any alignment CSS class. Unfortunately, this
    // deprecation's version of the block won't be invalidated due to the
    // alignwide class still being in the markup. That is because the custom
    // CSS classname support picks it up and adds it to the className
    // attribute. At the time of parsing, the className attribute won't
    // contain the alignwide class, hence the need to check the finalized
    // block attributes.

    return attributes.align === undefined && !!finalizedAttributes.className?.includes('alignwide');
  }

}; // Version with non-rounded background position attribute for focal point.
// See: https://github.com/WordPress/gutenberg/pull/33915

const media_text_deprecated_v5 = {
  attributes: v4ToV5BlockAttributes,
  supports: v4ToV5Supports,

  save({
    attributes
  }) {
    const {
      isStackedOnMobile,
      mediaAlt,
      mediaPosition,
      mediaType,
      mediaUrl,
      mediaWidth,
      mediaId,
      verticalAlignment,
      imageFill,
      focalPoint,
      linkClass,
      href,
      linkTarget,
      rel
    } = attributes;
    const mediaSizeSlug = attributes.mediaSizeSlug || DEFAULT_MEDIA_SIZE_SLUG;
    const newRel = !rel ? undefined : rel;
    const imageClasses = classnames_default()({
      [`wp-image-${mediaId}`]: mediaId && mediaType === 'image',
      [`size-${mediaSizeSlug}`]: mediaId && mediaType === 'image'
    });
    let image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: mediaUrl,
      alt: mediaAlt,
      className: imageClasses || null
    });

    if (href) {
      image = (0,external_wp_element_namespaceObject.createElement)("a", {
        className: linkClass,
        href: href,
        target: linkTarget,
        rel: newRel
      }, image);
    }

    const mediaTypeRenders = {
      image: () => image,
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    const className = classnames_default()({
      'has-media-on-the-right': 'right' === mediaPosition,
      'is-stacked-on-mobile': isStackedOnMobile,
      [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
      'is-image-fill': imageFill
    });
    const backgroundStyles = imageFill ? v1ToV5ImageFillStyles(mediaUrl, focalPoint) : {};
    let gridTemplateColumns;

    if (mediaWidth !== DEFAULT_MEDIA_WIDTH) {
      gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
    }

    const style = {
      gridTemplateColumns
    };

    if ('right' === mediaPosition) {
      return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
          className,
          style
        })
      }, (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
          className: 'wp-block-media-text__content'
        })
      }), (0,external_wp_element_namespaceObject.createElement)("figure", {
        className: "wp-block-media-text__media",
        style: backgroundStyles
      }, (mediaTypeRenders[mediaType] || noop)()));
    }

    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media",
      style: backgroundStyles
    }, (mediaTypeRenders[mediaType] || noop)()), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-media-text__content'
      })
    }));
  },

  migrate: migrateDefaultAlign
}; // Version with CSS grid
// See: https://github.com/WordPress/gutenberg/pull/40806

const media_text_deprecated_v4 = {
  attributes: v4ToV5BlockAttributes,
  supports: v4ToV5Supports,

  save({
    attributes
  }) {
    const {
      isStackedOnMobile,
      mediaAlt,
      mediaPosition,
      mediaType,
      mediaUrl,
      mediaWidth,
      mediaId,
      verticalAlignment,
      imageFill,
      focalPoint,
      linkClass,
      href,
      linkTarget,
      rel
    } = attributes;
    const mediaSizeSlug = attributes.mediaSizeSlug || DEFAULT_MEDIA_SIZE_SLUG;
    const newRel = !rel ? undefined : rel;
    const imageClasses = classnames_default()({
      [`wp-image-${mediaId}`]: mediaId && mediaType === 'image',
      [`size-${mediaSizeSlug}`]: mediaId && mediaType === 'image'
    });
    let image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: mediaUrl,
      alt: mediaAlt,
      className: imageClasses || null
    });

    if (href) {
      image = (0,external_wp_element_namespaceObject.createElement)("a", {
        className: linkClass,
        href: href,
        target: linkTarget,
        rel: newRel
      }, image);
    }

    const mediaTypeRenders = {
      image: () => image,
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    const className = classnames_default()({
      'has-media-on-the-right': 'right' === mediaPosition,
      'is-stacked-on-mobile': isStackedOnMobile,
      [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
      'is-image-fill': imageFill
    });
    const backgroundStyles = imageFill ? v1ToV5ImageFillStyles(mediaUrl, focalPoint) : {};
    let gridTemplateColumns;

    if (mediaWidth !== DEFAULT_MEDIA_WIDTH) {
      gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
    }

    const style = {
      gridTemplateColumns
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media",
      style: backgroundStyles
    }, (mediaTypeRenders[mediaType] || noop)()), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-media-text__content'
      })
    }));
  },

  migrate: migrateDefaultAlign
}; // Version with ad-hoc color attributes
// See: https://github.com/WordPress/gutenberg/pull/21169

const media_text_deprecated_v3 = {
  attributes: { ...baseAttributes,
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    mediaLink: {
      type: 'string'
    },
    linkDestination: {
      type: 'string'
    },
    linkTarget: {
      type: 'string',
      source: 'attribute',
      selector: 'figure a',
      attribute: 'target'
    },
    href: {
      type: 'string',
      source: 'attribute',
      selector: 'figure a',
      attribute: 'href'
    },
    rel: {
      type: 'string',
      source: 'attribute',
      selector: 'figure a',
      attribute: 'rel'
    },
    linkClass: {
      type: 'string',
      source: 'attribute',
      selector: 'figure a',
      attribute: 'class'
    },
    verticalAlignment: {
      type: 'string'
    },
    imageFill: {
      type: 'boolean'
    },
    focalPoint: {
      type: 'object'
    }
  },
  migrate: (0,external_wp_compose_namespaceObject.compose)(media_text_deprecated_migrateCustomColors, migrateDefaultAlign),

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor,
      isStackedOnMobile,
      mediaAlt,
      mediaPosition,
      mediaType,
      mediaUrl,
      mediaWidth,
      mediaId,
      verticalAlignment,
      imageFill,
      focalPoint,
      linkClass,
      href,
      linkTarget,
      rel
    } = attributes;
    const newRel = !rel ? undefined : rel;
    let image = (0,external_wp_element_namespaceObject.createElement)("img", {
      src: mediaUrl,
      alt: mediaAlt,
      className: mediaId && mediaType === 'image' ? `wp-image-${mediaId}` : null
    });

    if (href) {
      image = (0,external_wp_element_namespaceObject.createElement)("a", {
        className: linkClass,
        href: href,
        target: linkTarget,
        rel: newRel
      }, image);
    }

    const mediaTypeRenders = {
      image: () => image,
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const className = classnames_default()({
      'has-media-on-the-right': 'right' === mediaPosition,
      'has-background': backgroundClass || customBackgroundColor,
      [backgroundClass]: backgroundClass,
      'is-stacked-on-mobile': isStackedOnMobile,
      [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
      'is-image-fill': imageFill
    });
    const backgroundStyles = imageFill ? v1ToV5ImageFillStyles(mediaUrl, focalPoint) : {};
    let gridTemplateColumns;

    if (mediaWidth !== DEFAULT_MEDIA_WIDTH) {
      gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
    }

    const style = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      gridTemplateColumns
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className,
      style: style
    }, (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media",
      style: backgroundStyles
    }, (mediaTypeRenders[mediaType] || noop)()), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-media-text__content"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  }

}; // Version with stack on mobile off by default
// See: https://github.com/WordPress/gutenberg/pull/14364

const media_text_deprecated_v2 = {
  attributes: { ...baseAttributes,
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    mediaUrl: {
      type: 'string',
      source: 'attribute',
      selector: 'figure video,figure img',
      attribute: 'src'
    },
    verticalAlignment: {
      type: 'string'
    },
    imageFill: {
      type: 'boolean'
    },
    focalPoint: {
      type: 'object'
    }
  },
  migrate: (0,external_wp_compose_namespaceObject.compose)(media_text_deprecated_migrateCustomColors, migrateDefaultAlign),

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor,
      isStackedOnMobile,
      mediaAlt,
      mediaPosition,
      mediaType,
      mediaUrl,
      mediaWidth,
      mediaId,
      verticalAlignment,
      imageFill,
      focalPoint
    } = attributes;
    const mediaTypeRenders = {
      image: () => (0,external_wp_element_namespaceObject.createElement)("img", {
        src: mediaUrl,
        alt: mediaAlt,
        className: mediaId && mediaType === 'image' ? `wp-image-${mediaId}` : null
      }),
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const className = classnames_default()({
      'has-media-on-the-right': 'right' === mediaPosition,
      [backgroundClass]: backgroundClass,
      'is-stacked-on-mobile': isStackedOnMobile,
      [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
      'is-image-fill': imageFill
    });
    const backgroundStyles = imageFill ? v1ToV5ImageFillStyles(mediaUrl, focalPoint) : {};
    let gridTemplateColumns;

    if (mediaWidth !== DEFAULT_MEDIA_WIDTH) {
      gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
    }

    const style = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      gridTemplateColumns
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className,
      style: style
    }, (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media",
      style: backgroundStyles
    }, (mediaTypeRenders[mediaType] || noop)()), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-media-text__content"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  }

}; // Version without the wp-image-#### class on image
// See: https://github.com/WordPress/gutenberg/pull/11922

const media_text_deprecated_v1 = {
  attributes: { ...baseAttributes,
    backgroundColor: {
      type: 'string'
    },
    customBackgroundColor: {
      type: 'string'
    },
    mediaUrl: {
      type: 'string',
      source: 'attribute',
      selector: 'figure video,figure img',
      attribute: 'src'
    }
  },
  migrate: migrateDefaultAlign,

  save({
    attributes
  }) {
    const {
      backgroundColor,
      customBackgroundColor,
      isStackedOnMobile,
      mediaAlt,
      mediaPosition,
      mediaType,
      mediaUrl,
      mediaWidth
    } = attributes;
    const mediaTypeRenders = {
      image: () => (0,external_wp_element_namespaceObject.createElement)("img", {
        src: mediaUrl,
        alt: mediaAlt
      }),
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    const backgroundClass = (0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', backgroundColor);
    const className = classnames_default()({
      'has-media-on-the-right': 'right' === mediaPosition,
      [backgroundClass]: backgroundClass,
      'is-stacked-on-mobile': isStackedOnMobile
    });
    let gridTemplateColumns;

    if (mediaWidth !== DEFAULT_MEDIA_WIDTH) {
      gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
    }

    const style = {
      backgroundColor: backgroundClass ? undefined : customBackgroundColor,
      gridTemplateColumns
    };
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: className,
      style: style
    }, (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media"
    }, (mediaTypeRenders[mediaType] || noop)()), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block-media-text__content"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, null)));
  }

};
/* harmony default export */ var media_text_deprecated = ([media_text_deprecated_v6, media_text_deprecated_v5, media_text_deprecated_v4, media_text_deprecated_v3, media_text_deprecated_v2, media_text_deprecated_v1]);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/pull-left.js


/**
 * WordPress dependencies
 */

const pullLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 18h6V6H4v12zm9-9.5V10h7V8.5h-7zm0 7h7V14h-7v1.5z"
}));
/* harmony default export */ var pull_left = (pullLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/pull-right.js


/**
 * WordPress dependencies
 */

const pullRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14 6v12h6V6h-6zM4 10h7V8.5H4V10zm0 5.5h7V14H4v1.5z"
}));
/* harmony default export */ var pull_right = (pullRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/media.js


/**
 * WordPress dependencies
 */

const media = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m7 6.5 4 2.5-4 2.5z"
}), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "m5 3c-1.10457 0-2 .89543-2 2v14c0 1.1046.89543 2 2 2h14c1.1046 0 2-.8954 2-2v-14c0-1.10457-.8954-2-2-2zm14 1.5h-14c-.27614 0-.5.22386-.5.5v10.7072l3.62953-2.6465c.25108-.1831.58905-.1924.84981-.0234l2.92666 1.8969 3.5712-3.4719c.2911-.2831.7545-.2831 1.0456 0l2.9772 2.8945v-9.3568c0-.27614-.2239-.5-.5-.5zm-14.5 14.5v-1.4364l4.09643-2.987 2.99567 1.9417c.2936.1903.6798.1523.9307-.0917l3.4772-3.3806 3.4772 3.3806.0228-.0234v2.5968c0 .2761-.2239.5-.5.5h-14c-.27614 0-.5-.2239-.5-.5z"
}));
/* harmony default export */ var library_media = (media);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/media-container.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */










/**
 * Constants
 */

const media_container_ALLOWED_MEDIA_TYPES = ['image', 'video'];

const media_container_noop = () => {};

function imageFillStyles(url, focalPoint) {
  return url ? {
    backgroundImage: `url(${url})`,
    backgroundPosition: focalPoint ? `${Math.round(focalPoint.x * 100)}% ${Math.round(focalPoint.y * 100)}%` : `50% 50%`
  } : {};
}
const ResizableBoxContainer = (0,external_wp_element_namespaceObject.forwardRef)(({
  isSelected,
  isStackedOnMobile,
  ...props
}, ref) => {
  const isMobile = (0,external_wp_compose_namespaceObject.useViewportMatch)('small', '<');
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ResizableBox, {
    ref: ref,
    showHandle: isSelected && (!isMobile || !isStackedOnMobile),
    ...props
  });
});

function ToolbarEditButton({
  mediaId,
  mediaUrl,
  onSelectMedia
}) {
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "other"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaReplaceFlow, {
    mediaId: mediaId,
    mediaURL: mediaUrl,
    allowedTypes: media_container_ALLOWED_MEDIA_TYPES,
    accept: "image/*,video/*",
    onSelect: onSelectMedia
  }));
}

function PlaceholderContainer({
  className,
  mediaUrl,
  onSelectMedia
}) {
  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);

  const onUploadError = message => {
    createErrorNotice(message, {
      type: 'snackbar'
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.MediaPlaceholder, {
    icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockIcon, {
      icon: library_media
    }),
    labels: {
      title: (0,external_wp_i18n_namespaceObject.__)('Media area')
    },
    className: className,
    onSelect: onSelectMedia,
    accept: "image/*,video/*",
    allowedTypes: media_container_ALLOWED_MEDIA_TYPES,
    onError: onUploadError,
    disableMediaButtons: mediaUrl
  });
}

function MediaContainer(props, ref) {
  const {
    className,
    commitWidthChange,
    focalPoint,
    imageFill,
    isSelected,
    isStackedOnMobile,
    mediaAlt,
    mediaId,
    mediaPosition,
    mediaType,
    mediaUrl,
    mediaWidth,
    onSelectMedia,
    onWidthChange,
    enableResize
  } = props;
  const isTemporaryMedia = !mediaId && (0,external_wp_blob_namespaceObject.isBlobURL)(mediaUrl);
  const {
    toggleSelection
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);

  if (mediaUrl) {
    const onResizeStart = () => {
      toggleSelection(false);
    };

    const onResize = (event, direction, elt) => {
      onWidthChange(parseInt(elt.style.width));
    };

    const onResizeStop = (event, direction, elt) => {
      toggleSelection(true);
      commitWidthChange(parseInt(elt.style.width));
    };

    const enablePositions = {
      right: enableResize && mediaPosition === 'left',
      left: enableResize && mediaPosition === 'right'
    };
    const backgroundStyles = mediaType === 'image' && imageFill ? imageFillStyles(mediaUrl, focalPoint) : {};
    const mediaTypeRenderers = {
      image: () => (0,external_wp_element_namespaceObject.createElement)("img", {
        src: mediaUrl,
        alt: mediaAlt
      }),
      video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
        controls: true,
        src: mediaUrl
      })
    };
    return (0,external_wp_element_namespaceObject.createElement)(ResizableBoxContainer, {
      as: "figure",
      className: classnames_default()(className, 'editor-media-container__resizer', {
        'is-transient': isTemporaryMedia
      }),
      style: backgroundStyles,
      size: {
        width: mediaWidth + '%'
      },
      minWidth: "10%",
      maxWidth: "100%",
      enable: enablePositions,
      onResizeStart: onResizeStart,
      onResize: onResize,
      onResizeStop: onResizeStop,
      axis: "x",
      isSelected: isSelected,
      isStackedOnMobile: isStackedOnMobile,
      ref: ref
    }, (0,external_wp_element_namespaceObject.createElement)(ToolbarEditButton, {
      onSelectMedia: onSelectMedia,
      mediaUrl: mediaUrl,
      mediaId: mediaId
    }), (mediaTypeRenderers[mediaType] || media_container_noop)(), isTemporaryMedia && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null), (0,external_wp_element_namespaceObject.createElement)(PlaceholderContainer, { ...props
    }));
  }

  return (0,external_wp_element_namespaceObject.createElement)(PlaceholderContainer, { ...props
  });
}

/* harmony default export */ var media_container = ((0,external_wp_element_namespaceObject.forwardRef)(MediaContainer));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/edit.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */




const {
  useBlockEditingMode: edit_useBlockEditingMode
} = unlock(external_wp_blockEditor_namespaceObject.privateApis); // this limits the resize to a safe zone to avoid making broken layouts

const applyWidthConstraints = width => Math.max(WIDTH_CONSTRAINT_PERCENTAGE, Math.min(width, 100 - WIDTH_CONSTRAINT_PERCENTAGE));

function getImageSourceUrlBySizeSlug(image, slug) {
  // eslint-disable-next-line camelcase
  return image?.media_details?.sizes?.[slug]?.source_url;
}

function edit_attributesFromMedia({
  attributes: {
    linkDestination,
    href
  },
  setAttributes
}) {
  return media => {
    if (!media || !media.url) {
      setAttributes({
        mediaAlt: undefined,
        mediaId: undefined,
        mediaType: undefined,
        mediaUrl: undefined,
        mediaLink: undefined,
        href: undefined,
        focalPoint: undefined
      });
      return;
    }

    if ((0,external_wp_blob_namespaceObject.isBlobURL)(media.url)) {
      media.type = (0,external_wp_blob_namespaceObject.getBlobTypeByURL)(media.url);
    }

    let mediaType;
    let src; // For media selections originated from a file upload.

    if (media.media_type) {
      if (media.media_type === 'image') {
        mediaType = 'image';
      } else {
        // only images and videos are accepted so if the media_type is not an image we can assume it is a video.
        // video contain the media type of 'file' in the object returned from the rest api.
        mediaType = 'video';
      }
    } else {
      // For media selections originated from existing files in the media library.
      mediaType = media.type;
    }

    if (mediaType === 'image') {
      // Try the "large" size URL, falling back to the "full" size URL below.
      src = media.sizes?.large?.url || // eslint-disable-next-line camelcase
      media.media_details?.sizes?.large?.source_url;
    }

    let newHref = href;

    if (linkDestination === media_text_constants_LINK_DESTINATION_MEDIA) {
      // Update the media link.
      newHref = media.url;
    } // Check if the image is linked to the attachment page.


    if (linkDestination === media_text_constants_LINK_DESTINATION_ATTACHMENT) {
      // Update the media link.
      newHref = media.link;
    }

    setAttributes({
      mediaAlt: media.alt,
      mediaId: media.id,
      mediaType,
      mediaUrl: src || media.url,
      mediaLink: media.link || undefined,
      href: newHref,
      focalPoint: undefined
    });
  };
}

function MediaTextEdit({
  attributes,
  isSelected,
  setAttributes
}) {
  const {
    focalPoint,
    href,
    imageFill,
    isStackedOnMobile,
    linkClass,
    linkDestination,
    linkTarget,
    mediaAlt,
    mediaId,
    mediaPosition,
    mediaType,
    mediaUrl,
    mediaWidth,
    rel,
    verticalAlignment,
    allowedBlocks
  } = attributes;
  const mediaSizeSlug = attributes.mediaSizeSlug || DEFAULT_MEDIA_SIZE_SLUG;
  const {
    imageSizes,
    image
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    return {
      image: mediaId && isSelected ? select(external_wp_coreData_namespaceObject.store).getMedia(mediaId, {
        context: 'view'
      }) : null,
      imageSizes: getSettings()?.imageSizes
    };
  }, [isSelected, mediaId]);
  const refMediaContainer = (0,external_wp_element_namespaceObject.useRef)();

  const imperativeFocalPointPreview = value => {
    const {
      style
    } = refMediaContainer.current.resizable;
    const {
      x,
      y
    } = value;
    style.backgroundPosition = `${x * 100}% ${y * 100}%`;
  };

  const [temporaryMediaWidth, setTemporaryMediaWidth] = (0,external_wp_element_namespaceObject.useState)(null);
  const onSelectMedia = edit_attributesFromMedia({
    attributes,
    setAttributes
  });

  const onSetHref = props => {
    setAttributes(props);
  };

  const onWidthChange = width => {
    setTemporaryMediaWidth(applyWidthConstraints(width));
  };

  const commitWidthChange = width => {
    setAttributes({
      mediaWidth: applyWidthConstraints(width)
    });
    setTemporaryMediaWidth(null);
  };

  const classNames = classnames_default()({
    'has-media-on-the-right': 'right' === mediaPosition,
    'is-selected': isSelected,
    'is-stacked-on-mobile': isStackedOnMobile,
    [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
    'is-image-fill': imageFill
  });
  const widthString = `${temporaryMediaWidth || mediaWidth}%`;
  const gridTemplateColumns = 'right' === mediaPosition ? `1fr ${widthString}` : `${widthString} 1fr`;
  const style = {
    gridTemplateColumns,
    msGridColumns: gridTemplateColumns
  };

  const onMediaAltChange = newMediaAlt => {
    setAttributes({
      mediaAlt: newMediaAlt
    });
  };

  const onVerticalAlignmentChange = alignment => {
    setAttributes({
      verticalAlignment: alignment
    });
  };

  const imageSizeOptions = imageSizes.filter(({
    slug
  }) => getImageSourceUrlBySizeSlug(image, slug)).map(({
    name,
    slug
  }) => ({
    value: slug,
    label: name
  }));

  const updateImage = newMediaSizeSlug => {
    const newUrl = getImageSourceUrlBySizeSlug(image, newMediaSizeSlug);

    if (!newUrl) {
      return null;
    }

    setAttributes({
      mediaUrl: newUrl,
      mediaSizeSlug: newMediaSizeSlug
    });
  };

  const mediaTextGeneralSettings = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
    title: (0,external_wp_i18n_namespaceObject.__)('Settings')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Stack on mobile'),
    checked: isStackedOnMobile,
    onChange: () => setAttributes({
      isStackedOnMobile: !isStackedOnMobile
    })
  }), mediaType === 'image' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Crop image to fill entire column'),
    checked: imageFill,
    onChange: () => setAttributes({
      imageFill: !imageFill
    })
  }), imageFill && mediaUrl && mediaType === 'image' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FocalPointPicker, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Focal point picker'),
    url: mediaUrl,
    value: focalPoint,
    onChange: value => setAttributes({
      focalPoint: value
    }),
    onDragStart: imperativeFocalPointPreview,
    onDrag: imperativeFocalPointPreview
  }), mediaType === 'image' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextareaControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Alternative text'),
    value: mediaAlt,
    onChange: onMediaAltChange,
    help: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
      href: "https://www.w3.org/WAI/tutorials/images/decision-tree"
    }, (0,external_wp_i18n_namespaceObject.__)('Describe the purpose of the image.')), (0,external_wp_element_namespaceObject.createElement)("br", null), (0,external_wp_i18n_namespaceObject.__)('Leave empty if decorative.'))
  }), mediaType === 'image' && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalImageSizeControl, {
    onChangeImage: updateImage,
    slug: mediaSizeSlug,
    imageSizeOptions: imageSizeOptions,
    isResizable: false,
    imageSizeHelp: (0,external_wp_i18n_namespaceObject.__)('Select the size of the source image.')
  }), mediaUrl && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Media width'),
    value: temporaryMediaWidth || mediaWidth,
    onChange: commitWidthChange,
    min: WIDTH_CONSTRAINT_PERCENTAGE,
    max: 100 - WIDTH_CONSTRAINT_PERCENTAGE
  }));
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: classNames,
    style
  });
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)({
    className: 'wp-block-media-text__content'
  }, {
    template: constants_TEMPLATE,
    allowedBlocks
  });
  const blockEditingMode = edit_useBlockEditingMode();
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, mediaTextGeneralSettings), (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockControls, {
    group: "block"
  }, blockEditingMode === 'default' && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.BlockVerticalAlignmentControl, {
    onChange: onVerticalAlignmentChange,
    value: verticalAlignment
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: pull_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Show media on left'),
    isActive: mediaPosition === 'left',
    onClick: () => setAttributes({
      mediaPosition: 'left'
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    icon: pull_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Show media on right'),
    isActive: mediaPosition === 'right',
    onClick: () => setAttributes({
      mediaPosition: 'right'
    })
  })), mediaType === 'image' && (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.__experimentalImageURLInputUI, {
    url: href || '',
    onChangeUrl: onSetHref,
    linkDestination: linkDestination,
    mediaType: mediaType,
    mediaUrl: image && image.source_url,
    mediaLink: image && image.link,
    linkTarget: linkTarget,
    linkClass: linkClass,
    rel: rel
  })), (0,external_wp_element_namespaceObject.createElement)("div", { ...blockProps
  }, mediaPosition === 'right' && (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  }), (0,external_wp_element_namespaceObject.createElement)(media_container, {
    className: "wp-block-media-text__media",
    onSelectMedia: onSelectMedia,
    onWidthChange: onWidthChange,
    commitWidthChange: commitWidthChange,
    ref: refMediaContainer,
    enableResize: blockEditingMode === 'default',
    focalPoint,
    imageFill,
    isSelected,
    isStackedOnMobile,
    mediaAlt,
    mediaId,
    mediaPosition,
    mediaType,
    mediaUrl,
    mediaWidth
  }), mediaPosition !== 'right' && (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  })));
}

/* harmony default export */ var media_text_edit = (MediaTextEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/save.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const save_DEFAULT_MEDIA_WIDTH = 50;

const save_noop = () => {};

function media_text_save_save({
  attributes
}) {
  const {
    isStackedOnMobile,
    mediaAlt,
    mediaPosition,
    mediaType,
    mediaUrl,
    mediaWidth,
    mediaId,
    verticalAlignment,
    imageFill,
    focalPoint,
    linkClass,
    href,
    linkTarget,
    rel
  } = attributes;
  const mediaSizeSlug = attributes.mediaSizeSlug || DEFAULT_MEDIA_SIZE_SLUG;
  const newRel = !rel ? undefined : rel;
  const imageClasses = classnames_default()({
    [`wp-image-${mediaId}`]: mediaId && mediaType === 'image',
    [`size-${mediaSizeSlug}`]: mediaId && mediaType === 'image'
  });
  let image = (0,external_wp_element_namespaceObject.createElement)("img", {
    src: mediaUrl,
    alt: mediaAlt,
    className: imageClasses || null
  });

  if (href) {
    image = (0,external_wp_element_namespaceObject.createElement)("a", {
      className: linkClass,
      href: href,
      target: linkTarget,
      rel: newRel
    }, image);
  }

  const mediaTypeRenders = {
    image: () => image,
    video: () => (0,external_wp_element_namespaceObject.createElement)("video", {
      controls: true,
      src: mediaUrl
    })
  };
  const className = classnames_default()({
    'has-media-on-the-right': 'right' === mediaPosition,
    'is-stacked-on-mobile': isStackedOnMobile,
    [`is-vertically-aligned-${verticalAlignment}`]: verticalAlignment,
    'is-image-fill': imageFill
  });
  const backgroundStyles = imageFill ? imageFillStyles(mediaUrl, focalPoint) : {};
  let gridTemplateColumns;

  if (mediaWidth !== save_DEFAULT_MEDIA_WIDTH) {
    gridTemplateColumns = 'right' === mediaPosition ? `auto ${mediaWidth}%` : `${mediaWidth}% auto`;
  }

  const style = {
    gridTemplateColumns
  };

  if ('right' === mediaPosition) {
    return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
        className,
        style
      })
    }, (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
        className: 'wp-block-media-text__content'
      })
    }), (0,external_wp_element_namespaceObject.createElement)("figure", {
      className: "wp-block-media-text__media",
      style: backgroundStyles
    }, (mediaTypeRenders[mediaType] || save_noop)()));
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useBlockProps.save({
      className,
      style
    })
  }, (0,external_wp_element_namespaceObject.createElement)("figure", {
    className: "wp-block-media-text__media",
    style: backgroundStyles
  }, (mediaTypeRenders[mediaType] || save_noop)()), (0,external_wp_element_namespaceObject.createElement)("div", { ...external_wp_blockEditor_namespaceObject.useInnerBlocksProps.save({
      className: 'wp-block-media-text__content'
    })
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/transforms.js
/**
 * WordPress dependencies
 */

const media_text_transforms_transforms = {
  from: [{
    type: 'block',
    blocks: ['core/image'],
    transform: ({
      alt,
      url,
      id,
      anchor
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/media-text', {
      mediaAlt: alt,
      mediaId: id,
      mediaUrl: url,
      mediaType: 'image',
      anchor
    })
  }, {
    type: 'block',
    blocks: ['core/video'],
    transform: ({
      src,
      id,
      anchor
    }) => (0,external_wp_blocks_namespaceObject.createBlock)('core/media-text', {
      mediaId: id,
      mediaUrl: src,
      mediaType: 'video',
      anchor
    })
  }, {
    type: 'block',
    blocks: ['core/cover'],
    transform: ({
      align,
      alt,
      anchor,
      backgroundType,
      customGradient,
      customOverlayColor,
      gradient,
      id,
      overlayColor,
      style,
      textColor,
      url
    }, innerBlocks) => {
      let additionalAttributes = {};

      if (customGradient) {
        additionalAttributes = {
          style: {
            color: {
              gradient: customGradient
            }
          }
        };
      } else if (customOverlayColor) {
        additionalAttributes = {
          style: {
            color: {
              background: customOverlayColor
            }
          }
        };
      } // Maintain custom text color block support value.


      if (style?.color?.text) {
        additionalAttributes.style = {
          color: { ...additionalAttributes.style?.color,
            text: style.color.text
          }
        };
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/media-text', {
        align,
        anchor,
        backgroundColor: overlayColor,
        gradient,
        mediaAlt: alt,
        mediaId: id,
        mediaType: backgroundType,
        mediaUrl: url,
        textColor,
        ...additionalAttributes
      }, innerBlocks);
    }
  }],
  to: [{
    type: 'block',
    blocks: ['core/image'],
    isMatch: ({
      mediaType,
      mediaUrl
    }) => {
      return !mediaUrl || mediaType === 'image';
    },
    transform: ({
      mediaAlt,
      mediaId,
      mediaUrl,
      anchor
    }) => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/image', {
        alt: mediaAlt,
        id: mediaId,
        url: mediaUrl,
        anchor
      });
    }
  }, {
    type: 'block',
    blocks: ['core/video'],
    isMatch: ({
      mediaType,
      mediaUrl
    }) => {
      return !mediaUrl || mediaType === 'video';
    },
    transform: ({
      mediaId,
      mediaUrl,
      anchor
    }) => {
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/video', {
        id: mediaId,
        src: mediaUrl,
        anchor
      });
    }
  }, {
    type: 'block',
    blocks: ['core/cover'],
    transform: ({
      align,
      anchor,
      backgroundColor,
      focalPoint,
      gradient,
      mediaAlt,
      mediaId,
      mediaType,
      mediaUrl,
      style,
      textColor
    }, innerBlocks) => {
      const additionalAttributes = {}; // Migrate the background styles or gradient to Cover's custom
      // gradient and overlay properties.

      if (style?.color?.gradient) {
        additionalAttributes.customGradient = style.color.gradient;
      } else if (style?.color?.background) {
        additionalAttributes.customOverlayColor = style.color.background;
      } // Maintain custom text color support style.


      if (style?.color?.text) {
        additionalAttributes.style = {
          color: {
            text: style.color.text
          }
        };
      }

      const coverAttributes = {
        align,
        alt: mediaAlt,
        anchor,
        backgroundType: mediaType,
        dimRatio: !!mediaUrl ? 50 : 100,
        focalPoint,
        gradient,
        id: mediaId,
        overlayColor: backgroundColor,
        textColor,
        url: mediaUrl,
        ...additionalAttributes
      };
      return (0,external_wp_blocks_namespaceObject.createBlock)('core/cover', coverAttributes, innerBlocks);
    }
  }]
};
/* harmony default export */ var media_text_transforms = (media_text_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/media-text/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const media_text_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/media-text",
  title: "Media & Text",
  category: "media",
  description: "Set media and words side-by-side for a richer layout.",
  keywords: ["image", "video"],
  textdomain: "default",
  attributes: {
    align: {
      type: "string",
      "default": "none"
    },
    mediaAlt: {
      type: "string",
      source: "attribute",
      selector: "figure img",
      attribute: "alt",
      "default": "",
      __experimentalRole: "content"
    },
    mediaPosition: {
      type: "string",
      "default": "left"
    },
    mediaId: {
      type: "number",
      __experimentalRole: "content"
    },
    mediaUrl: {
      type: "string",
      source: "attribute",
      selector: "figure video,figure img",
      attribute: "src",
      __experimentalRole: "content"
    },
    mediaLink: {
      type: "string"
    },
    linkDestination: {
      type: "string"
    },
    linkTarget: {
      type: "string",
      source: "attribute",
      selector: "figure a",
      attribute: "target"
    },
    href: {
      type: "string",
      source: "attribute",
      selector: "figure a",
      attribute: "href",
      __experimentalRole: "content"
    },
    rel: {
      type: "string",
      source: "attribute",
      selector: "figure a",
      attribute: "rel"
    },
    linkClass: {
      type: "string",
      source: "attribute",
      selector: "figure a",
      attribute: "class"
    },
    mediaType: {
      type: "string",
      __experimentalRole: "content"
    },
    mediaWidth: {
      type: "number",
      "default": 50
    },
    mediaSizeSlug: {
      type: "string"
    },
    isStackedOnMobile: {
      type: "boolean",
      "default": true
    },
    verticalAlignment: {
      type: "string"
    },
    imageFill: {
      type: "boolean"
    },
    focalPoint: {
      type: "object"
    },
    allowedBlocks: {
      type: "array"
    }
  },
  supports: {
    anchor: true,
    align: ["wide", "full"],
    html: false,
    color: {
      gradients: true,
      link: true,
      __experimentalDefaultControls: {
        background: true,
        text: true
      }
    },
    spacing: {
      margin: true,
      padding: true
    },
    typography: {
      fontSize: true,
      lineHeight: true,
      __experimentalFontFamily: true,
      __experimentalFontWeight: true,
      __experimentalFontStyle: true,
      __experimentalTextTransform: true,
      __experimentalTextDecoration: true,
      __experimentalLetterSpacing: true,
      __experimentalDefaultControls: {
        fontSize: true
      }
    }
  },
  editorStyle: "wp-block-media-text-editor",
  style: "wp-block-media-text"
};


const {
  name: media_text_name
} = media_text_metadata;

const media_text_settings = {
  icon: media_and_text,
  example: {
    viewportWidth: 601,
    // Columns collapse "@media (max-width: 600px)".
    attributes: {
      mediaType: 'image',
      mediaUrl: 'https://s.w.org/images/core/5.3/Biologia_Centrali-Americana_-_Cantorchilus_semibadius_1902.jpg'
    },
    innerBlocks: [{
      name: 'core/paragraph',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('The wren<br>Earns his living<br>Noiselessly.')
      }
    }, {
      name: 'core/paragraph',
      attributes: {
        content: (0,external_wp_i18n_namespaceObject.__)('— Kobayashi Issa (一茶)')
      }
    }]
  },
  transforms: media_text_transforms,
  edit: media_text_edit,
  save: media_text_save_save,
  deprecated: media_text_deprecated
};
const media_text_init = () => initBlock({
  name: media_text_name,
  metadata: media_text_metadata,
  settings: media_text_settings
});

;// CONCATENATED MODULE: external ["wp","dom"]
var external_wp_dom_namespaceObject = window["wp"]["dom"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/missing/edit.js


/**
 * WordPress dependencies
 */








function MissingBlockWarning({
  attributes,
  convertToHTML,
  clientId
}) {
  const {
    originalName,
    originalUndelimitedContent
  } = attributes;
  const hasContent = !!originalUndelimitedContent;
  const hasHTMLBlock = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canInsertBlockType,
      getBlockRootClientId
    } = select(external_wp_blockEditor_namespaceObject.store);
    return canInsertBlockType('core/html', getBlockRootClientId(clientId));
  }, [clientId]);
  const actions = [];
  let messageHTML;

  if (hasContent && hasHTMLBlock) {
    messageHTML = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: block name */
    (0,external_wp_i18n_namespaceObject.__)('Your site doesn’t include support for the "%s" block. You can leave this block intact, convert its content to a Custom HTML block, or remove it entirely.'), originalName);
    actions.push((0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: "convert",
      onClick: convertToHTML,
      variant: "primary"
    }, (0,external_wp_i18n_namespaceObject.__)('Keep as HTML')));
  } else {
    messageHTML = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: block name */
    (0,external_wp_i18n_namespaceObject.__)('Your site doesn’t include support for the "%s" block. You can leave this block intact or remove it entirely.'), originalName);
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)({
      className: 'has-warning'
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.Warning, {
    actions: actions
  }, messageHTML), (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, (0,external_wp_dom_namespaceObject.safeHTML)(originalUndelimitedContent)));
}

const MissingEdit = (0,external_wp_data_namespaceObject.withDispatch)((dispatch, {
  clientId,
  attributes
}) => {
  const {
    replaceBlock
  } = dispatch(external_wp_blockEditor_namespaceObject.store);
  return {
    convertToHTML() {
      replaceBlock(clientId, (0,external_wp_blocks_namespaceObject.createBlock)('core/html', {
        content: attributes.originalUndelimitedContent
      }));
    }

  };
})(MissingBlockWarning);
/* harmony default export */ var missing_edit = (MissingEdit);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/missing/save.js


/**
 * WordPress dependencies
 */

function missing_save_save({
  attributes
}) {
  // Preserve the missing block's content.
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, attributes.originalContent);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/missing/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const missing_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/missing",
  title: "Unsupported",
  category: "text",
  description: "Your site doesn\u2019t include support for this block.",
  textdomain: "default",
  attributes: {
    originalName: {
      type: "string"
    },
    originalUndelimitedContent: {
      type: "string"
    },
    originalContent: {
      type: "string",
      source: "html"
    }
  },
  supports: {
    className: false,
    customClassName: false,
    inserter: false,
    html: false,
    reusable: false
  }
};

const {
  name: missing_name
} = missing_metadata;

const missing_settings = {
  name: missing_name,

  __experimentalLabel(attributes, {
    context
  }) {
    if (context === 'accessibility') {
      const {
        originalName
      } = attributes;
      const originalBlockType = originalName ? (0,external_wp_blocks_namespaceObject.getBlockType)(originalName) : undefined;

      if (originalBlockType) {
        return originalBlockType.settings.title || originalName;
      }

      return '';
    }
  },

  edit: missing_edit,
  save: missing_save_save
};
const missing_init = () => initBlock({
  name: missing_name,
  metadata: missing_metadata,
  settings: missing_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/more.js


/**
 * WordPress dependencies
 */

const more = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 9v1.5h16V9H4zm12 5.5h4V13h-4v1.5zm-6 0h4V13h-4v1.5zm-6 0h4V13H4v1.5z"
}));
/* harmony default export */ var library_more = (more);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/more/edit.js


/**
 * WordPress dependencies
 */






const DEFAULT_TEXT = (0,external_wp_i18n_namespaceObject.__)('Read more');

function MoreEdit({
  attributes: {
    customText,
    noTeaser
  },
  insertBlocksAfter,
  setAttributes
}) {
  const onChangeInput = event => {
    setAttributes({
      customText: event.target.value !== '' ? event.target.value : undefined
    });
  };

  const onKeyDown = ({
    keyCode
  }) => {
    if (keyCode === external_wp_keycodes_namespaceObject.ENTER) {
      insertBlocksAfter([(0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)())]);
    }
  };

  const getHideExcerptHelp = checked => checked ? (0,external_wp_i18n_namespaceObject.__)('The excerpt is hidden.') : (0,external_wp_i18n_namespaceObject.__)('The excerpt is visible.');

  const toggleHideExcerpt = () => setAttributes({
    noTeaser: !noTeaser
  });

  const style = {
    width: `${(customText ? customText : DEFAULT_TEXT).length + 1.2}em`
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_blockEditor_namespaceObject.InspectorControls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Hide the excerpt on the full content page'),
    checked: !!noTeaser,
    onChange: toggleHideExcerpt,
    help: getHideExcerptHelp
  }))), (0,external_wp_element_namespaceObject.createElement)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)()
  }, (0,external_wp_element_namespaceObject.createElement)("input", {
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('“Read more” link text'),
    type: "text",
    value: customText,
    placeholder: DEFAULT_TEXT,
    onChange: onChangeInput,
    onKeyDown: onKeyDown,
    style: style
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/more/save.js


/**
 * WordPress dependencies
 */

function more_save_save({
  attributes: {
    customText,
    noTeaser
  }
}) {
  const moreTag = customText ? `<!--more ${customText}-->` : '<!--more-->';
  const noTeaserTag = noTeaser ? '<!--noteaser-->' : '';
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, [moreTag, noTeaserTag].filter(Boolean).join('\n'));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/more/transforms.js
/**
 * WordPress dependencies
 */

const more_transforms_transforms = {
  from: [{
    type: 'raw',
    schema: {
      'wp-block': {
        attributes: ['data-block']
      }
    },
    isMatch: node => node.dataset && node.dataset.block === 'core/more',

    transform(node) {
      const {
        customText,
        noTeaser
      } = node.dataset;
      const attrs = {}; // Don't copy unless defined and not an empty string.

      if (customText) {
        attrs.customText = customText;
      } // Special handling for boolean.


      if (noTeaser === '') {
        attrs.noTeaser = true;
      }

      return (0,external_wp_blocks_namespaceObject.createBlock)('core/more', attrs);
    }

  }]
};
/* harmony default export */ var more_transforms = (more_transforms_transforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/more/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const more_metadata = {
  $schema: "https://schemas.wp.org/trunk/block.json",
  apiVersion: 3,
  name: "core/more",
  title: "More",
  category: "design",
  description: "Content before this block will be shown in the excerpt on your archives page.",
  keywords: ["read more"],
  textdomain: "default",
  attributes: {
    customText: {
      type: "string"
    },
    noTeaser: {
      type: "boolean",
      "default": false
    }
  },
  supports: {
    customClassName: false,
    className: false,
    html: false,
    multiple: false
  },
  editorStyle: "wp-block-more-editor"
};


const {
  name: more_name
} = more_metadata;

const more_settings = {
  icon: library_more,
  example: {},

  __experimentalLabel(attributes, {
    context
  }) {
    if (context === 'accessibility') {
      return attributes.customText;
    }
  },

  transforms: more_transforms,
  edit: MoreEdit,
  save: more_save_save
};
const more_init = () => initBlock({
  name: more_name,
  metadata: more_metadata,
  settings: more_settings
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/navigation.js


/**
 * WordPress dependencies
 */

const navigation = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M12 4c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 14.5c-3.6 0-6.5-2.9-6.5-6.5S8.4 5.5 12 5.5s6.5 2.9 6.5 6.5-2.9 6.5-6.5 6.5zM9 16l4.5-3L15 8.4l-4.5 3L9 16z"
}));
/* harmony default export */ var library_navigation = (navigation);

;// CONCATENATED MODULE: external ["wp","a11y"]
var external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/icon/index.js
/**
 * WordPress dependencies
 */

/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps} props icon is the SVG component to render
 *                          size is a number specifiying the icon size in pixels
 *                          Other props will be passed to wrapped SVG component
 *
 * @return {JSX.Element}  Icon component
 */

function Icon({
  icon,
  size = 24,
  ...props
}) {
  return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
    width: size,
    height: size,
    ...props
  });
}

/* harmony default export */ var build_module_icon = (Icon);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/close.js


/**
 * WordPress dependencies
 */

const close_close = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ var library_close = (close_close);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/constants.js
const constants_DEFAULT_BLOCK = {
  name: 'core/navigation-link'
};
const constants_ALLOWED_BLOCKS = ['core/navigation-link', 'core/search', 'core/social-links', 'core/page-list', 'core/spacer', 'core/home-link', 'core/site-title', 'core/site-logo', 'core/navigation-submenu', 'core/loginout'];
const PRIORITIZED_INSERTER_BLOCKS = ['core/navigation-link/page', 'core/navigation-link'];
const SELECT_NAVIGATION_MENUS_ARGS = ['postType', 'wp_navigation', {
  per_page: 100,
  status: ['publish', 'draft'],
  order: 'desc',
  orderby: 'date'
}];

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/use-navigation-menu.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNavigationMenu(ref) {
  const permissions = (0,external_wp_coreData_namespaceObject.useResourcePermissions)('navigation', ref);
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canCreate,
      canUpdate,
      canDelete,
      isResolving,
      hasResolved
    } = permissions;
    const {
      navigationMenus,
      isResolvingNavigationMenus,
      hasResolvedNavigationMenus
    } = selectNavigationMenus(select);
    const {
      navigationMenu,
      isNavigationMenuResolved,
      isNavigationMenuMissing
    } = selectExistingMenu(select, ref);
    return {
      navigationMenus,
      isResolvingNavigationMenus,
      hasResolvedNavigationMenus,
      navigationMenu,
      isNavigationMenuResolved,
      isNavigationMenuMissing,
      canSwitchNavigationMenu: ref ? navigationMenus?.length > 1 : navigationMenus?.length > 0,
      canUserCreateNavigationMenu: canCreate,
      isResolvingCanUserCreateNavigationMenu: isResolving,
      hasResolvedCanUserCreateNavigationMenu: hasResolved,
      canUserUpdateNavigationMenu: canUpdate,
      hasResolvedCanUserUpdateNavigationMenu: ref ? hasResolved : undefined,
      canUserDeleteNavigationMenu: canDelete,
      hasResolvedCanUserDeleteNavigationMenu: ref ? hasResolved : undefined
    };
  }, [ref, permissions]);
}

function selectNavigationMenus(select) {
  const {
    getEntityRecords,
    hasFinishedResolution,
    isResolving
  } = select(external_wp_coreData_namespaceObject.store);
  return {
    navigationMenus: getEntityRecords(...SELECT_NAVIGATION_MENUS_ARGS),
    isResolvingNavigationMenus: isResolving('getEntityRecords', SELECT_NAVIGATION_MENUS_ARGS),
    hasResolvedNavigationMenus: hasFinishedResolution('getEntityRecords', SELECT_NAVIGATION_MENUS_ARGS)
  };
}

function selectExistingMenu(select, ref) {
  if (!ref) {
    return {
      isNavigationMenuResolved: false,
      isNavigationMenuMissing: true
    };
  }

  const {
    getEntityRecord,
    getEditedEntityRecord,
    hasFinishedResolution
  } = select(external_wp_coreData_namespaceObject.store);
  const args = ['postType', 'wp_navigation', ref];
  const navigationMenu = getEntityRecord(...args);
  const editedNavigationMenu = getEditedEntityRecord(...args);
  const hasResolvedNavigationMenu = hasFinishedResolution('getEditedEntityRecord', args); // Only published Navigation posts are considered valid.
  // Draft Navigation posts are valid only on the editor,
  // requiring a post update to publish to show in frontend.
  // To achieve that, index.php must reflect this validation only for published.

  const isNavigationMenuPublishedOrDraft = editedNavigationMenu.status === 'publish' || editedNavigationMenu.status === 'draft';
  return {
    isNavigationMenuResolved: hasResolvedNavigationMenu,
    isNavigationMenuMissing: hasResolvedNavigationMenu && (!navigationMenu || !isNavigationMenuPublishedOrDraft),
    // getEditedEntityRecord will return the post regardless of status.
    // Therefore if the found post is not published then we should ignore it.
    navigationMenu: isNavigationMenuPublishedOrDraft ? editedNavigationMenu : null
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/use-navigation-entities.js
/**
 * WordPress dependencies
 */

/**
 * @typedef {Object} NavigationEntitiesData
 * @property {Array|undefined} pages                - a collection of WP Post entity objects of post type "Page".
 * @property {boolean}         isResolvingPages     - indicates whether the request to fetch pages is currently resolving.
 * @property {boolean}         hasResolvedPages     - indicates whether the request to fetch pages has finished resolving.
 * @property {Array|undefined} menus                - a collection of Menu entity objects.
 * @property {boolean}         isResolvingMenus     - indicates whether the request to fetch menus is currently resolving.
 * @property {boolean}         hasResolvedMenus     - indicates whether the request to fetch menus has finished resolving.
 * @property {Array|undefined} menusItems           - a collection of Menu Item entity objects for the current menuId.
 * @property {boolean}         hasResolvedMenuItems - indicates whether the request to fetch menuItems has finished resolving.
 * @property {boolean}         hasPages             - indicates whether there is currently any data for pages.
 * @property {boolean}         hasMenus             - indicates whether there is currently any data for menus.
 */

/**
 * Manages fetching and resolution state for all entities required
 * for the Navigation block.
 *
 * @param {number} menuId the menu for which to retrieve menuItem data.
 * @return { NavigationEntitiesData } the entity data.
 */

function useNavigationEntities(menuId) {
  const {
    records: menus,
    isResolving: isResolvingMenus,
    hasResolved: hasResolvedMenus
  } = (0,external_wp_coreData_namespaceObject.useEntityRecords)('root', 'menu', {
    per_page: -1,
    context: 'view'
  });
  const {
    records: pages,
    isResolving: isResolvingPages,
    hasResolved: hasResolvedPages
  } = (0,external_wp_coreData_namespaceObject.useEntityRecords)('postType', 'page', {
    parent: 0,
    order: 'asc',
    orderby: 'id',
    per_page: -1,
    context: 'view'
  });
  const {
    records: menuItems,
    hasResolved: hasResolvedMenuItems
  } = (0,external_wp_coreData_namespaceObject.useEntityRecords)('root', 'menuItem', {
    menus: menuId,
    per_page: -1,
    context: 'view'
  }, {
    enabled: !!menuId
  });
  return {
    pages,
    isResolvingPages,
    hasResolvedPages,
    hasPages: !!(hasResolvedPages && pages?.length),
    menus,
    isResolvingMenus,
    hasResolvedMenus,
    hasMenus: !!(hasResolvedMenus && menus?.length),
    menuItems,
    hasResolvedMenuItems
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/placeholder/placeholder-preview.js


/**
 * WordPress dependencies
 */



const PlaceholderPreview = ({
  isVisible = true
}) => {
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    "aria-hidden": !isVisible ? true : undefined,
    className: "wp-block-navigation-placeholder__preview"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-navigation-placeholder__actions__indicator"
  }, (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
    icon: library_navigation
  }), (0,external_wp_i18n_namespaceObject.__)('Navigation')));
};

/* harmony default export */ var placeholder_preview = (PlaceholderPreview);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/more-vertical.js


/**
 * WordPress dependencies
 */

const moreVertical = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M13 19h-2v-2h2v2zm0-6h-2v-2h2v2zm0-6h-2V5h2v2z"
}));
/* harmony default export */ var more_vertical = (moreVertical);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/navigation-menu-selector.js


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function buildMenuLabel(title, id, status) {
  if (!title?.rendered) {
    /* translators: %s is the index of the menu in the list of menus. */
    return (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('(no title %s)'), id);
  }

  if (status === 'publish') {
    return (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title?.rendered);
  }

  return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %1s: title of the menu; %2s: status of the menu (draft, pending, etc.).
  (0,external_wp_i18n_namespaceObject.__)('%1$s (%2$s)'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title?.rendered), status);
}

function NavigationMenuSelector({
  currentMenuId,
  onSelectNavigationMenu,
  onSelectClassicMenu,
  onCreateNew,
  actionLabel,
  createNavigationMenuIsSuccess,
  createNavigationMenuIsError
}) {
  /* translators: %s: The name of a menu. */
  const createActionLabel = (0,external_wp_i18n_namespaceObject.__)("Create from '%s'");

  const [isCreatingMenu, setIsCreatingMenu] = (0,external_wp_element_namespaceObject.useState)(false);
  actionLabel = actionLabel || createActionLabel;
  const {
    menus: classicMenus
  } = useNavigationEntities();
  const {
    navigationMenus,
    isResolvingNavigationMenus,
    hasResolvedNavigationMenus,
    canUserCreateNavigationMenu,
    canSwitchNavigationMenu
  } = useNavigationMenu();
  const [currentTitle] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', 'wp_navigation', 'title');
  const menuChoices = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return navigationMenus?.map(({
      id,
      title,
      status
    }, index) => {
      const label = buildMenuLabel(title, index + 1, status);
      return {
        value: id,
        label,
        ariaLabel: (0,external_wp_i18n_namespaceObject.sprintf)(actionLabel, label)
      };
    }) || [];
  }, [navigationMenus, actionLabel]);
  const hasNavigationMenus = !!navigationMenus?.length;
  const hasClassicMenus = !!classicMenus?.length;
  const showNavigationMenus = !!canSwitchNavigationMenu;
  const showClassicMenus = !!canUserCreateNavigationMenu;
  const noMenuSelected = hasNavigationMenus && !currentMenuId;
  const noBlockMenus = !hasNavigationMenus && hasResolvedNavigationMenus;
  const menuUnavailable = hasResolvedNavigationMenus && currentMenuId === null;
  let selectorLabel = '';

  if (isCreatingMenu || isResolvingNavigationMenus) {
    selectorLabel = (0,external_wp_i18n_namespaceObject.__)('Loading …');
  } else if (noMenuSelected || noBlockMenus || menuUnavailable) {
    // Note: classic Menus may be available.
    selectorLabel = (0,external_wp_i18n_namespaceObject.__)('Choose or create a Navigation menu');
  } else {
    // Current Menu's title.
    selectorLabel = currentTitle;
  }

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (isCreatingMenu && (createNavigationMenuIsSuccess || createNavigationMenuIsError)) {
      setIsCreatingMenu(false);
    }
  }, [hasResolvedNavigationMenus, createNavigationMenuIsSuccess, canUserCreateNavigationMenu, createNavigationMenuIsError, isCreatingMenu, menuUnavailable, noBlockMenus, noMenuSelected]);
  const NavigationMenuSelectorDropdown = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.DropdownMenu, {
    label: selectorLabel,
    icon: more_vertical,
    toggleProps: {
      isSmall: true
    }
  }, ({
    onClose
  }) => (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, showNavigationMenus && hasNavigationMenus && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
    label: (0,external_wp_i18n_namespaceObject.__)('Menus')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItemsChoice, {
    value: currentMenuId,
    onSelect: menuId => {
      setIsCreatingMenu(true);
      onSelectNavigationMenu(menuId);
      onClose();
    },
    choices: menuChoices,
    disabled: isCreatingMenu
  })), showClassicMenus && hasClassicMenus && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
    label: (0,external_wp_i18n_namespaceObject.__)('Import Classic Menus')
  }, classicMenus?.map(menu => {
    const label = (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(menu.name);
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
      onClick: () => {
        setIsCreatingMenu(true);
        onSelectClassicMenu(menu);
        onClose();
      },
      key: menu.id,
      "aria-label": (0,external_wp_i18n_namespaceObject.sprintf)(createActionLabel, label),
      disabled: isCreatingMenu
    }, label);
  })), canUserCreateNavigationMenu && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
    label: (0,external_wp_i18n_namespaceObject.__)('Tools')
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    disabled: isCreatingMenu,
    onClick: () => {
      onClose();
      onCreateNew();
      setIsCreatingMenu(true);
    }
  }, (0,external_wp_i18n_namespaceObject.__)('Create new menu')))));
  return NavigationMenuSelectorDropdown;
}

/* harmony default export */ var navigation_menu_selector = (NavigationMenuSelector);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/placeholder/index.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




function NavigationPlaceholder({
  isSelected,
  currentMenuId,
  clientId,
  canUserCreateNavigationMenu = false,
  isResolvingCanUserCreateNavigationMenu,
  onSelectNavigationMenu,
  onSelectClassicMenu,
  onCreateEmpty
}) {
  const {
    isResolvingMenus,
    hasResolvedMenus
  } = useNavigationEntities();
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isSelected) {
      return;
    }

    if (isResolvingMenus) {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Loading Navigation block setup options.'));
    }

    if (hasResolvedMenus) {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Navigation block setup options ready.'));
    }
  }, [hasResolvedMenus, isResolvingMenus, isSelected]);
  const isResolvingActions = isResolvingMenus && isResolvingCanUserCreateNavigationMenu;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Placeholder, {
    className: "wp-block-navigation-placeholder"
  }, (0,external_wp_element_namespaceObject.createElement)(placeholder_preview, {
    isVisible: !isSelected
  }), (0,external_wp_element_namespaceObject.createElement)("div", {
    "aria-hidden": !isSelected ? true : undefined,
    className: "wp-block-navigation-placeholder__controls"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-navigation-placeholder__actions"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-navigation-placeholder__actions__indicator"
  }, (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
    icon: library_navigation
  }), " ", (0,external_wp_i18n_namespaceObject.__)('Navigation')), (0,external_wp_element_namespaceObject.createElement)("hr", null), isResolvingActions && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Spinner, null), (0,external_wp_element_namespaceObject.createElement)(navigation_menu_selector, {
    currentMenuId: currentMenuId,
    clientId: clientId,
    onSelectNavigationMenu: onSelectNavigationMenu,
    onSelectClassicMenu: onSelectClassicMenu
  }), (0,external_wp_element_namespaceObject.createElement)("hr", null), canUserCreateNavigationMenu && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "tertiary",
    onClick: onCreateEmpty
  }, (0,external_wp_i18n_namespaceObject.__)('Start empty'))))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/menu.js


/**
 * WordPress dependencies
 */

const menu = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 5v1.5h14V5H5zm0 7.8h14v-1.5H5v1.5zM5 19h14v-1.5H5V19z"
}));
/* harmony default export */ var library_menu = (menu);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/overlay-menu-icon.js


/**
 * WordPress dependencies
 */


function OverlayMenuIcon({
  icon
}) {
  if (icon === 'menu') {
    return (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
      icon: library_menu
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24 24",
    width: "24",
    height: "24",
    "aria-hidden": "true",
    focusable: "false"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Rect, {
    x: "4",
    y: "7.5",
    width: "16",
    height: "1.5"
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Rect, {
    x: "4",
    y: "15",
    width: "16",
    height: "1.5"
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/responsive-wrapper.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function ResponsiveWrapper({
  children,
  id,
  isOpen,
  isResponsive,
  onToggle,
  isHiddenByDefault,
  overlayBackgroundColor,
  overlayTextColor,
  hasIcon,
  icon
}) {
  if (!isResponsive) {
    return children;
  }

  const responsiveContainerClasses = classnames_default()('wp-block-navigation__responsive-container', {
    'has-text-color': !!overlayTextColor.color || !!overlayTextColor?.class,
    [(0,external_wp_blockEditor_namespaceObject.getColorClassName)('color', overlayTextColor?.slug)]: !!overlayTextColor?.slug,
    'has-background': !!overlayBackgroundColor.color || overlayBackgroundColor?.class,
    [(0,external_wp_blockEditor_namespaceObject.getColorClassName)('background-color', overlayBackgroundColor?.slug)]: !!overlayBackgroundColor?.slug,
    'is-menu-open': isOpen,
    'hidden-by-default': isHiddenByDefault
  });
  const styles = {
    color: !overlayTextColor?.slug && overlayTextColor?.color,
    backgroundColor: !overlayBackgroundColor?.slug && overlayBackgroundColor?.color && overlayBackgroundColor.color
  };
  const openButtonClasses = classnames_default()('wp-block-navigation__responsive-container-open', {
    'always-shown': isHiddenByDefault
  });
  const modalId = `${id}-modal`;
  const dialogProps = {
    className: 'wp-block-navigation__responsive-dialog',
    ...(isOpen && {
      role: 'dialog',
      'aria-modal': true,
      'aria-label': (0,external_wp_i18n_namespaceObject.__)('Menu')
    })
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, !isOpen && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    "aria-haspopup": "true",
    "aria-label": hasIcon && (0,external_wp_i18n_namespaceObject.__)('Open menu'),
    className: openButtonClasses,
    onClick: () => onToggle(true)
  }, hasIcon && (0,external_wp_element_namespaceObject.createElement)(OverlayMenuIcon, {
    icon: icon
  }), !hasIcon && (0,external_wp_i18n_namespaceObject.__)('Menu')), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: responsiveContainerClasses,
    style: styles,
    id: modalId
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-navigation__responsive-close",
    tabIndex: "-1"
  }, (0,external_wp_element_namespaceObject.createElement)("div", { ...dialogProps
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    className: "wp-block-navigation__responsive-container-close",
    "aria-label": hasIcon && (0,external_wp_i18n_namespaceObject.__)('Close menu'),
    onClick: () => onToggle(false)
  }, hasIcon && (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
    icon: library_close
  }), !hasIcon && (0,external_wp_i18n_namespaceObject.__)('Close')), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "wp-block-navigation__responsive-container-content",
    id: `${modalId}-content`
  }, children)))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/inner-blocks.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function NavigationInnerBlocks({
  clientId,
  hasCustomPlaceholder,
  orientation,
  templateLock
}) {
  const {
    isImmediateParentOfSelectedBlock,
    selectedBlockHasChildren,
    isSelected
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockCount,
      hasSelectedInnerBlock,
      getSelectedBlockClientId
    } = select(external_wp_blockEditor_namespaceObject.store);
    const selectedBlockId = getSelectedBlockClientId();
    return {
      isImmediateParentOfSelectedBlock: hasSelectedInnerBlock(clientId, false),
      selectedBlockHasChildren: !!getBlockCount(selectedBlockId),
      // This prop is already available but computing it here ensures it's
      // fresh compared to isImmediateParentOfSelectedBlock.
      isSelected: selectedBlockId === clientId
    };
  }, [clientId]);
  const [blocks, onInput, onChange] = (0,external_wp_coreData_namespaceObject.useEntityBlockEditor)('postType', 'wp_navigation');
  const shouldDirectInsert = (0,external_wp_element_namespaceObject.useMemo)(() => blocks.every(({
    name
  }) => name === 'core/navigation-link' || name === 'core/navigation-submenu' || name === 'core/page-list'), [blocks]); // When the block is selected itself or has a top level item selected that
  // doesn't itself have children, show the standard appender. Else show no
  // appender.

  const parentOrChildHasSelection = isSelected || isImmediateParentOfSelectedBlock && !selectedBlockHasChildren;
  const placeholder = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_element_namespaceObject.createElement)(placeholder_preview, null), []);
  const hasMenuItems = !!blocks?.length; // If there is a `ref` attribute pointing to a `wp_navigation` but
  // that menu has no **items** (i.e. empty) then show a placeholder.
  // The block must also be selected else the placeholder will display
  // alongside the appender.

  const showPlaceholder = !hasCustomPlaceholder && !hasMenuItems && !isSelected;
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)({
    className: 'wp-block-navigation__container'
  }, {
    value: blocks,
    onInput,
    onChange,
    allowedBlocks: constants_ALLOWED_BLOCKS,
    prioritizedInserterBlocks: PRIORITIZED_INSERTER_BLOCKS,
    __experimentalDefaultBlock: constants_DEFAULT_BLOCK,
    __experimentalDirectInsert: shouldDirectInsert,
    orientation,
    templateLock,
    // As an exception to other blocks which feature nesting, show
    // the block appender even when a child block is selected.
    // This should be a temporary fix, to be replaced by improvements to
    // the sibling inserter.
    // See https://github.com/WordPress/gutenberg/issues/37572.
    renderAppender: isSelected || isImmediateParentOfSelectedBlock && !selectedBlockHasChildren || // Show the appender while dragging to allow inserting element between item and the appender.
    parentOrChildHasSelection ? external_wp_blockEditor_namespaceObject.InnerBlocks.ButtonBlockAppender : false,
    placeholder: showPlaceholder ? placeholder : undefined
  });
  return (0,external_wp_element_namespaceObject.createElement)("div", { ...innerBlocksProps
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/navigation-menu-name-control.js


/**
 * WordPress dependencies
 */



function NavigationMenuNameControl() {
  const [title, updateTitle] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', 'wp_navigation', 'title');
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Menu name'),
    value: title,
    onChange: updateTitle
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/are-blocks-dirty.js
function areBlocksDirty(originalBlocks, blocks) {
  return !isDeepEqual(originalBlocks, blocks, (prop, x) => {
    // Skip inner blocks of page list during comparison as they
    // are **always** controlled and may be updated async due to
    // syncing with entity records. Left unchecked this would
    // inadvertently trigger the dirty state.
    if (x?.name === 'core/page-list' && prop === 'innerBlocks') {
      return true;
    }
  });
}
/**
 * Conditionally compares two candidates for deep equality.
 * Provides an option to skip a given property of an object during comparison.
 *
 * @param {*}                  x          1st candidate for comparison
 * @param {*}                  y          2nd candidate for comparison
 * @param {Function|undefined} shouldSkip a function which can be used to skip a given property of an object.
 * @return {boolean}                      whether the two candidates are deeply equal.
 */

const isDeepEqual = (x, y, shouldSkip) => {
  if (x === y) {
    return true;
  } else if (typeof x === 'object' && x !== null && x !== undefined && typeof y === 'object' && y !== null && y !== undefined) {
    if (Object.keys(x).length !== Object.keys(y).length) return false;

    for (const prop in x) {
      if (y.hasOwnProperty(prop)) {
        // Afford skipping a given property of an object.
        if (shouldSkip && shouldSkip(prop, x)) {
          return true;
        }

        if (!isDeepEqual(x[prop], y[prop], shouldSkip)) return false;
      } else return false;
    }

    return true;
  }

  return false;
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-library/build-module/navigation/edit/unsaved-inner-blocks.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const EMPTY_OBJECT = {};
function UnsavedInnerBlocks({
  blocks,
  createNavigationMenu,
  hasSelection
}) {
  const originalBlocks = (0,external_wp_element_namespaceObject.useRef)();
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Initially store the uncontrolled inner blocks for
    // dirty state comparison.
    if (!originalBlocks?.current) {
      originalBlocks.current = blocks;
    }
  }, [blocks]); // If the current inner blocks are different from the original inner blocks
  // from the post content then the user has made changes to the inner blocks.
  // At this point the inner blocks can be considered "dirty".
  // Note: referential equality is not sufficient for comparison as the inner blocks
  // of the page list are controlled and may be updated async due to syncing with
  // entity records. As a result we need to perform a deep equality check skipping
  // the page list's inner blocks.

  const innerBlocksAreDirty = areBlocksDirty(originalBlocks?.current, blocks);
  const shouldDirectInsert = (0,external_wp_element_namespaceObject.useMemo)(() => blocks.every(({
    name
  }) => name === 'core/navigation-link' || name === 'core/navigation-submenu' || name === 'core/page-list'), [blocks]); // The block will be disabled in a block preview, use this as a way of
  // avoiding the side-effects of this component for block previews.

  const isDisabled = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.Disabled.Context);
  const innerBlocksProps = (0,external_wp_blockEditor_namespaceObject.useInnerBlocksProps)({
    className: 'wp-block-navigation__container'
  }, {
    renderAppender: hasSelection ? undefined : false,
    allowedBlocks: constants_ALLOWED_BLOCKS,
    __experimentalDefaultBlock: constants_DEFAULT_BLOCK,
    __experimentalDirectInsert: shouldDirectInsert
  });
  const {
    isSaving,
    hasResolvedAllNavigationMenus
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (isDisabled) {
      return EMPTY_OBJECT;
    }

    const {
      hasFinishedResolution,
      isSavingEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      isSaving: isSavingEntityRecord('postType', 'wp_navigation'),
      hasResolvedAllNavigationMenus: hasFinishedResolution('getEntityRecords', SELECT_NAVIGATION_MENUS_ARGS)
    };
  }, [isDisabled]); // Automatically save the uncontrolled blocks.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // The block will be disabled when used in a BlockPreview.
    // In this case avoid automatic creation of a wp_navigation post.
    // Otherwise the user will be spammed with lots of menus!
    //
    // Also ensure other navigation menus have loaded so an
    // accurate name can be created.
    //
    // Don't try saving when another save is already
    // in progress.
    //
    // And finally only create the menu when the block is selected,
    // which is an indication they want to start editing.
    if (isDisabled || isSaving || !hasResolve